/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateRequest;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.CertificateVerify;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.ClientKeyExchange;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionIdExtension;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSContext;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.ECDHClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ECDHServerKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskClientKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskServerKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhSignedServerKeyExchange;
import org.eclipse.californium.scandium.dtls.ExtendedMasterSecretExtension;
import org.eclipse.californium.scandium.dtls.ExtendedMasterSecretMode;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeState;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.HelloVerifyRequest;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.PSKClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.RecordSizeLimitExtension;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.ServerNameExtension;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.PseudoRandomFunction;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;

@NoPublicAPI
public class ClientHandshaker
extends Handshaker {
    protected static final HandshakeState[] INIT = new HandshakeState[]{new HandshakeState(HandshakeType.HELLO_VERIFY_REQUEST, true), new HandshakeState(HandshakeType.SERVER_HELLO)};
    protected static final HandshakeState[] SEVER_CERTIFICATE = new HandshakeState[]{new HandshakeState(HandshakeType.CERTIFICATE), new HandshakeState(HandshakeType.SERVER_KEY_EXCHANGE), new HandshakeState(HandshakeType.CERTIFICATE_REQUEST, true), new HandshakeState(HandshakeType.SERVER_HELLO_DONE), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    private static final HandshakeState[] NO_SEVER_CERTIFICATE = new HandshakeState[]{new HandshakeState(HandshakeType.SERVER_KEY_EXCHANGE, true), new HandshakeState(HandshakeType.SERVER_HELLO_DONE), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    private ProtocolVersion maxProtocolVersion = ProtocolVersion.VERSION_DTLS_1_2;
    private boolean probe;
    private boolean receivedServerHelloDone;
    private ECDHServerKeyExchange serverKeyExchange;
    protected ClientHello clientHello;
    protected DTLSFlight flight5;
    private final List<CipherSuite> supportedCipherSuites;
    protected final List<XECDHECryptography.SupportedGroup> supportedGroups;
    protected final MaxFragmentLengthExtension.Length maxFragmentLength;
    protected final boolean truncateCertificatePath;
    protected final List<CertificateType> supportedClientCertificateTypes;
    protected final List<SignatureAndHashAlgorithm> supportedSignatureAlgorithms;
    protected final List<CertificateType> supportedServerCertificateTypes;
    private final Integer useDeprecatedCid;
    private final boolean verifyServerCertificatesSubject;
    private CertificateRequest certificateRequest;
    protected byte[] handshakeHash;

    public ClientHandshaker(String hostname, RecordLayer recordLayer, ScheduledExecutorService timer, Connection connection, DtlsConnectorConfig config, boolean probe) {
        super(0L, 0, recordLayer, timer, connection, config);
        this.supportedCipherSuites = config.getSupportedCipherSuites();
        this.supportedGroups = config.getSupportedGroups();
        this.maxFragmentLength = config.getMaxFragmentLength();
        this.truncateCertificatePath = config.useTruncatedCertificatePathForClientsCertificateMessage();
        this.supportedServerCertificateTypes = config.getTrustCertificateTypes();
        this.supportedClientCertificateTypes = config.getIdentityCertificateTypes();
        this.supportedSignatureAlgorithms = config.getSupportedSignatureAlgorithms();
        this.useDeprecatedCid = config.useDeprecatedCid();
        this.verifyServerCertificatesSubject = config.verifyServerCertificatesSubject();
        this.probe = probe;
        this.getSession().setHostName(hostname);
    }

    @Override
    protected boolean isClient() {
        return true;
    }

    @Override
    protected void doProcessMessage(HandshakeMessage message) throws HandshakeException {
        block0 : switch (message.getMessageType()) {
            case HELLO_VERIFY_REQUEST: {
                this.receivedHelloVerifyRequest((HelloVerifyRequest)message);
                break;
            }
            case SERVER_HELLO: {
                this.receivedServerHello((ServerHello)message);
                break;
            }
            case CERTIFICATE: {
                this.receivedServerCertificate((CertificateMessage)message);
                break;
            }
            case SERVER_KEY_EXCHANGE: {
                switch (this.getSession().getKeyExchange()) {
                    case EC_DIFFIE_HELLMAN: {
                        this.receivedEcdhSignedServerKeyExchange((EcdhSignedServerKeyExchange)message);
                        break block0;
                    }
                    case PSK: {
                        break block0;
                    }
                    case ECDHE_PSK: {
                        this.serverKeyExchange = (EcdhPskServerKeyExchange)message;
                        break block0;
                    }
                }
                throw new HandshakeException(String.format("Unsupported key exchange algorithm %s", this.getSession().getKeyExchange().name()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE));
            }
            case CERTIFICATE_REQUEST: {
                this.receivedCertificateRequest((CertificateRequest)message);
                break;
            }
            case SERVER_HELLO_DONE: {
                this.receivedServerHelloDone();
                break;
            }
            case FINISHED: {
                this.receivedServerFinished((Finished)message);
                break;
            }
            default: {
                throw new HandshakeException(String.format("Received unexpected handshake message [%s] from peer %s", new Object[]{message.getMessageType(), this.peerToLog}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE));
            }
        }
    }

    private void receivedServerFinished(Finished message) throws HandshakeException {
        this.verifyFinished(message, this.handshakeHash);
        this.contextEstablished();
        this.handshakeCompleted();
    }

    protected void receivedHelloVerifyRequest(HelloVerifyRequest message) {
        this.handshakeMessages.clear();
        if (CipherSuite.containsEccBasedCipherSuite(this.clientHello.getCipherSuites())) {
            this.expectEcc();
        }
        this.clientHello.setCookie(message.getCookie());
        this.flightNumber = 3;
        DTLSFlight flight = this.createFlight();
        this.wrapMessage(flight, this.clientHello);
        this.sendFlight(flight);
        this.setExpectedStates(INIT);
    }

    protected void receivedServerHello(ServerHello message) throws HandshakeException {
        ProtocolVersion usedProtocol = message.getProtocolVersion();
        if (!usedProtocol.equals(ProtocolVersion.VERSION_DTLS_1_2)) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.PROTOCOL_VERSION);
            throw new HandshakeException("The client only supports DTLS v1.2, not " + usedProtocol + "!", alert);
        }
        this.serverRandom = message.getRandom();
        DTLSSession session = this.getSession();
        session.setSessionIdentifier(message.getSessionId());
        session.setProtocolVersion(usedProtocol);
        CipherSuite cipherSuite = message.getCipherSuite();
        if (!this.supportedCipherSuites.contains((Object)cipherSuite)) {
            throw new HandshakeException("Server wants to use not supported cipher suite " + (Object)((Object)cipherSuite), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
        }
        session.setCipherSuite(cipherSuite);
        CompressionMethod compressionMethod = message.getCompressionMethod();
        if (compressionMethod != CompressionMethod.NULL) {
            throw new HandshakeException("Server wants to use not supported compression method " + (Object)((Object)compressionMethod), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
        }
        session.setCompressionMethod(message.getCompressionMethod());
        this.verifyServerHelloExtensions(message);
        if (this.supportsConnectionId()) {
            this.receivedConnectionIdExtension(message.getConnectionIdExtension());
        }
        if (message.hasExtendedMasterSecretExtension()) {
            session.setExtendedMasterSecret(true);
        } else if (this.extendedMasterSecretMode == ExtendedMasterSecretMode.REQUIRED) {
            throw new HandshakeException("Extended Master Secret required!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE));
        }
        session.setSniSupported(message.getServerNameExtension() != null);
        this.setExpectedStates(cipherSuite.requiresServerCertificateMessage() ? SEVER_CERTIFICATE : NO_SEVER_CERTIFICATE);
    }

    protected void receivedConnectionIdExtension(ConnectionIdExtension extension) throws HandshakeException {
        if (extension != null) {
            ConnectionId connectionId = extension.getConnectionId();
            DTLSContext context = this.getDtlsContext();
            context.setWriteConnectionId(connectionId);
            context.setReadConnectionId(this.getReadConnectionId());
            context.setDeprecatedCid(extension.useDeprecatedCid());
        }
    }

    protected void verifyServerHelloExtensions(ServerHello message) throws HandshakeException {
        CertificateTypeExtension certificateTypeExtension;
        MaxFragmentLengthExtension maxFragmentLengthExtension;
        SupportedPointFormatsExtension pointFormatsExtension;
        HelloExtensions serverExtensions = message.getExtensions();
        if (serverExtensions != null && !serverExtensions.isEmpty()) {
            HelloExtensions clientExtensions = this.clientHello.getExtensions();
            if (clientExtensions == null || clientExtensions.isEmpty()) {
                throw new HandshakeException("Server wants extensions, but client not!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNSUPPORTED_EXTENSION));
            }
            for (HelloExtension serverExtension : serverExtensions.getExtensions()) {
                if (clientExtensions.getExtension(serverExtension.getType()) != null) continue;
                throw new HandshakeException("Server wants " + (Object)((Object)serverExtension.getType()) + ", but client didn't propose it!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNSUPPORTED_EXTENSION));
            }
        }
        if ((pointFormatsExtension = message.getSupportedPointFormatsExtension()) != null && !pointFormatsExtension.contains(SupportedPointFormatsExtension.ECPointFormat.UNCOMPRESSED)) {
            throw new HandshakeException("Server wants to use only not supported EC point formats!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
        }
        DTLSSession session = this.getSession();
        RecordSizeLimitExtension recordSizeLimitExt = message.getRecordSizeLimitExtension();
        if (recordSizeLimitExt != null) {
            session.setRecordSizeLimit(recordSizeLimitExt.getRecordSizeLimit());
        }
        if ((maxFragmentLengthExtension = message.getMaxFragmentLengthExtension()) != null) {
            if (recordSizeLimitExt != null) {
                throw new HandshakeException("Server wants to use record size limit and max. fragment size", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
            }
            MaxFragmentLengthExtension.Length maxFragmentLength = maxFragmentLengthExtension.getFragmentLength();
            if (this.maxFragmentLength == maxFragmentLength) {
                session.setMaxFragmentLength(maxFragmentLength.length());
            } else {
                throw new HandshakeException("Server wants to use other max. fragment size than proposed", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
            }
        }
        if ((certificateTypeExtension = message.getServerCertificateTypeExtension()) != null) {
            CertificateType serverCertificateType = certificateTypeExtension.getCertificateType();
            if (!ClientHandshaker.isSupportedCertificateType(serverCertificateType, this.supportedServerCertificateTypes)) {
                throw new HandshakeException("Server wants to use not supported server certificate type " + (Object)((Object)serverCertificateType), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
            }
            session.setReceiveCertificateType(serverCertificateType);
        }
        if ((certificateTypeExtension = message.getClientCertificateTypeExtension()) != null) {
            CertificateType clientCertificateType = certificateTypeExtension.getCertificateType();
            if (!ClientHandshaker.isSupportedCertificateType(clientCertificateType, this.supportedClientCertificateTypes)) {
                throw new HandshakeException("Server wants to use not supported client certificate type " + (Object)((Object)clientCertificateType), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
            }
            session.setSendCertificateType(clientCertificateType);
        }
    }

    private void receivedServerCertificate(CertificateMessage message) throws HandshakeException {
        if (message.isEmpty()) {
            this.LOGGER.debug("Certificate validation failed: empty server certificate!");
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
            throw new HandshakeException("Empty server certificate!", alert);
        }
        this.verifyCertificate(message, this.verifyServerCertificatesSubject);
    }

    private void receivedEcdhSignedServerKeyExchange(EcdhSignedServerKeyExchange message) throws HandshakeException {
        message.verifySignature(this.otherPeersPublicKey, this.clientRandom, this.serverRandom);
        this.serverKeyExchange = message;
        this.setOtherPeersSignatureVerified();
    }

    private void receivedCertificateRequest(CertificateRequest message) throws HandshakeException {
        this.certificateRequest = message;
        this.requestCertificateIdentity(this.certificateRequest.getCertificateAuthorities(), this.getServerNames(), this.certificateRequest.getCertificateKeyAlgorithms(), this.certificateRequest.getSupportedSignatureAlgorithms(), null);
    }

    @Override
    protected void processCertificateIdentityAvailable() throws HandshakeException {
        if (this.receivedServerHelloDone) {
            this.processServerHelloDone();
        }
    }

    private void receivedServerHelloDone() throws HandshakeException {
        this.receivedServerHelloDone = true;
        if (this.certificateRequest == null || this.certificateIdentityAvailable) {
            this.processServerHelloDone();
        }
    }

    private void processServerHelloDone() throws HandshakeException {
        this.flightNumber += 2;
        this.flight5 = this.createFlight();
        this.createCertificateMessage(this.flight5);
        DTLSSession session = this.getSession();
        CipherSuite.KeyExchangeAlgorithm keyExchangeAlgorithm = session.getKeyExchange();
        XECDHECryptography ecdhe = null;
        SecretKey ecdheSecret = null;
        byte[] encodedPoint = null;
        if (CipherSuite.KeyExchangeAlgorithm.ECDHE_PSK == keyExchangeAlgorithm || CipherSuite.KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN == keyExchangeAlgorithm) {
            try {
                XECDHECryptography.SupportedGroup ecGroup = this.serverKeyExchange.getSupportedGroup();
                if (!this.supportedGroups.contains((Object)ecGroup)) {
                    AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER);
                    throw new HandshakeException("Cannot process handshake message, ec-group not offered! ", alert);
                }
                ecdhe = new XECDHECryptography(ecGroup);
                ecdheSecret = ecdhe.generateSecret(this.serverKeyExchange.getEncodedPoint());
                encodedPoint = ecdhe.getEncodedPoint();
                session.setEcGroup(ecGroup);
            }
            catch (GeneralSecurityException ex) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER);
                throw new HandshakeException("Cannot process handshake message, caused by " + ex.getMessage(), alert, ex);
            }
        }
        switch (keyExchangeAlgorithm) {
            case EC_DIFFIE_HELLMAN: {
                ClientKeyExchange clientKeyExchange = new ECDHClientKeyExchange(encodedPoint);
                this.wrapMessage(this.flight5, clientKeyExchange);
                byte[] seed = this.generateMasterSecretSeed();
                SecretKey masterSecret = PseudoRandomFunction.generateMasterSecret(session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), ecdheSecret, seed, session.useExtendedMasterSecret());
                this.applyMasterSecret(masterSecret);
                SecretUtil.destroy(masterSecret);
                this.processMasterSecret();
                break;
            }
            case PSK: {
                PskPublicInformation clientIdentity = this.getPskClientIdentity();
                this.LOGGER.trace("Using PSK identity: {}", (Object)clientIdentity);
                ClientKeyExchange clientKeyExchange = new PSKClientKeyExchange(clientIdentity);
                this.wrapMessage(this.flight5, clientKeyExchange);
                byte[] seed = this.generateMasterSecretSeed();
                this.requestPskSecretResult(clientIdentity, null, seed);
                break;
            }
            case ECDHE_PSK: {
                PskPublicInformation clientIdentity = this.getPskClientIdentity();
                this.LOGGER.trace("Using ECDHE PSK identity: {}", (Object)clientIdentity);
                ClientKeyExchange clientKeyExchange = new EcdhPskClientKeyExchange(clientIdentity, encodedPoint);
                this.wrapMessage(this.flight5, clientKeyExchange);
                byte[] seed = this.generateMasterSecretSeed();
                this.requestPskSecretResult(clientIdentity, ecdheSecret, seed);
                break;
            }
        }
        SecretUtil.destroy(ecdhe);
        SecretUtil.destroy(ecdheSecret);
    }

    @Override
    protected void processMasterSecret() throws HandshakeException {
        if (!this.isExpectedStates(SEVER_CERTIFICATE) || this.otherPeersCertificateVerified) {
            this.completeProcessingServerHelloDone();
        }
    }

    @Override
    protected void processCertificateVerified() throws HandshakeException {
        if (this.hasMasterSecret()) {
            this.completeProcessingServerHelloDone();
        }
    }

    protected void completeProcessingServerHelloDone() throws HandshakeException {
        SignatureAndHashAlgorithm negotiatedSignatureAndHashAlgorithm;
        DTLSSession session = this.getSession();
        if (session.getCipherSuite().isEccBased()) {
            this.expectEcc();
        }
        if ((negotiatedSignatureAndHashAlgorithm = session.getSignatureAndHashAlgorithm()) != null) {
            CertificateVerify certificateVerify = new CertificateVerify(negotiatedSignatureAndHashAlgorithm, this.privateKey, this.handshakeMessages);
            this.wrapMessage(this.flight5, certificateVerify);
        }
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage();
        this.wrapMessage(this.flight5, changeCipherSpecMessage);
        this.setCurrentWriteState();
        MessageDigest md = this.getHandshakeMessageDigest();
        MessageDigest mdWithClientFinished = this.cloneMessageDigest(md);
        Finished finished = this.createFinishedMessage(md.digest());
        this.wrapMessage(this.flight5, finished);
        mdWithClientFinished.update(finished.toByteArray());
        this.handshakeHash = mdWithClientFinished.digest();
        this.sendFlight(this.flight5);
        this.expectChangeCipherSpecMessage();
    }

    private void createCertificateMessage(DTLSFlight flight) {
        if (this.certificateRequest != null) {
            List<SignatureAndHashAlgorithm> supported = this.supportedSignatureAlgorithms;
            if (supported.isEmpty()) {
                supported = SignatureAndHashAlgorithm.DEFAULT;
            }
            CertificateType certificateType = this.getSession().sendCertificateType();
            CertificateMessage clientCertificate = null;
            SignatureAndHashAlgorithm negotiatedSignatureAndHashAlgorithm = null;
            if (CertificateType.RAW_PUBLIC_KEY == certificateType) {
                PublicKey publicKey = this.publicKey;
                if (publicKey != null && (negotiatedSignatureAndHashAlgorithm = this.certificateRequest.getSignatureAndHashAlgorithm(publicKey, supported)) != null) {
                    clientCertificate = new CertificateMessage(publicKey);
                    if (this.LOGGER.isDebugEnabled()) {
                        this.LOGGER.debug("sending CERTIFICATE message with client RawPublicKey [{}] to server", (Object)StringUtil.byteArray2HexString((byte[])publicKey.getEncoded()));
                    }
                }
            } else if (CertificateType.X_509 == certificateType) {
                List<X500Principal> authorities;
                if (this.certificateChain != null && (negotiatedSignatureAndHashAlgorithm = this.certificateRequest.getSignatureAndHashAlgorithm(this.certificateChain, supported)) != null && (clientCertificate = new CertificateMessage(this.certificateChain, authorities = this.truncateCertificatePath ? this.certificateRequest.getCertificateAuthorities() : null)).isEmpty()) {
                    negotiatedSignatureAndHashAlgorithm = null;
                }
            } else {
                throw new IllegalArgumentException("Certificate type " + (Object)((Object)certificateType) + " not supported!");
            }
            if (clientCertificate == null && negotiatedSignatureAndHashAlgorithm == null) {
                clientCertificate = new CertificateMessage();
            }
            this.wrapMessage(flight, clientCertificate);
            this.getSession().setSignatureAndHashAlgorithm(negotiatedSignatureAndHashAlgorithm);
        }
    }

    protected static boolean isSupportedCertificateType(CertificateType certType, List<CertificateType> supportedCertificateTypes) {
        if (supportedCertificateTypes != null) {
            return supportedCertificateTypes.contains((Object)certType);
        }
        return certType == CertificateType.X_509;
    }

    public void startHandshake() throws HandshakeException {
        this.handshakeStarted();
        ClientHello startMessage = new ClientHello(this.maxProtocolVersion, this.supportedCipherSuites, this.supportedSignatureAlgorithms, this.supportedClientCertificateTypes, this.supportedServerCertificateTypes, this.supportedGroups);
        if (CipherSuite.containsEccBasedCipherSuite(startMessage.getCipherSuites())) {
            this.expectEcc();
        }
        this.clientRandom = startMessage.getRandom();
        startMessage.addCompressionMethod(CompressionMethod.NULL);
        if (this.extendedMasterSecretMode != ExtendedMasterSecretMode.NONE) {
            startMessage.addExtension(ExtendedMasterSecretExtension.INSTANCE);
        }
        this.addConnectionId(startMessage);
        this.addRecordSizeLimit(startMessage);
        this.addMaxFragmentLength(startMessage);
        this.addServerNameIndication(startMessage);
        this.flightNumber = 1;
        this.clientHello = startMessage;
        DTLSFlight flight = this.createFlight();
        this.wrapMessage(flight, startMessage);
        this.sendFlight(flight);
        this.setExpectedStates(INIT);
    }

    protected void addRecordSizeLimit(ClientHello helloMessage) {
        if (this.recordSizeLimit != null) {
            RecordSizeLimitExtension ext = new RecordSizeLimitExtension(this.recordSizeLimit);
            helloMessage.addExtension(ext);
            this.LOGGER.debug("Indicating record size limit [{}] to server [{}]", (Object)this.recordSizeLimit, this.peerToLog);
        }
    }

    protected void addMaxFragmentLength(ClientHello helloMessage) {
        if (this.maxFragmentLength != null) {
            MaxFragmentLengthExtension ext = new MaxFragmentLengthExtension(this.maxFragmentLength);
            helloMessage.addExtension(ext);
            this.LOGGER.debug("Indicating max. fragment length [{}] to server [{}]", (Object)this.maxFragmentLength, this.peerToLog);
        }
    }

    protected void addConnectionId(ClientHello helloMessage) {
        if (this.supportsConnectionId()) {
            ConnectionId connectionId = this.connectionIdGenerator.useConnectionId() ? this.getConnection().getConnectionId() : ConnectionId.EMPTY;
            HelloExtension.ExtensionType cidType = this.useDeprecatedCid != null ? HelloExtension.ExtensionType.getExtensionTypeById(this.useDeprecatedCid) : HelloExtension.ExtensionType.CONNECTION_ID;
            ConnectionIdExtension extension = ConnectionIdExtension.fromConnectionId(connectionId, cidType);
            helloMessage.addExtension(extension);
        }
    }

    protected void addServerNameIndication(ClientHello helloMessage) {
        ServerNames serverNames = this.getServerNames();
        if (serverNames != null) {
            this.LOGGER.debug("adding SNI extension to CLIENT_HELLO message [{}]", (Object)this.getSession().getHostName());
            helloMessage.addExtension(ServerNameExtension.forServerNames(serverNames));
        }
    }

    protected PskPublicInformation getPskClientIdentity() throws HandshakeException {
        PskPublicInformation pskIdentity;
        ServerNames serverName = this.getServerNames();
        if (serverName != null && !this.getSession().isSniSupported()) {
            this.LOGGER.warn("client is configured to use SNI but server does not support it, PSK authentication is likely to fail");
        }
        if ((pskIdentity = this.advancedPskStore.getIdentity(this.getPeerAddress(), serverName)) == null) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR);
            if (serverName != null) {
                throw new HandshakeException(String.format("No Identity found for peer [address: %s, virtual host: %s]", this.peerToLog, this.getSession().getHostName()), alert);
            }
            throw new HandshakeException(String.format("No Identity found for peer [address: %s]", this.peerToLog), alert);
        }
        return pskIdentity;
    }

    @Override
    public boolean isProbing() {
        return this.probe;
    }

    @Override
    public void resetProbing() {
        this.probe = false;
    }

    @Override
    public boolean isRemovingConnection() {
        return !this.probe && super.isRemovingConnection();
    }
}

