/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.InvalidKeyException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DataStreamReader;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.SerializationUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.elements.util.WipAPI;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.DTLSConnectionState;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.util.SecretIvParameterSpec;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DTLSContext
implements Destroyable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DTLSContext.class);
    private static final long RECEIVE_WINDOW_SIZE = 64L;
    private ConnectionId writeConnectionId = null;
    private ConnectionId readConnectionId = null;
    private DTLSConnectionState readState = DTLSConnectionState.NULL;
    private DTLSConnectionState writeState = DTLSConnectionState.NULL;
    private SecretKey clusterWriteMacKey = null;
    private SecretKey clusterReadMacKey = null;
    private int readEpoch = 0;
    private int writeEpoch = 0;
    private long[] sequenceNumbers = new long[2];
    private int readEpochClosed;
    private long readSequenceNumberClosed;
    private boolean markedAsclosed;
    private volatile long receiveWindowUpperCurrent = -1L;
    private volatile long receiveWindowLowerBoundary = 0L;
    private volatile long receivedRecordsVector = 0L;
    private volatile long macErrors = 0L;
    private final long handshakeTime;
    private final DTLSSession session;
    private static final int VERSION = 2;
    private static final int SEQN_VERSION = 1;

    DTLSContext(long initialRecordSequenceNo) {
        if (initialRecordSequenceNo < 0L || initialRecordSequenceNo > 0xFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("Initial sequence number must be greater than 0 and less than 2^48");
        }
        this.session = new DTLSSession();
        this.handshakeTime = System.currentTimeMillis();
        this.sequenceNumbers[0] = initialRecordSequenceNo;
    }

    @Override
    public void destroy() throws DestroyFailedException {
        SecretUtil.destroy(this.session);
        SecretUtil.destroy(this.clusterWriteMacKey);
        this.clusterWriteMacKey = null;
        SecretUtil.destroy(this.clusterReadMacKey);
        this.clusterReadMacKey = null;
        if (this.readState != DTLSConnectionState.NULL) {
            this.readState.destroy();
            this.readState = DTLSConnectionState.NULL;
        }
        if (this.writeState != DTLSConnectionState.NULL) {
            this.writeState.destroy();
            this.writeState = DTLSConnectionState.NULL;
        }
    }

    @Override
    public boolean isDestroyed() {
        return SecretUtil.isDestroyed(this.session) && SecretUtil.isDestroyed(this.readState) && SecretUtil.isDestroyed(this.writeState) && SecretUtil.isDestroyed(this.clusterReadMacKey) && SecretUtil.isDestroyed(this.clusterWriteMacKey);
    }

    public DTLSSession getSession() {
        return this.session;
    }

    public ConnectionId getWriteConnectionId() {
        return this.writeConnectionId;
    }

    void setWriteConnectionId(ConnectionId connectionId) {
        this.writeConnectionId = connectionId;
    }

    public ConnectionId getReadConnectionId() {
        return this.readConnectionId;
    }

    void setReadConnectionId(ConnectionId connectionId) {
        this.readConnectionId = connectionId;
    }

    void setClusterMacKeys(SecretKey clusterWriteMacKey, SecretKey clusterReadMacKey) {
        this.clusterWriteMacKey = SecretUtil.create(clusterWriteMacKey);
        this.clusterReadMacKey = SecretUtil.create(clusterReadMacKey);
    }

    public Mac getThreadLocalClusterWriteMac() {
        if (this.clusterWriteMacKey != null) {
            try {
                Mac mac = this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac();
                mac.init(this.clusterWriteMacKey);
                return mac;
            }
            catch (InvalidKeyException e) {
                LOGGER.info("cluster write MAC failed!", (Throwable)e);
            }
        }
        return null;
    }

    public Mac getThreadLocalClusterReadMac() {
        if (this.clusterReadMacKey != null) {
            try {
                Mac mac = this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac();
                mac.init(this.clusterReadMacKey);
                return mac;
            }
            catch (InvalidKeyException e) {
                LOGGER.info("cluster read MAC failed!", (Throwable)e);
            }
        }
        return null;
    }

    public long getLastHandshakeTime() {
        return this.handshakeTime;
    }

    public void addWriteEndpointContext(MapBasedEndpointContext.Attributes attributes) {
        this.addEndpointContext(attributes, this.writeEpoch);
    }

    public void addReadEndpointContext(MapBasedEndpointContext.Attributes attributes) {
        this.addEndpointContext(attributes, this.readEpoch);
    }

    private void addEndpointContext(MapBasedEndpointContext.Attributes attributes, int epoch) {
        this.session.addEndpintContext(attributes);
        attributes.add("DTLS_EPOCH", Integer.valueOf(epoch));
        attributes.add("DTLS_HANDSHAKE_TIMESTAMP", Long.valueOf(this.handshakeTime));
        if (this.writeConnectionId != null && this.readConnectionId != null) {
            attributes.add("DTLS_READ_CONNECTION_ID", (Bytes)this.readConnectionId);
            attributes.add("DTLS_WRITE_CONNECTION_ID", (Bytes)this.writeConnectionId);
        }
    }

    public int getWriteEpoch() {
        return this.writeEpoch;
    }

    void setWriteEpoch(int epoch) {
        if (epoch < 0) {
            throw new IllegalArgumentException("Write epoch must not be negative");
        }
        this.writeEpoch = epoch;
    }

    public int getReadEpoch() {
        return this.readEpoch;
    }

    void setReadEpoch(int epoch) {
        if (epoch < 0) {
            throw new IllegalArgumentException("Read epoch must not be negative");
        }
        this.resetReceiveWindow();
        this.readEpoch = epoch;
    }

    void incrementReadEpoch() {
        this.resetReceiveWindow();
        ++this.readEpoch;
    }

    private void incrementWriteEpoch() {
        ++this.writeEpoch;
        this.sequenceNumbers[this.writeEpoch] = 0L;
    }

    public long getNextSequenceNumber() {
        return this.getNextSequenceNumber(this.writeEpoch);
    }

    public long getNextSequenceNumber(int epoch) {
        long sequenceNumber = this.sequenceNumbers[epoch];
        if (sequenceNumber <= 0xFFFFFFFFFFFFL) {
            this.sequenceNumbers[epoch] = sequenceNumber + 1L;
            return sequenceNumber;
        }
        throw new IllegalStateException("Maximum sequence number for epoch has been reached");
    }

    public DTLSConnectionState getReadState() {
        return this.readState;
    }

    public void createReadState(SecretKey encryptionKey, SecretIvParameterSpec iv, SecretKey macKey) {
        DTLSConnectionState readState = DTLSConnectionState.create(this.session.getCipherSuite(), this.session.getCompressionMethod(), encryptionKey, iv, macKey);
        SecretUtil.destroy(this.readState);
        this.readState = readState;
        this.incrementReadEpoch();
        LOGGER.trace("Setting current read state to{}{}", (Object)StringUtil.lineSeparator(), (Object)readState);
    }

    public String getReadStateCipher() {
        return this.readState.getCipherSuite().name();
    }

    DTLSConnectionState getWriteState() {
        return this.getWriteState(this.writeEpoch);
    }

    DTLSConnectionState getWriteState(int epoch) {
        if (epoch == 0) {
            return DTLSConnectionState.NULL;
        }
        return this.writeState;
    }

    public void createWriteState(SecretKey encryptionKey, SecretIvParameterSpec iv, SecretKey macKey) {
        DTLSConnectionState writeState = DTLSConnectionState.create(this.session.getCipherSuite(), this.session.getCompressionMethod(), encryptionKey, iv, macKey);
        SecretUtil.destroy(this.writeState);
        this.writeState = writeState;
        this.incrementWriteEpoch();
        LOGGER.trace("Setting current write state to{}{}", (Object)StringUtil.lineSeparator(), (Object)writeState);
    }

    public String getWriteStateCipher() {
        return this.writeState.getCipherSuite().name();
    }

    public boolean isRecordProcessable(int epoch, long sequenceNo, int useExtendedWindow) {
        int readEpoch = this.getReadEpoch();
        if (epoch != readEpoch) {
            throw new IllegalArgumentException("wrong epoch! " + epoch + " != " + readEpoch);
        }
        if (sequenceNo < this.receiveWindowLowerBoundary) {
            if (useExtendedWindow < 0) {
                return true;
            }
            return sequenceNo > this.receiveWindowLowerBoundary - (long)useExtendedWindow;
        }
        if (this.markedAsclosed) {
            if (epoch > this.readEpochClosed) {
                return false;
            }
            if (epoch == this.readEpochClosed && sequenceNo >= this.readSequenceNumberClosed) {
                return false;
            }
        }
        return !this.isDuplicate(sequenceNo);
    }

    boolean isDuplicate(long sequenceNo) {
        if (sequenceNo > this.receiveWindowUpperCurrent) {
            return false;
        }
        long idx = sequenceNo - this.receiveWindowLowerBoundary;
        long bitMask = 1L << (int)idx;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Checking sequence no [{}] using bit mask [{}] against received records [{}] with lower boundary [{}]", new Object[]{sequenceNo, Long.toBinaryString(bitMask), Long.toBinaryString(this.receivedRecordsVector), this.receiveWindowLowerBoundary});
        }
        return (this.receivedRecordsVector & bitMask) == bitMask;
    }

    public boolean markRecordAsRead(int epoch, long sequenceNo) {
        boolean newest;
        int readEpoch = this.getReadEpoch();
        if (epoch != readEpoch) {
            throw new IllegalArgumentException("wrong epoch! " + epoch + " != " + readEpoch);
        }
        boolean bl = newest = sequenceNo > this.receiveWindowUpperCurrent;
        if (newest) {
            this.receiveWindowUpperCurrent = sequenceNo;
            long lowerBoundary = Math.max(0L, sequenceNo - 64L + 1L);
            long incr = lowerBoundary - this.receiveWindowLowerBoundary;
            if (incr > 0L) {
                this.receivedRecordsVector >>>= (int)incr;
                this.receiveWindowLowerBoundary = lowerBoundary;
            }
        }
        long bitMask = 1L << (int)(sequenceNo - this.receiveWindowLowerBoundary);
        this.receivedRecordsVector |= bitMask;
        LOGGER.debug("Updated receive window with sequence number [{}]: new upper boundary [{}], new bit vector [{}]", new Object[]{sequenceNo, this.receiveWindowUpperCurrent, Long.toBinaryString(this.receivedRecordsVector)});
        return newest;
    }

    public boolean isMarkedAsClosed() {
        return this.markedAsclosed;
    }

    public void markCloseNotify(int epoch, long sequenceNo) {
        this.markedAsclosed = true;
        this.readEpochClosed = epoch;
        this.readSequenceNumberClosed = sequenceNo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.handshakeTime ^ this.handshakeTime >>> 32);
        if (this.markedAsclosed) {
            result = 31 * result + this.readEpochClosed;
            result = 31 * result + (int)this.readSequenceNumberClosed;
        } else {
            result = 31 * result + this.readEpoch;
            result = 31 * result + (int)this.receiveWindowUpperCurrent;
        }
        result = 31 * result + this.writeEpoch;
        result = 31 * result + (int)this.sequenceNumbers[this.writeEpoch];
        result = 31 * result + (int)this.receiveWindowLowerBoundary;
        result = 31 * result + (int)(this.receivedRecordsVector ^ this.receivedRecordsVector >>> 32);
        result = 31 * result + (this.readConnectionId == null ? 0 : this.readConnectionId.hashCode());
        result = 31 * result + (this.writeConnectionId == null ? 0 : this.writeConnectionId.hashCode());
        result = 31 * result + this.session.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DTLSContext other = (DTLSContext)obj;
        if (!this.session.equals(other.session)) {
            return false;
        }
        if (this.handshakeTime != other.handshakeTime) {
            return false;
        }
        if (this.markedAsclosed != other.markedAsclosed) {
            return false;
        }
        if (this.markedAsclosed) {
            if (this.readEpochClosed != other.readEpochClosed) {
                return false;
            }
            if (this.readSequenceNumberClosed != other.readSequenceNumberClosed) {
                return false;
            }
        }
        if (!Bytes.equals((Bytes)this.readConnectionId, (Bytes)other.readConnectionId)) {
            return false;
        }
        if (!Bytes.equals((Bytes)this.writeConnectionId, (Bytes)other.writeConnectionId)) {
            return false;
        }
        if (this.readEpoch != other.readEpoch) {
            return false;
        }
        if (this.receiveWindowLowerBoundary != other.receiveWindowLowerBoundary) {
            return false;
        }
        if (this.receiveWindowUpperCurrent != other.receiveWindowUpperCurrent) {
            return false;
        }
        if (this.receivedRecordsVector != other.receivedRecordsVector) {
            return false;
        }
        if (this.writeEpoch != other.writeEpoch) {
            return false;
        }
        return this.sequenceNumbers[this.writeEpoch] == other.sequenceNumbers[this.writeEpoch];
    }

    private void resetReceiveWindow() {
        this.receivedRecordsVector = 0L;
        this.receiveWindowUpperCurrent = -1L;
        this.receiveWindowLowerBoundary = 0L;
    }

    public void incrementMacErrors() {
        ++this.macErrors;
    }

    public long getMacErrors() {
        return this.macErrors;
    }

    @WipAPI
    public boolean writeTo(DatagramWriter writer) {
        if (this.markedAsclosed) {
            return false;
        }
        int position = SerializationUtil.writeStartItem((DatagramWriter)writer, (int)2, (int)16);
        writer.writeLong(this.handshakeTime, 64);
        this.session.writeTo(writer);
        writer.write(this.readEpoch, 8);
        if (this.readEpoch > 0) {
            this.getReadState().writeTo(writer);
        }
        writer.write(this.writeEpoch, 8);
        if (this.writeEpoch > 0) {
            this.getWriteState().writeTo(writer);
        }
        writer.writeVarBytes((Bytes)this.writeConnectionId, 8);
        this.writeSequenceNumbers(writer);
        SerializationUtil.writeFinishedItem((DatagramWriter)writer, (int)position, (int)16);
        return true;
    }

    @WipAPI
    public static DTLSContext fromReader(DatagramReader reader) {
        int length = SerializationUtil.readStartItem((DataStreamReader)reader, (int)2, (int)16);
        if (0 < length) {
            DatagramReader rangeReader = reader.createRangeReader(length);
            return new DTLSContext(rangeReader);
        }
        return null;
    }

    private DTLSContext(DatagramReader reader) {
        this.handshakeTime = reader.readLong(64);
        this.session = DTLSSession.fromReader(reader);
        if (this.session == null) {
            throw new IllegalArgumentException("read session must not be null!");
        }
        this.readEpoch = reader.read(8);
        if (this.readEpoch > 0) {
            this.readState = DTLSConnectionState.fromReader(this.session.getCipherSuite(), this.session.getCompressionMethod(), reader);
        }
        this.writeEpoch = reader.read(8);
        if (this.writeEpoch == 1) {
            this.writeState = DTLSConnectionState.fromReader(this.session.getCipherSuite(), this.session.getCompressionMethod(), reader);
        } else if (this.writeEpoch > 1) {
            throw new IllegalArgumentException("write epoch must be 1!");
        }
        byte[] data = reader.readVarBytes(8);
        if (data != null) {
            this.writeConnectionId = new ConnectionId(data);
        }
        this.readSequenceNumbers(reader);
        reader.assertFinished("dtls-context");
    }

    @WipAPI
    public void writeSequenceNumbers(DatagramWriter writer) {
        int position = SerializationUtil.writeStartItem((DatagramWriter)writer, (int)1, (int)8);
        writer.writeLong(this.sequenceNumbers[this.writeEpoch], 48);
        writer.writeLong(this.receiveWindowLowerBoundary, 48);
        writer.writeLong(this.receivedRecordsVector, 64);
        writer.writeLong(this.macErrors, 64);
        SerializationUtil.writeFinishedItem((DatagramWriter)writer, (int)position, (int)8);
    }

    @WipAPI
    public void readSequenceNumbers(DatagramReader reader) {
        int length = SerializationUtil.readStartItem((DataStreamReader)reader, (int)1, (int)8);
        if (0 < length) {
            DatagramReader rangeReader = reader.createRangeReader(length);
            long sequenceNumber = rangeReader.readLong(48);
            long receiveLowerBoundary = rangeReader.readLong(48);
            long receivedVector = rangeReader.readLong(64);
            long errors = rangeReader.readLong(64);
            rangeReader.assertFinished("dtls-context-sequence-numbers");
            int zeros = Long.numberOfLeadingZeros(receivedVector);
            this.sequenceNumbers[this.writeEpoch] = sequenceNumber;
            this.receiveWindowLowerBoundary = receiveLowerBoundary;
            this.receivedRecordsVector = receivedVector;
            this.receiveWindowUpperCurrent = receiveLowerBoundary + 64L - (long)zeros - 1L;
            this.macErrors = errors;
        }
    }
}

