/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.crypto.Mac;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.ClientCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.ConnectionIdExtension;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.RecordSizeLimitExtension;
import org.eclipse.californium.scandium.dtls.ServerCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ServerNameExtension;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SignatureAlgorithmsExtension;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.SupportedEllipticCurvesExtension;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.eclipse.californium.scandium.util.ServerNames;

@NoPublicAPI
public final class ClientHello
extends HandshakeMessage {
    private static final int VERSION_BITS = 8;
    private static final int RANDOM_BYTES = 32;
    private static final int SESSION_ID_LENGTH_BITS = 8;
    private static final int COOKIE_LENGTH = 8;
    private static final int CIPHER_SUITES_LENGTH_BITS = 16;
    private static final int COMPRESSION_METHODS_LENGTH_BITS = 8;
    private final ProtocolVersion clientVersion;
    private final Random random;
    private final SessionId sessionId;
    private byte[] cookie;
    private final List<CipherSuite> supportedCipherSuites;
    private final List<CompressionMethod> compressionMethods;
    private final HelloExtensions extensions;

    public ClientHello(ProtocolVersion version, List<CipherSuite> supportedCipherSuites, List<SignatureAndHashAlgorithm> supportedSignatureAndHashAlgorithms, List<CertificateType> supportedClientCertificateTypes, List<CertificateType> supportedServerCertificateTypes, List<XECDHECryptography.SupportedGroup> supportedGroups) {
        this(version, null, supportedCipherSuites, supportedSignatureAndHashAlgorithms, supportedClientCertificateTypes, supportedServerCertificateTypes, supportedGroups);
    }

    public ClientHello(ProtocolVersion version, DTLSSession session, List<SignatureAndHashAlgorithm> supportedSignatureAndHashAlgorithms, List<CertificateType> supportedClientCertificateTypes, List<CertificateType> supportedServerCertificateTypes, List<XECDHECryptography.SupportedGroup> supportedGroups) {
        this(version, session.getSessionIdentifier(), Arrays.asList(session.getCipherSuite()), supportedSignatureAndHashAlgorithms, supportedClientCertificateTypes, supportedServerCertificateTypes, supportedGroups);
        this.addCompressionMethod(session.getCompressionMethod());
    }

    private ClientHello(ProtocolVersion version, SessionId sessionId, List<CipherSuite> supportedCipherSuites, List<SignatureAndHashAlgorithm> supportedSignatureAndHashAlgorithms, List<CertificateType> supportedClientCertificateTypes, List<CertificateType> supportedServerCertificateTypes, List<XECDHECryptography.SupportedGroup> supportedGroups) {
        this.clientVersion = version;
        this.random = new Random();
        this.cookie = Bytes.EMPTY;
        this.sessionId = sessionId != null ? sessionId : SessionId.emptySessionId();
        this.supportedCipherSuites = new ArrayList<CipherSuite>();
        if (supportedCipherSuites != null) {
            this.supportedCipherSuites.addAll(supportedCipherSuites);
        }
        this.compressionMethods = new ArrayList<CompressionMethod>();
        this.extensions = new HelloExtensions();
        if (CipherSuite.containsEccBasedCipherSuite(supportedCipherSuites)) {
            this.addExtension(new SupportedEllipticCurvesExtension(supportedGroups));
            this.addExtension(SupportedPointFormatsExtension.DEFAULT_POINT_FORMATS_EXTENSION);
        }
        if (!supportedSignatureAndHashAlgorithms.isEmpty()) {
            if (this.useCertificateTypeRawPublicKeyOnly(supportedClientCertificateTypes) && this.useCertificateTypeRawPublicKeyOnly(supportedServerCertificateTypes)) {
                supportedSignatureAndHashAlgorithms = SignatureAndHashAlgorithm.getEcdsaCompatibleSignatureAlgorithms(supportedSignatureAndHashAlgorithms);
            }
            this.addExtension(new SignatureAlgorithmsExtension(supportedSignatureAndHashAlgorithms));
        }
        if (CipherSuite.containsCipherSuiteRequiringCertExchange(supportedCipherSuites)) {
            if (this.useCertificateTypeExtension(supportedClientCertificateTypes)) {
                ClientCertificateTypeExtension clientCertificateType = new ClientCertificateTypeExtension(supportedClientCertificateTypes);
                this.addExtension(clientCertificateType);
            }
            if (this.useCertificateTypeExtension(supportedServerCertificateTypes)) {
                ServerCertificateTypeExtension serverCertificateType = new ServerCertificateTypeExtension(supportedServerCertificateTypes);
                this.addExtension(serverCertificateType);
            }
        }
    }

    private ClientHello(DatagramReader reader) throws HandshakeException {
        int major = reader.read(8);
        int minor = reader.read(8);
        this.clientVersion = ProtocolVersion.valueOf(major, minor);
        this.random = new Random(reader.readBytes(32));
        this.sessionId = new SessionId(reader.readVarBytes(8));
        this.cookie = reader.readVarBytes(8);
        int cipherSuitesLength = reader.read(16);
        DatagramReader rangeReader = reader.createRangeReader(cipherSuitesLength);
        this.supportedCipherSuites = CipherSuite.listFromReader(rangeReader);
        int compressionMethodsLength = reader.read(8);
        rangeReader = reader.createRangeReader(compressionMethodsLength);
        this.compressionMethods = CompressionMethod.listFromReader(rangeReader);
        this.extensions = HelloExtensions.fromReader(reader);
    }

    private boolean useCertificateTypeExtension(List<CertificateType> supportedCertificateTypes) {
        if (supportedCertificateTypes != null && !supportedCertificateTypes.isEmpty()) {
            return supportedCertificateTypes.size() > 1 || !supportedCertificateTypes.contains((Object)CertificateType.X_509);
        }
        return false;
    }

    private boolean useCertificateTypeRawPublicKeyOnly(List<CertificateType> supportedCertificateTypes) {
        if (supportedCertificateTypes != null && supportedCertificateTypes.size() == 1) {
            return supportedCertificateTypes.contains((Object)CertificateType.RAW_PUBLIC_KEY);
        }
        return false;
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.clientVersion.getMajor(), 8);
        writer.write(this.clientVersion.getMinor(), 8);
        writer.writeBytes(this.random.getBytes());
        writer.writeVarBytes((Bytes)this.sessionId, 8);
        writer.writeVarBytes(this.cookie, 8);
        writer.write(this.supportedCipherSuites.size() * 2, 16);
        CipherSuite.listToWriter(writer, this.supportedCipherSuites);
        writer.write(this.compressionMethods.size(), 8);
        CompressionMethod.listToWriter(writer, this.compressionMethods);
        writer.writeBytes(this.extensions.toByteArray());
        return writer.toByteArray();
    }

    public static ClientHello fromReader(DatagramReader reader) throws HandshakeException {
        return new ClientHello(reader);
    }

    @Override
    public HandshakeType getMessageType() {
        return HandshakeType.CLIENT_HELLO;
    }

    @Override
    public int getMessageLength() {
        int extensionsLength = this.extensions.isEmpty() ? 0 : 2 + this.extensions.getLength();
        return 39 + this.sessionId.length() + this.cookie.length + this.supportedCipherSuites.size() * 2 + this.compressionMethods.size() + extensionsLength;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\t\tVersion: ").append(this.clientVersion.getMajor()).append(", ").append(this.clientVersion.getMinor());
        sb.append(StringUtil.lineSeparator()).append("\t\tRandom:").append(StringUtil.lineSeparator()).append((Object)this.random);
        sb.append("\t\tSession ID Length: ").append(this.sessionId.length());
        if (this.sessionId.length() > 0) {
            sb.append(StringUtil.lineSeparator()).append("\t\tSession ID: ").append((Object)this.sessionId);
        }
        sb.append(StringUtil.lineSeparator()).append("\t\tCookie Length: ").append(this.cookie.length);
        if (this.cookie.length > 0) {
            sb.append(StringUtil.lineSeparator()).append("\t\tCookie: ").append(StringUtil.byteArray2HexString((byte[])this.cookie));
        }
        sb.append(StringUtil.lineSeparator()).append("\t\tCipher Suites Length: ").append(this.supportedCipherSuites.size() * 2);
        sb.append(StringUtil.lineSeparator()).append("\t\tCipher Suites (").append(this.supportedCipherSuites.size()).append(" suites)");
        for (CipherSuite cipher : this.supportedCipherSuites) {
            sb.append(StringUtil.lineSeparator()).append("\t\t\tCipher Suite: ").append((Object)cipher);
        }
        sb.append(StringUtil.lineSeparator()).append("\t\tCompression Methods Length: ").append(this.compressionMethods.size());
        sb.append(StringUtil.lineSeparator()).append("\t\tCompression Methods (").append(this.compressionMethods.size()).append(" methods)");
        for (CompressionMethod method : this.compressionMethods) {
            sb.append(StringUtil.lineSeparator()).append("\t\t\tCompression Method: ").append((Object)method);
        }
        sb.append(StringUtil.lineSeparator()).append(this.extensions);
        return sb.toString();
    }

    public ProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    public Random getRandom() {
        return this.random;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public boolean hasSessionId() {
        return !this.sessionId.isEmpty();
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public boolean hasCookie() {
        return this.cookie.length > 0;
    }

    public void setCookie(byte[] cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie must not be null!");
        }
        if (cookie.length == 0) {
            throw new IllegalArgumentException("cookie must not be empty!");
        }
        this.cookie = Arrays.copyOf(cookie, cookie.length);
        this.fragmentChanged();
    }

    public void updateForCookie(Mac hmac) {
        byte[] rawMessage = this.toByteArray();
        int head = this.sessionId.length() + 32 + 3;
        int tail = head + 1 + 12;
        if (this.cookie != null) {
            tail += this.cookie.length;
        }
        hmac.update(rawMessage, 12, head);
        hmac.update(rawMessage, tail, rawMessage.length - tail);
    }

    public List<CipherSuite> getCipherSuites() {
        return Collections.unmodifiableList(this.supportedCipherSuites);
    }

    public List<CipherSuite> getCommonCipherSuites(List<CipherSuite> serverCipherSuite) {
        ArrayList<CipherSuite> common = new ArrayList<CipherSuite>();
        for (CipherSuite cipherSuite : this.supportedCipherSuites) {
            if (cipherSuite == CipherSuite.TLS_NULL_WITH_NULL_NULL || !serverCipherSuite.contains((Object)cipherSuite)) continue;
            common.add(cipherSuite);
        }
        return common;
    }

    public List<CompressionMethod> getCompressionMethods() {
        return Collections.unmodifiableList(this.compressionMethods);
    }

    public void setCompressionMethods(List<CompressionMethod> compressionMethods) {
        this.compressionMethods.addAll(compressionMethods);
    }

    public void addCompressionMethod(CompressionMethod compressionMethod) {
        this.compressionMethods.add(compressionMethod);
    }

    void addExtension(HelloExtension extension) {
        this.extensions.addExtension(extension);
    }

    public HelloExtensions getExtensions() {
        return this.extensions;
    }

    public SupportedEllipticCurvesExtension getSupportedEllipticCurvesExtension() {
        return (SupportedEllipticCurvesExtension)this.extensions.getExtension(HelloExtension.ExtensionType.ELLIPTIC_CURVES);
    }

    public SupportedPointFormatsExtension getSupportedPointFormatsExtension() {
        return (SupportedPointFormatsExtension)this.extensions.getExtension(HelloExtension.ExtensionType.EC_POINT_FORMATS);
    }

    public ClientCertificateTypeExtension getClientCertificateTypeExtension() {
        return (ClientCertificateTypeExtension)this.extensions.getExtension(HelloExtension.ExtensionType.CLIENT_CERT_TYPE);
    }

    public ServerCertificateTypeExtension getServerCertificateTypeExtension() {
        return (ServerCertificateTypeExtension)this.extensions.getExtension(HelloExtension.ExtensionType.SERVER_CERT_TYPE);
    }

    public SignatureAlgorithmsExtension getSupportedSignatureAlgorithms() {
        return (SignatureAlgorithmsExtension)this.extensions.getExtension(HelloExtension.ExtensionType.SIGNATURE_ALGORITHMS);
    }

    public MaxFragmentLengthExtension getMaxFragmentLengthExtension() {
        return (MaxFragmentLengthExtension)this.extensions.getExtension(HelloExtension.ExtensionType.MAX_FRAGMENT_LENGTH);
    }

    public RecordSizeLimitExtension getRecordSizeLimitExtension() {
        return (RecordSizeLimitExtension)this.extensions.getExtension(HelloExtension.ExtensionType.RECORD_SIZE_LIMIT);
    }

    public ServerNameExtension getServerNameExtension() {
        return (ServerNameExtension)this.extensions.getExtension(HelloExtension.ExtensionType.SERVER_NAME);
    }

    public ServerNames getServerNames() {
        ServerNameExtension extension = this.getServerNameExtension();
        return extension == null ? null : extension.getServerNames();
    }

    public ConnectionIdExtension getConnectionIdExtension() {
        return (ConnectionIdExtension)this.extensions.getExtension(HelloExtension.ExtensionType.CONNECTION_ID);
    }

    public boolean hasExtendedMasterSecret() {
        return this.extensions.getExtension(HelloExtension.ExtensionType.EXTENDED_MASTER_SECRET) != null;
    }
}

