/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSMessage;

public final class ApplicationMessage
implements DTLSMessage {
    private final byte[] data;

    public ApplicationMessage(byte[] data) {
        if (data == null) {
            throw new NullPointerException("data must not be null!");
        }
        this.data = data;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_DATA;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\tApplication Data: ").append(StringUtil.byteArray2Hex((byte[])this.data)).append(StringUtil.lineSeparator());
        return sb.toString();
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public byte[] toByteArray() {
        return this.data;
    }

    public static DTLSMessage fromByteArray(byte[] byteArray) {
        return new ApplicationMessage(byteArray);
    }

    public byte[] getData() {
        return this.data;
    }
}

