/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.config;

import java.net.InetSocketAddress;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.elements.util.CertPathUtil;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.ConnectionListener;
import org.eclipse.californium.scandium.DtlsHealth;
import org.eclipse.californium.scandium.auth.ApplicationLevelInfoSupplier;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.ConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuiteSelector;
import org.eclipse.californium.scandium.dtls.cipher.DefaultCipherSuiteSelector;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedInMemoryPskStore;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.dtls.rpkstore.TrustAllRpks;
import org.eclipse.californium.scandium.dtls.rpkstore.TrustedRpkStore;
import org.eclipse.californium.scandium.dtls.x509.CertificateVerifier;
import org.eclipse.californium.scandium.dtls.x509.StaticCertificateVerifier;
import org.eclipse.californium.scandium.util.ListUtils;

public final class DtlsConnectorConfig {
    public static final int DEFAULT_MAX_DEFERRED_PROCESSED_APPLICATION_DATA_MESSAGES = 10;
    public static final int DEFAULT_MAX_CONNECTIONS = 150000;
    public static final int DEFAULT_MAX_FRAGMENTED_HANDSHAKE_MESSAGE_LENGTH = 8192;
    public static final int DEFAULT_MAX_DEFERRED_PROCESSED_HANDSHAKE_RECORDS_SIZE = 8192;
    public static final long DEFAULT_STALE_CONNECTION_TRESHOLD = 1800L;
    public static final int DEFAULT_RETRANSMISSION_TIMEOUT_MS = 1000;
    public static final int DEFAULT_MAX_RETRANSMISSIONS = 4;
    public static final int DEFAULT_VERIFY_PEERS_ON_RESUMPTION_THRESHOLD_IN_PERCENT = 30;
    public static final int DEFAULT_MAX_TRANSMISSION_UNIT_LIMIT = 1500;
    private static final int DEFAULT_EXECUTOR_THREAD_POOL_SIZE = 6 * Runtime.getRuntime().availableProcessors();
    private static final int DEFAULT_RECEIVER_THREADS = (Runtime.getRuntime().availableProcessors() + 1) / 2;
    private InetSocketAddress address;
    private X509Certificate[] trustStore;
    private CertificateVerifier certificateVerifier;
    private Boolean earlyStopRetransmission;
    private Boolean enableReuseAddress;
    private Integer recordSizeLimit;
    private Integer maxFragmentLengthCode;
    private Integer maxFragmentedHandshakeMessageLength;
    private Boolean enableMultiRecordMessages;
    private Boolean enableMultiHandshakeMessageRecords;
    private Integer retransmissionTimeout;
    private Integer backOffRetransmission;
    private Integer maxRetransmissions;
    private Integer maxTransmissionUnit;
    private Integer maxTransmissionUnitLimit;
    private Boolean clientAuthenticationWanted;
    private Boolean clientAuthenticationRequired;
    private Boolean serverOnly;
    private String defaultHandshakeMode;
    private List<CertificateType> identityCertificateTypes;
    private List<CertificateType> trustCertificateTypes;
    private PskStore pskStore;
    private AdvancedPskStore advancedPskStore;
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private List<X509Certificate> certChain;
    private CipherSuiteSelector cipherSuiteSelector;
    private List<CipherSuite> supportedCipherSuites;
    private List<SignatureAndHashAlgorithm> supportedSignatureAlgorithms;
    private List<XECDHECryptography.SupportedGroup> supportedGroups;
    private TrustedRpkStore trustedRPKs;
    private Integer outboundMessageBufferSize;
    private Integer maxDeferredProcessedOutgoingApplicationDataMessages;
    private Integer maxDeferredProcessedIncomingRecordsSize;
    private Integer maxConnections;
    private Long staleConnectionThreshold;
    private Integer connectionThreadCount;
    private Integer receiverThreadCount;
    private Integer socketReceiveBufferSize;
    private Integer socketSendBufferSize;
    private Integer healthStatusInterval;
    private Long autoResumptionTimeoutMillis;
    private Boolean sniEnabled;
    private Integer verifyPeersOnResumptionThreshold;
    private Boolean useNoServerSessionId;
    private Boolean useAntiReplayFilter;
    private Integer useExtendedWindowFilter;
    private Boolean useCidUpdateAddressOnNewerRecordFilter;
    private String loggingTag;
    private ConnectionIdGenerator connectionIdGenerator;
    private ApplicationLevelInfoSupplier applicationLevelInfoSupplier;
    private Boolean useHandshakeStateValidation;
    private Boolean useKeyUsageVerification;
    private Boolean useTruncatedCertificatePathForClientsCertificateMessage;
    private Boolean useTruncatedCertificatePathForValidation;
    private ConnectionListener connectionListener;
    private DtlsHealth healthHandler;
    private Boolean clientOnly;
    private Boolean recommendedCipherSuitesOnly;
    private Boolean recommendedSupportedGroupsOnly;

    private DtlsConnectorConfig() {
    }

    public Integer getRecordSizeLimit() {
        return this.recordSizeLimit;
    }

    public Integer getMaxFragmentLengthCode() {
        return this.maxFragmentLengthCode;
    }

    public Integer getMaxFragmentedHandshakeMessageLength() {
        return this.maxFragmentedHandshakeMessageLength;
    }

    public Boolean useMultiRecordMessages() {
        return this.enableMultiRecordMessages;
    }

    public Boolean useMultiHandshakeMessageRecords() {
        return this.enableMultiHandshakeMessageRecords;
    }

    public Integer getRetransmissionTimeout() {
        return this.retransmissionTimeout;
    }

    public Integer getMaxDeferredProcessedOutgoingApplicationDataMessages() {
        return this.maxDeferredProcessedOutgoingApplicationDataMessages;
    }

    public Integer getMaxDeferredProcessedIncomingRecordsSize() {
        return this.maxDeferredProcessedIncomingRecordsSize;
    }

    public Integer getBackOffRetransmission() {
        return this.backOffRetransmission;
    }

    public Integer getMaxRetransmissions() {
        return this.maxRetransmissions;
    }

    public Integer getMaxTransmissionUnit() {
        return this.maxTransmissionUnit;
    }

    public Integer getMaxTransmissionUnitLimit() {
        return this.maxTransmissionUnitLimit;
    }

    public Boolean isEarlyStopRetransmission() {
        return this.earlyStopRetransmission;
    }

    public Boolean isAddressReuseEnabled() {
        return this.enableReuseAddress;
    }

    public Boolean isSniEnabled() {
        return this.sniEnabled;
    }

    public Integer getVerifyPeersOnResumptionThreshold() {
        return this.verifyPeersOnResumptionThreshold;
    }

    public ConnectionIdGenerator getConnectionIdGenerator() {
        return this.connectionIdGenerator;
    }

    public Integer getOutboundMessageBufferSize() {
        return this.outboundMessageBufferSize;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public List<X509Certificate> getCertificateChain() {
        return this.certChain;
    }

    public CipherSuiteSelector getCipherSuiteSelector() {
        return this.cipherSuiteSelector;
    }

    public List<CipherSuite> getSupportedCipherSuites() {
        return this.supportedCipherSuites;
    }

    public List<SignatureAndHashAlgorithm> getSupportedSignatureAlgorithms() {
        return this.supportedSignatureAlgorithms;
    }

    public List<XECDHECryptography.SupportedGroup> getSupportedGroups() {
        return this.supportedGroups;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Deprecated
    public PskStore getPskStore() {
        return this.pskStore;
    }

    public AdvancedPskStore getAdvancedPskStore() {
        return this.advancedPskStore;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public X509Certificate[] getTrustStore() {
        if (this.trustStore == null) {
            return null;
        }
        return Arrays.copyOf(this.trustStore, this.trustStore.length);
    }

    public CertificateVerifier getCertificateVerifier() {
        return this.certificateVerifier;
    }

    public ApplicationLevelInfoSupplier getApplicationLevelInfoSupplier() {
        return this.applicationLevelInfoSupplier;
    }

    public Boolean isClientAuthenticationWanted() {
        return this.clientAuthenticationWanted;
    }

    public Boolean isClientAuthenticationRequired() {
        return this.clientAuthenticationRequired;
    }

    public Boolean isServerOnly() {
        return this.serverOnly;
    }

    public String getDefaultHandshakeMode() {
        return this.defaultHandshakeMode;
    }

    public List<CertificateType> getIdentityCertificateTypes() {
        return this.identityCertificateTypes;
    }

    public List<CertificateType> getTrustCertificateTypes() {
        return this.trustCertificateTypes;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public Long getStaleConnectionThreshold() {
        return this.staleConnectionThreshold;
    }

    public Integer getConnectionThreadCount() {
        return this.connectionThreadCount;
    }

    public Integer getReceiverThreadCount() {
        return this.receiverThreadCount;
    }

    public Integer getSocketReceiveBufferSize() {
        return this.socketReceiveBufferSize;
    }

    public Integer getSocketSendBufferSize() {
        return this.socketSendBufferSize;
    }

    public Long getAutoResumptionTimeoutMillis() {
        return this.autoResumptionTimeoutMillis;
    }

    public Boolean useNoServerSessionId() {
        return this.useNoServerSessionId;
    }

    public Boolean useAntiReplayFilter() {
        return this.useAntiReplayFilter;
    }

    @Deprecated
    public Boolean useWindowFilter() {
        return this.useExtendedWindowFilter != null && this.useExtendedWindowFilter < 0;
    }

    public Integer useExtendedWindowFilter() {
        return this.useExtendedWindowFilter;
    }

    public Boolean useCidUpdateAddressOnNewerRecordFilter() {
        return this.useCidUpdateAddressOnNewerRecordFilter;
    }

    public TrustedRpkStore getRpkTrustStore() {
        return this.trustedRPKs;
    }

    public Boolean useHandshakeStateValidation() {
        return this.useHandshakeStateValidation;
    }

    public Boolean useKeyUsageVerification() {
        return this.useKeyUsageVerification;
    }

    public Boolean useTruncatedCertificatePathForClientsCertificateMessage() {
        return this.useTruncatedCertificatePathForClientsCertificateMessage;
    }

    public Boolean useTruncatedCertificatePathForValidation() {
        return this.useTruncatedCertificatePathForValidation;
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    public String getLoggingTag() {
        return this.loggingTag;
    }

    public Integer getHealthStatusInterval() {
        return this.healthStatusInterval;
    }

    public DtlsHealth getHealthHandler() {
        return this.healthHandler;
    }

    public Boolean isClientOnly() {
        return this.clientOnly;
    }

    public Boolean isRecommendedCipherSuitesOnly() {
        return this.recommendedCipherSuitesOnly;
    }

    public Boolean isRecommendedSupportedGroupsOnly() {
        return this.recommendedSupportedGroupsOnly;
    }

    protected Object clone() {
        DtlsConnectorConfig cloned = new DtlsConnectorConfig();
        cloned.address = this.address;
        cloned.trustStore = this.trustStore;
        cloned.certificateVerifier = this.certificateVerifier;
        cloned.earlyStopRetransmission = this.earlyStopRetransmission;
        cloned.enableReuseAddress = this.enableReuseAddress;
        cloned.recordSizeLimit = this.recordSizeLimit;
        cloned.maxFragmentLengthCode = this.maxFragmentLengthCode;
        cloned.maxFragmentedHandshakeMessageLength = this.maxFragmentedHandshakeMessageLength;
        cloned.enableMultiRecordMessages = this.enableMultiRecordMessages;
        cloned.enableMultiHandshakeMessageRecords = this.enableMultiHandshakeMessageRecords;
        cloned.retransmissionTimeout = this.retransmissionTimeout;
        cloned.maxRetransmissions = this.maxRetransmissions;
        cloned.maxTransmissionUnit = this.maxTransmissionUnit;
        cloned.maxTransmissionUnitLimit = this.maxTransmissionUnitLimit;
        cloned.clientAuthenticationRequired = this.clientAuthenticationRequired;
        cloned.clientAuthenticationWanted = this.clientAuthenticationWanted;
        cloned.serverOnly = this.serverOnly;
        cloned.defaultHandshakeMode = this.defaultHandshakeMode;
        cloned.identityCertificateTypes = this.identityCertificateTypes;
        cloned.trustCertificateTypes = this.trustCertificateTypes;
        cloned.pskStore = this.pskStore;
        cloned.advancedPskStore = this.advancedPskStore;
        cloned.privateKey = this.privateKey;
        cloned.publicKey = this.publicKey;
        cloned.certChain = this.certChain;
        cloned.cipherSuiteSelector = this.cipherSuiteSelector;
        cloned.supportedCipherSuites = this.supportedCipherSuites;
        cloned.supportedSignatureAlgorithms = this.supportedSignatureAlgorithms;
        cloned.supportedGroups = this.supportedGroups;
        cloned.trustedRPKs = this.trustedRPKs;
        cloned.outboundMessageBufferSize = this.outboundMessageBufferSize;
        cloned.maxDeferredProcessedOutgoingApplicationDataMessages = this.maxDeferredProcessedOutgoingApplicationDataMessages;
        cloned.maxDeferredProcessedIncomingRecordsSize = this.maxDeferredProcessedIncomingRecordsSize;
        cloned.maxConnections = this.maxConnections;
        cloned.staleConnectionThreshold = this.staleConnectionThreshold;
        cloned.connectionThreadCount = this.connectionThreadCount;
        cloned.receiverThreadCount = this.receiverThreadCount;
        cloned.socketReceiveBufferSize = this.socketReceiveBufferSize;
        cloned.socketSendBufferSize = this.socketSendBufferSize;
        cloned.healthStatusInterval = this.healthStatusInterval;
        cloned.autoResumptionTimeoutMillis = this.autoResumptionTimeoutMillis;
        cloned.sniEnabled = this.sniEnabled;
        cloned.verifyPeersOnResumptionThreshold = this.verifyPeersOnResumptionThreshold;
        cloned.useNoServerSessionId = this.useNoServerSessionId;
        cloned.loggingTag = this.loggingTag;
        cloned.useAntiReplayFilter = this.useAntiReplayFilter;
        cloned.useExtendedWindowFilter = this.useExtendedWindowFilter;
        cloned.useCidUpdateAddressOnNewerRecordFilter = this.useCidUpdateAddressOnNewerRecordFilter;
        cloned.connectionIdGenerator = this.connectionIdGenerator;
        cloned.applicationLevelInfoSupplier = this.applicationLevelInfoSupplier;
        cloned.useHandshakeStateValidation = this.useHandshakeStateValidation;
        cloned.useTruncatedCertificatePathForClientsCertificateMessage = this.useTruncatedCertificatePathForClientsCertificateMessage;
        cloned.useTruncatedCertificatePathForValidation = this.useTruncatedCertificatePathForValidation;
        cloned.useKeyUsageVerification = this.useKeyUsageVerification;
        cloned.connectionListener = this.connectionListener;
        cloned.healthHandler = this.healthHandler;
        cloned.clientOnly = this.clientOnly;
        cloned.recommendedCipherSuitesOnly = this.recommendedCipherSuitesOnly;
        cloned.recommendedSupportedGroupsOnly = this.recommendedSupportedGroupsOnly;
        return cloned;
    }

    static /* synthetic */ X509Certificate[] access$3802(DtlsConnectorConfig x0, X509Certificate[] x1) {
        x0.trustStore = x1;
        return x1;
    }

    public static final class Builder {
        private DtlsConnectorConfig config;

        public Builder() {
            this.config = new DtlsConnectorConfig();
        }

        public Builder(DtlsConnectorConfig initialConfiguration) {
            this.config = (DtlsConnectorConfig)initialConfiguration.clone();
        }

        public Builder setAddress(InetSocketAddress address) {
            if (address.isUnresolved()) {
                throw new IllegalArgumentException("Bind address must not be unresolved");
            }
            this.config.address = address;
            return this;
        }

        public Builder setEnableAddressReuse(boolean enable) {
            this.config.enableReuseAddress = enable;
            return this;
        }

        public Builder setRecommendedCipherSuitesOnly(boolean recommendedCipherSuitesOnly) {
            this.config.recommendedCipherSuitesOnly = recommendedCipherSuitesOnly;
            if (recommendedCipherSuitesOnly && this.config.supportedCipherSuites != null) {
                this.verifyRecommendedCipherSuitesOnly(this.config.supportedCipherSuites);
            }
            return this;
        }

        public Builder setRecommendedSupportedGroupsOnly(boolean recommendedSupportedGroupsOnly) {
            this.config.recommendedSupportedGroupsOnly = recommendedSupportedGroupsOnly;
            if (recommendedSupportedGroupsOnly && this.config.supportedGroups != null) {
                this.verifyRecommendedSupportedGroupsOnly(this.config.supportedGroups);
            }
            return this;
        }

        public Builder setClientOnly() {
            if (this.config.serverOnly != null && this.config.serverOnly.booleanValue()) {
                throw new IllegalStateException("client only is in contradiction to server only!");
            }
            if (this.config.clientAuthenticationRequired != null || this.config.clientAuthenticationWanted != null) {
                throw new IllegalStateException("client only is in contradiction to server side client authentication!");
            }
            if (this.config.useNoServerSessionId != null && this.config.useNoServerSessionId.booleanValue()) {
                throw new IllegalStateException("client only is in contradiction to server side 'no server session id'!");
            }
            this.config.clientOnly = true;
            return this;
        }

        public Builder setServerOnly(boolean enable) {
            if (enable) {
                if (Boolean.TRUE.equals(this.config.clientOnly)) {
                    throw new IllegalStateException("server only is in contradiction to client only!");
                }
                if (this.config.defaultHandshakeMode != null && !this.config.defaultHandshakeMode.equals("none")) {
                    throw new IllegalStateException("server only is in contradiction to default handshake mode '" + this.config.defaultHandshakeMode + "!");
                }
            }
            this.config.serverOnly = enable;
            return this;
        }

        public Builder setDefaultHandshakeMode(String defaultHandshakeMode) {
            if (defaultHandshakeMode != null && !defaultHandshakeMode.equals("auto") && !defaultHandshakeMode.equals("none")) {
                throw new IllegalArgumentException("default handshake mode must be either \"auto\" or \"none\"!");
            }
            if (this.config.serverOnly != null && this.config.serverOnly.booleanValue() && defaultHandshakeMode != null && !defaultHandshakeMode.equals("none")) {
                throw new IllegalStateException("default handshake modes are not supported for server only!");
            }
            this.config.defaultHandshakeMode = defaultHandshakeMode;
            return this;
        }

        public Builder setRecordSizeLimit(Integer recordSizeLimit) {
            if (recordSizeLimit != null && (recordSizeLimit < 64 || recordSizeLimit > 65535)) {
                throw new IllegalArgumentException("Record size limit must be within [64...65535], not " + recordSizeLimit + "!");
            }
            this.config.recordSizeLimit = recordSizeLimit;
            return this;
        }

        public Builder setMaxFragmentLengthCode(Integer lengthCode) {
            if (lengthCode != null && (lengthCode < 1 || lengthCode > 4)) {
                throw new IllegalArgumentException("Maximum fragment length code must be one of {1, 2, 3, 4}");
            }
            this.config.maxFragmentLengthCode = lengthCode;
            return this;
        }

        public Builder setMaxFragmentedHandshakeMessageLength(Integer length) {
            this.config.maxFragmentedHandshakeMessageLength = length;
            return this;
        }

        public Builder setEnableMultiRecordMessages(boolean enable) {
            this.config.enableMultiRecordMessages = enable;
            return this;
        }

        public Builder setEnableMultiHandshakeMessageRecords(boolean enable) {
            this.config.enableMultiHandshakeMessageRecords = enable;
            return this;
        }

        public Builder setSocketReceiveBufferSize(Integer size) {
            this.config.socketReceiveBufferSize = size;
            return this;
        }

        public Builder setSocketSendBufferSize(Integer size) {
            this.config.socketSendBufferSize = size;
            return this;
        }

        public Builder setHealthStatusInterval(Integer healthStatusIntervalSeconds) {
            this.config.healthStatusInterval = healthStatusIntervalSeconds;
            return this;
        }

        public Builder setHealthHandler(DtlsHealth healthHandler) {
            this.config.healthHandler = healthHandler;
            return this;
        }

        public Builder setOutboundMessageBufferSize(int capacity) {
            if (capacity < 1) {
                throw new IllegalArgumentException("Outbound message buffer size must be at least 1");
            }
            this.config.outboundMessageBufferSize = capacity;
            return this;
        }

        public Builder setBackOffRetransmission(Integer count) {
            if (count != null && count < 0) {
                throw new IllegalArgumentException("number of retransmissions to back-off must not be negative");
            }
            this.config.backOffRetransmission = count;
            return this;
        }

        public Builder setMaxRetransmissions(int count) {
            if (count < 1) {
                throw new IllegalArgumentException("Maximum number of retransmissions must be greater than zero");
            }
            this.config.maxRetransmissions = count;
            return this;
        }

        public Builder setMaxTransmissionUnit(int mtu) {
            if (this.config.maxTransmissionUnitLimit != null) {
                throw new IllegalArgumentException("MTU limit already set!");
            }
            this.config.maxTransmissionUnit = mtu;
            return this;
        }

        public Builder setMaxTransmissionUnitLimit(int limit) {
            if (this.config.maxTransmissionUnit != null) {
                throw new IllegalArgumentException("MTU already set!");
            }
            this.config.maxTransmissionUnitLimit = limit;
            return this;
        }

        public Builder setClientAuthenticationWanted(boolean authWanted) {
            if (Boolean.TRUE.equals(this.config.clientOnly)) {
                throw new IllegalStateException("client authentication is not supported for client only!");
            }
            if (authWanted && Boolean.TRUE.equals(this.config.clientAuthenticationRequired)) {
                throw new IllegalArgumentException("client authentication is already required!");
            }
            this.config.clientAuthenticationWanted = authWanted;
            return this;
        }

        public Builder setClientAuthenticationRequired(boolean authRequired) {
            if (Boolean.TRUE.equals(this.config.clientOnly)) {
                throw new IllegalStateException("client authentication is not supported for client only!");
            }
            if (authRequired && Boolean.TRUE.equals(this.config.clientAuthenticationWanted)) {
                throw new IllegalArgumentException("client authentication is already wanted!");
            }
            this.config.clientAuthenticationRequired = authRequired;
            return this;
        }

        public Builder setCipherSuiteSelector(CipherSuiteSelector cipherSuiteSelector) {
            this.config.cipherSuiteSelector = cipherSuiteSelector;
            return this;
        }

        public Builder setSupportedCipherSuites(CipherSuite ... cipherSuites) {
            if (cipherSuites == null) {
                throw new NullPointerException("Connector must support at least one cipher suite");
            }
            return this.setSupportedCipherSuites(Arrays.asList(cipherSuites));
        }

        public Builder setSupportedCipherSuites(List<CipherSuite> cipherSuites) {
            if (cipherSuites == null) {
                throw new NullPointerException("Connector must support at least one cipher suite");
            }
            if (cipherSuites.isEmpty()) {
                throw new IllegalArgumentException("Connector must support at least one cipher suite");
            }
            if (cipherSuites.contains((Object)CipherSuite.TLS_NULL_WITH_NULL_NULL)) {
                throw new IllegalArgumentException("NULL Cipher Suite is not supported by connector");
            }
            if (this.config.recommendedCipherSuitesOnly == null || this.config.recommendedCipherSuitesOnly.booleanValue()) {
                this.verifyRecommendedCipherSuitesOnly(cipherSuites);
            }
            for (CipherSuite cipherSuite : cipherSuites) {
                if (cipherSuite.isSupported()) continue;
                throw new IllegalArgumentException("cipher-suites " + (Object)((Object)cipherSuite) + " is not supported by JVM!");
            }
            this.config.supportedCipherSuites = cipherSuites;
            return this;
        }

        public Builder setSupportedCipherSuites(String ... cipherSuites) {
            if (cipherSuites == null) {
                throw new NullPointerException("Connector must support at least one cipher suite");
            }
            ArrayList<CipherSuite> suites = new ArrayList<CipherSuite>(cipherSuites.length);
            for (int i = 0; i < cipherSuites.length; ++i) {
                CipherSuite knownSuite = CipherSuite.getTypeByName(cipherSuites[i]);
                if (knownSuite == null) {
                    throw new IllegalArgumentException(String.format("Cipher suite [%s] is not (yet) supported", cipherSuites[i]));
                }
                suites.add(knownSuite);
            }
            return this.setSupportedCipherSuites(suites);
        }

        public Builder setSupportedSignatureAlgorithms(SignatureAndHashAlgorithm ... supportedSignatureAlgorithms) {
            List<SignatureAndHashAlgorithm> list = null;
            if (supportedSignatureAlgorithms != null) {
                list = Arrays.asList(supportedSignatureAlgorithms);
            }
            return this.setSupportedSignatureAlgorithms(list);
        }

        public Builder setSupportedSignatureAlgorithms(List<SignatureAndHashAlgorithm> supportedSignatureAlgorithms) {
            this.config.supportedSignatureAlgorithms = supportedSignatureAlgorithms;
            return this;
        }

        public Builder setSupportedSignatureAlgorithms(String ... supportedSignatureAlgorithms) {
            ArrayList<SignatureAndHashAlgorithm> list = null;
            if (supportedSignatureAlgorithms != null) {
                list = new ArrayList<SignatureAndHashAlgorithm>(supportedSignatureAlgorithms.length);
                for (int i = 0; i < supportedSignatureAlgorithms.length; ++i) {
                    SignatureAndHashAlgorithm signatureAndHashAlgorithm = SignatureAndHashAlgorithm.valueOf(supportedSignatureAlgorithms[i]);
                    if (signatureAndHashAlgorithm == null) {
                        throw new IllegalArgumentException(String.format("Signature and hash algorithm [%s] is not (yet) supported", supportedSignatureAlgorithms[i]));
                    }
                    list.add(signatureAndHashAlgorithm);
                }
            }
            return this.setSupportedSignatureAlgorithms(list);
        }

        public Builder setSupportedGroups(XECDHECryptography.SupportedGroup ... supportedGroups) {
            if (supportedGroups == null) {
                throw new NullPointerException("Connector must support at least one group (curve)");
            }
            return this.setSupportedGroups(Arrays.asList(supportedGroups));
        }

        public Builder setSupportedGroups(List<XECDHECryptography.SupportedGroup> supportedGroups) {
            if (supportedGroups == null) {
                throw new NullPointerException("Connector must support at least one group (curve)");
            }
            if (supportedGroups.isEmpty()) {
                throw new IllegalArgumentException("Connector must support at least one group (curve)");
            }
            if (this.config.recommendedSupportedGroupsOnly == null || this.config.recommendedSupportedGroupsOnly.booleanValue()) {
                this.verifyRecommendedSupportedGroupsOnly(supportedGroups);
            }
            for (XECDHECryptography.SupportedGroup group : supportedGroups) {
                if (group.isUsable()) continue;
                throw new IllegalArgumentException("curve " + group.name() + " is not supported by JVM!");
            }
            this.config.supportedGroups = supportedGroups;
            return this;
        }

        public Builder setSupportedGroups(String ... supportedGroups) {
            if (supportedGroups == null) {
                throw new NullPointerException("Connector must support at least one supported group (curve)");
            }
            ArrayList<XECDHECryptography.SupportedGroup> groups = new ArrayList<XECDHECryptography.SupportedGroup>(supportedGroups.length);
            for (int i = 0; i < supportedGroups.length; ++i) {
                XECDHECryptography.SupportedGroup knownGroup = XECDHECryptography.SupportedGroup.valueOf(supportedGroups[i]);
                if (knownGroup == null) {
                    throw new IllegalArgumentException(String.format("Group (curve) [%s] is not (yet) supported", supportedGroups[i]));
                }
                groups.add(knownGroup);
            }
            return this.setSupportedGroups(groups);
        }

        public Builder setEarlyStopRetransmission(boolean activate) {
            this.config.earlyStopRetransmission = activate;
            return this;
        }

        public Builder setRetransmissionTimeout(int timeout) {
            if (timeout < 0) {
                throw new IllegalArgumentException("Retransmission timeout must not be negative");
            }
            this.config.retransmissionTimeout = timeout;
            return this;
        }

        public Builder setPskStore(PskStore pskStore) {
            this.config.advancedPskStore = pskStore == null ? null : new AdvancedInMemoryPskStore(pskStore);
            this.config.pskStore = pskStore;
            return this;
        }

        public Builder setAdvancedPskStore(AdvancedPskStore advancedPskStore) {
            this.config.pskStore = null;
            this.config.advancedPskStore = advancedPskStore;
            return this;
        }

        public Builder setIdentity(PrivateKey privateKey, PublicKey publicKey) {
            if (privateKey == null) {
                throw new NullPointerException("The private key must not be null");
            }
            if (publicKey == null) {
                throw new NullPointerException("The public key must not be null");
            }
            this.config.privateKey = privateKey;
            this.config.publicKey = publicKey;
            this.config.certChain = null;
            this.config.identityCertificateTypes = new ArrayList(1);
            this.config.identityCertificateTypes.add(CertificateType.RAW_PUBLIC_KEY);
            return this;
        }

        public Builder setIdentity(PrivateKey privateKey, Certificate[] certificateChain, CertificateType ... certificateTypes) {
            if (certificateTypes == null || certificateTypes.length == 0) {
                return this.setIdentity(privateKey, certificateChain, (List<CertificateType>)null);
            }
            return this.setIdentity(privateKey, certificateChain, Arrays.asList(certificateTypes));
        }

        public Builder setIdentity(PrivateKey privateKey, Certificate[] certificateChain, List<CertificateType> certificateTypes) {
            if (privateKey == null) {
                throw new NullPointerException("The private key must not be null!");
            }
            if (certificateChain == null) {
                throw new NullPointerException("The certificate chain must not be null!");
            }
            if (certificateChain.length < 1) {
                throw new IllegalArgumentException("The certificate chain must not be empty!");
            }
            if (certificateTypes != null && certificateTypes.isEmpty()) {
                throw new IllegalArgumentException("The certificate types must not be empty!");
            }
            if (certificateTypes != null) {
                for (CertificateType certificateType : certificateTypes) {
                    if (certificateType.isSupported()) continue;
                    throw new IllegalArgumentException("The certificate type " + (Object)((Object)certificateType) + " is not supported!");
                }
            }
            this.config.privateKey = privateKey;
            this.config.certChain = Arrays.asList(SslContextUtil.asX509Certificates((Certificate[])certificateChain));
            this.config.publicKey = ((X509Certificate)this.config.certChain.get(0)).getPublicKey();
            if (certificateTypes == null) {
                this.config.identityCertificateTypes = new ArrayList(1);
                this.config.identityCertificateTypes.add(CertificateType.X_509);
            } else {
                this.config.identityCertificateTypes = certificateTypes;
                if (!this.config.identityCertificateTypes.contains((Object)CertificateType.X_509)) {
                    this.config.certChain = null;
                }
            }
            return this;
        }

        public Builder setTrustStore(Certificate[] trustedCerts) {
            if (trustedCerts == null) {
                throw new NullPointerException("Trust store must not be null");
            }
            if (this.config.certificateVerifier != null) {
                throw new IllegalStateException("Trust store must not be used after certificate verifier is set!");
            }
            if (trustedCerts.length == 0) {
                DtlsConnectorConfig.access$3802(this.config, new X509Certificate[0]);
            } else {
                X509Certificate[] certificates = SslContextUtil.asX509Certificates((Certificate[])trustedCerts);
                this.checkTrustStore(certificates);
                DtlsConnectorConfig.access$3802(this.config, certificates);
            }
            return this;
        }

        public Builder setCertificateVerifier(CertificateVerifier verifier) {
            if (verifier == null) {
                throw new NullPointerException("CertificateVerifier must not be null");
            }
            if (this.config.trustStore != null) {
                throw new IllegalStateException("CertificateVerifier must not be used after trust store is set!");
            }
            this.config.certificateVerifier = verifier;
            return this;
        }

        public Builder setApplicationLevelInfoSupplier(ApplicationLevelInfoSupplier supplier) {
            if (supplier == null) {
                throw new NullPointerException("Supplier must not be null");
            }
            this.config.applicationLevelInfoSupplier = supplier;
            return this;
        }

        public Builder setRpkTrustStore(TrustedRpkStore store) {
            if (store == null) {
                throw new IllegalStateException("Must provide a non-null rpk trust store");
            }
            this.config.trustedRPKs = store;
            return this;
        }

        public Builder setRpkTrustAll() {
            this.config.trustedRPKs = new TrustAllRpks();
            return this;
        }

        public Builder setTrustCertificateTypes(CertificateType ... certificateTypes) {
            if (certificateTypes == null) {
                throw new NullPointerException("CertificateTypes must not be null!");
            }
            if (certificateTypes.length == 0) {
                throw new IllegalArgumentException("CertificateTypes must not be empty!");
            }
            for (CertificateType certificateType : certificateTypes) {
                if (certificateType.isSupported()) continue;
                throw new IllegalArgumentException("The certificate type " + (Object)((Object)certificateType) + " is not supported!");
            }
            this.config.trustCertificateTypes = Arrays.asList(certificateTypes);
            return this;
        }

        public Builder setMaxDeferredProcessedOutgoingApplicationDataMessages(int maxDeferredProcessedOutgoingApplicationDataMessages) {
            if (maxDeferredProcessedOutgoingApplicationDataMessages < 0) {
                throw new IllegalArgumentException("Max deferred processed outging application data messages must not be negative!");
            }
            this.config.maxDeferredProcessedOutgoingApplicationDataMessages = maxDeferredProcessedOutgoingApplicationDataMessages;
            return this;
        }

        public Builder setMaxDeferredProcessedIncomingRecordsSize(int maxDeferredProcessedIncomingRecordsSize) {
            if (maxDeferredProcessedIncomingRecordsSize < 0) {
                throw new IllegalArgumentException("Max deferred processed incoming records size must not be negative!");
            }
            this.config.maxDeferredProcessedIncomingRecordsSize = maxDeferredProcessedIncomingRecordsSize;
            return this;
        }

        public Builder setMaxConnections(int maxConnections) {
            if (maxConnections < 1) {
                throw new IllegalArgumentException("Max connections must be at least 1");
            }
            this.config.maxConnections = maxConnections;
            return this;
        }

        public Builder setStaleConnectionThreshold(long threshold) {
            if (threshold < 1L) {
                throw new IllegalArgumentException("Threshold must be at least 1 second");
            }
            this.config.staleConnectionThreshold = threshold;
            return this;
        }

        public Builder setConnectionIdGenerator(ConnectionIdGenerator connectionIdGenerator) {
            this.config.connectionIdGenerator = connectionIdGenerator;
            return this;
        }

        public Builder setConnectionThreadCount(int threadCount) {
            this.config.connectionThreadCount = threadCount;
            return this;
        }

        public Builder setReceiverThreadCount(int threadCount) {
            this.config.receiverThreadCount = threadCount;
            return this;
        }

        public Builder setAutoResumptionTimeoutMillis(Long timeoutInMillis) {
            if (timeoutInMillis != null && timeoutInMillis < 1L) {
                throw new IllegalArgumentException("auto resumption timeout must not below 1!");
            }
            this.config.autoResumptionTimeoutMillis = timeoutInMillis;
            return this;
        }

        public Builder setSniEnabled(boolean flag) {
            this.config.sniEnabled = flag;
            return this;
        }

        public Builder setVerifyPeersOnResumptionThreshold(int threshold) {
            if (threshold < 0 || threshold > 100) {
                throw new IllegalArgumentException("threshold must be between 0 and 100, but is " + threshold + "!");
            }
            this.config.verifyPeersOnResumptionThreshold = threshold;
            return this;
        }

        public Builder setNoServerSessionId(boolean flag) {
            if (Boolean.TRUE.equals(this.config.clientOnly) && flag) {
                throw new IllegalArgumentException("not applicable for client only!");
            }
            this.config.useNoServerSessionId = flag;
            return this;
        }

        public Builder setUseAntiReplayFilter(boolean enable) {
            if (enable && this.config.useExtendedWindowFilter != null && this.config.useExtendedWindowFilter != 0) {
                throw new IllegalArgumentException("Window filter is active!");
            }
            this.config.useAntiReplayFilter = enable;
            return this;
        }

        @Deprecated
        public Builder setUseWindowFilter(boolean enable) {
            if (enable && Boolean.TRUE.equals(this.config.useAntiReplayFilter)) {
                throw new IllegalArgumentException("Anti replay filter is active!");
            }
            if (enable) {
                this.config.useExtendedWindowFilter = -1;
            } else {
                this.config.useExtendedWindowFilter = 0;
            }
            return this;
        }

        public Builder setUseExtendedWindowFilter(int level) {
            if (level != 0 && Boolean.TRUE.equals(this.config.useAntiReplayFilter)) {
                throw new IllegalArgumentException("Anti replay filter is active!");
            }
            this.config.useExtendedWindowFilter = level;
            return this;
        }

        public Builder setCidUpdateAddressOnNewerRecordFilter(boolean enable) {
            this.config.useCidUpdateAddressOnNewerRecordFilter = enable;
            return this;
        }

        public Builder setUseHandshakeStateValidation(boolean enable) {
            this.config.useHandshakeStateValidation = enable;
            return this;
        }

        public Builder setKeyUsageVerification(boolean enable) {
            this.config.useKeyUsageVerification = enable;
            return this;
        }

        public Builder setUseTruncatedCertificatePathForClientsCertificateMessage(boolean enable) {
            this.config.useTruncatedCertificatePathForClientsCertificateMessage = enable;
            return this;
        }

        public Builder setUseTruncatedCertificatePathForValidation(boolean enable) {
            this.config.useTruncatedCertificatePathForValidation = enable;
            return this;
        }

        public Builder setLoggingTag(String tag) {
            this.config.loggingTag = tag;
            return this;
        }

        public Builder setConnectionListener(ConnectionListener connectionListener) {
            this.config.connectionListener = connectionListener;
            return this;
        }

        private boolean isConfiguredWithKeyPair() {
            return this.config.privateKey != null && this.config.publicKey != null;
        }

        public DtlsConnectorConfig getIncompleteConfig() {
            return this.config;
        }

        public DtlsConnectorConfig build() {
            this.config.loggingTag = StringUtil.normalizeLoggingTag((String)this.config.loggingTag);
            if (this.config.address == null) {
                this.config.address = new InetSocketAddress(0);
            }
            if (this.config.enableReuseAddress == null) {
                this.config.enableReuseAddress = Boolean.FALSE;
            }
            if (this.config.useHandshakeStateValidation == null) {
                this.config.useHandshakeStateValidation = Boolean.TRUE;
            }
            if (this.config.useTruncatedCertificatePathForClientsCertificateMessage == null) {
                this.config.useTruncatedCertificatePathForClientsCertificateMessage = Boolean.TRUE;
            }
            if (this.config.useTruncatedCertificatePathForValidation == null) {
                this.config.useTruncatedCertificatePathForValidation = Boolean.TRUE;
            }
            if (this.config.useKeyUsageVerification == null) {
                this.config.useKeyUsageVerification = Boolean.TRUE;
            }
            if (this.config.earlyStopRetransmission == null) {
                this.config.earlyStopRetransmission = Boolean.TRUE;
            }
            if (this.config.retransmissionTimeout == null) {
                this.config.retransmissionTimeout = 1000;
            }
            if (this.config.maxRetransmissions == null) {
                this.config.maxRetransmissions = 4;
            }
            if (this.config.backOffRetransmission == null) {
                this.config.backOffRetransmission = this.config.maxRetransmissions / 2;
            }
            if (this.config.maxFragmentedHandshakeMessageLength == null) {
                this.config.maxFragmentedHandshakeMessageLength = 8192;
            }
            if (this.config.clientAuthenticationWanted == null) {
                this.config.clientAuthenticationWanted = Boolean.FALSE;
            }
            if (this.config.clientOnly == null) {
                this.config.clientOnly = Boolean.FALSE;
            }
            if (this.config.recommendedCipherSuitesOnly == null) {
                this.config.recommendedCipherSuitesOnly = Boolean.TRUE;
            }
            if (this.config.recommendedSupportedGroupsOnly == null) {
                this.config.recommendedSupportedGroupsOnly = Boolean.TRUE;
            }
            if (this.config.clientAuthenticationRequired == null) {
                if (this.config.clientOnly.booleanValue()) {
                    this.config.clientAuthenticationRequired = Boolean.FALSE;
                } else {
                    this.config.clientAuthenticationRequired = this.config.clientAuthenticationWanted == false;
                }
            }
            if (this.config.serverOnly == null) {
                this.config.serverOnly = Boolean.FALSE;
            }
            if (this.config.defaultHandshakeMode == null) {
                if (this.config.serverOnly.booleanValue()) {
                    this.config.defaultHandshakeMode = "none";
                } else {
                    this.config.defaultHandshakeMode = "auto";
                }
            }
            if (this.config.useNoServerSessionId == null) {
                this.config.useNoServerSessionId = Boolean.FALSE;
            }
            if (this.config.outboundMessageBufferSize == null) {
                this.config.outboundMessageBufferSize = 100000;
            }
            if (this.config.maxDeferredProcessedOutgoingApplicationDataMessages == null) {
                this.config.maxDeferredProcessedOutgoingApplicationDataMessages = 10;
            }
            if (this.config.maxDeferredProcessedIncomingRecordsSize == null) {
                this.config.maxDeferredProcessedIncomingRecordsSize = 8192;
            }
            if (this.config.maxConnections == null) {
                this.config.maxConnections = 150000;
            }
            if (this.config.connectionThreadCount == null) {
                this.config.connectionThreadCount = DEFAULT_EXECUTOR_THREAD_POOL_SIZE;
            }
            if (this.config.receiverThreadCount == null) {
                this.config.receiverThreadCount = DEFAULT_RECEIVER_THREADS;
            }
            if (this.config.staleConnectionThreshold == null) {
                this.config.staleConnectionThreshold = 1800L;
            }
            if (this.config.maxTransmissionUnitLimit == null) {
                this.config.maxTransmissionUnitLimit = 1500;
            }
            if (this.config.sniEnabled == null) {
                this.config.sniEnabled = Boolean.FALSE;
            }
            if (this.config.useExtendedWindowFilter == null) {
                this.config.useExtendedWindowFilter = 0;
            }
            if (this.config.useAntiReplayFilter == null) {
                this.config.useAntiReplayFilter = this.config.useExtendedWindowFilter == 0;
            }
            if (this.config.useCidUpdateAddressOnNewerRecordFilter == null) {
                this.config.useCidUpdateAddressOnNewerRecordFilter = Boolean.TRUE;
            }
            if (this.config.verifyPeersOnResumptionThreshold == null) {
                this.config.verifyPeersOnResumptionThreshold = 30;
            }
            if (this.config.certificateVerifier == null && this.config.trustStore != null) {
                this.config.certificateVerifier = new StaticCertificateVerifier(this.config.trustStore);
            }
            if (this.config.trustCertificateTypes == null && (this.config.trustedRPKs != null || this.config.certificateVerifier != null)) {
                this.config.trustCertificateTypes = new ArrayList(2);
                if (this.config.trustedRPKs != null) {
                    this.config.trustCertificateTypes.add(CertificateType.RAW_PUBLIC_KEY);
                }
                if (this.config.certificateVerifier != null) {
                    this.config.trustCertificateTypes.add(CertificateType.X_509);
                }
            }
            if (this.config.serverOnly.booleanValue() && !this.config.clientAuthenticationRequired.booleanValue() && !this.config.clientAuthenticationWanted.booleanValue() && this.config.trustCertificateTypes != null) {
                throw new IllegalStateException("configured trusted certificates or certificate verifier are not used for disabled client authentication!");
            }
            if (this.config.supportedCipherSuites == null || this.config.supportedCipherSuites.isEmpty()) {
                this.determineCipherSuitesFromConfig();
            }
            if (this.config.supportedGroups == null) {
                this.config.supportedGroups = Collections.emptyList();
            }
            if (this.config.supportedSignatureAlgorithms == null) {
                this.config.supportedSignatureAlgorithms = Collections.emptyList();
            }
            if (this.config.cipherSuiteSelector == null && !this.config.clientOnly.booleanValue()) {
                this.config.cipherSuiteSelector = new DefaultCipherSuiteSelector();
            }
            if (this.config.supportedCipherSuites == null || this.config.supportedCipherSuites.isEmpty()) {
                throw new IllegalStateException("Supported cipher suites must be set either explicitly or implicitly by means of setting the identity or PSK store");
            }
            for (CipherSuite cipherSuite : this.config.supportedCipherSuites) {
                if (cipherSuite.isSupported()) continue;
                throw new IllegalStateException("cipher-suites " + (Object)((Object)cipherSuite) + " is not supported by JVM!");
            }
            if (this.config.trustCertificateTypes != null) {
                if (this.config.trustCertificateTypes.contains((Object)CertificateType.RAW_PUBLIC_KEY) && this.config.trustedRPKs == null) {
                    throw new IllegalStateException("rpk trust must be set for trust certificate type RAW_PUBLIC_KEY");
                }
                if (this.config.trustCertificateTypes.contains((Object)CertificateType.X_509) && this.config.certificateVerifier == null) {
                    throw new IllegalStateException("trusted certificates or certificate verifier must be set for trust certificate type X_509");
                }
            }
            boolean certifacte = false;
            boolean ecc = false;
            boolean psk = false;
            for (CipherSuite suite : this.config.supportedCipherSuites) {
                if (suite.isPskBased()) {
                    this.verifyPskBasedCipherConfig(suite);
                    psk = true;
                } else if (suite.requiresServerCertificateMessage()) {
                    this.verifyCertificateBasedCipherConfig(suite);
                    certifacte = true;
                }
                if (!suite.isEccBased()) continue;
                ecc = true;
            }
            if (!psk && this.config.pskStore != null) {
                throw new IllegalStateException("PSK store set, but no PSK cipher suite!");
            }
            if (!psk && this.config.advancedPskStore != null) {
                throw new IllegalStateException("Advanced PSK store set, but no PSK cipher suite!");
            }
            if (ecc) {
                if (this.config.supportedSignatureAlgorithms.isEmpty()) {
                    if (this.config.certChain == null && this.config.publicKey != null) {
                        this.config.supportedSignatureAlgorithms = SignatureAndHashAlgorithm.getDefaultSignatureAlgorithms(this.config.publicKey);
                    } else {
                        this.config.supportedSignatureAlgorithms = SignatureAndHashAlgorithm.getDefaultSignatureAlgorithms(this.config.certChain);
                    }
                }
                if (this.config.supportedGroups.isEmpty()) {
                    this.config.supportedGroups = this.getDefaultSupportedGroups();
                }
            } else {
                if (!this.config.supportedSignatureAlgorithms.isEmpty()) {
                    throw new IllegalStateException("supported signature and hash algorithms set, but no ecdhe based cipher suite!");
                }
                if (!this.config.supportedGroups.isEmpty()) {
                    throw new IllegalStateException("supported groups set, but no ecdhe based cipher suite!");
                }
            }
            if (!certifacte) {
                if (this.config.privateKey != null || this.config.publicKey != null) {
                    throw new IllegalStateException("Identity set, but no certificate based cipher suite!");
                }
                if (this.config.trustedRPKs != null || this.config.certificateVerifier != null) {
                    throw new IllegalStateException("certificate trust set, but no certificate based cipher suite!");
                }
            }
            if (this.config.certChain != null) {
                X509Certificate certificate = (X509Certificate)this.config.certChain.get(0);
                if (this.config.clientOnly.booleanValue()) {
                    if (!CertPathUtil.canBeUsedForAuthentication((X509Certificate)certificate, (boolean)true)) {
                        throw new IllegalStateException("certificate has no proper key usage for clients!");
                    }
                } else if (this.config.serverOnly.booleanValue()) {
                    if (!CertPathUtil.canBeUsedForAuthentication((X509Certificate)certificate, (boolean)false)) {
                        throw new IllegalStateException("certificate has no proper key usage for servers!");
                    }
                } else {
                    if (!CertPathUtil.canBeUsedForAuthentication((X509Certificate)certificate, (boolean)true)) {
                        throw new IllegalStateException("certificate has no proper key usage as clients!");
                    }
                    if (!CertPathUtil.canBeUsedForAuthentication((X509Certificate)certificate, (boolean)false)) {
                        throw new IllegalStateException("certificate has no proper key usage as servers!");
                    }
                }
            }
            this.verifySignatureAndHashAlgorithms(this.config.supportedSignatureAlgorithms);
            this.verifySupportedGroups(this.config.supportedGroups);
            this.config.trustCertificateTypes = ListUtils.init(this.config.trustCertificateTypes);
            this.config.identityCertificateTypes = ListUtils.init(this.config.identityCertificateTypes);
            this.config.supportedCipherSuites = ListUtils.init(this.config.supportedCipherSuites);
            this.config.supportedGroups = ListUtils.init(this.config.supportedGroups);
            this.config.certChain = ListUtils.init(this.config.certChain);
            this.config.supportedSignatureAlgorithms = ListUtils.init(this.config.supportedSignatureAlgorithms);
            return this.config;
        }

        private void verifyPskBasedCipherConfig(CipherSuite suite) {
            if (this.config.advancedPskStore == null) {
                throw new IllegalStateException("PSK store must be set for configured " + suite.name());
            }
            if (!this.config.advancedPskStore.hasEcdhePskSupported() && suite.isEccBased()) {
                throw new IllegalStateException("PSK store doesn't support ECDHE! " + suite.name());
            }
        }

        private void verifyCertificateBasedCipherConfig(CipherSuite suite) {
            if (this.config.privateKey == null || this.config.publicKey == null) {
                if (!this.config.clientOnly.booleanValue()) {
                    throw new IllegalStateException("Identity must be set for configured " + suite.name());
                }
            } else {
                String algorithm = suite.getCertificateKeyAlgorithm().name();
                if (!(algorithm.equals(this.config.privateKey.getAlgorithm()) && algorithm.equals(this.config.publicKey.getAlgorithm()) || algorithm.equals("EC") && Asn1DerDecoder.isSupported((String)this.config.privateKey.getAlgorithm()) && Asn1DerDecoder.isSupported((String)this.config.publicKey.getAlgorithm()))) {
                    throw new IllegalStateException("Keys must be " + algorithm + " capable for configured " + suite.name());
                }
            }
            if (this.config.clientOnly.booleanValue() || this.config.clientAuthenticationRequired.booleanValue() || this.config.clientAuthenticationWanted.booleanValue()) {
                if (this.config.trustCertificateTypes == null) {
                    throw new IllegalStateException("trust must be set for configured " + suite.name());
                }
                if (this.config.trustCertificateTypes.contains((Object)CertificateType.RAW_PUBLIC_KEY) && this.config.trustedRPKs == null) {
                    throw new IllegalStateException("Raw public key trust must be set for configured " + suite.name());
                }
                if (this.config.trustCertificateTypes.contains((Object)CertificateType.X_509) && this.config.certificateVerifier == null) {
                    throw new IllegalStateException("X509 certficate trust must be set for configured " + suite.name());
                }
            }
        }

        private void verifyRecommendedCipherSuitesOnly(List<CipherSuite> suites) {
            StringBuilder message = new StringBuilder();
            for (CipherSuite cipherSuite : suites) {
                if (cipherSuite.isRecommended()) continue;
                if (message.length() > 0) {
                    message.append(", ");
                }
                message.append(cipherSuite.name());
            }
            if (message.length() > 0) {
                throw new IllegalStateException("Not recommended cipher suites " + message + " used! (Requires to set recommendedCipherSuitesOnly to false.)");
            }
        }

        private void verifyRecommendedSupportedGroupsOnly(List<XECDHECryptography.SupportedGroup> supportedGroups) {
            StringBuilder message = new StringBuilder();
            for (XECDHECryptography.SupportedGroup group : supportedGroups) {
                if (group.isRecommended()) continue;
                if (message.length() > 0) {
                    message.append(", ");
                }
                message.append(group.name());
            }
            if (message.length() > 0) {
                throw new IllegalStateException("Not recommended supported groups (curves) " + message + " used! (Requires to set recommendedSupportedGroupsOnly to false.)");
            }
        }

        private void determineCipherSuitesFromConfig() {
            boolean certificates;
            ArrayList<CipherSuite> ciphers = new ArrayList<CipherSuite>();
            boolean bl = certificates = this.isConfiguredWithKeyPair() || this.config.trustCertificateTypes != null;
            if (certificates) {
                ciphers.addAll(CipherSuite.getEcdsaCipherSuites(this.config.recommendedCipherSuitesOnly));
            }
            if (this.config.advancedPskStore != null) {
                if (this.config.advancedPskStore.hasEcdhePskSupported()) {
                    ciphers.addAll(CipherSuite.getCipherSuitesByKeyExchangeAlgorithm((boolean)this.config.recommendedCipherSuitesOnly, CipherSuite.KeyExchangeAlgorithm.ECDHE_PSK));
                }
                ciphers.addAll(CipherSuite.getCipherSuitesByKeyExchangeAlgorithm((boolean)this.config.recommendedCipherSuitesOnly, CipherSuite.KeyExchangeAlgorithm.PSK));
            }
            this.config.supportedCipherSuites = ciphers;
        }

        private void verifySignatureAndHashAlgorithms(List<SignatureAndHashAlgorithm> list) {
            if (this.config.publicKey != null) {
                if (SignatureAndHashAlgorithm.getSupportedSignatureAlgorithm(list, this.config.publicKey) == null) {
                    throw new IllegalStateException("supported signature and hash algorithms doesn't match the public key!");
                }
                if (this.config.certChain != null && !SignatureAndHashAlgorithm.isSignedWithSupportedAlgorithms(list, this.config.certChain)) {
                    throw new IllegalStateException("supported signature and hash algorithms doesn't match the certificate chain!");
                }
            }
        }

        private List<XECDHECryptography.SupportedGroup> getDefaultSupportedGroups() {
            ArrayList<XECDHECryptography.SupportedGroup> defaultGroups = new ArrayList<XECDHECryptography.SupportedGroup>(XECDHECryptography.SupportedGroup.getPreferredGroups());
            if (this.config.certChain != null) {
                for (X509Certificate certificate : this.config.certChain) {
                    this.addSupportedGroups(defaultGroups, certificate.getPublicKey());
                }
            } else {
                this.addSupportedGroups(defaultGroups, this.config.publicKey);
            }
            return defaultGroups;
        }

        private void addSupportedGroups(List<XECDHECryptography.SupportedGroup> defaultGroups, PublicKey publicKey) {
            XECDHECryptography.SupportedGroup group;
            if (publicKey != null && (group = XECDHECryptography.SupportedGroup.fromPublicKey(publicKey)) != null && group.isUsable() && !defaultGroups.contains((Object)group) && (!this.config.recommendedSupportedGroupsOnly.booleanValue() || group.isRecommended())) {
                defaultGroups.add(group);
            }
        }

        private void verifySupportedGroups(List<XECDHECryptography.SupportedGroup> list) {
            if (this.config.certChain != null) {
                for (X509Certificate certificate : this.config.certChain) {
                    PublicKey publicKey = certificate.getPublicKey();
                    if (!XECDHECryptography.SupportedGroup.isEcPublicKey(publicKey)) continue;
                    this.verifySupportedGroups(list, publicKey);
                }
            } else {
                this.verifySupportedGroups(list, this.config.publicKey);
            }
        }

        private void verifySupportedGroups(List<XECDHECryptography.SupportedGroup> list, PublicKey publicKey) {
            if (publicKey != null) {
                XECDHECryptography.SupportedGroup group = XECDHECryptography.SupportedGroup.fromPublicKey(publicKey);
                if (group == null) {
                    throw new IllegalStateException("public key used with unknown group (curve)!");
                }
                if (!group.isUsable()) {
                    throw new IllegalStateException("public key used with unsupported group (curve) " + group.name() + "!");
                }
                if (!list.contains((Object)group)) {
                    throw new IllegalStateException("public key used with not configured group (curve) " + group.name() + "!");
                }
                if (this.config.recommendedSupportedGroupsOnly.booleanValue() && !group.isRecommended()) {
                    throw new IllegalStateException("public key used with unrecommended group (curve) " + group.name() + "!");
                }
            }
        }

        private void checkTrustStore(X509Certificate[] store) {
            List subjects = CertPathUtil.toSubjects(Arrays.asList(store));
            HashSet<X500Principal> set = new HashSet<X500Principal>();
            for (X500Principal subject : subjects) {
                if (set.add(subject)) continue;
                throw new IllegalStateException("Truststore contains 2 certificates with same subject: " + subject);
            }
        }
    }
}

