/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import javax.crypto.SecretKey;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;

public class PskSecretResult {
    public static final String ALGORITHM_PSK = "PSK";
    public static final String ALGORITHM_MAC = "MAC";
    private final ConnectionId cid;
    private final PskPublicInformation pskIdentity;
    private final SecretKey secret;

    public PskSecretResult(ConnectionId cid, PskPublicInformation pskIdentity, SecretKey secret) {
        String algorithm;
        if (secret != null && !ALGORITHM_MAC.equals(algorithm = secret.getAlgorithm()) && !ALGORITHM_PSK.equals(algorithm)) {
            throw new IllegalArgumentException("Secret must be either MAC for master secret, or PSK for secret key, but not " + algorithm + "!");
        }
        this.cid = cid;
        this.pskIdentity = pskIdentity;
        this.secret = secret;
    }

    public ConnectionId getConnectionId() {
        return this.cid;
    }

    public PskPublicInformation getPskPublicInformation() {
        return this.pskIdentity;
    }

    public SecretKey getSecret() {
        return this.secret;
    }
}

