/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;

public class CookieGenerator {
    private static final long KEY_LIFE_TIME = TimeUnit.MINUTES.toNanos(5L);
    private long nextKeyGenerationNanos;
    private SecretKeySpec lastSecretKey;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Mac hmac;
    private final SecureRandom rng = new SecureRandom();
    byte[] rd = new byte[32];

    private final Mac createHMAC() throws GeneralSecurityException {
        if (this.hmac != null) {
            try {
                return (Mac)this.hmac.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException("hmac doesn't support clone and MUST therefore be null!");
            }
        }
        Mac hmac = Mac.getInstance("HmacSHA256");
        hmac.init(this.lastSecretKey);
        return hmac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mac getHMAC() throws GeneralSecurityException {
        this.lock.readLock().lock();
        try {
            if (this.lastSecretKey != null && !this.isKeyExpired()) {
                Mac mac = this.createHMAC();
                return mac;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.lastSecretKey == null) {
                this.generateSecretKey();
                this.hmac = Mac.getInstance("HmacSHA256");
                this.hmac.init(this.lastSecretKey);
                Mac mac = (Mac)this.hmac.clone();
                return mac;
            }
            if (this.isKeyExpired()) {
                this.generateSecretKey();
            }
            Mac mac = this.createHMAC();
            return mac;
        }
        catch (CloneNotSupportedException ex) {
            Mac hmac = this.hmac;
            this.hmac = null;
            Mac mac = hmac;
            return mac;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean isKeyExpired() {
        return ClockUtil.nanoRealtime() - this.nextKeyGenerationNanos >= 0L;
    }

    private void generateSecretKey() {
        this.nextKeyGenerationNanos = ClockUtil.nanoRealtime() + KEY_LIFE_TIME;
        this.rng.nextBytes(this.rd);
        this.lastSecretKey = new SecretKeySpec(this.rd, "MAC");
    }

    public byte[] generateCookie(ClientHello clientHello) throws GeneralSecurityException {
        Mac hmac = this.getHMAC();
        InetSocketAddress peer = clientHello.getPeer();
        hmac.update(peer.getAddress().getAddress());
        int port = peer.getPort();
        hmac.update((byte)(port >>> 8));
        hmac.update((byte)port);
        hmac.update((byte)clientHello.getClientVersion().getMajor());
        hmac.update((byte)clientHello.getClientVersion().getMinor());
        hmac.update(clientHello.getRandom().getBytes());
        hmac.update(clientHello.getSessionId().getBytes());
        hmac.update(CipherSuite.listToByteArray(clientHello.getCipherSuites()));
        hmac.update(CompressionMethod.listToByteArray(clientHello.getCompressionMethods()));
        return hmac.doFinal();
    }
}

