/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.x509;

import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import org.eclipse.californium.elements.util.CertPathUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.x509.AdvancedCertificateVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticCertificateVerifier
implements AdvancedCertificateVerifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticCertificateVerifier.class);
    private final X509Certificate[] rootCertificates;

    public StaticCertificateVerifier(X509Certificate[] rootCertificates) {
        this.rootCertificates = rootCertificates;
    }

    @Override
    public void verifyCertificate(CertificateMessage message, DTLSSession session) throws HandshakeException {
        try {
            CertPathUtil.validateCertificatePath((boolean)false, (CertPath)message.getCertificateChain(), (X509Certificate[])this.rootCertificates);
        }
        catch (GeneralSecurityException e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Certificate validation failed", (Throwable)e);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Certificate validation failed due to {}", (Object)e.getMessage());
            }
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, session.getPeer());
            throw new HandshakeException("Certificate chain could not be validated", alert, e);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.rootCertificates;
    }

    @Override
    public CertPath verifyCertificate(Boolean clientUsage, boolean truncateCertificatePath, CertificateMessage message, DTLSSession session) throws HandshakeException {
        try {
            Certificate certificate;
            List<? extends Certificate> certificates;
            CertPath certPath = message.getCertificateChain();
            if (clientUsage != null && !(certificates = certPath.getCertificates()).isEmpty() && (certificate = certificates.get(0)) instanceof X509Certificate && !CertPathUtil.canBeUsedForAuthentication((X509Certificate)((X509Certificate)certificate), (boolean)clientUsage)) {
                LOGGER.debug("Certificate validation failed: key usage doesn't match");
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, session.getPeer());
                throw new HandshakeException("Key Usage doesn't match!", alert);
            }
            return CertPathUtil.validateCertificatePath((boolean)truncateCertificatePath, (CertPath)certPath, (X509Certificate[])this.rootCertificates);
        }
        catch (GeneralSecurityException e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Certificate validation failed", (Throwable)e);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Certificate validation failed due to {}", (Object)e.getMessage());
            }
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, session.getPeer());
            throw new HandshakeException("Certificate chain could not be validated", alert, e);
        }
    }
}

