/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientHandshaker;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionIdExtension;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeState;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.HelloVerifyRequest;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.ServerHello;

@NoPublicAPI
public class ResumingClientHandshaker
extends ClientHandshaker {
    private static HandshakeState[] RESUME = new HandshakeState[]{new HandshakeState(HandshakeType.HELLO_VERIFY_REQUEST, true), new HandshakeState(HandshakeType.SERVER_HELLO), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    private boolean probe;
    private boolean fullHandshake = false;

    public ResumingClientHandshaker(DTLSSession session, RecordLayer recordLayer, Connection connection, DtlsConnectorConfig config, int maxTransmissionUnit, boolean probe) {
        super(session, recordLayer, connection, config, maxTransmissionUnit);
        if (session.getSessionIdentifier() == null) {
            throw new IllegalArgumentException("Session must contain the ID of the session to resume");
        }
        this.probe = probe;
    }

    @Override
    protected void doProcessMessage(HandshakeMessage message) throws HandshakeException, GeneralSecurityException {
        if (this.fullHandshake) {
            super.doProcessMessage(message);
            return;
        }
        switch (message.getMessageType()) {
            case HELLO_VERIFY_REQUEST: {
                this.receivedHelloVerifyRequest((HelloVerifyRequest)message);
                break;
            }
            case SERVER_HELLO: {
                this.receivedServerHello((ServerHello)message);
                break;
            }
            case FINISHED: {
                this.receivedServerFinished((Finished)message);
                break;
            }
            default: {
                throw new HandshakeException(String.format("Received unexpected handshake message [%s] from peer %s", new Object[]{message.getMessageType(), message.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE, message.getPeer()));
            }
        }
    }

    @Override
    protected void receivedServerHello(ServerHello message) throws HandshakeException {
        if (!this.session.getSessionIdentifier().equals((Object)message.getSessionId())) {
            this.LOGGER.debug("Server [{}] refuses to resume session [{}], performing full handshake instead...", (Object)message.getPeer(), (Object)this.session.getSessionIdentifier());
            this.fullHandshake = true;
            this.states = SEVER_CERTIFICATE;
            super.receivedServerHello(message);
        } else {
            ConnectionIdExtension extension;
            if (!message.getCompressionMethod().equals((Object)this.session.getCompressionMethod())) {
                throw new HandshakeException("Server wants to change compression method in resumed session", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, message.getPeer()));
            }
            if (!message.getCipherSuite().equals((Object)this.session.getCipherSuite())) {
                throw new HandshakeException("Server wants to change cipher suite in resumed session", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, message.getPeer()));
            }
            this.verifyServerHelloExtensions(message);
            this.serverRandom = message.getRandom();
            if (this.connectionIdGenerator != null && (extension = message.getConnectionIdExtension()) != null) {
                ConnectionId connectionId = extension.getConnectionId();
                this.session.setWriteConnectionId(connectionId);
            }
            this.expectChangeCipherSpecMessage();
            this.masterSecret = this.session.getMasterSecret();
            this.calculateKeys(this.masterSecret);
        }
    }

    private void receivedServerFinished(Finished message) throws HandshakeException {
        MessageDigest mdWithServerFinish;
        this.flightNumber += 2;
        DTLSFlight flight = new DTLSFlight(this.getSession(), this.flightNumber);
        MessageDigest md = this.getHandshakeMessageDigest();
        try {
            mdWithServerFinish = (MessageDigest)md.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HandshakeException("Cannot create FINISHED message hash", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, message.getPeer()));
        }
        message.verifyData(this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), this.masterSecret, false, md.digest());
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage(message.getPeer());
        this.wrapMessage(flight, changeCipherSpecMessage);
        this.setCurrentWriteState();
        mdWithServerFinish.update(message.getRawMessage());
        this.handshakeHash = mdWithServerFinish.digest();
        Finished finished = new Finished(this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), this.masterSecret, this.isClient, this.handshakeHash, message.getPeer());
        this.wrapMessage(flight, finished);
        this.sendLastFlight(flight);
        this.sessionEstablished();
    }

    @Override
    public void startHandshake() throws HandshakeException {
        this.handshakeStarted();
        ClientHello message = new ClientHello(new ProtocolVersion(), this.session, this.supportedClientCertificateTypes, this.supportedServerCertificateTypes);
        this.clientRandom = message.getRandom();
        message.addCompressionMethod(this.session.getCompressionMethod());
        this.addConnectionId(message);
        this.addMaxFragmentLength(message);
        this.addServerNameIndication(message);
        this.clientHello = message;
        this.flightNumber = 1;
        DTLSFlight flight = new DTLSFlight(this.getSession(), this.flightNumber);
        this.wrapMessage(flight, message);
        this.sendFlight(flight);
        this.states = RESUME;
        this.statesIndex = 0;
    }

    @Override
    public boolean isProbing() {
        return this.probe;
    }

    @Override
    public void resetProbing() {
        this.probe = false;
    }

    @Override
    public boolean isRemovingConnection() {
        return !this.probe && super.isRemovingConnection();
    }
}

