/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.RawDataChannel;
import org.eclipse.californium.elements.exception.EndpointMismatchException;
import org.eclipse.californium.elements.exception.EndpointUnconnectedException;
import org.eclipse.californium.elements.exception.MulticastNotSupportedException;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.DaemonThreadFactory;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.eclipse.californium.elements.util.LeastRecentlyUsedCache;
import org.eclipse.californium.elements.util.NamedThreadFactory;
import org.eclipse.californium.elements.util.NetworkInterfacesUtil;
import org.eclipse.californium.elements.util.SerialExecutor;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.AlertHandler;
import org.eclipse.californium.scandium.CookieGenerator;
import org.eclipse.californium.scandium.DtlsHealth;
import org.eclipse.californium.scandium.DtlsHealthLogger;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ApplicationMessage;
import org.eclipse.californium.scandium.dtls.AvailableConnections;
import org.eclipse.californium.scandium.dtls.ClientHandshaker;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.CloseSupportingConnectionStore;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.DtlsHandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.HelloVerifyRequest;
import org.eclipse.californium.scandium.dtls.InMemoryConnectionStore;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.Record;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.ResumingClientHandshaker;
import org.eclipse.californium.scandium.dtls.ResumingServerHandshaker;
import org.eclipse.californium.scandium.dtls.ResumptionSupportingConnectionStore;
import org.eclipse.californium.scandium.dtls.ServerHandshaker;
import org.eclipse.californium.scandium.dtls.ServerNameExtension;
import org.eclipse.californium.scandium.dtls.SessionAdapter;
import org.eclipse.californium.scandium.dtls.SessionCache;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SessionListener;
import org.eclipse.californium.scandium.dtls.SessionTicket;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTLSConnector
implements Connector,
RecordLayer {
    public static final String KEY_TLS_SERVER_HOST_NAME = "TLS_SERVER_HOST_NAME";
    public static final int MAX_MTU = 65535;
    public static final int DEFAULT_IPV6_MTU = 1280;
    public static final int DEFAULT_IPV4_MTU = 576;
    private static final Logger LOGGER = LoggerFactory.getLogger(DTLSConnector.class);
    private static final int MAX_PLAINTEXT_FRAGMENT_LENGTH = 16384;
    private static final int MAX_CIPHERTEXT_EXPANSION = CipherSuite.getOverallMaxCiphertextExpansion();
    private static final int MAX_DATAGRAM_BUFFER_SIZE = 16409 + MAX_CIPHERTEXT_EXPANSION;
    private static final int TLS12_CID_PADDING = 0;
    private static final long CLIENT_HELLO_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
    private final DtlsConnectorConfig config;
    private final ResumptionSupportingConnectionStore connectionStore;
    private final Long autoResumptionTimeoutMillis;
    private final int thresholdHandshakesWithoutVerifiedPeer;
    private final AtomicInteger pendingHandshakesWithoutVerifiedPeer = new AtomicInteger();
    private final DtlsHealth health;
    private final boolean serverOnly;
    private final String defaultHandshakeMode;
    private final boolean useWindowFilter;
    private final boolean useFilter;
    private final boolean useCidUpdateAddressOnNewerRecordFilter;
    private final AtomicInteger pendingOutboundMessagesCountdown = new AtomicInteger();
    private final List<Thread> receiverThreads = new LinkedList<Thread>();
    private final ConnectionIdGenerator connectionIdGenerator;
    private ScheduledFuture<?> statusLogger;
    private InetSocketAddress lastBindAddress;
    private int maximumTransmissionUnit = 576;
    private int inboundDatagramBufferSize = MAX_DATAGRAM_BUFFER_SIZE;
    private CookieGenerator cookieGenerator = new CookieGenerator();
    private Object alertHandlerLock = new Object();
    private volatile DatagramSocket socket;
    private ScheduledExecutorService timer;
    private AtomicBoolean running = new AtomicBoolean(false);
    private volatile EndpointContextMatcher endpointContextMatcher;
    private RawDataChannel messageHandler;
    private AlertHandler alertHandler;
    private SessionListener sessionListener;
    private ExecutorService executorService;
    private boolean hasInternalExecutor;

    public DTLSConnector(DtlsConnectorConfig configuration) {
        this(configuration, (SessionCache)null);
    }

    public DTLSConnector(DtlsConnectorConfig configuration, SessionCache sessionCache) {
        this(configuration, new InMemoryConnectionStore(configuration.getMaxConnections(), configuration.getStaleConnectionThreshold(), sessionCache).setTag(configuration.getLoggingTag()));
    }

    protected DTLSConnector(DtlsConnectorConfig configuration, final ResumptionSupportingConnectionStore connectionStore) {
        long thresholdInPercent;
        if (configuration == null) {
            throw new NullPointerException("Configuration must not be null");
        }
        if (connectionStore == null) {
            throw new NullPointerException("Connection store must not be null");
        }
        this.connectionIdGenerator = configuration.getConnectionIdGenerator();
        this.config = configuration;
        this.pendingOutboundMessagesCountdown.set(this.config.getOutboundMessageBufferSize());
        this.autoResumptionTimeoutMillis = this.config.getAutoResumptionTimeoutMillis();
        this.serverOnly = this.config.isServerOnly();
        this.defaultHandshakeMode = this.config.getDefaultHandshakeMode();
        this.useWindowFilter = this.config.useWindowFilter();
        this.useFilter = this.config.useAntiReplayFilter() != false || this.useWindowFilter;
        this.useCidUpdateAddressOnNewerRecordFilter = this.config.useCidUpdateAddressOnNewerRecordFilter();
        this.connectionStore = connectionStore;
        this.connectionStore.attach(this.connectionIdGenerator);
        this.connectionStore.setConnectionListener(this.config.getConnectionListener());
        DtlsHealth healthHandler = null;
        Integer healthStatusInterval = this.config.getHealthStatusInterval();
        if (healthStatusInterval != null && healthStatusInterval > 0) {
            healthHandler = this.config.getHealthHandler();
            if (healthHandler == null) {
                healthHandler = new DtlsHealthLogger();
            }
            if (!healthHandler.isEnabled()) {
                healthHandler = null;
            }
        }
        this.health = healthHandler;
        this.sessionListener = new SessionAdapter(){

            @Override
            public void sessionEstablished(Handshaker handshaker, DTLSSession establishedSession) throws HandshakeException {
                DTLSConnector.this.sessionEstablished(handshaker, establishedSession);
            }

            @Override
            public void handshakeCompleted(final Handshaker handshaker) {
                if (DTLSConnector.this.health != null) {
                    DTLSConnector.this.health.endHandshake(true);
                }
                DTLSConnector.this.timer.schedule(new Runnable(){

                    @Override
                    public void run() {
                        handshaker.getConnection().startByClientHello(null);
                    }
                }, CLIENT_HELLO_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
            }

            @Override
            public void handshakeFailed(Handshaker handshaker, Throwable error) {
                List<RawData> listOut;
                if (DTLSConnector.this.health != null) {
                    DTLSConnector.this.health.endHandshake(false);
                }
                if (!(listOut = handshaker.takeDeferredApplicationData()).isEmpty()) {
                    LOGGER.debug("Handshake with [{}] failed, report error to deferred {} messages", (Object)handshaker.getPeerAddress(), (Object)listOut.size());
                    for (RawData message : listOut) {
                        message.onError(error);
                    }
                }
                Connection connection = handshaker.getConnection();
                if (handshaker.isRemovingConnection()) {
                    connectionStore.remove(connection, false);
                } else if (handshaker.isProbing()) {
                    LOGGER.debug("Handshake with [{}] failed within probe!", (Object)handshaker.getPeerAddress());
                } else if (connection.getEstablishedSession() == handshaker.getSession()) {
                    LOGGER.warn("Handshake with [{}] failed after session was established!", (Object)handshaker.getPeerAddress());
                } else if (connection.hasEstablishedSession()) {
                    LOGGER.warn("Handshake with [{}] failed, but has an established session!", (Object)handshaker.getPeerAddress());
                } else {
                    LOGGER.warn("Handshake with [{}] failed, connection preserved!", (Object)handshaker.getPeerAddress());
                }
            }
        };
        int maxConnections = configuration.getMaxConnections();
        long threshold = ((long)maxConnections * (thresholdInPercent = (long)this.config.getVerifyPeersOnResumptionThreshold().intValue()) + 50L) / 100L;
        if (threshold == 0L && thresholdInPercent > 0L) {
            threshold = 1L;
        }
        this.thresholdHandshakesWithoutVerifiedPeer = (int)threshold;
    }

    private final void sessionEstablished(Handshaker handshaker, final DTLSSession establishedSession) throws HandshakeException {
        List<Record> listIn;
        final Connection connection = handshaker.getConnection();
        this.connectionStore.putEstablishedSession(establishedSession, connection);
        SerialExecutor serialExecutor = connection.getExecutor();
        List<RawData> listOut = handshaker.takeDeferredApplicationData();
        if (!listOut.isEmpty()) {
            LOGGER.debug("Session with [{}] established, now process deferred {} messages", (Object)establishedSession.getPeer(), (Object)listOut.size());
            Iterator<RawData> i$ = listOut.iterator();
            while (i$.hasNext()) {
                RawData message;
                final RawData rawData = message = i$.next();
                serialExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        DTLSConnector.this.sendMessage(rawData, connection, establishedSession);
                    }
                });
            }
        }
        if (!(listIn = handshaker.takeDeferredRecords()).isEmpty()) {
            LOGGER.debug("Session with [{}] established, now process deferred {} messages", (Object)establishedSession.getPeer(), (Object)listIn.size());
            Iterator<Record> i$ = listIn.iterator();
            while (i$.hasNext()) {
                Record message;
                final Record record = message = i$.next();
                serialExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        DTLSConnector.this.processRecord(record, connection);
                    }
                });
            }
        }
    }

    protected void onInitializeHandshaker(Handshaker handshaker) {
    }

    private final void initializeHandshaker(Handshaker handshaker) {
        if (this.sessionListener != null) {
            handshaker.addSessionListener(this.sessionListener);
            if (this.health != null) {
                this.health.startHandshake();
            }
        }
        this.onInitializeHandshaker(handshaker);
    }

    public final synchronized void setExecutor(ExecutorService executor) {
        if (this.executorService != executor) {
            if (this.running.get()) {
                throw new IllegalStateException("cannot set new executor while connector is running");
            }
            this.executorService = executor;
        }
    }

    public final void close(InetSocketAddress peerAddress) {
        final Connection connection = this.getConnection(peerAddress, null, false);
        if (connection != null && connection.hasEstablishedSession()) {
            SerialExecutor serialExecutor = connection.getExecutor();
            serialExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    DTLSConnector.this.terminateConnection(connection, new AlertMessage(AlertMessage.AlertLevel.WARNING, AlertMessage.AlertDescription.CLOSE_NOTIFY, connection.getPeerAddress()), connection.getEstablishedSession());
                }
            });
        }
    }

    public final synchronized void start() throws IOException {
        this.start(this.config.getAddress());
    }

    final synchronized void restart() throws IOException {
        if (this.lastBindAddress == null) {
            throw new IllegalStateException("Connector has never been started before");
        }
        this.start(this.lastBindAddress);
    }

    private synchronized ExecutorService getExecutorService() {
        return this.executorService;
    }

    protected void start(InetSocketAddress bindAddress) throws IOException {
        if (this.running.get()) {
            return;
        }
        this.init(bindAddress, new DatagramSocket(null), this.config.getMaxTransmissionUnit());
    }

    protected void init(InetSocketAddress bindAddress, DatagramSocket socket, Integer mtu) throws IOException {
        this.socket = socket;
        this.pendingOutboundMessagesCountdown.set(this.config.getOutboundMessageBufferSize());
        this.timer = this.executorService instanceof ScheduledExecutorService ? (ScheduledExecutorService)this.executorService : ExecutorsUtil.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory("DTLS-Retransmit-Task-", NamedThreadFactory.SCANDIUM_THREAD_GROUP));
        if (this.executorService == null) {
            int threadCount = this.config.getConnectionThreadCount();
            this.executorService = threadCount > 1 ? ExecutorsUtil.newFixedThreadPool((int)(threadCount - 1), (ThreadFactory)new DaemonThreadFactory("DTLS-Connection-Handler-", NamedThreadFactory.SCANDIUM_THREAD_GROUP)) : this.timer;
            this.hasInternalExecutor = true;
        }
        if (bindAddress.getPort() != 0 && this.config.isAddressReuseEnabled().booleanValue()) {
            LOGGER.info("Enable address reuse for socket!");
            socket.setReuseAddress(true);
            if (!socket.getReuseAddress()) {
                LOGGER.warn("Enable address reuse for socket failed!");
            }
        }
        Integer size = this.config.getSocketReceiveBufferSize();
        try {
            if (size != null && size != 0) {
                socket.setReceiveBufferSize(size);
            }
            if ((size = this.config.getSocketSendBufferSize()) != null && size != 0) {
                socket.setSendBufferSize(size);
            }
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error("failed to apply {}", (Object)size, (Object)ex);
        }
        int recvBuffer = socket.getReceiveBufferSize();
        int sendBuffer = socket.getSendBufferSize();
        socket.bind(bindAddress);
        if (!(this.lastBindAddress == null || socket.getLocalAddress().equals(this.lastBindAddress.getAddress()) && socket.getLocalPort() == this.lastBindAddress.getPort())) {
            if (this.connectionStore instanceof ResumptionSupportingConnectionStore) {
                this.connectionStore.markAllAsResumptionRequired();
            } else {
                this.connectionStore.clear();
            }
        }
        if (this.config.getMaxTransmissionUnit() != null) {
            this.maximumTransmissionUnit = this.config.getMaxTransmissionUnit();
        } else if (mtu != null) {
            this.maximumTransmissionUnit = mtu;
        } else {
            InetAddress localInterfaceAddress = bindAddress.getAddress();
            if (localInterfaceAddress.isAnyLocalAddress()) {
                this.maximumTransmissionUnit = NetworkInterfacesUtil.getAnyMtu();
                LOGGER.info("multiple network interfaces, using smallest MTU [{}]", (Object)this.maximumTransmissionUnit);
            } else {
                NetworkInterface ni = NetworkInterface.getByInetAddress(localInterfaceAddress);
                if (ni != null && ni.getMTU() > 0) {
                    this.maximumTransmissionUnit = ni.getMTU();
                } else if (localInterfaceAddress instanceof Inet4Address) {
                    LOGGER.info("Cannot determine MTU of network interface, using minimum MTU [{}] of IPv4 instead", (Object)576);
                    this.maximumTransmissionUnit = 576;
                } else {
                    LOGGER.info("Cannot determine MTU of network interface, using minimum MTU [{}] of IPv6 instead", (Object)1280);
                    this.maximumTransmissionUnit = 1280;
                }
            }
        }
        if (this.config.getMaxFragmentLengthCode() != null) {
            MaxFragmentLengthExtension.Length lengthCode = MaxFragmentLengthExtension.Length.fromCode(this.config.getMaxFragmentLengthCode());
            this.inboundDatagramBufferSize = lengthCode.length() + MAX_CIPHERTEXT_EXPANSION + 25;
        }
        this.lastBindAddress = new InetSocketAddress(socket.getLocalAddress(), socket.getLocalPort());
        this.running.set(true);
        int receiverThreadCount = this.config.getReceiverThreadCount();
        for (int i = 0; i < receiverThreadCount; ++i) {
            Worker receiver = new Worker("DTLS-Receiver-" + i + "-" + this.lastBindAddress){
                private final byte[] receiverBuffer;
                private final DatagramPacket packet;
                {
                    this.receiverBuffer = new byte[DTLSConnector.this.inboundDatagramBufferSize];
                    this.packet = new DatagramPacket(this.receiverBuffer, DTLSConnector.this.inboundDatagramBufferSize);
                }

                @Override
                public void doWork() throws Exception {
                    this.packet.setData(this.receiverBuffer);
                    DTLSConnector.this.receiveNextDatagramFromNetwork(this.packet);
                }
            };
            receiver.setDaemon(true);
            receiver.start();
            this.receiverThreads.add(receiver);
        }
        LOGGER.info("DTLSConnector listening on {}, recv buf = {}, send buf = {}, recv packet size = {}, MTU = {}", new Object[]{this.lastBindAddress, recvBuffer, sendBuffer, this.inboundDatagramBufferSize, this.maximumTransmissionUnit});
        if (this.health != null) {
            Integer healthStatusInterval = this.config.getHealthStatusInterval();
            this.statusLogger = this.timer.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    DTLSConnector.this.health.dump(DTLSConnector.this.config.getLoggingTag(), DTLSConnector.this.config.getMaxConnections(), DTLSConnector.this.connectionStore.remainingCapacity(), DTLSConnector.this.pendingHandshakesWithoutVerifiedPeer.get());
                }
            }, healthStatusInterval.intValue(), healthStatusInterval.intValue(), TimeUnit.SECONDS);
        }
    }

    public final synchronized void forceResumeSessionFor(InetSocketAddress peer) {
        Connection peerConnection = this.connectionStore.get(peer);
        if (peerConnection != null && peerConnection.hasEstablishedSession()) {
            peerConnection.setResumptionRequired(true);
        }
    }

    public final synchronized void forceResumeAllSessions() {
        this.connectionStore.markAllAsResumptionRequired();
    }

    public final synchronized void clearConnectionState() {
        this.connectionStore.clear();
    }

    private final DatagramSocket getSocket() {
        return this.socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        ExecutorService shutdownTimer = null;
        ExecutorService shutdown = null;
        ArrayList<Runnable> pending = new ArrayList<Runnable>();
        DTLSConnector dTLSConnector = this;
        synchronized (dTLSConnector) {
            if (this.running.compareAndSet(true, false)) {
                if (this.statusLogger != null) {
                    this.statusLogger.cancel(false);
                    this.statusLogger = null;
                }
                LOGGER.info("Stopping DTLS connector on [{}]", (Object)this.lastBindAddress);
                for (Thread t : this.receiverThreads) {
                    t.interrupt();
                }
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
                this.maximumTransmissionUnit = 0;
                this.connectionStore.stop(pending);
                if (this.executorService != this.timer) {
                    pending.addAll(this.timer.shutdownNow());
                    shutdownTimer = this.timer;
                    this.timer = null;
                }
                if (this.hasInternalExecutor) {
                    pending.addAll(this.executorService.shutdownNow());
                    shutdown = this.executorService;
                    this.executorService = null;
                    this.hasInternalExecutor = false;
                }
                for (Thread t : this.receiverThreads) {
                    t.interrupt();
                    try {
                        t.join(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.receiverThreads.clear();
            }
        }
        if (shutdownTimer != null) {
            try {
                if (!shutdownTimer.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                    LOGGER.warn("Shutdown DTLS connector on [{}] timer not terminated in time!", (Object)this.lastBindAddress);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (shutdown != null) {
            try {
                if (!shutdown.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                    LOGGER.warn("Shutdown DTLS connector on [{}] executor not terminated in time!", (Object)this.lastBindAddress);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        for (Runnable job : pending) {
            try {
                job.run();
            }
            catch (Exception e) {
                LOGGER.warn("Shutdown DTLS connector:", (Throwable)e);
            }
        }
    }

    public final synchronized void destroy() {
        this.stop();
        this.connectionStore.clear();
    }

    public Future<Void> startDropConnectionsForPrincipal(final Principal principal) {
        if (principal == null) {
            throw new NullPointerException("principal must not be null!");
        }
        LeastRecentlyUsedCache.Predicate<Principal> handler = new LeastRecentlyUsedCache.Predicate<Principal>(){

            public boolean accept(Principal connectionPrincipal) {
                return principal.equals(connectionPrincipal);
            }
        };
        return this.startTerminateConnectionsForPrincipal(handler);
    }

    public Future<Void> startTerminateConnectionsForPrincipal(final LeastRecentlyUsedCache.Predicate<Principal> principalHandler) {
        if (principalHandler == null) {
            throw new NullPointerException("principal handler must not be null!");
        }
        LeastRecentlyUsedCache.Predicate<Connection> connectionHandler = new LeastRecentlyUsedCache.Predicate<Connection>(){

            public boolean accept(Connection connection) {
                Principal peer = null;
                SessionTicket ticket = connection.getSessionTicket();
                if (ticket != null) {
                    peer = ticket.getClientIdentity();
                } else {
                    DTLSSession session = connection.getSession();
                    if (session != null) {
                        peer = session.getPeerIdentity();
                    }
                }
                if (peer != null && principalHandler.accept((Object)peer)) {
                    DTLSConnector.this.connectionStore.remove(connection, true);
                }
                return false;
            }
        };
        return this.startForEach(connectionHandler);
    }

    public Future<Void> startForEach(LeastRecentlyUsedCache.Predicate<Connection> handler) {
        if (handler == null) {
            throw new NullPointerException("handler must not be null!");
        }
        ForEachFuture result = new ForEachFuture();
        this.nextForEach(this.connectionStore.iterator(), handler, result);
        return result;
    }

    private void nextForEach(final Iterator<Connection> iterator, final LeastRecentlyUsedCache.Predicate<Connection> handler, final ForEachFuture result) {
        block4: {
            if (!result.isStopped() && iterator.hasNext()) {
                final Connection next = iterator.next();
                try {
                    next.getExecutor().execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            boolean done = true;
                            try {
                                if (!result.isStopped() && !handler.accept((Object)next)) {
                                    done = false;
                                    DTLSConnector.this.nextForEach(iterator, (LeastRecentlyUsedCache.Predicate<Connection>)handler, result);
                                }
                            }
                            catch (Exception exception) {
                                result.failed(exception);
                            }
                            finally {
                                if (done) {
                                    result.done();
                                }
                            }
                        }
                    });
                    return;
                }
                catch (RejectedExecutionException ex) {
                    if (handler.accept((Object)next)) break block4;
                    while (iterator.hasNext() && !handler.accept((Object)iterator.next()) && !result.isStopped()) {
                    }
                }
            }
        }
        result.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Connection getConnection(InetSocketAddress peerAddress, ConnectionId cid, boolean create) {
        ExecutorService executor = this.getExecutorService();
        ResumptionSupportingConnectionStore resumptionSupportingConnectionStore = this.connectionStore;
        synchronized (resumptionSupportingConnectionStore) {
            Connection connection;
            if (cid != null) {
                connection = this.connectionStore.get(cid);
            } else {
                connection = this.connectionStore.get(peerAddress);
                if (connection == null && create) {
                    LOGGER.debug("create new connection for {}", (Object)peerAddress);
                    Connection newConnection = new Connection(peerAddress, new SerialExecutor((Executor)executor));
                    if (this.running.get() && !this.connectionStore.put(newConnection)) {
                        return null;
                    }
                    return newConnection;
                }
            }
            if (connection == null) {
                LOGGER.debug("no connection available for {},{}", (Object)peerAddress, (Object)cid);
            } else if (!connection.isExecuting() && this.running.get()) {
                LOGGER.debug("revive connection for {},{}", (Object)peerAddress, (Object)cid);
                connection.setExecutor(new SerialExecutor((Executor)executor));
            } else {
                LOGGER.trace("connection available for {},{}", (Object)peerAddress, (Object)cid);
            }
            return connection;
        }
    }

    protected void receiveNextDatagramFromNetwork(DatagramPacket packet) throws IOException {
        DatagramSocket currentSocket = this.getSocket();
        if (currentSocket == null) {
            return;
        }
        currentSocket.receive(packet);
        if (packet.getLength() == 0) {
            return;
        }
        this.processDatagram(packet);
    }

    protected void processDatagram(DatagramPacket packet) {
        if (this.health != null) {
            this.health.receivingRecord(false);
        }
        long timestamp = ClockUtil.nanoRealtime();
        InetSocketAddress peerAddress = new InetSocketAddress(packet.getAddress(), packet.getPort());
        byte[] data = Arrays.copyOfRange(packet.getData(), packet.getOffset(), packet.getLength());
        List<Record> records = Record.fromByteArray(data, peerAddress, this.connectionIdGenerator, timestamp);
        LOGGER.debug("Received {} DTLS records from {} using a {} byte datagram buffer", new Object[]{records.size(), peerAddress, this.inboundDatagramBufferSize});
        if (records.isEmpty()) {
            return;
        }
        if (!this.running.get()) {
            LOGGER.debug("Execution shutdown while processing incoming records from peer: {}", (Object)peerAddress);
            return;
        }
        final Record firstRecord = records.get(0);
        if (records.size() == 1 && firstRecord.isNewClientHello()) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    DTLSConnector.this.processNewClientHello(firstRecord);
                }
            });
            return;
        }
        ConnectionId connectionId = firstRecord.getConnectionId();
        final Connection connection = this.getConnection(peerAddress, connectionId, false);
        if (connection == null) {
            if (this.health != null) {
                this.health.receivingRecord(true);
            }
            if (connectionId == null) {
                LOGGER.debug("Discarding {} records from [{}] received without existing connection", (Object)records.size(), (Object)peerAddress);
            } else {
                LOGGER.debug("Discarding {} records from [{},{}] received without existing connection", new Object[]{records.size(), peerAddress, connectionId});
            }
            return;
        }
        SerialExecutor serialExecutor = connection.getExecutor();
        for (final Record record : records) {
            try {
                serialExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (DTLSConnector.this.running.get()) {
                            DTLSConnector.this.processRecord(record, connection);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                LOGGER.debug("Execution rejected while processing record [type: {}, peer: {}]", new Object[]{record.getType(), peerAddress, e});
                break;
            }
            catch (RuntimeException e) {
                LOGGER.warn("Unexpected error occurred while processing record [type: {}, peer: {}]", new Object[]{record.getType(), peerAddress, e});
                this.terminateConnection(connection, e, AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR);
                break;
            }
        }
    }

    @Override
    public void processRecord(Record record, Connection connection) {
        try {
            boolean useCid;
            DTLSSession session;
            if (record.getConnectionId() == null && !connection.equalsPeerAddress(record.getPeerAddress())) {
                long delay = TimeUnit.NANOSECONDS.toMillis(ClockUtil.nanoRealtime() - record.getReceiveNanos());
                LOGGER.warn("Drop record {}, connection changed address {} => {}! (shift {}ms)", new Object[]{record.getType(), record.getPeerAddress(), connection.getPeerAddress(), delay});
                if (this.health != null) {
                    this.health.receivingRecord(true);
                }
                return;
            }
            int epoch = record.getEpoch();
            LOGGER.trace("Received DTLS record of type [{}], length: {}, [epoche:{},reqn:{}]", new Object[]{record.getType(), record.getFragmentLength(), epoch, record.getSequenceNumber()});
            Handshaker handshaker = connection.getOngoingHandshake();
            if (handshaker != null && handshaker.isExpired()) {
                handshaker.handshakeFailed(new Exception("handshake already expired!"));
                if (this.connectionStore.get(connection.getConnectionId()) != connection) {
                    LOGGER.debug("Discarding {} record received from peer [{}], handshake expired!", new Object[]{record.getType(), record.getPeerAddress(), epoch});
                    if (this.health != null) {
                        this.health.receivingRecord(true);
                    }
                    return;
                }
                handshaker = null;
            }
            if ((session = connection.getSession(epoch)) == null) {
                if (handshaker != null && handshaker.getSession().getReadEpoch() == 0 && epoch == 1) {
                    handshaker.addRecordsForDeferredProcessing(record);
                } else {
                    LOGGER.debug("Discarding {} record received from peer [{}] without an active session for epoch {}", new Object[]{record.getType(), record.getPeerAddress(), epoch});
                    if (this.health != null) {
                        this.health.receivingRecord(true);
                    }
                }
                return;
            }
            if (this.useFilter && session != null && !session.isRecordProcessable(record.getEpoch(), record.getSequenceNumber(), this.useWindowFilter)) {
                LOGGER.debug("Discarding duplicate {} record received from peer [{}]", (Object)record.getType(), (Object)record.getPeerAddress());
                if (this.health != null) {
                    this.health.receivingRecord(true);
                }
                return;
            }
            boolean bl = useCid = this.connectionIdGenerator != null && this.connectionIdGenerator.useConnectionId();
            if (record.getType() == ContentType.TLS12_CID) {
                if (epoch == 0) {
                    LOGGER.debug("Discarding TLS_CID record received from peer [{}] during handshake", (Object)record.getPeerAddress());
                    if (this.health != null) {
                        this.health.receivingRecord(true);
                    }
                    return;
                }
            } else if (epoch > 0 && useCid && connection.expectCid()) {
                LOGGER.debug("Discarding record received from peer [{}], CID required!", (Object)record.getPeerAddress());
                if (this.health != null) {
                    this.health.receivingRecord(true);
                }
                return;
            }
            record.applySession(session);
            if (handshaker != null && handshaker.isProbing()) {
                if (connection.hasEstablishedSession()) {
                    this.connectionStore.removeFromEstablishedSessions(connection.getEstablishedSession(), connection);
                }
                connection.resetSession();
                handshaker.resetProbing();
                LOGGER.debug("handshake probe successful {}", (Object)connection.getPeerAddress());
            }
            switch (record.getType()) {
                case APPLICATION_DATA: {
                    this.processApplicationDataRecord(record, connection);
                    break;
                }
                case ALERT: {
                    this.processAlertRecord(record, connection, session);
                    break;
                }
                case CHANGE_CIPHER_SPEC: {
                    this.processChangeCipherSpecRecord(record, connection);
                    break;
                }
                case HANDSHAKE: {
                    this.processHandshakeRecord(record, connection);
                    break;
                }
                default: {
                    LOGGER.debug("Discarding record of unsupported type [{}] from peer [{}]", (Object)record.getType(), (Object)record.getPeerAddress());
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            if (this.health != null) {
                this.health.receivingRecord(true);
            }
            LOGGER.warn("Unexpected error occurred while processing record from peer [{}]", (Object)record.getPeerAddress(), (Object)e);
            this.terminateConnection(connection, e, AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR);
        }
        catch (GeneralSecurityException e) {
            if (this.health != null) {
                this.health.receivingRecord(true);
            }
            LOGGER.info("error occurred while processing record from peer [{}]", (Object)record.getPeerAddress(), (Object)e);
        }
        catch (HandshakeException e) {
            LOGGER.info("error occurred while processing record from peer [{}]", (Object)record.getPeerAddress(), (Object)e);
        }
    }

    private void terminateOngoingHandshake(Connection connection, Throwable cause, AlertMessage.AlertDescription description) {
        Handshaker handshaker = connection.getOngoingHandshake();
        if (handshaker != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Aborting handshake with peer [{}]:", (Object)connection.getPeerAddress(), (Object)cause);
            } else if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Aborting handshake with peer [{}]: {}", (Object)connection.getPeerAddress(), (Object)cause.getMessage());
            }
            handshaker.setFailureCause(cause);
            DTLSSession session = handshaker.getSession();
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, description, connection.getPeerAddress());
            if (!connection.hasEstablishedSession()) {
                this.terminateConnection(connection, alert, session);
            } else {
                if (connection.getEstablishedSession() == handshaker.getSession()) {
                    LOGGER.warn("Handshake with [{}] failed after session was established!", (Object)handshaker.getPeerAddress());
                } else {
                    LOGGER.warn("Handshake with [{}] failed, but has an established session!", (Object)handshaker.getPeerAddress());
                }
                this.send(alert, session);
            }
            handshaker.handshakeFailed(cause);
        }
    }

    private void terminateConnection(Connection connection) {
        if (connection != null) {
            this.connectionStore.remove(connection);
        }
    }

    private void terminateConnection(Connection connection, Throwable cause, AlertMessage.AlertLevel level, AlertMessage.AlertDescription description) {
        if (connection.hasEstablishedSession()) {
            this.terminateConnection(connection, new AlertMessage(level, description, connection.getPeerAddress()), connection.getEstablishedSession());
        } else if (connection.hasOngoingHandshake()) {
            this.terminateConnection(connection, new AlertMessage(level, description, connection.getPeerAddress()), connection.getOngoingHandshake().getSession());
        }
    }

    private void terminateConnection(Connection connection, AlertMessage alert, DTLSSession session) {
        if (alert == null) {
            LOGGER.debug("Terminating connection with peer [{}]", (Object)connection.getPeerAddress());
        } else {
            if (session == null) {
                throw new IllegalArgumentException("Session must not be null, if alert message is to be sent");
            }
            LOGGER.debug("Terminating connection with peer [{}], reason [{}]", (Object)connection.getPeerAddress(), (Object)alert.getDescription());
            this.send(alert, session);
        }
        if (alert != null && alert.getLevel() == AlertMessage.AlertLevel.WARNING && alert.getDescription() == AlertMessage.AlertDescription.CLOSE_NOTIFY) {
            connection.setResumptionRequired(true);
        } else {
            this.connectionStore.remove(connection);
        }
    }

    private void processApplicationDataRecord(Record record, Connection connection) {
        Handshaker ongoingHandshake = connection.getOngoingHandshake();
        DTLSSession session = connection.getEstablishedSession();
        if (session != null && !connection.isResumptionRequired()) {
            ApplicationMessage message = (ApplicationMessage)record.getFragment();
            InetSocketAddress newAddress = record.getPeerAddress();
            if (this.connectionStore.get(newAddress) == connection) {
                newAddress = null;
            }
            if (!session.markRecordAsRead(record.getEpoch(), record.getSequenceNumber()) && this.useCidUpdateAddressOnNewerRecordFilter) {
                newAddress = null;
            }
            if (ongoingHandshake != null) {
                ongoingHandshake.handshakeCompleted();
            }
            connection.refreshAutoResumptionTime();
            this.connectionStore.update(connection, newAddress);
            RawDataChannel channel = this.messageHandler;
            if (channel != null) {
                DtlsEndpointContext context;
                if (session.getPeer() == null) {
                    session.setPeer(record.getPeerAddress());
                    context = session.getConnectionWriteContext();
                    session.setPeer(null);
                    LOGGER.warn("Received APPLICATION_DATA from deprecated {}", (Object)record.getPeerAddress());
                } else {
                    context = session.getConnectionWriteContext();
                }
                LOGGER.debug("Received APPLICATION_DATA for {}", (Object)context);
                RawData receivedApplicationMessage = RawData.inbound((byte[])message.getData(), (EndpointContext)context, (boolean)false, (long)record.getReceiveNanos());
                channel.receiveData(receivedApplicationMessage);
            }
        } else if (ongoingHandshake != null) {
            ongoingHandshake.addRecordsForDeferredProcessing(record);
        } else {
            LOGGER.debug("Discarding APPLICATION_DATA record received from peer [{}]", (Object)record.getPeerAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAlertRecord(Record record, Connection connection, DTLSSession session) {
        AlertMessage alert = (AlertMessage)record.getFragment();
        Handshaker handshaker = connection.getOngoingHandshake();
        HandshakeException error = null;
        LOGGER.trace("Processing {} ALERT from [{}]: {}", new Object[]{alert.getLevel(), alert.getPeer(), alert.getDescription()});
        if (AlertMessage.AlertDescription.CLOSE_NOTIFY.equals((Object)alert.getDescription())) {
            error = new HandshakeException("Received 'close notify'", alert);
            if (handshaker != null) {
                handshaker.setFailureCause(error);
            }
            if (!connection.isResumptionRequired()) {
                this.send(new AlertMessage(AlertMessage.AlertLevel.WARNING, AlertMessage.AlertDescription.CLOSE_NOTIFY, alert.getPeer()), session);
                if (this.connectionStore instanceof CloseSupportingConnectionStore) {
                    ((CloseSupportingConnectionStore)((Object)this.connectionStore)).removeFromAddress(connection);
                } else {
                    this.connectionStore.remove(connection, false);
                }
            }
        } else if (AlertMessage.AlertLevel.FATAL.equals((Object)alert.getLevel())) {
            error = new HandshakeException("Received 'fatal alert'", alert);
            if (handshaker != null) {
                handshaker.setFailureCause(error);
            }
            this.terminateConnection(connection);
        }
        Object object = this.alertHandlerLock;
        synchronized (object) {
            if (this.alertHandler != null) {
                this.alertHandler.onAlert(alert.getPeer(), alert);
            }
        }
        if (null != error && null != handshaker) {
            handshaker.handshakeFailed(error);
        }
    }

    private void processChangeCipherSpecRecord(Record record, Connection connection) {
        Handshaker ongoingHandshaker = connection.getOngoingHandshake();
        if (ongoingHandshaker != null) {
            try {
                ongoingHandshaker.processMessage(record);
            }
            catch (HandshakeException e) {
                this.handleExceptionDuringHandshake(e, e.getAlert().getLevel(), e.getAlert().getDescription(), connection, record);
            }
        } else {
            LOGGER.debug("Received CHANGE_CIPHER_SPEC record from peer [{}] with no handshake going on", (Object)record.getPeerAddress());
        }
    }

    private void processHandshakeRecord(Record record, Connection connection) {
        LOGGER.debug("Received {} record from peer [{}]", (Object)record.getType(), (Object)record.getPeerAddress());
        try {
            if (record.isNewClientHello()) {
                throw new IllegalArgumentException("new CLIENT_HELLO must be processed by processClientHello!");
            }
            HandshakeMessage handshakeMessage = (HandshakeMessage)record.getFragment();
            switch (handshakeMessage.getMessageType()) {
                case CLIENT_HELLO: {
                    LOGGER.debug("Reject re-negociation from peer {}", (Object)record.getPeerAddress());
                    DTLSSession session = connection.getEstablishedSession();
                    this.send(new AlertMessage(AlertMessage.AlertLevel.WARNING, AlertMessage.AlertDescription.NO_RENEGOTIATION, record.getPeerAddress()), session);
                    break;
                }
                case HELLO_REQUEST: {
                    this.processHelloRequest(connection);
                    break;
                }
                default: {
                    Handshaker handshaker = connection.getOngoingHandshake();
                    if (handshaker != null) {
                        handshaker.processMessage(record);
                        break;
                    }
                    LOGGER.debug("Discarding HANDSHAKE message [epoch={}] from peer [{}], no ongoing handshake!", (Object)record.getEpoch(), (Object)record.getPeerAddress());
                    break;
                }
            }
        }
        catch (HandshakeException e) {
            this.handleExceptionDuringHandshake(e, e.getAlert().getLevel(), e.getAlert().getDescription(), connection, record);
        }
    }

    private void processHelloRequest(Connection connection) throws HandshakeException {
        if (connection.hasOngoingHandshake()) {
            LOGGER.debug("Ignoring HELLO_REQUEST received from [{}] while already in an ongoing handshake with peer", (Object)connection.getPeerAddress());
        } else {
            DTLSSession session = connection.getEstablishedSession();
            this.send(new AlertMessage(AlertMessage.AlertLevel.WARNING, AlertMessage.AlertDescription.NO_RENEGOTIATION, connection.getPeerAddress()), session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNewClientHello(final Record record) {
        block20: {
            InetSocketAddress peerAddress = record.getPeerAddress();
            if (LOGGER.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder("Processing new CLIENT_HELLO from peer [").append(peerAddress).append("]");
                if (LOGGER.isTraceEnabled()) {
                    msg.append(":").append(StringUtil.lineSeparator()).append(record);
                }
                LOGGER.debug(msg.toString());
            }
            try {
                Connection connection;
                record.applySession(null);
                final ClientHello clientHello = (ClientHello)record.getFragment();
                final AvailableConnections connections = new AvailableConnections();
                if (!this.isClientInControlOfSourceIpAddress(clientHello, record, connections)) break block20;
                boolean verify = false;
                ResumptionSupportingConnectionStore resumptionSupportingConnectionStore = this.connectionStore;
                synchronized (resumptionSupportingConnectionStore) {
                    connection = this.connectionStore.get(peerAddress);
                    if (connection != null && !connection.isStartedByClientHello(clientHello)) {
                        Connection sessionConnection = connections.getConnectionBySessionId();
                        if (sessionConnection != null && sessionConnection != connection) {
                            verify = true;
                        } else {
                            if (sessionConnection != null && sessionConnection == connection) {
                                connections.setRemoveConnectionBySessionId(true);
                            }
                            connection = null;
                        }
                    }
                    if (connection == null) {
                        connection = new Connection(peerAddress, new SerialExecutor((Executor)this.getExecutorService()));
                        connection.startByClientHello(clientHello);
                        if (!this.connectionStore.put(connection)) {
                            return;
                        }
                    }
                }
                if (verify) {
                    this.sendHelloVerify(clientHello, record, null);
                } else {
                    connections.setConnectionByAddress(connection);
                    try {
                        connection.getExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                if (DTLSConnector.this.running.get()) {
                                    DTLSConnector.this.processClientHello(clientHello, record, connections);
                                }
                            }
                        });
                    }
                    catch (RejectedExecutionException e) {
                        LOGGER.debug("Execution rejected while processing record [type: {}, peer: {}]", new Object[]{record.getType(), peerAddress, e});
                    }
                    catch (RuntimeException e) {
                        LOGGER.warn("Unexpected error occurred while processing record [type: {}, peer: {}]", new Object[]{record.getType(), peerAddress, e});
                        this.terminateConnection(connections.getConnectionByAddress(), e, AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR);
                    }
                }
            }
            catch (HandshakeException e) {
                LOGGER.debug("Processing new CLIENT_HELLO from peer [{}] failed!", (Object)record.getPeerAddress(), (Object)e);
            }
            catch (GeneralSecurityException e) {
                LOGGER.debug("Processing new CLIENT_HELLO from peer [{}] failed!", (Object)record.getPeerAddress(), (Object)e);
            }
            catch (RuntimeException e) {
                LOGGER.debug("Processing new CLIENT_HELLO from peer [{}] failed!", (Object)record.getPeerAddress(), (Object)e);
            }
        }
    }

    private void processClientHello(ClientHello clientHello, Record record, AvailableConnections connections) {
        if (connections == null) {
            throw new NullPointerException("available connections must not be null!");
        }
        Connection connection = connections.getConnectionByAddress();
        if (connection == null) {
            throw new NullPointerException("connection by address must not be null!");
        }
        if (!connection.equalsPeerAddress(record.getPeerAddress())) {
            LOGGER.warn("Drop CLIENT_HELLO, changed address {} => {}!", (Object)record.getPeerAddress(), (Object)connection.getPeerAddress());
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder("Processing CLIENT_HELLO from peer [").append(record.getPeerAddress()).append("]");
            if (LOGGER.isTraceEnabled()) {
                msg.append(":").append(StringUtil.lineSeparator()).append(record);
            }
            LOGGER.debug(msg.toString());
        }
        try {
            if (connection.hasEstablishedSession() || connection.getOngoingHandshake() != null) {
                LOGGER.debug("Discarding duplicate CLIENT_HELLO message [epoch={}] from peer [{}]!", (Object)record.getEpoch(), (Object)record.getPeerAddress());
            } else if (clientHello.hasSessionId()) {
                this.resumeExistingSession(clientHello, record, connections);
            } else {
                this.startNewHandshake(clientHello, record, connection);
            }
        }
        catch (HandshakeException e) {
            this.handleExceptionDuringHandshake(e, e.getAlert().getLevel(), e.getAlert().getDescription(), connection, record);
        }
    }

    private boolean isClientInControlOfSourceIpAddress(ClientHello clientHello, Record record, AvailableConnections connections) {
        if (connections == null) {
            throw new NullPointerException("available connections must not be null!");
        }
        try {
            byte[] expectedCookie = null;
            byte[] providedCookie = clientHello.getCookie();
            if (providedCookie.length > 0) {
                expectedCookie = this.cookieGenerator.generateCookie(clientHello);
                if (Arrays.equals(expectedCookie, providedCookie)) {
                    return true;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("provided cookie must {} match {}. Send verify request to {}", new Object[]{StringUtil.byteArray2HexString((byte[])providedCookie, (char)'\u0000', (int)6), StringUtil.byteArray2HexString((byte[])expectedCookie, (char)'\u0000', (int)6), record.getPeerAddress()});
                }
            } else if (0 < this.thresholdHandshakesWithoutVerifiedPeer) {
                int pending = this.pendingHandshakesWithoutVerifiedPeer.get();
                LOGGER.trace("pending fast resumptions [{}], threshold [{}]", (Object)pending, (Object)this.thresholdHandshakesWithoutVerifiedPeer);
                if (pending < this.thresholdHandshakesWithoutVerifiedPeer) {
                    Connection sessionConnection = this.connectionStore.find(clientHello.getSessionId());
                    connections.setConnectionBySessionId(sessionConnection);
                    if (sessionConnection != null) {
                        return true;
                    }
                }
            }
            this.sendHelloVerify(clientHello, record, expectedCookie);
            return false;
        }
        catch (GeneralSecurityException e) {
            throw new DtlsHandshakeException("Cannot compute cookie for peer", AlertMessage.AlertDescription.INTERNAL_ERROR, AlertMessage.AlertLevel.FATAL, clientHello.getPeer(), e);
        }
    }

    private void startNewHandshake(ClientHello clientHello, Record record, Connection connection) throws HandshakeException {
        DTLSSession newSession = new DTLSSession(record.getPeerAddress(), record.getSequenceNumber());
        ServerHandshaker handshaker = new ServerHandshaker(clientHello.getMessageSeq(), newSession, this, connection, this.config, this.maximumTransmissionUnit);
        this.initializeHandshaker(handshaker);
        handshaker.processMessage(record);
    }

    private void resumeExistingSession(ClientHello clientHello, Record record, AvailableConnections connections) throws HandshakeException {
        Connection previousConnection;
        InetSocketAddress peerAddress = record.getPeerAddress();
        LOGGER.debug("Client [{}] wants to resume session with ID [{}]", (Object)peerAddress, (Object)clientHello.getSessionId());
        if (connections == null) {
            throw new NullPointerException("available connections must not be null!");
        }
        Connection connection = connections.getConnectionByAddress();
        if (connection == null) {
            throw new NullPointerException("connection by address must not be null!");
        }
        if (!connection.equalsPeerAddress(peerAddress)) {
            throw new IllegalArgumentException("connection must have records address!");
        }
        SessionTicket ticket = null;
        if (!connections.isConnectionBySessionIdKnown()) {
            connections.setConnectionBySessionId(this.connectionStore.find(clientHello.getSessionId()));
        }
        if ((previousConnection = connections.getConnectionBySessionId()) != null && previousConnection.isActive()) {
            ticket = previousConnection.hasEstablishedSession() ? previousConnection.getEstablishedSession().getSessionTicket() : previousConnection.getSessionTicket();
            boolean ok = true;
            if (ticket != null && this.config.isSniEnabled().booleanValue()) {
                ServerNames serverNames1 = ticket.getServerNames();
                ServerNames serverNames2 = null;
                ServerNameExtension extension = clientHello.getServerNameExtension();
                if (extension != null) {
                    serverNames2 = extension.getServerNames();
                }
                if (serverNames1 != null) {
                    ok = serverNames1.equals(serverNames2);
                } else if (serverNames2 != null) {
                    ok = false;
                }
            }
            if (!ok && ticket != null) {
                SecretUtil.destroy(ticket);
                ticket = null;
            }
        }
        if (ticket != null) {
            DTLSSession sessionToResume = new DTLSSession(clientHello.getSessionId(), peerAddress, ticket, record.getSequenceNumber());
            ResumingServerHandshaker handshaker = new ResumingServerHandshaker(clientHello.getMessageSeq(), sessionToResume, this, connection, this.config, this.maximumTransmissionUnit);
            this.initializeHandshaker(handshaker);
            SecretUtil.destroy(ticket);
            if (previousConnection.hasEstablishedSession()) {
                if (connections.isRemoveConnectionBySessionId()) {
                    this.connectionStore.remove(previousConnection, false);
                } else if (clientHello.getCookie().length == 0) {
                    this.pendingHandshakesWithoutVerifiedPeer.incrementAndGet();
                    handshaker.addSessionListener(new SessionAdapter(){

                        @Override
                        public void sessionEstablished(Handshaker currentHandshaker, DTLSSession establishedSession) throws HandshakeException {
                            DTLSConnector.this.pendingHandshakesWithoutVerifiedPeer.decrementAndGet();
                        }

                        @Override
                        public void handshakeFailed(Handshaker handshaker, Throwable error) {
                            DTLSConnector.this.pendingHandshakesWithoutVerifiedPeer.decrementAndGet();
                        }
                    });
                }
            }
            handshaker.processMessage(record);
        } else {
            LOGGER.debug("Client [{}] tries to resume non-existing session [ID={}], performing full handshake instead ...", (Object)peerAddress, (Object)clientHello.getSessionId());
            this.startNewHandshake(clientHello, record, connection);
        }
    }

    private void sendHelloVerify(ClientHello clientHello, Record record, byte[] expectedCookie) throws GeneralSecurityException {
        LOGGER.debug("Verifying client IP address [{}] using HELLO_VERIFY_REQUEST", (Object)record.getPeerAddress());
        if (expectedCookie == null) {
            expectedCookie = this.cookieGenerator.generateCookie(clientHello);
        }
        HelloVerifyRequest msg = new HelloVerifyRequest(new ProtocolVersion(), expectedCookie, record.getPeerAddress());
        msg.setMessageSeq(clientHello.getMessageSeq());
        Record helloVerify = new Record(ContentType.HANDSHAKE, record.getSequenceNumber(), msg, record.getPeerAddress());
        try {
            this.sendRecord(helloVerify);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void send(AlertMessage alert, DTLSSession session) {
        if (alert == null) {
            throw new IllegalArgumentException("Alert must not be NULL");
        }
        if (session == null) {
            throw new IllegalArgumentException("Session must not be NULL");
        }
        try {
            boolean useCid = session.getWriteEpoch() > 0;
            LOGGER.debug("send ALERT {} for peer {}.", (Object)alert, (Object)session.getPeer());
            this.sendRecord(new Record(ContentType.ALERT, session.getWriteEpoch(), session.getSequenceNumber(), alert, session, useCid, 0));
        }
        catch (IOException useCid) {
        }
        catch (GeneralSecurityException e) {
            LOGGER.debug("Cannot create ALERT message for peer [{}]", (Object)session.getPeer(), (Object)e);
        }
    }

    public final void send(final RawData message) {
        Connection connection;
        if (message == null) {
            throw new NullPointerException("Message must not be null");
        }
        if (this.health != null) {
            this.health.sendingRecord(false);
        }
        if (message.isMulticast()) {
            LOGGER.warn("DTLSConnector drops {} bytes to multicast {}:{}", new Object[]{message.getSize(), message.getAddress(), message.getPort()});
            message.onError((Throwable)new MulticastNotSupportedException("DTLS doesn't support multicast!"));
            if (this.health != null) {
                this.health.sendingRecord(true);
            }
            return;
        }
        RuntimeException error = null;
        if (!this.running.get()) {
            connection = null;
            error = new IllegalStateException("connector must be started before sending messages is possible");
        } else if (message.getSize() > 16384) {
            connection = null;
            error = new IllegalArgumentException("Message data must not exceed 16384 bytes");
        } else {
            boolean create;
            boolean bl = create = !this.serverOnly;
            if (create) {
                boolean bl2 = create = !this.getEffectiveHandshakeMode(message).equals("none");
            }
            if ((connection = this.getConnection(message.getInetSocketAddress(), null, create)) == null) {
                if (create) {
                    error = new IllegalStateException("connection store is exhausted!");
                } else {
                    if (this.serverOnly) {
                        message.onError((Throwable)new EndpointUnconnectedException("server only, connection missing!"));
                    } else {
                        message.onError((Throwable)new EndpointUnconnectedException("connection missing!"));
                    }
                    if (this.health != null) {
                        this.health.sendingRecord(true);
                    }
                    return;
                }
            }
        }
        if (error != null) {
            message.onError((Throwable)error);
            if (this.health != null) {
                this.health.sendingRecord(true);
            }
            throw error;
        }
        final long now = ClockUtil.nanoRealtime();
        if (this.pendingOutboundMessagesCountdown.decrementAndGet() >= 0) {
            try {
                SerialExecutor executor = connection.getExecutor();
                if (executor == null) {
                    throw new NullPointerException("missing executor for connection! " + connection.getPeerAddress());
                }
                executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (DTLSConnector.this.running.get()) {
                                DTLSConnector.this.sendMessage(now, message, connection);
                            } else {
                                message.onError((Throwable)new InterruptedIOException("Connector is not running."));
                                if (DTLSConnector.this.health != null) {
                                    DTLSConnector.this.health.sendingRecord(true);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (DTLSConnector.this.running.get()) {
                                LOGGER.debug("Exception thrown by executor thread [{}]", (Object)Thread.currentThread().getName(), (Object)e);
                            }
                            if (DTLSConnector.this.health != null) {
                                DTLSConnector.this.health.sendingRecord(true);
                            }
                            message.onError((Throwable)e);
                        }
                        finally {
                            DTLSConnector.this.pendingOutboundMessagesCountdown.incrementAndGet();
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                LOGGER.debug("Execution rejected while sending application record [peer: {}]", (Object)message.getInetSocketAddress(), (Object)e);
                message.onError((Throwable)new InterruptedIOException("Connector is not running."));
                if (this.health != null) {
                    this.health.sendingRecord(true);
                }
            }
        } else {
            this.pendingOutboundMessagesCountdown.incrementAndGet();
            LOGGER.warn("Outbound message overflow! Dropping outbound message to peer [{}]", (Object)message.getInetSocketAddress());
            message.onError((Throwable)new IllegalStateException("Outbound message overflow!"));
            if (this.health != null) {
                this.health.sendingRecord(true);
            }
        }
    }

    private void sendMessage(long nanos, RawData message, Connection connection) throws HandshakeException {
        if (connection.getPeerAddress() == null) {
            long delay = TimeUnit.NANOSECONDS.toMillis(ClockUtil.nanoRealtime() - nanos);
            LOGGER.warn("Drop record with {} bytes, connection lost address {}! (shift {}ms)", new Object[]{message.getSize(), message.getInetSocketAddress(), delay});
            message.onError((Throwable)new EndpointUnconnectedException("connection not longer assigned to address!"));
            if (this.health != null) {
                this.health.sendingRecord(true);
            }
            return;
        }
        LOGGER.debug("Sending application layer message to [{}]", (Object)message.getEndpointContext());
        Handshaker handshaker = connection.getOngoingHandshake();
        if (handshaker != null) {
            if (handshaker.isExpired()) {
                handshaker.handshakeAborted(new Exception("handshake already expired!"));
            } else if (handshaker.isProbing()) {
                if (this.checkOutboundEndpointContext(message, null)) {
                    message.onConnecting();
                    handshaker.addApplicationDataForDeferredProcessing(message);
                }
                return;
            }
        }
        if (connection.isActive()) {
            this.sendMessageWithSession(message, connection);
        } else {
            this.sendMessageWithoutSession(message, connection);
        }
    }

    private void sendMessageWithoutSession(RawData message, Connection connection) throws HandshakeException {
        if (!this.checkOutboundEndpointContext(message, null)) {
            return;
        }
        Handshaker handshaker = connection.getOngoingHandshake();
        if (handshaker == null) {
            if (this.serverOnly) {
                message.onError((Throwable)new EndpointUnconnectedException("server only, connection missing!"));
                if (this.health != null) {
                    this.health.sendingRecord(true);
                }
                return;
            }
            boolean none = this.getEffectiveHandshakeMode(message).contentEquals("none");
            if (none) {
                message.onError((Throwable)new EndpointUnconnectedException("connection missing!"));
                if (this.health != null) {
                    this.health.sendingRecord(true);
                }
                return;
            }
            DTLSSession session = new DTLSSession(message.getInetSocketAddress());
            session.setHostName(message.getEndpointContext().getVirtualHost());
            handshaker = new ClientHandshaker(session, this, connection, this.config, this.maximumTransmissionUnit);
            this.initializeHandshaker(handshaker);
            handshaker.startHandshake();
        }
        message.onConnecting();
        handshaker.addApplicationDataForDeferredProcessing(message);
    }

    private void sendMessageWithSession(RawData message, Connection connection) throws HandshakeException {
        DTLSSession session = connection.getEstablishedSession();
        String handshakeMode = this.getEffectiveHandshakeMode(message);
        boolean none = "none".equals(handshakeMode);
        if (none) {
            if (connection.isResumptionRequired()) {
                message.onError((Throwable)new EndpointUnconnectedException("resumption required!"));
                if (this.health != null) {
                    this.health.sendingRecord(true);
                }
                return;
            }
        } else {
            boolean force;
            boolean probing = "probe".equals(handshakeMode);
            boolean full = "full".equals(handshakeMode);
            boolean bl = force = probing || full || "force".equals(handshakeMode);
            if (force || connection.isAutoResumptionRequired(this.getAutResumptionTimeout(message))) {
                ClientHandshaker newHandshaker;
                if (this.serverOnly) {
                    message.onError((Throwable)new EndpointUnconnectedException("server only, resumption requested failed!"));
                    if (this.health != null) {
                        this.health.sendingRecord(true);
                    }
                    return;
                }
                message.onConnecting();
                Handshaker previousHandshaker = connection.getOngoingHandshake();
                SessionTicket ticket = null;
                SessionId sessionId = null;
                if (session != null) {
                    sessionId = session.getSessionIdentifier();
                    ticket = session.getSessionTicket();
                    if (!probing) {
                        this.connectionStore.removeFromEstablishedSessions(session, connection);
                    }
                } else {
                    if (!full) {
                        sessionId = connection.getSessionIdentity();
                        ticket = connection.getSessionTicket();
                    }
                    probing = false;
                }
                if (probing) {
                    connection.setResumptionRequired(false);
                } else {
                    connection.resetSession();
                }
                if (full || sessionId.isEmpty()) {
                    DTLSSession newSession = new DTLSSession(message.getInetSocketAddress());
                    newSession.setHostName(message.getEndpointContext().getVirtualHost());
                    newHandshaker = new ClientHandshaker(newSession, this, connection, this.config, this.maximumTransmissionUnit);
                } else {
                    DTLSSession resumableSession = new DTLSSession(sessionId, message.getInetSocketAddress(), ticket, 0L);
                    SecretUtil.destroy(ticket);
                    resumableSession.setHostName(message.getEndpointContext().getVirtualHost());
                    newHandshaker = new ResumingClientHandshaker(resumableSession, this, connection, this.config, this.maximumTransmissionUnit, probing);
                }
                this.initializeHandshaker(newHandshaker);
                if (previousHandshaker != null) {
                    newHandshaker.takeDeferredApplicationData(previousHandshaker);
                    previousHandshaker.handshakeAborted(new Exception("handshake replaced!"));
                }
                newHandshaker.addApplicationDataForDeferredProcessing(message);
                ((Handshaker)newHandshaker).startHandshake();
                return;
            }
        }
        this.sendMessage(message, connection, session);
    }

    private void sendMessage(RawData message, Connection connection, DTLSSession session) {
        try {
            LOGGER.trace("send {}-{} using {}-{}", new Object[]{connection.getConnectionId(), connection.getPeerAddress(), session.getSessionIdentifier(), session.getPeer()});
            DtlsEndpointContext ctx = session.getConnectionWriteContext();
            if (!this.checkOutboundEndpointContext(message, (EndpointContext)ctx)) {
                return;
            }
            message.onContextEstablished((EndpointContext)ctx);
            Record record = new Record(ContentType.APPLICATION_DATA, session.getWriteEpoch(), session.getSequenceNumber(), new ApplicationMessage(message.getBytes(), message.getInetSocketAddress()), session, true, 0);
            this.sendRecord(record);
            message.onSent();
            connection.refreshAutoResumptionTime();
        }
        catch (IOException e) {
            message.onError((Throwable)e);
        }
        catch (GeneralSecurityException e) {
            LOGGER.debug("Cannot send APPLICATION record to peer [{}]", (Object)message.getInetSocketAddress(), (Object)e);
            message.onError((Throwable)e);
        }
    }

    private boolean checkOutboundEndpointContext(RawData message, EndpointContext connectionContext) {
        EndpointContextMatcher endpointMatcher = this.getEndpointContextMatcher();
        if (null != endpointMatcher && !endpointMatcher.isToBeSent(message.getEndpointContext(), connectionContext)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("DTLSConnector ({}) drops {} bytes, {} != {}", new Object[]{this, message.getSize(), endpointMatcher.toRelevantState(message.getEndpointContext()), endpointMatcher.toRelevantState(connectionContext)});
            }
            message.onError((Throwable)new EndpointMismatchException());
            if (this.health != null) {
                this.health.sendingRecord(true);
            }
            return false;
        }
        return true;
    }

    public final DTLSSession getSessionByAddress(InetSocketAddress address) {
        if (address == null) {
            return null;
        }
        Connection connection = this.connectionStore.get(address);
        if (connection != null) {
            return connection.getEstablishedSession();
        }
        return null;
    }

    @Override
    public void sendFlight(DTLSFlight flight, Connection connection) throws IOException {
        if (flight != null) {
            flight.setTimeout(this.config.getRetransmissionTimeout());
            this.sendFlightOverNetwork(flight);
            this.scheduleRetransmission(flight, connection);
        }
    }

    private void sendFlightOverNetwork(DTLSFlight flight) throws IOException {
        int maxDatagramSize = flight.getSession().getMaxDatagramSize();
        DatagramWriter writer = new DatagramWriter(maxDatagramSize);
        ArrayList<DatagramPacket> datagrams = new ArrayList<DatagramPacket>();
        for (Record record : flight.getMessages()) {
            byte[] recordBytes = record.toByteArray();
            if (recordBytes.length > maxDatagramSize) {
                LOGGER.info("{} record of {} bytes for peer [{}] exceeds max. datagram size [{}], discarding...", new Object[]{record.getType(), recordBytes.length, record.getPeerAddress(), maxDatagramSize});
                continue;
            }
            LOGGER.trace("Sending record of {} bytes to peer [{}]:\n{}", new Object[]{recordBytes.length, flight.getPeerAddress(), record});
            if (writer.size() + recordBytes.length > maxDatagramSize) {
                byte[] payload = writer.toByteArray();
                DatagramPacket datagram = new DatagramPacket(payload, payload.length, flight.getPeerAddress().getAddress(), flight.getPeerAddress().getPort());
                datagrams.add(datagram);
                if (this.health != null) {
                    this.health.sendingRecord(false);
                }
            }
            writer.writeBytes(recordBytes);
        }
        byte[] payload = writer.toByteArray();
        DatagramPacket datagram = new DatagramPacket(payload, payload.length, flight.getPeerAddress().getAddress(), flight.getPeerAddress().getPort());
        datagrams.add(datagram);
        if (this.health != null) {
            this.health.sendingRecord(false);
        }
        LOGGER.debug("Sending flight of {} message(s) to peer [{}] using {} datagram(s) of max. {} bytes", new Object[]{flight.getMessages().size(), flight.getPeerAddress(), datagrams.size(), maxDatagramSize});
        for (DatagramPacket datagramPacket : datagrams) {
            if (this.health != null) {
                this.health.sendingRecord(false);
            }
            this.sendNextDatagramOverNetwork(datagramPacket);
        }
    }

    protected void sendRecord(Record record) throws IOException {
        byte[] recordBytes = record.toByteArray();
        DatagramPacket datagram = new DatagramPacket(recordBytes, recordBytes.length, record.getPeerAddress());
        this.sendNextDatagramOverNetwork(datagram);
    }

    protected void sendNextDatagramOverNetwork(DatagramPacket datagramPacket) throws IOException {
        InetSocketAddress address;
        block4: {
            DatagramSocket socket = this.getSocket();
            if (socket != null && !socket.isClosed()) {
                try {
                    socket.send(datagramPacket);
                    return;
                }
                catch (IOException e) {
                    if (socket.isClosed()) break block4;
                    LOGGER.warn("Could not send record", (Throwable)e);
                    throw e;
                }
            }
        }
        if ((address = this.lastBindAddress) == null) {
            address = this.config.getAddress();
        }
        LOGGER.debug("Socket [{}] is closed, discarding packet ...", (Object)address);
        throw new IOException("Socket closed.");
    }

    private void handleTimeout(DTLSFlight flight, Connection connection) {
        Handshaker handshaker;
        if (!flight.isResponseCompleted() && null != (handshaker = connection.getOngoingHandshake())) {
            if (!handshaker.isProbing() && connection.hasEstablishedSession()) {
                return;
            }
            Exception cause = null;
            String message = "";
            if (!connection.isExecuting() || !this.running.get()) {
                message = " Stopped by shutdown!";
            } else if (this.connectionStore.get(flight.getPeerAddress()) != connection) {
                message = " Stopped by address change!";
            } else {
                int max = this.config.getMaxRetransmissions();
                int tries = flight.getTries();
                if (tries < max && handshaker.isExpired()) {
                    message = " Stopped by expired realtime!";
                } else if (tries < max) {
                    if (this.config.isEarlyStopRetransmission().booleanValue() && flight.isResponseStarted()) {
                        while (tries < max) {
                            ++tries;
                            flight.incrementTries();
                            flight.incrementTimeout();
                        }
                        flight.incrementTries();
                        LOGGER.debug("schedule handshake timeout {}ms after flight {}", (Object)flight.getTimeout(), (Object)flight.getFlightNumber());
                        ScheduledFuture<?> f = this.timer.schedule(new TimeoutPeerTask(connection, flight), (long)flight.getTimeout(), TimeUnit.MILLISECONDS);
                        flight.setTimeoutTask(f);
                        return;
                    }
                    LOGGER.debug("Re-transmitting flight for [{}], [{}] retransmissions left", (Object)flight.getPeerAddress(), (Object)(max - tries - 1));
                    try {
                        flight.incrementTries();
                        flight.incrementTimeout();
                        flight.setNewSequenceNumbers();
                        this.sendFlightOverNetwork(flight);
                        this.scheduleRetransmission(flight, connection);
                        handshaker.handshakeFlightRetransmitted(flight.getFlightNumber());
                        return;
                    }
                    catch (IOException e) {
                        cause = e;
                        message = " " + e.getMessage();
                        LOGGER.info("Cannot retransmit flight to peer [{}]", (Object)flight.getPeerAddress(), (Object)e);
                    }
                    catch (GeneralSecurityException e) {
                        LOGGER.info("Cannot retransmit flight to peer [{}]", (Object)flight.getPeerAddress(), (Object)e);
                        cause = e;
                        message = " " + e.getMessage();
                    }
                } else if (tries > max) {
                    LOGGER.debug("Flight for [{}] has reached timeout, discarding ...", (Object)flight.getPeerAddress());
                    message = " Stopped by timeout!";
                } else {
                    LOGGER.debug("Flight for [{}] has reached maximum no. [{}] of retransmissions, discarding ...", (Object)flight.getPeerAddress(), (Object)max);
                    message = " Stopped by timeout after " + max + " retransmissions!";
                }
            }
            handshaker.handshakeFailed(new Exception("Handshake flight " + flight.getFlightNumber() + " failed!" + message, cause));
        }
    }

    private void scheduleRetransmission(DTLSFlight flight, Connection connection) {
        if (flight.isRetransmissionNeeded()) {
            ScheduledFuture<?> f = this.timer.schedule(new TimeoutPeerTask(connection, flight), (long)flight.getTimeout(), TimeUnit.MILLISECONDS);
            flight.setTimeoutTask(f);
            LOGGER.trace("handshake flight to peer {}, retransmission {} ms.", (Object)connection.getPeerAddress(), (Object)flight.getTimeout());
        } else {
            LOGGER.trace("handshake flight to peer {}, no retransmission!", (Object)connection.getPeerAddress());
        }
    }

    private Long getAutResumptionTimeout(RawData message) {
        Long timeout = this.autoResumptionTimeoutMillis;
        String contextTimeout = message.getEndpointContext().get("*DTLS_RESUMPTION_TIMEOUT");
        if (contextTimeout != null) {
            if (contextTimeout.isEmpty()) {
                timeout = null;
            } else {
                try {
                    timeout = Long.valueOf(contextTimeout);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return timeout;
    }

    public final int getMaximumTransmissionUnit() {
        return this.maximumTransmissionUnit;
    }

    public final int getMaximumFragmentLength(InetSocketAddress peer) {
        Connection con = this.connectionStore.get(peer);
        if (con != null && con.hasEstablishedSession()) {
            return con.getEstablishedSession().getMaxFragmentLength();
        }
        return this.maximumTransmissionUnit - 89;
    }

    public final InetSocketAddress getAddress() {
        DatagramSocket socket = this.getSocket();
        if (socket == null) {
            return this.config.getAddress();
        }
        return new InetSocketAddress(socket.getLocalAddress(), socket.getLocalPort());
    }

    public final boolean isRunning() {
        return this.running.get();
    }

    public void setRawDataReceiver(RawDataChannel messageHandler) {
        if (this.isRunning()) {
            throw new IllegalStateException("message handler cannot be set on running connector");
        }
        this.messageHandler = messageHandler;
    }

    public void setEndpointContextMatcher(EndpointContextMatcher endpointContextMatcher) {
        this.endpointContextMatcher = endpointContextMatcher;
    }

    private EndpointContextMatcher getEndpointContextMatcher() {
        return this.endpointContextMatcher;
    }

    private String getEffectiveHandshakeMode(RawData message) {
        String mode = message.getEndpointContext().get("*DTLS_HANDSHAKE_MODE");
        if (mode == null) {
            mode = this.defaultHandshakeMode;
        }
        return mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAlertHandler(AlertHandler handler) {
        Object object = this.alertHandlerLock;
        synchronized (object) {
            this.alertHandler = handler;
        }
    }

    private void handleExceptionDuringHandshake(HandshakeException cause, AlertMessage.AlertLevel level, AlertMessage.AlertDescription description, Connection connection, Record record) {
        if (!AlertMessage.AlertLevel.FATAL.equals((Object)level)) {
            this.discardRecord(record, cause);
            return;
        }
        if (AlertMessage.AlertDescription.UNKNOWN_PSK_IDENTITY == description) {
            this.discardRecord(record, cause);
            return;
        }
        this.terminateOngoingHandshake(connection, cause, description);
    }

    private void discardRecord(Record record, Throwable cause) {
        if (this.health != null) {
            this.health.receivingRecord(true);
        }
        byte[] bytes = record.getFragmentBytes();
        if (LOGGER.isTraceEnabled()) {
            String hexString = StringUtil.byteArray2HexString((byte[])bytes, (char)'\u0000', (int)64);
            LOGGER.trace("Discarding {} record (epoch {}, payload: {}) from peer [{}]: ", new Object[]{record.getType(), record.getEpoch(), hexString, record.getPeerAddress(), cause});
        } else if (LOGGER.isDebugEnabled()) {
            String hexString = StringUtil.byteArray2HexString((byte[])bytes, (char)'\u0000', (int)16);
            LOGGER.debug("Discarding {} record (epoch {}, payload: {}) from peer [{}]: {}", new Object[]{record.getType(), record.getEpoch(), hexString, record.getPeerAddress(), cause.getMessage()});
        }
    }

    public String getProtocol() {
        return "DTLS";
    }

    public String toString() {
        return this.getProtocol() + "-" + StringUtil.toString((InetSocketAddress)this.getAddress());
    }

    private static class ForEachFuture
    implements Future<Void> {
        private final Lock lock = new ReentrantLock();
        private final Condition waitDone = this.lock.newCondition();
        private volatile boolean cancel;
        private volatile boolean done;
        private volatile Exception exception;

        private ForEachFuture() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = false;
            this.lock.lock();
            try {
                if (!this.done && !this.cancel) {
                    cancelled = true;
                    this.cancel = true;
                }
            }
            finally {
                this.lock.unlock();
            }
            return cancelled;
        }

        @Override
        public boolean isCancelled() {
            return this.cancel;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void get() throws InterruptedException, ExecutionException {
            this.lock.lock();
            try {
                if (!this.done) {
                    this.waitDone.await();
                }
                if (this.exception != null) {
                    throw new ExecutionException(this.exception);
                }
            }
            finally {
                this.lock.unlock();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.lock.lock();
            try {
                if (!this.done) {
                    this.waitDone.await(timeout, unit);
                }
                if (this.exception != null) {
                    throw new ExecutionException(this.exception);
                }
            }
            finally {
                this.lock.unlock();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            this.lock.lock();
            try {
                this.done = true;
                this.waitDone.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(Exception exception) {
            this.lock.lock();
            try {
                this.exception = exception;
                this.done = true;
                this.waitDone.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean isStopped() {
            return this.done || this.cancel;
        }
    }

    private abstract class Worker
    extends Thread {
        protected Worker(String name) {
            super(NamedThreadFactory.SCANDIUM_THREAD_GROUP, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LOGGER.info("Starting worker thread [{}]", (Object)this.getName());
                while (DTLSConnector.this.running.get()) {
                    try {
                        this.doWork();
                    }
                    catch (InterruptedIOException e) {
                        if (!DTLSConnector.this.running.get()) continue;
                        LOGGER.info("Worker thread [{}] has been interrupted", (Object)this.getName());
                    }
                    catch (InterruptedException e) {
                        if (!DTLSConnector.this.running.get()) continue;
                        LOGGER.info("Worker thread [{}] has been interrupted", (Object)this.getName());
                    }
                    catch (Exception e) {
                        if (!DTLSConnector.this.running.get()) continue;
                        LOGGER.debug("Exception thrown by worker thread [{}]", (Object)this.getName(), (Object)e);
                    }
                }
            }
            finally {
                LOGGER.info("Worker thread [{}] has terminated", (Object)this.getName());
            }
        }

        protected abstract void doWork() throws Exception;
    }

    private class TimeoutPeerTask
    extends ConnectionTask {
        private TimeoutPeerTask(final Connection connection, final DTLSFlight flight) {
            super(connection, new Runnable(){

                @Override
                public void run() {
                    DTLSConnector.this.handleTimeout(flight, connection);
                }
            }, true);
        }
    }

    private class ConnectionTask
    implements Runnable {
        private final Connection connection;
        private final Runnable task;
        private final boolean force;

        private ConnectionTask(Connection connection, Runnable task, boolean force) {
            this.connection = connection;
            this.task = task;
            this.force = force;
        }

        @Override
        public void run() {
            block2: {
                SerialExecutor serialExecutor = this.connection.getExecutor();
                try {
                    serialExecutor.execute(this.task);
                }
                catch (RejectedExecutionException e) {
                    LOGGER.debug("Execution rejected while execute task of peer: {}", (Object)this.connection.getPeerAddress(), (Object)e);
                    if (!this.force) break block2;
                    this.task.run();
                }
            }
        }
    }
}

