/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.pskstore;

import java.net.InetSocketAddress;
import javax.crypto.SecretKey;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.util.ServerNames;

public abstract class StringPskStore
implements PskStore {
    @Override
    public SecretKey getKey(PskPublicInformation identity) {
        if (identity.isCompliantEncoding()) {
            return this.getKey(identity.getPublicInfoAsString());
        }
        return null;
    }

    @Override
    public SecretKey getKey(ServerNames serverNames, PskPublicInformation identity) {
        if (identity.isCompliantEncoding()) {
            return this.getKey(serverNames, identity.getPublicInfoAsString());
        }
        return null;
    }

    @Override
    public PskPublicInformation getIdentity(InetSocketAddress inetAddress) {
        return new PskPublicInformation(this.getIdentityAsString(inetAddress));
    }

    @Override
    public PskPublicInformation getIdentity(InetSocketAddress peerAddress, ServerNames virtualHost) {
        return new PskPublicInformation(this.getIdentityAsString(peerAddress, virtualHost));
    }

    public abstract SecretKey getKey(String var1);

    public abstract SecretKey getKey(ServerNames var1, String var2);

    public abstract String getIdentityAsString(InetSocketAddress var1);

    public abstract String getIdentityAsString(InetSocketAddress var1, ServerNames var2);
}

