/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AbstractMessage;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSMessage;

public final class ApplicationMessage
extends AbstractMessage {
    private final byte[] data;

    public ApplicationMessage(byte[] data, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.data = data;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_DATA;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\tApplication Data: ").append(StringUtil.byteArray2Hex((byte[])this.data)).append(StringUtil.lineSeparator());
        return sb.toString();
    }

    @Override
    public byte[] toByteArray() {
        return this.data;
    }

    public static DTLSMessage fromByteArray(byte[] byteArray, InetSocketAddress peerAddress) {
        return new ApplicationMessage(byteArray, peerAddress);
    }

    public byte[] getData() {
        return this.data;
    }
}

