/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.pskstore;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.californium.scandium.dtls.ServerNameResolver;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.util.ServerName;
import org.eclipse.californium.scandium.util.ServerNames;

public class InMemoryPskStore
implements PskStore,
ServerNameResolver {
    private final Map<ServerName, Map<String, byte[]>> scopedKeys = new ConcurrentHashMap<ServerName, Map<String, byte[]>>();
    private final Map<String, byte[]> keys = new ConcurrentHashMap<String, byte[]>();
    private final Map<InetSocketAddress, String> identitiesByAddress = new ConcurrentHashMap<InetSocketAddress, String>();
    private final Map<InetSocketAddress, ServerNames> serverNamesByAddress = new ConcurrentHashMap<InetSocketAddress, ServerNames>();

    @Override
    public byte[] getKey(String identity) {
        if (identity == null) {
            throw new NullPointerException("identity must not be null");
        }
        return InMemoryPskStore.getKeyFromMap(identity, this.keys);
    }

    private static byte[] getKeyFromMap(String identity, Map<String, byte[]> keyMap) {
        byte[] key;
        byte[] result = null;
        if (keyMap != null && (key = keyMap.get(identity)) != null) {
            result = Arrays.copyOf(key, key.length);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getKey(ServerNames serverNames, String identity) {
        if (serverNames == null) {
            throw new NullPointerException("server names must not be null");
        }
        if (identity == null) {
            throw new NullPointerException("identity must not be null");
        }
        Map<ServerName, Map<String, byte[]>> map = this.scopedKeys;
        synchronized (map) {
            for (ServerName serverName : serverNames) {
                byte[] key = InMemoryPskStore.getKeyFromMap(identity, this.scopedKeys.get(serverName));
                if (key == null) continue;
                return key;
            }
            return null;
        }
    }

    public void setKey(String identity, byte[] key) {
        this.keys.put(identity, Arrays.copyOf(key, key.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKey(String identity, byte[] key, ServerName serverName) {
        if (identity == null) {
            throw new NullPointerException("identity must not be null");
        }
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName must not be null");
        }
        Map<ServerName, Map<String, byte[]>> map = this.scopedKeys;
        synchronized (map) {
            Map<String, byte[]> keysForServerName = this.scopedKeys.get(serverName);
            if (keysForServerName == null) {
                keysForServerName = new ConcurrentHashMap<String, byte[]>();
                this.scopedKeys.put(serverName, keysForServerName);
            }
            keysForServerName.put(identity, Arrays.copyOf(key, key.length));
        }
    }

    public void addKnownPeer(InetSocketAddress peerAddress, String identity, byte[] key) {
        this.identitiesByAddress.put(peerAddress, identity);
        this.setKey(identity, key);
    }

    public void addServerNames(InetSocketAddress peerAddress, ServerNames serverNames) {
        if (peerAddress != null && serverNames != null) {
            this.serverNamesByAddress.put(peerAddress, serverNames);
        }
    }

    @Override
    public String getIdentity(InetSocketAddress inetAddress) {
        if (inetAddress == null) {
            throw new NullPointerException("address must not be null");
        }
        return this.identitiesByAddress.get(inetAddress);
    }

    @Override
    public ServerNames getServerNames(InetSocketAddress peerAddress) {
        if (peerAddress == null) {
            return null;
        }
        return this.serverNamesByAddress.get(peerAddress);
    }
}

