/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.util.Arrays;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.util.ByteArrayUtils;

public final class HelloVerifyRequest
extends HandshakeMessage {
    private static final int VERSION_BITS = 8;
    private static final int COOKIE_LENGTH_BITS = 8;
    private final ProtocolVersion serverVersion;
    private final byte[] cookie;

    public HelloVerifyRequest(ProtocolVersion version, byte[] cookie, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.serverVersion = version;
        this.cookie = Arrays.copyOf(cookie, cookie.length);
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.serverVersion.getMajor(), 8);
        writer.write(this.serverVersion.getMinor(), 8);
        writer.write(this.cookie.length, 8);
        writer.writeBytes(this.cookie);
        return writer.toByteArray();
    }

    public static HandshakeMessage fromByteArray(byte[] byteArray, InetSocketAddress peerAddress) {
        DatagramReader reader = new DatagramReader(byteArray);
        int major = reader.read(8);
        int minor = reader.read(8);
        ProtocolVersion version = new ProtocolVersion(major, minor);
        int cookieLength = reader.read(8);
        byte[] cookie = reader.readBytes(cookieLength);
        return new HelloVerifyRequest(version, cookie, peerAddress);
    }

    @Override
    public HandshakeType getMessageType() {
        return HandshakeType.HELLO_VERIFY_REQUEST;
    }

    @Override
    public int getMessageLength() {
        return 3 + this.cookie.length;
    }

    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\t\tServer Version: ").append(this.serverVersion.getMajor()).append(", ").append(this.serverVersion.getMinor()).append(System.lineSeparator());
        sb.append("\t\tCookie Length: ").append(this.cookie.length).append(System.lineSeparator());
        sb.append("\t\tCookie: ").append(ByteArrayUtils.toHexString(this.cookie)).append(System.lineSeparator());
        return sb.toString();
    }
}

