/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import eu.javaspecialists.tjsn.concurrency.stripedexecutor.StripedExecutorService;
import eu.javaspecialists.tjsn.concurrency.stripedexecutor.StripedRunnable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.nio.channels.ClosedByInterruptException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.EndpointMismatchException;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.RawDataChannel;
import org.eclipse.californium.elements.util.DaemonThreadFactory;
import org.eclipse.californium.elements.util.NamedThreadFactory;
import org.eclipse.californium.scandium.AlertHandler;
import org.eclipse.californium.scandium.CookieGenerator;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ApplicationMessage;
import org.eclipse.californium.scandium.dtls.ClientHandshaker;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.DtlsHandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.HelloRequest;
import org.eclipse.californium.scandium.dtls.HelloVerifyRequest;
import org.eclipse.californium.scandium.dtls.InMemoryConnectionStore;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.Record;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.ResumingClientHandshaker;
import org.eclipse.californium.scandium.dtls.ResumingServerHandshaker;
import org.eclipse.californium.scandium.dtls.ResumptionSupportingConnectionStore;
import org.eclipse.californium.scandium.dtls.ServerHandshaker;
import org.eclipse.californium.scandium.dtls.SessionAdapter;
import org.eclipse.californium.scandium.dtls.SessionCache;
import org.eclipse.californium.scandium.dtls.SessionListener;
import org.eclipse.californium.scandium.dtls.SessionTicket;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.util.ByteArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTLSConnector
implements Connector {
    public static final String KEY_TLS_SERVER_HOST_NAME = "TLS_SERVER_HOST_NAME";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DTLSConnector.class.getCanonicalName());
    private static final int MAX_PLAINTEXT_FRAGMENT_LENGTH = 16384;
    private static final int MAX_CIPHERTEXT_EXPANSION = CipherSuite.TLS_PSK_WITH_AES_128_CBC_SHA256.getMaxCiphertextExpansion();
    private static final int MAX_DATAGRAM_BUFFER_SIZE = 16409 + MAX_CIPHERTEXT_EXPANSION;
    private static final int DEFAULT_EXECUTOR_THREAD_POOL_SIZE = 6 * Runtime.getRuntime().availableProcessors();
    private final DtlsConnectorConfig config;
    private final ResumptionSupportingConnectionStore connectionStore;
    private final AtomicInteger pendingOutboundMessages = new AtomicInteger();
    private InetSocketAddress lastBindAddress;
    private int maximumTransmissionUnit = 1280;
    private int inboundDatagramBufferSize = MAX_DATAGRAM_BUFFER_SIZE;
    private CookieGenerator cookieGenerator = new CookieGenerator();
    private Object allertHandlerLock = new Object();
    private DatagramSocket socket;
    private ScheduledExecutorService timer;
    private Worker receiver;
    private AtomicBoolean running = new AtomicBoolean(false);
    private EndpointContextMatcher endpointContextMatcher;
    private RawDataChannel messageHandler;
    private AlertHandler alertHandler;
    private SessionListener sessionCacheSynchronization;
    private ExecutorService executor;
    private boolean hasInternalExecutor;

    public DTLSConnector(DtlsConnectorConfig configuration) {
        this(configuration, (SessionCache)null);
    }

    public DTLSConnector(DtlsConnectorConfig configuration, SessionCache sessionCache) {
        this(configuration, new InMemoryConnectionStore(configuration.getMaxConnections(), configuration.getStaleConnectionThreshold(), sessionCache));
    }

    DTLSConnector(DtlsConnectorConfig configuration, ResumptionSupportingConnectionStore connectionStore) {
        if (configuration == null) {
            throw new NullPointerException("Configuration must not be null");
        }
        if (connectionStore == null) {
            throw new NullPointerException("Connection store must not be null");
        }
        this.config = configuration;
        this.pendingOutboundMessages.set(this.config.getOutboundMessageBufferSize());
        this.connectionStore = connectionStore;
        this.sessionCacheSynchronization = (SessionListener)((Object)this.connectionStore);
    }

    public final synchronized void setExecutor(StripedExecutorService executor) {
        if (this.running.get()) {
            throw new IllegalStateException("cannot set executor while connector is running");
        }
        this.executor = executor;
    }

    public final void close(InetSocketAddress peerAddress) {
        Connection connection = this.connectionStore.get(peerAddress);
        if (connection != null && connection.getEstablishedSession() != null) {
            this.terminateConnection(connection, new AlertMessage(AlertMessage.AlertLevel.WARNING, AlertMessage.AlertDescription.CLOSE_NOTIFY, peerAddress), connection.getEstablishedSession());
        }
    }

    public final synchronized void start() throws IOException {
        this.start(this.config.getAddress());
    }

    final synchronized void restart() throws IOException {
        if (this.lastBindAddress == null) {
            throw new IllegalStateException("Connector has never been started before");
        }
        this.start(this.lastBindAddress);
    }

    private void start(InetSocketAddress bindAddress) throws IOException {
        NetworkInterface ni;
        if (this.running.get()) {
            return;
        }
        this.pendingOutboundMessages.set(this.config.getOutboundMessageBufferSize());
        this.timer = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory("DTLS-Retransmit-Task-", NamedThreadFactory.SCANDIUM_THREAD_GROUP));
        if (this.executor == null) {
            int threadCount = this.config.getConnectionThreadCount() == null ? DEFAULT_EXECUTOR_THREAD_POOL_SIZE : this.config.getConnectionThreadCount();
            this.executor = threadCount == 1 ? Executors.newSingleThreadExecutor((ThreadFactory)new DaemonThreadFactory("DTLS-Connection-Handler-", NamedThreadFactory.SCANDIUM_THREAD_GROUP)) : new StripedExecutorService(Executors.newFixedThreadPool(threadCount, (ThreadFactory)new DaemonThreadFactory("DTLS-Connection-Handler-", NamedThreadFactory.SCANDIUM_THREAD_GROUP)));
            this.hasInternalExecutor = true;
        }
        this.socket = new DatagramSocket(null);
        if (bindAddress.getPort() != 0 && this.config.isAddressReuseEnabled().booleanValue()) {
            LOGGER.info("Enable address reuse for socket!");
            this.socket.setReuseAddress(true);
            if (!this.socket.getReuseAddress()) {
                LOGGER.warn("Enable address reuse for socket failed!");
            }
        }
        this.socket.bind(bindAddress);
        if (!(this.lastBindAddress == null || this.socket.getLocalAddress().equals(this.lastBindAddress.getAddress()) && this.socket.getLocalPort() == this.lastBindAddress.getPort())) {
            if (this.connectionStore instanceof ResumptionSupportingConnectionStore) {
                this.connectionStore.markAllAsResumptionRequired();
            } else {
                this.connectionStore.clear();
            }
        }
        if ((ni = NetworkInterface.getByInetAddress(bindAddress.getAddress())) != null && ni.getMTU() > 0) {
            this.maximumTransmissionUnit = ni.getMTU();
        } else {
            LOGGER.info("Cannot determine MTU of network interface, using minimum MTU [1280] of IPv6 instead");
            this.maximumTransmissionUnit = 1280;
        }
        if (this.config.getMaxFragmentLengthCode() != null) {
            MaxFragmentLengthExtension.Length lengthCode = MaxFragmentLengthExtension.Length.fromCode(this.config.getMaxFragmentLengthCode());
            this.inboundDatagramBufferSize = lengthCode.length() + MAX_CIPHERTEXT_EXPANSION + 25;
        }
        this.lastBindAddress = new InetSocketAddress(this.socket.getLocalAddress(), this.socket.getLocalPort());
        this.running.set(true);
        this.receiver = new Worker("DTLS-Receiver-" + this.lastBindAddress){
            private final byte[] receiverBuffer;
            private final DatagramPacket packet;
            {
                this.receiverBuffer = new byte[DTLSConnector.this.inboundDatagramBufferSize];
                this.packet = new DatagramPacket(this.receiverBuffer, DTLSConnector.this.inboundDatagramBufferSize);
            }

            @Override
            public void doWork() throws Exception {
                this.packet.setData(this.receiverBuffer);
                DTLSConnector.this.receiveNextDatagramFromNetwork(this.packet);
            }
        };
        this.receiver.setDaemon(true);
        this.receiver.start();
        LOGGER.info("DTLS connector listening on [{}] with MTU [{}] using (inbound) datagram buffer size [{} bytes]", new Object[]{this.lastBindAddress, this.maximumTransmissionUnit, this.inboundDatagramBufferSize});
    }

    public final synchronized void forceResumeSessionFor(InetSocketAddress peer) {
        Connection peerConnection = this.connectionStore.get(peer);
        if (peerConnection != null && peerConnection.getEstablishedSession() != null) {
            peerConnection.setResumptionRequired(true);
        }
    }

    public final synchronized void forceResumeAllSessions() {
        this.connectionStore.markAllAsResumptionRequired();
    }

    public final synchronized void clearConnectionState() {
        this.connectionStore.clear();
    }

    final synchronized void releaseSocket() {
        this.running.set(false);
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        this.maximumTransmissionUnit = 0;
    }

    private final synchronized DatagramSocket getSocket() {
        return this.socket;
    }

    public final synchronized void stop() {
        if (this.running.get()) {
            LOGGER.info("Stopping DTLS connector on [{}]", (Object)this.lastBindAddress);
            this.timer.shutdownNow();
            if (this.hasInternalExecutor) {
                this.executor.shutdownNow();
                this.executor = null;
                this.hasInternalExecutor = false;
            }
            this.releaseSocket();
        }
    }

    public final synchronized void destroy() {
        this.stop();
        this.connectionStore.clear();
    }

    private void receiveNextDatagramFromNetwork(DatagramPacket packet) throws IOException {
        DatagramSocket currentSocket = this.getSocket();
        if (currentSocket == null) {
            return;
        }
        currentSocket.receive(packet);
        if (packet.getLength() == 0) {
            return;
        }
        InetSocketAddress peerAddress = new InetSocketAddress(packet.getAddress(), packet.getPort());
        byte[] data = Arrays.copyOfRange(packet.getData(), packet.getOffset(), packet.getLength());
        List<Record> records = Record.fromByteArray(data, peerAddress);
        LOGGER.debug("Received {} DTLS records using a {} byte datagram buffer", new Object[]{records.size(), this.inboundDatagramBufferSize});
        for (final Record record : records) {
            try {
                switch (record.getType()) {
                    case HANDSHAKE: 
                    case APPLICATION_DATA: 
                    case ALERT: 
                    case CHANGE_CIPHER_SPEC: {
                        this.executor.execute((Runnable)new StripedRunnable(){

                            public Object getStripe() {
                                return record.getPeerAddress();
                            }

                            public void run() {
                                DTLSConnector.this.processRecord(record);
                            }
                        });
                        break;
                    }
                    default: {
                        LOGGER.debug("Discarding unsupported record [type: {}, peer: {}]", new Object[]{record.getType(), record.getPeerAddress()});
                        break;
                    }
                }
            }
            catch (RuntimeException e) {
                LOGGER.info("Unexpected error occurred while processing record [type: {}, peer: {}]", new Object[]{record.getType(), peerAddress, e});
                this.terminateConnection(peerAddress, e, AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR);
                break;
            }
        }
    }

    private void processRecord(Record record) {
        try {
            LOGGER.trace("Received DTLS record of type [{}]", (Object)record.getType());
            switch (record.getType()) {
                case APPLICATION_DATA: {
                    this.processApplicationDataRecord(record);
                    break;
                }
                case ALERT: {
                    this.processAlertRecord(record);
                    break;
                }
                case CHANGE_CIPHER_SPEC: {
                    this.processChangeCipherSpecRecord(record);
                    break;
                }
                case HANDSHAKE: {
                    this.processHandshakeRecord(record);
                    break;
                }
                default: {
                    LOGGER.debug("Discarding record of unsupported type [{}] from peer [{}]", new Object[]{record.getType(), record.getPeerAddress()});
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.info("Unexpected error occurred while processing record from peer [{}]", (Object)record.getPeerAddress(), (Object)e);
            this.terminateConnection(record.getPeerAddress(), e, AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR);
        }
    }

    private void terminateOngoingHandshake(InetSocketAddress peerAddress, Throwable cause, AlertMessage.AlertDescription description) {
        Connection connection = this.connectionStore.get(peerAddress);
        if (connection != null && connection.hasOngoingHandshake()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Aborting handshake with peer [{}]:", (Object)peerAddress, (Object)cause);
            } else if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Aborting handshake with peer [{}]: {}", (Object)peerAddress, (Object)cause.getMessage());
            }
            Handshaker handshaker = connection.getOngoingHandshake();
            DTLSSession session = handshaker.getSession();
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, description, peerAddress);
            if (!connection.hasEstablishedSession()) {
                this.terminateConnection(connection, alert, session);
            } else {
                this.send(alert, session);
                connection.terminateOngoingHandshake();
            }
            handshaker.handshakeFailed(cause);
        }
    }

    private void terminateConnection(InetSocketAddress peerAddress) {
        if (peerAddress != null) {
            this.terminateConnection(this.connectionStore.get(peerAddress));
        }
    }

    private void terminateConnection(Connection connection) {
        if (connection != null) {
            connection.cancelPendingFlight();
            this.connectionClosed(connection.getPeerAddress());
        }
    }

    private void terminateConnection(InetSocketAddress peerAddress, Throwable cause, AlertMessage.AlertLevel level, AlertMessage.AlertDescription description) {
        Connection connection = this.connectionStore.get(peerAddress);
        if (connection != null) {
            if (connection.hasEstablishedSession()) {
                this.terminateConnection(connection, new AlertMessage(level, description, peerAddress), connection.getEstablishedSession());
            } else if (connection.hasOngoingHandshake()) {
                this.terminateConnection(connection, new AlertMessage(level, description, peerAddress), connection.getOngoingHandshake().getSession());
            }
        }
    }

    private void terminateConnection(Connection connection, AlertMessage alert, DTLSSession session) {
        if (alert != null && session == null) {
            throw new IllegalArgumentException("Session must not be NULL if alert message is to be sent");
        }
        connection.cancelPendingFlight();
        if (alert == null) {
            LOGGER.debug("Terminating connection with peer [{}]", (Object)connection.getPeerAddress());
        } else {
            LOGGER.debug("Terminating connection with peer [{}], reason [{}]", new Object[]{connection.getPeerAddress(), alert.getDescription()});
            this.send(alert, session);
        }
        this.connectionClosed(connection.getPeerAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processApplicationDataRecord(Record record) {
        DTLSSession session = null;
        Connection connection = this.connectionStore.get(record.getPeerAddress());
        if (connection != null && (session = connection.getEstablishedSession()) != null) {
            RawData receivedApplicationMessage = null;
            DTLSSession dTLSSession = session;
            synchronized (dTLSSession) {
                if (session.isRecordProcessable(record.getEpoch(), record.getSequenceNumber())) {
                    try {
                        record.setSession(session);
                        ApplicationMessage message = (ApplicationMessage)record.getFragment();
                        connection.handshakeCompleted(record.getPeerAddress());
                        session.markRecordAsRead(record.getEpoch(), record.getSequenceNumber());
                        receivedApplicationMessage = RawData.inbound((byte[])message.getData(), (EndpointContext)session.getConnectionReadContext(), (boolean)false);
                        connection.refreshAutoResumptionTime();
                    }
                    catch (GeneralSecurityException | HandshakeException e) {
                        DTLSConnector.discardRecord(record, e);
                    }
                } else {
                    LOGGER.debug("Discarding duplicate APPLICATION_DATA record received from peer [{}]", (Object)record.getPeerAddress());
                }
            }
            RawDataChannel channel = this.messageHandler;
            if (channel != null && receivedApplicationMessage != null) {
                channel.receiveData(receivedApplicationMessage);
            }
        } else {
            LOGGER.debug("Discarding APPLICATION_DATA record received from peer [{}] without an active session", (Object)record.getPeerAddress());
        }
    }

    private void processAlertRecord(Record record) {
        Connection connection = this.connectionStore.get(record.getPeerAddress());
        if (connection == null) {
            LOGGER.debug("Discarding ALERT record from [{}] received without existing connection", (Object)record.getPeerAddress());
        } else {
            this.processAlertRecord(record, connection);
        }
    }

    private void processAlertRecord(Record record, Connection connection) {
        if (connection.hasEstablishedSession() && connection.getEstablishedSession().getReadEpoch() == record.getEpoch()) {
            this.processAlertRecord(record, connection, connection.getEstablishedSession());
        } else if (connection.hasOngoingHandshake() && connection.getOngoingHandshake().getSession().getReadEpoch() == record.getEpoch()) {
            this.processAlertRecord(record, connection, connection.getOngoingHandshake().getSession());
        } else {
            LOGGER.debug("Epoch of ALERT record [epoch={}] from [{}] does not match expected epoch(s), discarding ...", new Object[]{record.getEpoch(), record.getPeerAddress()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAlertRecord(Record record, Connection connection, DTLSSession session) {
        record.setSession(session);
        try {
            AlertMessage alert = (AlertMessage)record.getFragment();
            Handshaker handshaker = connection.getOngoingHandshake();
            HandshakeException error = null;
            LOGGER.trace("Processing {} ALERT from [{}]: {}", new Object[]{alert.getLevel(), alert.getPeer(), alert.getDescription()});
            if (AlertMessage.AlertDescription.CLOSE_NOTIFY.equals((Object)alert.getDescription())) {
                error = new HandshakeException("Received 'close notify'", alert);
                this.terminateConnection(connection, new AlertMessage(AlertMessage.AlertLevel.WARNING, AlertMessage.AlertDescription.CLOSE_NOTIFY, alert.getPeer()), session);
            } else if (AlertMessage.AlertLevel.FATAL.equals((Object)alert.getLevel())) {
                error = new HandshakeException("Received 'fatal alert'", alert);
                this.terminateConnection(connection);
            }
            Object object = this.allertHandlerLock;
            synchronized (object) {
                if (this.alertHandler != null) {
                    this.alertHandler.onAlert(alert.getPeer(), alert);
                }
            }
            if (null != error && null != handshaker) {
                handshaker.handshakeFailed(error);
            }
        }
        catch (GeneralSecurityException | HandshakeException e) {
            DTLSConnector.discardRecord(record, e);
        }
    }

    private void processChangeCipherSpecRecord(Record record) {
        Connection connection = this.connectionStore.get(record.getPeerAddress());
        if (connection != null && connection.hasOngoingHandshake()) {
            try {
                connection.getOngoingHandshake().processMessage(record);
            }
            catch (HandshakeException e) {
                this.handleExceptionDuringHandshake(e, e.getAlert().getLevel(), e.getAlert().getDescription(), record);
            }
        } else {
            LOGGER.debug("Received CHANGE_CIPHER_SPEC record from peer [{}] with no handshake going on", (Object)record.getPeerAddress());
        }
    }

    private void processHandshakeRecord(Record record) {
        LOGGER.debug("Received {} record from peer [{}]", new Object[]{record.getType(), record.getPeerAddress()});
        Connection con = this.connectionStore.get(record.getPeerAddress());
        try {
            if (con == null) {
                this.processHandshakeRecordWithoutConnection(record);
            } else {
                this.processHandshakeRecordWithConnection(record, con);
            }
        }
        catch (HandshakeException e) {
            this.handleExceptionDuringHandshake(e, e.getAlert().getLevel(), e.getAlert().getDescription(), record);
        }
    }

    private void processHandshakeRecordWithoutConnection(Record record) throws HandshakeException {
        if (record.getEpoch() > 0) {
            LOGGER.debug("Discarding unexpected handshake message [epoch={}] received from peer [{}] without existing connection", new Object[]{record.getEpoch(), record.getPeerAddress()});
        } else {
            try {
                HandshakeMessage handshakeMessage = (HandshakeMessage)record.getFragment();
                if (HandshakeType.CLIENT_HELLO.equals((Object)handshakeMessage.getMessageType())) {
                    this.processClientHello((ClientHello)handshakeMessage, record);
                } else {
                    LOGGER.debug("Discarding unexpected {} message from peer [{}]", new Object[]{handshakeMessage.getMessageType(), handshakeMessage.getPeer()});
                }
            }
            catch (GeneralSecurityException e) {
                DTLSConnector.discardRecord(record, e);
            }
        }
    }

    private void processHandshakeRecordWithConnection(Record record, Connection connection) throws HandshakeException {
        if (connection.hasOngoingHandshake()) {
            DTLSSession handshakeSession = connection.getOngoingHandshake().getSession();
            if (handshakeSession.getReadEpoch() == record.getEpoch()) {
                record.setSession(handshakeSession);
            } else if (!record.isNewClientHello()) {
                connection.getOngoingHandshake().processMessage(record);
                return;
            }
        } else if (connection.hasEstablishedSession() && connection.getEstablishedSession().getReadEpoch() == record.getEpoch()) {
            record.setSession(connection.getEstablishedSession());
        } else if (!record.isNewClientHello()) {
            LOGGER.debug("Discarding HANDSHAKE message [epoch={}] from peer [{}] which does not match expected epoch(s)", new Object[]{record.getEpoch(), record.getPeerAddress()});
            return;
        }
        try {
            HandshakeMessage handshakeMessage = (HandshakeMessage)record.getFragment();
            this.processDecryptedHandshakeMessage(handshakeMessage, record, connection);
        }
        catch (GeneralSecurityException e) {
            DTLSConnector.discardRecord(record, e);
        }
    }

    private void processDecryptedHandshakeMessage(HandshakeMessage handshakeMessage, Record record, Connection connection) throws HandshakeException {
        switch (handshakeMessage.getMessageType()) {
            case CLIENT_HELLO: {
                this.processClientHello((ClientHello)handshakeMessage, record, connection);
                break;
            }
            case HELLO_REQUEST: {
                this.processHelloRequest((HelloRequest)handshakeMessage, connection);
                break;
            }
            default: {
                DTLSConnector.processOngoingHandshakeMessage(handshakeMessage, record, connection);
            }
        }
    }

    private static void processOngoingHandshakeMessage(HandshakeMessage message, Record record, Connection connection) throws HandshakeException {
        if (connection.hasOngoingHandshake()) {
            connection.getOngoingHandshake().processMessage(record);
        } else {
            LOGGER.debug("Discarding {} message received from peer [{}] with no handshake going on", new Object[]{message.getMessageType(), message.getPeer()});
        }
    }

    private void processHelloRequest(HelloRequest helloRequest, Connection connection) throws HandshakeException {
        if (connection.hasOngoingHandshake()) {
            LOGGER.debug("Ignoring {} received from [{}] while already in an ongoing handshake with peer", new Object[]{helloRequest.getMessageType(), helloRequest.getPeer()});
        } else {
            DTLSSession session = connection.getEstablishedSession();
            if (session == null) {
                session = new DTLSSession(helloRequest.getPeer(), true);
            }
            ClientHandshaker handshaker = new ClientHandshaker(session, this.getRecordLayerForPeer(connection), connection, this.config, this.maximumTransmissionUnit);
            this.addSessionCacheSynchronization(handshaker);
            ((Handshaker)handshaker).startHandshake();
        }
    }

    private void processClientHello(ClientHello clientHello, Record record) throws HandshakeException {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder("Processing CLIENT_HELLO from peer [").append(record.getPeerAddress()).append("]");
            if (LOGGER.isTraceEnabled()) {
                msg.append(":").append(System.lineSeparator()).append(record);
            }
            LOGGER.debug(msg.toString());
        }
        if (this.isClientInControlOfSourceIpAddress(clientHello, record)) {
            if (clientHello.hasSessionId()) {
                this.resumeExistingSession(clientHello, record);
            } else {
                this.startNewHandshake(clientHello, record);
            }
        }
    }

    private void processClientHello(ClientHello clientHello, Record record, Connection connection) throws HandshakeException {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder("Processing CLIENT_HELLO from peer [").append(record.getPeerAddress()).append("]");
            if (LOGGER.isTraceEnabled()) {
                msg.append(":").append(System.lineSeparator()).append(record);
            }
            LOGGER.debug(msg.toString());
        }
        if (this.isClientInControlOfSourceIpAddress(clientHello, record)) {
            if (DTLSConnector.isHandshakeAlreadyStartedForMessage(clientHello, connection)) {
                DTLSConnector.processOngoingHandshakeMessage(clientHello, record, connection);
            } else if (clientHello.hasSessionId()) {
                this.resumeExistingSession(clientHello, record);
            } else {
                this.terminateConnection(connection);
                this.startNewHandshake(clientHello, record);
            }
        }
    }

    private static boolean isHandshakeAlreadyStartedForMessage(ClientHello clientHello, Connection connection) {
        return connection != null && connection.hasOngoingHandshake() && connection.getOngoingHandshake().hasBeenStartedByMessage(clientHello);
    }

    private boolean isClientInControlOfSourceIpAddress(ClientHello clientHello, Record record) {
        try {
            byte[] expectedCookie = this.cookieGenerator.generateCookie(clientHello);
            if (Arrays.equals(expectedCookie, clientHello.getCookie())) {
                return true;
            }
            this.sendHelloVerify(clientHello, record, expectedCookie);
            return false;
        }
        catch (GeneralSecurityException e) {
            throw new DtlsHandshakeException("Cannot compute cookie for peer", AlertMessage.AlertDescription.INTERNAL_ERROR, AlertMessage.AlertLevel.FATAL, clientHello.getPeer(), e);
        }
    }

    private void startNewHandshake(ClientHello clientHello, Record record) throws HandshakeException {
        Connection peerConnection = new Connection(record.getPeerAddress(), this.config.getAutoResumptionTimeoutMillis());
        if (!this.connectionStore.put(peerConnection)) {
            this.terminateOngoingHandshake(record.getPeerAddress(), new IllegalStateException("connection store exhausted!"), AlertMessage.AlertDescription.INTERNAL_ERROR);
            return;
        }
        DTLSSession newSession = new DTLSSession(record.getPeerAddress(), false, record.getSequenceNumber());
        ServerHandshaker handshaker = new ServerHandshaker(clientHello.getMessageSeq(), newSession, this.getRecordLayerForPeer(peerConnection), peerConnection, this.config, this.maximumTransmissionUnit);
        this.addSessionCacheSynchronization(handshaker);
        handshaker.processMessage(record);
    }

    private void resumeExistingSession(ClientHello clientHello, Record record) throws HandshakeException {
        LOGGER.debug("Client [{}] wants to resume session with ID [{}]", new Object[]{clientHello.getPeer(), clientHello.getSessionId()});
        final Connection previousConnection = this.connectionStore.find(clientHello.getSessionId());
        if (previousConnection != null && previousConnection.isActive()) {
            Connection peerConnection = new Connection(record.getPeerAddress(), this.config.getAutoResumptionTimeoutMillis());
            SessionTicket ticket = null;
            if (previousConnection.hasEstablishedSession()) {
                ticket = previousConnection.getEstablishedSession().getSessionTicket();
            } else if (previousConnection.hasSessionTicket()) {
                ticket = previousConnection.getSessionTicket();
            }
            DTLSSession sessionToResume = new DTLSSession(clientHello.getSessionId(), record.getPeerAddress(), ticket, record.getSequenceNumber());
            ResumingServerHandshaker handshaker = new ResumingServerHandshaker(clientHello.getMessageSeq(), sessionToResume, this.getRecordLayerForPeer(peerConnection), peerConnection, this.config, this.maximumTransmissionUnit);
            this.addSessionCacheSynchronization(handshaker);
            if (previousConnection.hasEstablishedSession()) {
                if (!previousConnection.getPeerAddress().equals(peerConnection.getPeerAddress())) {
                    handshaker.addSessionListener(new SessionAdapter(){

                        @Override
                        public void sessionEstablished(Handshaker currentHandshaker, DTLSSession establishedSession) throws HandshakeException {
                            LOGGER.debug("Discarding existing connection to [{}] after successful resumption of session [ID={}] by peer [{}]", new Object[]{previousConnection.getPeerAddress(), establishedSession.getSessionIdentifier(), establishedSession.getPeer()});
                            DTLSConnector.this.terminateConnection(previousConnection);
                        }
                    });
                } else {
                    this.terminateConnection(previousConnection);
                }
            }
            this.connectionStore.put(peerConnection);
            handshaker.processMessage(record);
        } else {
            LOGGER.debug("Client [{}] tries to resume non-existing session [ID={}], performing full handshake instead ...", new Object[]{clientHello.getPeer(), clientHello.getSessionId()});
            this.terminateConnection(clientHello.getPeer());
            this.startNewHandshake(clientHello, record);
        }
    }

    private void sendHelloVerify(ClientHello clientHello, Record record, byte[] expectedCookie) {
        LOGGER.debug("Verifying client IP address [{}] using HELLO_VERIFY_REQUEST", (Object)record.getPeerAddress());
        HelloVerifyRequest msg = new HelloVerifyRequest(new ProtocolVersion(), expectedCookie, record.getPeerAddress());
        msg.setMessageSeq(clientHello.getMessageSeq());
        Record helloVerify = new Record(ContentType.HANDSHAKE, 0, record.getSequenceNumber(), (DTLSMessage)msg, record.getPeerAddress());
        try {
            this.sendRecord(helloVerify);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void send(AlertMessage alert, DTLSSession session) {
        if (alert == null) {
            throw new IllegalArgumentException("Alert must not be NULL");
        }
        if (session == null) {
            throw new IllegalArgumentException("Session must not be NULL");
        }
        try {
            this.sendRecord(new Record(ContentType.ALERT, session.getWriteEpoch(), session.getSequenceNumber(), (DTLSMessage)alert, session));
        }
        catch (IOException iOException) {
        }
        catch (GeneralSecurityException e) {
            LOGGER.debug("Cannot create ALERT message for peer [{}]", (Object)session.getPeer(), (Object)e);
        }
    }

    public final void send(final RawData msg) {
        if (msg == null) {
            throw new NullPointerException("Message must not be null");
        }
        if (!this.running.get()) {
            throw new IllegalStateException("connector must be started before sending messages is possible");
        }
        if (msg.getBytes().length > 16384) {
            throw new IllegalArgumentException("Message data must not exceed 16384 bytes");
        }
        if (this.pendingOutboundMessages.decrementAndGet() >= 0) {
            this.executor.execute((Runnable)new StripedRunnable(){

                public Object getStripe() {
                    return msg.getEndpointContext().getPeerAddress();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        DTLSConnector.this.pendingOutboundMessages.incrementAndGet();
                        if (DTLSConnector.this.running.get()) {
                            DTLSConnector.this.sendMessage(msg);
                        }
                    }
                    catch (Exception e) {
                        if (DTLSConnector.this.running.get()) {
                            LOGGER.debug("Exception thrown by executor thread [{}]", (Object)Thread.currentThread().getName(), (Object)e);
                        }
                    }
                    finally {
                        DTLSConnector.this.pendingOutboundMessages.incrementAndGet();
                    }
                }
            });
        } else {
            this.pendingOutboundMessages.incrementAndGet();
            LOGGER.warn("Outbound message overflow! Dropping outbound message to peer [{}]", (Object)msg.getInetSocketAddress());
        }
    }

    private void sendMessage(RawData message) throws HandshakeException {
        DTLSSession session;
        InetSocketAddress peerAddress = message.getInetSocketAddress();
        LOGGER.debug("Sending application layer message to peer [{}]", (Object)peerAddress);
        Connection connection = this.connectionStore.get(peerAddress);
        if (connection == null) {
            connection = new Connection(peerAddress, this.config.getAutoResumptionTimeoutMillis());
            this.connectionStore.put(connection);
        }
        if ((session = connection.getEstablishedSession()) == null) {
            if (!this.checkOutboundEndpointContext(message, null)) {
                return;
            }
            ClientHandshaker handshaker = new ClientHandshaker(new DTLSSession(peerAddress, true), this.getRecordLayerForPeer(connection), connection, this.config, this.maximumTransmissionUnit);
            this.addSessionCacheSynchronization(handshaker);
            handshaker.addSessionListener(this.newDeferredMessageSender(message));
            ((Handshaker)handshaker).startHandshake();
        } else if (connection.isResumptionRequired()) {
            DTLSSession resumableSession = new DTLSSession(session.getSessionIdentifier(), peerAddress, session.getSessionTicket(), 0L);
            Connection newConnection = new Connection(peerAddress, this.config.getAutoResumptionTimeoutMillis());
            this.terminateConnection(connection, null, null);
            this.connectionStore.put(newConnection);
            ResumingClientHandshaker handshaker = new ResumingClientHandshaker(resumableSession, this.getRecordLayerForPeer(newConnection), newConnection, this.config, this.maximumTransmissionUnit);
            this.addSessionCacheSynchronization(handshaker);
            handshaker.addSessionListener(this.newDeferredMessageSender(message));
            ((Handshaker)handshaker).startHandshake();
        } else {
            this.sendMessage(message, session);
        }
    }

    private void sendMessage(RawData message, DTLSSession session) {
        try {
            DtlsEndpointContext ctx = session.getConnectionWriteContext();
            if (!this.checkOutboundEndpointContext(message, (EndpointContext)ctx)) {
                return;
            }
            message.onContextEstablished((EndpointContext)ctx);
            Record record = new Record(ContentType.APPLICATION_DATA, session.getWriteEpoch(), session.getSequenceNumber(), (DTLSMessage)new ApplicationMessage(message.getBytes(), message.getInetSocketAddress()), session);
            this.sendRecord(record);
            message.onSent();
            InetSocketAddress peerAddress = message.getInetSocketAddress();
            Connection connection = this.connectionStore.get(peerAddress);
            if (connection != null) {
                connection.refreshAutoResumptionTime();
            }
        }
        catch (IOException e) {
            message.onError((Throwable)e);
        }
        catch (GeneralSecurityException e) {
            LOGGER.debug("Cannot send APPLICATION record to peer [{}]", (Object)message.getInetSocketAddress(), (Object)e);
            message.onError((Throwable)e);
        }
    }

    private boolean checkOutboundEndpointContext(RawData message, EndpointContext connectionContext) {
        EndpointContextMatcher endpointMatcher = this.getEndpointContextMatcher();
        if (null != endpointMatcher && !endpointMatcher.isToBeSent(message.getEndpointContext(), connectionContext)) {
            LOGGER.warn("DTLSConnector ({}) drops {} bytes to {}:{}", new Object[]{this, message.getSize(), message.getAddress(), message.getPort()});
            message.onError((Throwable)new EndpointMismatchException());
            return false;
        }
        return true;
    }

    private void addSessionCacheSynchronization(Handshaker handshaker) {
        if (this.sessionCacheSynchronization != null) {
            handshaker.addSessionListener(this.sessionCacheSynchronization);
        }
    }

    private SessionListener newDeferredMessageSender(final RawData message) {
        return new SessionAdapter(){

            @Override
            public void sessionEstablished(Handshaker handshaker, DTLSSession establishedSession) throws HandshakeException {
                LOGGER.debug("Session with [{}] established, now sending deferred message", (Object)establishedSession.getPeer());
                DTLSConnector.this.sendMessage(message, establishedSession);
            }

            @Override
            public void handshakeFailed(InetSocketAddress peer, Throwable error) {
                LOGGER.debug("Session with [{}] failed, report error", (Object)peer);
                message.onError(error);
            }
        };
    }

    public final DTLSSession getSessionByAddress(InetSocketAddress address) {
        if (address == null) {
            return null;
        }
        Connection connection = this.connectionStore.get(address);
        if (connection != null) {
            return connection.getEstablishedSession();
        }
        return null;
    }

    private void sendHandshakeFlight(DTLSFlight flight, Connection connection) {
        if (flight != null) {
            if (flight.isRetransmissionNeeded()) {
                connection.setPendingFlight(flight);
                this.scheduleRetransmission(flight);
            } else {
                connection.cancelPendingFlight();
            }
            this.sendFlight(flight);
        }
    }

    private void sendFlight(DTLSFlight flight) {
        byte[] payload = new byte[]{};
        int maxDatagramSize = this.maximumTransmissionUnit;
        if (flight.getSession() != null) {
            maxDatagramSize = flight.getSession().getMaxDatagramSize();
        }
        ArrayList<DatagramPacket> datagrams = new ArrayList<DatagramPacket>();
        try {
            for (Record record : flight.getMessages()) {
                byte[] recordBytes = record.toByteArray();
                if (recordBytes.length > maxDatagramSize) {
                    LOGGER.info("{} record of {} bytes for peer [{}] exceeds max. datagram size [{}], discarding...", new Object[]{record.getType(), recordBytes.length, record.getPeerAddress(), maxDatagramSize});
                    continue;
                }
                LOGGER.trace("Sending record of {} bytes to peer [{}]:\n{}", new Object[]{recordBytes.length, flight.getPeerAddress(), record});
                if (payload.length + recordBytes.length > maxDatagramSize) {
                    DatagramPacket datagram = new DatagramPacket(payload, payload.length, flight.getPeerAddress().getAddress(), flight.getPeerAddress().getPort());
                    datagrams.add(datagram);
                    payload = new byte[]{};
                }
                payload = ByteArrayUtils.concatenate(payload, recordBytes);
            }
            DatagramPacket datagram = new DatagramPacket(payload, payload.length, flight.getPeerAddress().getAddress(), flight.getPeerAddress().getPort());
            datagrams.add(datagram);
            LOGGER.debug("Sending flight of {} message(s) to peer [{}] using {} datagram(s) of max. {} bytes", new Object[]{flight.getMessages().size(), flight.getPeerAddress(), datagrams.size(), maxDatagramSize});
            for (DatagramPacket datagramPacket : datagrams) {
                this.sendNextDatagramOverNetwork(datagramPacket);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Could not send datagram", (Throwable)e);
        }
    }

    private void sendRecord(Record record) throws IOException {
        byte[] recordBytes = record.toByteArray();
        DatagramPacket datagram = new DatagramPacket(recordBytes, recordBytes.length, record.getPeerAddress());
        this.sendNextDatagramOverNetwork(datagram);
    }

    private void sendNextDatagramOverNetwork(DatagramPacket datagramPacket) throws IOException {
        DatagramSocket socket = this.getSocket();
        if (socket != null && !socket.isClosed()) {
            try {
                socket.send(datagramPacket);
            }
            catch (IOException e) {
                LOGGER.warn("Could not send record", (Throwable)e);
                throw e;
            }
        } else {
            LOGGER.debug("Socket [{}] is closed, discarding packet ...", (Object)this.config.getAddress());
            throw new IOException("Socket closed.");
        }
    }

    private void handleTimeout(DTLSFlight flight) {
        int max = this.config.getMaxRetransmissions();
        if (flight.getTries() < max) {
            LOGGER.debug("Re-transmitting flight for [{}], [{}] retransmissions left", new Object[]{flight.getPeerAddress(), max - flight.getTries() - 1});
            try {
                flight.incrementTries();
                flight.setNewSequenceNumbers();
                this.sendFlight(flight);
                this.scheduleRetransmission(flight);
            }
            catch (GeneralSecurityException e) {
                LOGGER.info("Cannot retransmit flight to peer [{}]", (Object)flight.getPeerAddress(), (Object)e);
            }
        } else {
            Handshaker handshaker;
            LOGGER.debug("Flight for [{}] has reached maximum no. [{}] of retransmissions, discarding ...", new Object[]{flight.getPeerAddress(), max});
            Connection connection = this.connectionStore.get(flight.getPeerAddress());
            if (null != connection && null != (handshaker = connection.getOngoingHandshake())) {
                handshaker.handshakeFailed(new Exception("handshake flight timeout!"));
            }
        }
    }

    private void scheduleRetransmission(DTLSFlight flight) {
        if (flight.isRetransmissionNeeded()) {
            if (flight.getTimeout() == 0) {
                flight.setTimeout(this.config.getRetransmissionTimeout());
            } else {
                flight.incrementTimeout();
            }
            ScheduledFuture<?> f = this.timer.schedule(new RetransmitTask(flight), (long)flight.getTimeout(), TimeUnit.MILLISECONDS);
            flight.setRetransmitTask(f);
        }
    }

    public final int getMaximumTransmissionUnit() {
        return this.maximumTransmissionUnit;
    }

    public final int getMaximumFragmentLength(InetSocketAddress peer) {
        Connection con = this.connectionStore.get(peer);
        if (con != null && con.getEstablishedSession() != null) {
            return con.getEstablishedSession().getMaxFragmentLength();
        }
        return this.maximumTransmissionUnit - 53;
    }

    public final InetSocketAddress getAddress() {
        DatagramSocket socket = this.getSocket();
        if (socket == null) {
            return this.config.getAddress();
        }
        return new InetSocketAddress(socket.getLocalAddress(), socket.getLocalPort());
    }

    public final boolean isRunning() {
        return this.running.get();
    }

    private RecordLayer getRecordLayerForPeer(final Connection connection) {
        return new RecordLayer(){

            @Override
            public void sendRecord(Record record) {
                this.sendRecord(record);
            }

            @Override
            public void sendFlight(DTLSFlight flight) {
                DTLSConnector.this.sendHandshakeFlight(flight, connection);
            }

            @Override
            public void cancelRetransmissions() {
                if (DTLSConnector.this.config.isEarlyStopRetransmission().booleanValue()) {
                    connection.cancelPendingFlight();
                }
            }
        };
    }

    public void setRawDataReceiver(RawDataChannel messageHandler) {
        if (this.isRunning()) {
            throw new IllegalStateException("message handler cannot be set on running connector");
        }
        this.messageHandler = messageHandler;
    }

    public synchronized void setEndpointContextMatcher(EndpointContextMatcher endpointContextMatcher) {
        this.endpointContextMatcher = endpointContextMatcher;
    }

    private synchronized EndpointContextMatcher getEndpointContextMatcher() {
        return this.endpointContextMatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAlertHandler(AlertHandler handler) {
        Object object = this.allertHandlerLock;
        synchronized (object) {
            this.alertHandler = handler;
        }
    }

    private void connectionClosed(InetSocketAddress peerAddress) {
        if (peerAddress != null) {
            this.connectionStore.remove(peerAddress);
        }
    }

    private void handleExceptionDuringHandshake(Throwable cause, AlertMessage.AlertLevel level, AlertMessage.AlertDescription description, Record record) {
        if (AlertMessage.AlertLevel.FATAL.equals((Object)level)) {
            this.terminateOngoingHandshake(record.getPeerAddress(), cause, description);
        } else {
            DTLSConnector.discardRecord(record, cause);
        }
    }

    private static void discardRecord(Record record, Throwable cause) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Discarding {} record from peer [{}]: ", new Object[]{record.getType(), record.getPeerAddress(), cause});
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Discarding {} record from peer [{}]: {}", new Object[]{record.getType(), record.getPeerAddress(), cause.getMessage()});
        }
    }

    public String getProtocol() {
        return "DTLS";
    }

    public String toString() {
        return this.getProtocol() + "-" + this.getAddress();
    }

    private abstract class Worker
    extends Thread {
        protected Worker(String name) {
            super(NamedThreadFactory.SCANDIUM_THREAD_GROUP, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LOGGER.info("Starting worker thread [{}]", (Object)this.getName());
                while (DTLSConnector.this.running.get()) {
                    try {
                        this.doWork();
                    }
                    catch (ClosedByInterruptException e) {
                        LOGGER.info("Worker thread [{}] has been interrupted", (Object)this.getName());
                    }
                    catch (Exception e) {
                        if (!DTLSConnector.this.running.get()) continue;
                        LOGGER.debug("Exception thrown by worker thread [{}]", (Object)this.getName(), (Object)e);
                    }
                }
            }
            finally {
                LOGGER.info("Worker thread [{}] has terminated", (Object)this.getName());
            }
        }

        protected abstract void doWork() throws Exception;
    }

    private class RetransmitTask
    implements Runnable {
        private DTLSFlight flight;

        RetransmitTask(DTLSFlight flight) {
            this.flight = flight;
        }

        @Override
        public void run() {
            DTLSConnector.this.executor.execute((Runnable)new StripedRunnable(){

                public Object getStripe() {
                    return RetransmitTask.this.flight.getPeerAddress();
                }

                public void run() {
                    if (!RetransmitTask.this.flight.isRetransmissionCancelled()) {
                        DTLSConnector.this.handleTimeout(RetransmitTask.this.flight);
                    }
                }
            });
        }
    }
}

