/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.util.ServerName;
import org.eclipse.californium.scandium.util.ServerNames;

public final class ServerNameExtension
extends HelloExtension {
    private static final int LIST_LENGTH_BITS = 16;
    private ServerNames serverNames;

    private ServerNameExtension() {
        super(HelloExtension.ExtensionType.SERVER_NAME);
    }

    private ServerNameExtension(ServerNames serverNames) {
        this();
        if (serverNames == null) {
            throw new NullPointerException("server names must not be null");
        }
        this.serverNames = serverNames;
    }

    public static ServerNameExtension emptyServerNameIndication() {
        return new ServerNameExtension();
    }

    public static ServerNameExtension forHostName(String hostName) {
        return new ServerNameExtension(ServerNames.newInstance(ServerName.from(ServerName.NameType.HOST_NAME, hostName.getBytes(StandardCharsets.US_ASCII))));
    }

    public static ServerNameExtension forServerNames(ServerNames serverNames) {
        return new ServerNameExtension(serverNames);
    }

    @Override
    protected void addExtensionData(DatagramWriter writer) {
        if (this.serverNames == null) {
            writer.write(0, 16);
        } else {
            writer.write(this.serverNames.getEncodedLength() + 2, 16);
            writer.write(this.serverNames.getEncodedLength(), 16);
            for (ServerName serverName : this.serverNames) {
                writer.writeByte(serverName.getType().getCode());
                writer.write(serverName.getName().length, 16);
                writer.writeBytes(serverName.getName());
            }
        }
    }

    public static ServerNameExtension fromExtensionData(byte[] extensionData, InetSocketAddress peerAddress) throws HandshakeException {
        if (extensionData == null || extensionData.length == 0) {
            return ServerNameExtension.emptyServerNameIndication();
        }
        DatagramReader reader = new DatagramReader(extensionData);
        return ServerNameExtension.readServerNameList(reader, peerAddress);
    }

    private static ServerNameExtension readServerNameList(DatagramReader reader, InetSocketAddress peerAddress) throws HandshakeException {
        byte[] hostname;
        ServerNames serverNames = ServerNames.newInstance();
        block3: for (int listLengthBytes = reader.read(16); listLengthBytes > 0; listLengthBytes -= hostname.length + 3) {
            if (reader.bitsLeft() >= 8) {
                ServerName.NameType nameType = ServerName.NameType.fromCode(reader.readNextByte());
                switch (nameType) {
                    case HOST_NAME: {
                        hostname = ServerNameExtension.readHostName(reader, peerAddress);
                        serverNames.add(ServerName.from(nameType, hostname));
                        continue block3;
                    }
                }
                throw new HandshakeException("Server Name Indication extension contains unknown name_type", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, peerAddress));
            }
            throw ServerNameExtension.newDecodeError(peerAddress);
        }
        return new ServerNameExtension(serverNames);
    }

    private static byte[] readHostName(DatagramReader reader, InetSocketAddress peerAddress) throws HandshakeException {
        int length;
        if (reader.bitsLeft() >= 16 && reader.bytesAvailable(length = reader.read(16))) {
            return reader.readBytes(length);
        }
        throw ServerNameExtension.newDecodeError(peerAddress);
    }

    private static HandshakeException newDecodeError(InetSocketAddress peerAddress) {
        return new HandshakeException("malformed Server Name Indication extension", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.DECODE_ERROR, peerAddress));
    }

    public ServerNames getServerNames() {
        return this.serverNames;
    }

    @Override
    public int getLength() {
        int length = 2;
        length += 2;
        if (this.serverNames != null) {
            length += 2;
            length += this.serverNames.getEncodedLength();
        }
        return length;
    }
}

