/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.SessionListener;
import org.eclipse.californium.scandium.dtls.SessionTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Connection
implements SessionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Connection.class.getName());
    private final InetSocketAddress peerAddress;
    private final SessionTicket ticket;
    private final AtomicReference<Handshaker> ongoingHandshake = new AtomicReference();
    private final AtomicReference<DTLSFlight> pendingFlight = new AtomicReference();
    private final AtomicLong lastMessage = new AtomicLong();
    private final Long autoResumptionTimeout;
    private volatile DTLSSession establishedSession;
    private volatile boolean resumptionRequired = false;

    public Connection(InetSocketAddress peerAddress, Long autoResumptionTimeout) {
        this(peerAddress, null, autoResumptionTimeout);
    }

    public Connection(SessionTicket sessionTicket) {
        if (sessionTicket == null) {
            throw new NullPointerException("session ticket must not be null");
        }
        this.ticket = sessionTicket;
        this.peerAddress = null;
        this.autoResumptionTimeout = null;
    }

    public Connection(InetSocketAddress peerAddress, Handshaker ongoingHandshake, Long autoResumptionTimeout) {
        if (peerAddress == null) {
            throw new NullPointerException("Peer address must not be null");
        }
        this.ticket = null;
        this.peerAddress = peerAddress;
        this.autoResumptionTimeout = autoResumptionTimeout;
        this.ongoingHandshake.set(ongoingHandshake);
    }

    public boolean isActive() {
        return this.establishedSession != null || this.ticket != null;
    }

    public SessionTicket getSessionTicket() {
        return this.ticket;
    }

    public boolean hasSessionTicket() {
        return this.ticket != null;
    }

    public InetSocketAddress getPeerAddress() {
        return this.peerAddress;
    }

    public DTLSSession getEstablishedSession() {
        return this.establishedSession;
    }

    public boolean hasEstablishedSession() {
        return this.establishedSession != null;
    }

    public Handshaker getOngoingHandshake() {
        return this.ongoingHandshake.get();
    }

    public boolean hasOngoingHandshake() {
        return this.ongoingHandshake.get() != null;
    }

    public void setOngoingHandshake(Handshaker ongoingHandshake) {
        this.ongoingHandshake.set(ongoingHandshake);
    }

    public void terminateOngoingHandshake() {
        this.cancelPendingFlight();
        this.setOngoingHandshake(null);
    }

    public void setPendingFlight(DTLSFlight pendingFlight) {
        DTLSFlight flight = this.pendingFlight.getAndSet(pendingFlight);
        if (flight != null && flight != pendingFlight) {
            flight.cancelRetransmission();
        }
    }

    public void cancelPendingFlight() {
        this.setPendingFlight(null);
    }

    public DTLSSession getSession() {
        Handshaker handshaker;
        DTLSSession session = this.establishedSession;
        if (session == null && (handshaker = this.ongoingHandshake.get()) != null) {
            session = handshaker.getSession();
        }
        return session;
    }

    @Override
    public void handshakeStarted(Handshaker handshaker) throws HandshakeException {
        this.ongoingHandshake.set(handshaker);
        LOGGER.debug("Handshake with [{}] has been started", (Object)handshaker.getPeerAddress());
    }

    @Override
    public void sessionEstablished(Handshaker handshaker, DTLSSession session) throws HandshakeException {
        this.establishedSession = session;
        LOGGER.debug("Session with [{}] has been established", (Object)session.getPeer());
    }

    @Override
    public void handshakeCompleted(InetSocketAddress peer) {
        Handshaker handshaker = this.ongoingHandshake.getAndSet(null);
        if (handshaker != null) {
            this.cancelPendingFlight();
            LOGGER.debug("Handshake with [{}] has been completed", (Object)peer);
        }
    }

    @Override
    public void handshakeFailed(InetSocketAddress peer, Throwable error) {
        Handshaker handshaker = this.ongoingHandshake.getAndSet(null);
        if (handshaker != null) {
            this.cancelPendingFlight();
            LOGGER.debug("Handshake with [{}] has failed", (Object)peer);
        }
    }

    public boolean isResumptionRequired() {
        return this.resumptionRequired || this.isAutoResumptionRequired();
    }

    public boolean isAutoResumptionRequired() {
        if (this.autoResumptionTimeout != null && this.establishedSession != null) {
            long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            if (this.lastMessage.get() + this.autoResumptionTimeout - now < 0L) {
                this.setResumptionRequired(true);
                return this.resumptionRequired;
            }
        }
        return false;
    }

    public void refreshAutoResumptionTime() {
        if (this.autoResumptionTimeout != null) {
            long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            this.lastMessage.set(now);
        }
    }

    public void setResumptionRequired(boolean resumptionRequired) {
        this.resumptionRequired = resumptionRequired;
    }
}

