/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ByteArrayUtils {
    private static final char[] BIN_TO_HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static byte[] padArray(byte[] array, byte value, int newLength) {
        int length = array.length;
        int paddingLength = newLength - length;
        if (paddingLength < 1) {
            return array;
        }
        byte[] padding = new byte[paddingLength];
        Arrays.fill(padding, value);
        return ByteArrayUtils.concatenate(array, padding);
    }

    public static byte[] truncate(byte[] array, int newLength) {
        if (array.length < newLength) {
            return array;
        }
        byte[] truncated = new byte[newLength];
        System.arraycopy(array, 0, truncated, 0, newLength);
        return truncated;
    }

    public static byte[] concatenate(byte[] a, byte[] b) {
        int lengthA = a.length;
        int lengthB = b.length;
        byte[] concat = new byte[lengthA + lengthB];
        System.arraycopy(a, 0, concat, 0, lengthA);
        System.arraycopy(b, 0, concat, lengthA, lengthB);
        return concat;
    }

    public static byte[] xorArrays(byte[] a, byte[] b) {
        byte[] xor = new byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            xor[i] = (byte)(a[i] ^ b[i]);
        }
        return xor;
    }

    public static List<byte[]> splitAndPad(byte[] byteArray, int blocksize) {
        ArrayList<byte[]> blocks = new ArrayList<byte[]>();
        int numBlocks = (int)Math.ceil((double)byteArray.length / (double)blocksize);
        for (int i = 0; i < numBlocks; ++i) {
            byte[] block = new byte[blocksize];
            Arrays.fill(block, (byte)0);
            if (i + 1 == numBlocks) {
                int remainingBytes = byteArray.length - i * blocksize;
                System.arraycopy(byteArray, i * blocksize, block, 0, remainingBytes);
            } else {
                System.arraycopy(byteArray, i * blocksize, block, 0, blocksize);
            }
            blocks.add(block);
        }
        return blocks;
    }

    public static String toHexString(byte[] byteArray) {
        if (byteArray != null && byteArray.length != 0) {
            char[] bytesHexadecimal = new char[byteArray.length * 3];
            int dest = 0;
            for (int src = 0; src < byteArray.length; ++src) {
                int value = byteArray[src] & 0xFF;
                bytesHexadecimal[dest++] = BIN_TO_HEX_ARRAY[value >>> 4];
                bytesHexadecimal[dest++] = BIN_TO_HEX_ARRAY[value & 0xF];
                bytesHexadecimal[dest++] = 32;
            }
            return new String(bytesHexadecimal, 0, bytesHexadecimal.length - 1);
        }
        return "--";
    }

    public static String toHex(byte[] byteArray) {
        char[] bytesHexadecimal = new char[byteArray.length * 2];
        int dest = 0;
        for (int src = 0; src < byteArray.length; ++src) {
            int value = byteArray[src] & 0xFF;
            bytesHexadecimal[dest++] = BIN_TO_HEX_ARRAY[value >>> 4];
            bytesHexadecimal[dest++] = BIN_TO_HEX_ARRAY[value & 0xF];
        }
        return new String(bytesHexadecimal);
    }

    public static byte[] hexStreamToByteArray(String hexStream) {
        int length = hexStream.length();
        byte[] data = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexStream.charAt(i), 16) << 4) + Character.digit(hexStream.charAt(i + 1), 16));
        }
        return data;
    }

    public static byte[] trimZeroes(byte[] byeArray) {
        int count;
        for (count = 0; count < byeArray.length - 1 && byeArray[count] == 0; ++count) {
        }
        if (count == 0) {
            return byeArray;
        }
        byte[] trimmedByteArray = new byte[byeArray.length - count];
        System.arraycopy(byeArray, count, trimmedByteArray, 0, trimmedByteArray.length);
        return trimmedByteArray;
    }
}

