/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.scandium.dtls.ClientKeyExchange;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;

public final class PSKClientKeyExchange
extends ClientKeyExchange {
    private static final int IDENTITY_LENGTH_BITS = 16;
    private static final Charset CHAR_SET_UTF8 = Charset.forName("UTF8");
    private final byte[] identityEncoded;
    private final String identity;

    public PSKClientKeyExchange(String identity, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.identityEncoded = identity.getBytes(CHAR_SET_UTF8);
        this.identity = identity;
    }

    private PSKClientKeyExchange(byte[] identityEncoded, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.identityEncoded = Arrays.copyOf(identityEncoded, identityEncoded.length);
        this.identity = new String(this.identityEncoded, CHAR_SET_UTF8);
    }

    @Override
    public int getMessageLength() {
        return 2 + this.identityEncoded.length;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\t\tPSK Identity: ").append(this.identity).append(System.lineSeparator());
        return sb.toString();
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.identityEncoded.length, 16);
        writer.writeBytes(this.identityEncoded);
        return writer.toByteArray();
    }

    public static HandshakeMessage fromByteArray(byte[] byteArray, InetSocketAddress peerAddress) {
        DatagramReader reader = new DatagramReader(byteArray);
        int length = reader.read(16);
        byte[] identityEncoded = reader.readBytes(length);
        return new PSKClientKeyExchange(identityEncoded, peerAddress);
    }

    public String getIdentity() {
        return this.identity;
    }
}

