/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.util.Iterator;
import org.eclipse.californium.elements.util.LeastRecentlyUsedCache;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.ResumptionSupportingConnectionStore;
import org.eclipse.californium.scandium.dtls.SessionCache;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SessionListener;
import org.eclipse.californium.scandium.dtls.SessionTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InMemoryConnectionStore
implements ResumptionSupportingConnectionStore,
SessionListener {
    private static final Logger LOG = LoggerFactory.getLogger((String)InMemoryConnectionStore.class.getName());
    private static final int DEFAULT_CACHE_SIZE = 150000;
    private static final long DEFAULT_EXPIRATION_THRESHOLD = 129600L;
    private final LeastRecentlyUsedCache<InetSocketAddress, Connection> connections;
    private final SessionCache sessionCache;

    public InMemoryConnectionStore() {
        this(150000, 129600L);
    }

    public InMemoryConnectionStore(SessionCache sessionCache) {
        this(150000, 129600L, sessionCache);
    }

    public InMemoryConnectionStore(int capacity, long threshold) {
        this(capacity, threshold, null);
    }

    public InMemoryConnectionStore(int capacity, long threshold, SessionCache sessionCache) {
        this.connections = new LeastRecentlyUsedCache(capacity, threshold);
        this.sessionCache = sessionCache;
        if (sessionCache != null) {
            this.connections.addEvictionListener((LeastRecentlyUsedCache.EvictionListener)new LeastRecentlyUsedCache.EvictionListener<Connection>(){

                public void onEviction(Connection staleConnection) {
                    InMemoryConnectionStore.this.removeSessionFromCache(staleConnection);
                }
            });
        }
        LOG.info("Created new InMemoryConnectionStore [capacity: {}, connection expiration threshold: {}s]", new Object[]{capacity, threshold});
    }

    @Override
    public synchronized boolean put(Connection connection) {
        if (connection != null) {
            return this.connections.put((Object)connection.getPeerAddress(), (Object)connection);
        }
        return false;
    }

    @Override
    public synchronized Connection find(SessionId id) {
        if (id == null) {
            return null;
        }
        Connection conFromLocalCache = this.findLocally(id);
        if (this.sessionCache == null) {
            return conFromLocalCache;
        }
        SessionTicket ticket = this.sessionCache.get(id);
        if (ticket == null) {
            if (conFromLocalCache != null) {
                this.remove(conFromLocalCache.getPeerAddress());
            }
            return null;
        }
        if (conFromLocalCache == null) {
            return new Connection(ticket);
        }
        return conFromLocalCache;
    }

    private synchronized Connection findLocally(final SessionId id) {
        return (Connection)this.connections.find((LeastRecentlyUsedCache.Predicate)new LeastRecentlyUsedCache.Predicate<Connection>(){

            public boolean accept(Connection connection) {
                DTLSSession session = connection.getEstablishedSession();
                return session != null && id.equals(session.getSessionIdentifier());
            }
        });
    }

    @Override
    public synchronized void markAllAsResumptionRequired() {
        Iterator iterator = this.connections.values();
        while (iterator.hasNext()) {
            Connection c = (Connection)iterator.next();
            if (c == null) continue;
            c.setResumptionRequired(true);
        }
    }

    @Override
    public synchronized int remainingCapacity() {
        return this.connections.remainingCapacity();
    }

    @Override
    public synchronized Connection get(InetSocketAddress peerAddress) {
        return (Connection)this.connections.get((Object)peerAddress);
    }

    @Override
    public synchronized Connection remove(InetSocketAddress peerAddress) {
        Connection removedConnection = (Connection)this.connections.remove((Object)peerAddress);
        this.removeSessionFromCache(removedConnection);
        return removedConnection;
    }

    private synchronized void removeSessionFromCache(Connection connection) {
        if (this.sessionCache != null && connection.hasEstablishedSession()) {
            this.sessionCache.remove(connection.getEstablishedSession().getSessionIdentifier());
        }
    }

    @Override
    public final synchronized void clear() {
        this.connections.clear();
    }

    @Override
    public void handshakeStarted(Handshaker handshaker) throws HandshakeException {
    }

    @Override
    public void sessionEstablished(Handshaker handshaker, DTLSSession establishedSession) throws HandshakeException {
        if (this.sessionCache != null) {
            this.sessionCache.put(establishedSession);
        }
    }

    @Override
    public void handshakeCompleted(InetSocketAddress peer) {
    }

    @Override
    public void handshakeFailed(InetSocketAddress peer, Throwable error) {
    }
}

