/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.DTLSConnectionState;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SessionTicket;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;

public final class DTLSSession {
    public static final int HEADER_LENGTH = 53;
    private static final Logger LOGGER = Logger.getLogger(DTLSSession.class.getName());
    private static final long RECEIVE_WINDOW_SIZE = 64L;
    private static final long MAX_SEQUENCE_NO = 0xFFFFFFFFFFFFL;
    private static final int MAX_FRAGMENT_LENGTH_DEFAULT = 16384;
    private static final int MAX_TRANSMISSION_UNIT_DEFAULT = 1400;
    private static final int MASTER_SECRET_LENGTH = 48;
    private InetSocketAddress peer = null;
    private SessionId sessionIdentifier = null;
    private Principal peerIdentity;
    private int maxFragmentLength = 16384;
    private int maxTransmissionUnit = 1400;
    private CipherSuite cipherSuite = CipherSuite.TLS_NULL_WITH_NULL_NULL;
    private CompressionMethod compressionMethod = CompressionMethod.NULL;
    private byte[] masterSecret = null;
    private final boolean isClient;
    private DTLSConnectionState readState = new DTLSConnectionState();
    private DTLSConnectionState writeState = new DTLSConnectionState();
    private int readEpoch = 0;
    private int writeEpoch = 0;
    private Map<Integer, Long> sequenceNumbers = new HashMap<Integer, Long>();
    private boolean sendRawPublicKey = false;
    private boolean receiveRawPublicKey = false;
    private volatile long receiveWindowUpperBoundary = 63L;
    private volatile long receiveWindowLowerBoundary = 0L;
    private volatile long receivedRecordsVector = 0L;
    private long creationTime;

    public DTLSSession(InetSocketAddress peerAddress, boolean isClient) {
        this(peerAddress, isClient, 0L);
    }

    public DTLSSession(SessionId id, InetSocketAddress peerAddress, SessionTicket ticket, long initialSequenceNo) {
        this(peerAddress, false, initialSequenceNo);
        this.sessionIdentifier = id;
        this.masterSecret = ticket.getMasterSecret();
        this.peerIdentity = ticket.getClientIdentity();
        this.cipherSuite = ticket.getCipherSuite();
        this.compressionMethod = ticket.getCompressionMethod();
    }

    public DTLSSession(InetSocketAddress peerAddress, boolean isClient, long initialSequenceNo) {
        if (peerAddress == null) {
            throw new NullPointerException("Peer address must not be null");
        }
        if (initialSequenceNo < 0L || initialSequenceNo > 0xFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("Initial sequence number must be greater than 0 and less than 2^48");
        }
        this.creationTime = System.currentTimeMillis();
        this.peer = peerAddress;
        this.isClient = isClient;
        this.sequenceNumbers.put(0, initialSequenceNo);
    }

    public SessionId getSessionIdentifier() {
        return this.sessionIdentifier;
    }

    void setSessionIdentifier(SessionId sessionIdentifier) {
        this.sessionIdentifier = sessionIdentifier;
    }

    CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    void setCipherSuite(CipherSuite cipherSuite) {
        if (cipherSuite == null || CipherSuite.TLS_NULL_WITH_NULL_NULL == cipherSuite) {
            throw new IllegalArgumentException("Negotiated cipher suite must not be null");
        }
        this.cipherSuite = cipherSuite;
    }

    CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    void setCompressionMethod(CompressionMethod compressionMethod) {
        this.compressionMethod = compressionMethod;
    }

    boolean isClient() {
        return this.isClient;
    }

    public int getWriteEpoch() {
        return this.writeEpoch;
    }

    void setWriteEpoch(int epoch) {
        if (epoch < 0) {
            throw new IllegalArgumentException("Write epoch must not be negative");
        }
        this.writeEpoch = epoch;
    }

    public int getReadEpoch() {
        return this.readEpoch;
    }

    void setReadEpoch(int epoch) {
        if (epoch < 0) {
            throw new IllegalArgumentException("Read epoch must not be negative");
        }
        this.resetReceiveWindow();
        this.readEpoch = epoch;
    }

    private synchronized void incrementReadEpoch() {
        this.resetReceiveWindow();
        ++this.readEpoch;
    }

    private synchronized void incrementWriteEpoch() {
        ++this.writeEpoch;
        this.sequenceNumbers.put(this.writeEpoch, 0L);
    }

    public synchronized long getSequenceNumber() {
        return this.getSequenceNumber(this.writeEpoch);
    }

    public synchronized long getSequenceNumber(int epoch) {
        long sequenceNumber = this.sequenceNumbers.get(epoch);
        if (sequenceNumber < 0xFFFFFFFFFFFFL) {
            this.sequenceNumbers.put(epoch, sequenceNumber + 1L);
            return sequenceNumber;
        }
        throw new IllegalStateException("Maximum sequence number for epoch has been reached");
    }

    synchronized DTLSConnectionState getReadState() {
        return this.readState;
    }

    synchronized void setReadState(DTLSConnectionState readState) {
        if (readState == null) {
            throw new NullPointerException("Read state must not be null");
        }
        this.readState = readState;
        this.incrementReadEpoch();
        LOGGER.log(Level.FINEST, "Setting current read state to\n{0}", readState);
    }

    public synchronized String getReadStateCipher() {
        return this.readState.getCipherSuite().name();
    }

    synchronized DTLSConnectionState getWriteState() {
        return this.writeState;
    }

    synchronized void setWriteState(DTLSConnectionState writeState) {
        if (writeState == null) {
            throw new NullPointerException("Write state must not be null");
        }
        this.writeState = writeState;
        this.incrementWriteEpoch();
        this.determineMaxFragmentLength(this.maxFragmentLength);
        LOGGER.log(Level.FINEST, "Setting current write state to\n{0}", writeState);
    }

    public synchronized String getWriteStateCipher() {
        return this.writeState.getCipherSuite().name();
    }

    final CipherSuite.KeyExchangeAlgorithm getKeyExchange() {
        if (this.cipherSuite == null) {
            throw new IllegalStateException("Cipher suite has not been set (yet)");
        }
        return this.cipherSuite.getKeyExchange();
    }

    byte[] getMasterSecret() {
        return this.masterSecret;
    }

    void setMasterSecret(byte[] masterSecret) {
        if (this.masterSecret == null) {
            if (masterSecret == null) {
                throw new NullPointerException("Master secret must not be null");
            }
            if (masterSecret.length != 48) {
                throw new IllegalArgumentException(String.format("Master secret must consist of of exactly %d bytes but has %d bytes", 48, masterSecret.length));
            }
            this.masterSecret = Arrays.copyOf(masterSecret, masterSecret.length);
        }
    }

    void setMaxFragmentLength(int length) {
        if (length < 0 || length > 16384) {
            throw new IllegalArgumentException("Max. fragment length must be > 0 and < 16384");
        }
        this.determineMaxFragmentLength(length);
    }

    public int getMaxDatagramSize() {
        return this.maxFragmentLength + this.writeState.getMaxCiphertextExpansion() + 53;
    }

    void setMaxTransmissionUnit(int mtu) {
        if (mtu < 60) {
            throw new IllegalArgumentException("MTU must be at least 60 bytes");
        }
        LOGGER.log(Level.FINER, "Setting MTU for peer [{0}] to {1} bytes", new Object[]{this.peer, mtu});
        this.maxTransmissionUnit = mtu;
        this.determineMaxFragmentLength(mtu);
    }

    private void determineMaxFragmentLength(int maxProcessableFragmentLength) {
        int maxDatagramSize = maxProcessableFragmentLength + this.writeState.getMaxCiphertextExpansion() + 53;
        this.maxFragmentLength = maxDatagramSize <= this.maxTransmissionUnit ? maxProcessableFragmentLength : this.maxTransmissionUnit - 53 - this.writeState.getMaxCiphertextExpansion();
        LOGGER.log(Level.FINER, "Setting maximum fragment length for peer [{0}] to {1} bytes", new Object[]{this.peer, this.maxFragmentLength});
    }

    public int getMaxFragmentLength() {
        return this.maxFragmentLength;
    }

    boolean sendRawPublicKey() {
        return this.sendRawPublicKey;
    }

    void setSendRawPublicKey(boolean sendRawPublicKey) {
        this.sendRawPublicKey = sendRawPublicKey;
    }

    boolean receiveRawPublicKey() {
        return this.receiveRawPublicKey;
    }

    void setReceiveRawPublicKey(boolean receiveRawPublicKey) {
        this.receiveRawPublicKey = receiveRawPublicKey;
    }

    public InetSocketAddress getPeer() {
        return this.peer;
    }

    public Principal getPeerIdentity() {
        return this.peerIdentity;
    }

    void setPeerIdentity(Principal peerIdentity) {
        if (peerIdentity == null) {
            throw new NullPointerException("Peer identity must not be null");
        }
        this.peerIdentity = peerIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRecordProcessable(long epoch, long sequenceNo) {
        if (epoch < (long)this.getReadEpoch()) {
            return false;
        }
        if (epoch > (long)this.getReadEpoch()) {
            return false;
        }
        DTLSSession dTLSSession = this;
        synchronized (dTLSSession) {
            if (sequenceNo < this.receiveWindowLowerBoundary) {
                return false;
            }
            return !this.isDuplicate(sequenceNo);
        }
    }

    synchronized boolean isDuplicate(long sequenceNo) {
        if (sequenceNo > this.receiveWindowUpperBoundary) {
            return false;
        }
        long idx = sequenceNo - this.receiveWindowLowerBoundary;
        long bitMask = 1L << (int)idx;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Checking sequence no [{0}] using bit mask [{1}] against received records [{2}] with lower boundary [{3}]", new Object[]{sequenceNo, Long.toBinaryString(bitMask), Long.toBinaryString(this.receivedRecordsVector), this.receiveWindowLowerBoundary});
        }
        return (this.receivedRecordsVector & bitMask) == bitMask;
    }

    public synchronized void markRecordAsRead(long epoch, long sequenceNo) {
        if (epoch == (long)this.getReadEpoch()) {
            if (sequenceNo > this.receiveWindowUpperBoundary) {
                long incr = sequenceNo - this.receiveWindowUpperBoundary;
                this.receiveWindowUpperBoundary = sequenceNo;
                this.receivedRecordsVector >>>= (int)incr;
                this.receiveWindowLowerBoundary = Math.max(0L, this.receiveWindowUpperBoundary - 64L + 1L);
            }
            long bitMask = 1L << (int)(sequenceNo - this.receiveWindowLowerBoundary);
            this.receivedRecordsVector |= bitMask;
            LOGGER.log(Level.FINER, "Updated receive window with sequence number [{0}]: new upper boundary [{1}], new bit vector [{2}]", new Object[]{sequenceNo, this.receiveWindowUpperBoundary, Long.toBinaryString(this.receivedRecordsVector)});
        }
    }

    private synchronized void resetReceiveWindow() {
        this.receivedRecordsVector = 0L;
        this.receiveWindowUpperBoundary = 63L;
        this.receiveWindowLowerBoundary = 0L;
    }

    public SessionTicket getSessionTicket() {
        if (this.getWriteState().hasValidCipherSuite()) {
            return new SessionTicket(new ProtocolVersion(), this.getWriteState().getCipherSuite(), this.getWriteState().getCompressionMethod(), this.getMasterSecret(), this.getPeerIdentity(), System.currentTimeMillis());
        }
        throw new IllegalStateException("session has no valid crypto params, not fully negotiated yet?");
    }
}

