/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.Record;

public class DTLSFlight {
    private List<Record> messages;
    private InetSocketAddress peerAddress;
    private DTLSSession session;
    private int tries;
    private int timeout = 0;
    private boolean retransmissionNeeded = false;
    private ScheduledFuture<?> retransmitTask;

    @Deprecated
    public DTLSFlight() {
        this.messages = new ArrayList<Record>();
        this.tries = 0;
        this.timeout = 0;
    }

    public DTLSFlight(InetSocketAddress peerAddress) {
        if (peerAddress == null) {
            throw new NullPointerException("Peer address must not be null");
        }
        this.peerAddress = peerAddress;
        this.messages = new ArrayList<Record>();
    }

    public DTLSFlight(DTLSSession session) {
        this(session.getPeer());
        this.session = session;
        this.retransmissionNeeded = true;
    }

    public void addMessage(List<Record> messagesToAdd) {
        this.messages.addAll(messagesToAdd);
    }

    public void addMessage(Record messageToAdd) {
        this.messages.add(messageToAdd);
    }

    public List<Record> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public InetSocketAddress getPeerAddress() {
        return this.peerAddress;
    }

    @Deprecated
    public void setPeerAddress(InetSocketAddress peerAddress) {
        this.peerAddress = peerAddress;
    }

    public DTLSSession getSession() {
        return this.session;
    }

    @Deprecated
    public void setSession(DTLSSession session) {
        this.session = session;
    }

    public int getTries() {
        return this.tries;
    }

    public void incrementTries() {
        ++this.tries;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void incrementTimeout() {
        this.timeout *= 2;
    }

    public boolean isRetransmissionNeeded() {
        return this.retransmissionNeeded;
    }

    public void setRetransmissionNeeded(boolean needsRetransmission) {
        this.retransmissionNeeded = needsRetransmission;
    }

    public void cancelRetransmission() {
        if (this.retransmitTask != null) {
            this.retransmitTask.cancel(true);
            this.retransmitTask = null;
        }
    }

    public ScheduledFuture<?> getRetransmitTask() {
        return this.retransmitTask;
    }

    public void setRetransmitTask(ScheduledFuture<?> retransmitTask) {
        this.retransmitTask = retransmitTask;
    }

    public void setNewSequenceNumbers() throws GeneralSecurityException {
        if (this.getTries() > 0 && this.session != null) {
            for (Record record : this.messages) {
                int epoch = record.getEpoch();
                record.setSequenceNumber(this.session.getSequenceNumber(epoch));
            }
        } else {
            throw new IllegalStateException("Can only set new sequence numbers for retransmitted flight with session");
        }
    }
}

