/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.auth;

import java.io.ByteArrayInputStream;
import java.security.Principal;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class X509CertPath
implements Principal {
    private static final String TYPE_X509 = "X.509";
    private final CertPath path;
    private final X509Certificate target;

    public X509CertPath(CertPath certPath) {
        if (certPath.getType() != TYPE_X509) {
            throw new IllegalArgumentException("Cert path must contain X.509 certificates only");
        }
        if (certPath.getCertificates().isEmpty()) {
            throw new IllegalArgumentException("Cert path must not be empty");
        }
        this.path = certPath;
        this.target = (X509Certificate)certPath.getCertificates().get(0);
    }

    public static X509CertPath fromBytes(byte[] encodedPath) {
        try {
            CertificateFactory factory = CertificateFactory.getInstance(TYPE_X509);
            CertPath certPath = factory.generateCertPath(new ByteArrayInputStream(encodedPath), "PkiPath");
            return new X509CertPath(certPath);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("byte array does not contain X.509 certificate path");
        }
    }

    public byte[] toByteArray() {
        try {
            return this.path.getEncoded("PkiPath");
        }
        catch (CertificateEncodingException e) {
            return new byte[0];
        }
    }

    @Override
    public String getName() {
        return this.target.getSubjectX500Principal().getName();
    }
}

