/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.auth;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Principal;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.scandium.auth.PreSharedKeyIdentity;
import org.eclipse.californium.scandium.auth.RawPublicKeyIdentity;
import org.eclipse.californium.scandium.auth.X509CertPath;

public final class PrincipalSerializer {
    private PrincipalSerializer() {
    }

    public static void serialize(Principal principal, DatagramWriter writer) {
        if (writer == null) {
            throw new NullPointerException("Writer must not be null");
        }
        if (principal == null) {
            writer.writeByte(ClientAuthenticationType.ANONYMOUS.code);
        } else if (principal instanceof PreSharedKeyIdentity) {
            PrincipalSerializer.serializeIdentity((PreSharedKeyIdentity)principal, writer);
        } else if (principal instanceof RawPublicKeyIdentity) {
            PrincipalSerializer.serializeSubjectInfo((RawPublicKeyIdentity)principal, writer);
        } else if (principal instanceof X509CertPath) {
            PrincipalSerializer.serializeCertChain((X509CertPath)principal, writer);
        } else {
            throw new IllegalArgumentException("unsupported principal type: " + principal.getClass().getName());
        }
    }

    private static void serializeIdentity(PreSharedKeyIdentity principal, DatagramWriter writer) {
        writer.writeByte(ClientAuthenticationType.PSK.code);
        PrincipalSerializer.writeBytes(principal.getName().getBytes(StandardCharsets.UTF_8), writer);
    }

    private static void serializeSubjectInfo(RawPublicKeyIdentity principal, DatagramWriter writer) {
        writer.writeByte(ClientAuthenticationType.RPK.code);
        PrincipalSerializer.writeBytes(principal.getSubjectInfo(), writer);
    }

    private static void serializeCertChain(X509CertPath principal, DatagramWriter writer) {
        writer.writeByte(ClientAuthenticationType.CERT.code);
        PrincipalSerializer.writeBytes(principal.toByteArray(), writer);
    }

    private static void writeBytes(byte[] bytesToWrite, DatagramWriter writer) {
        writer.write(bytesToWrite.length, 16);
        writer.writeBytes(bytesToWrite);
    }

    public static Principal deserialize(DatagramReader reader) throws GeneralSecurityException {
        if (reader == null) {
            throw new NullPointerException("reader must not be null");
        }
        int code = reader.read(8);
        ClientAuthenticationType type = ClientAuthenticationType.fromCode((byte)code);
        switch (type) {
            case CERT: {
                return PrincipalSerializer.deserializeCertChain(reader);
            }
            case PSK: {
                return PrincipalSerializer.deserializeIdentity(reader);
            }
            case RPK: {
                return PrincipalSerializer.deserializeSubjectInfo(reader);
            }
        }
        return null;
    }

    private static X509CertPath deserializeCertChain(DatagramReader reader) {
        return X509CertPath.fromBytes(PrincipalSerializer.readBytes(reader, 24));
    }

    private static PreSharedKeyIdentity deserializeIdentity(DatagramReader reader) {
        return new PreSharedKeyIdentity(new String(PrincipalSerializer.readBytes(reader, 16)));
    }

    private static RawPublicKeyIdentity deserializeSubjectInfo(DatagramReader reader) throws GeneralSecurityException {
        byte[] subjectInfo = PrincipalSerializer.readBytes(reader, 16);
        return new RawPublicKeyIdentity(subjectInfo);
    }

    private static byte[] readBytes(DatagramReader reader, int lengthBits) {
        int length = reader.read(lengthBits);
        return reader.readBytes(length);
    }

    private static enum ClientAuthenticationType {
        ANONYMOUS(0),
        CERT(1),
        PSK(2),
        RPK(-1);

        private byte code;

        private ClientAuthenticationType(byte code) {
            this.code = code;
        }

        static ClientAuthenticationType fromCode(byte code) {
            for (ClientAuthenticationType type : ClientAuthenticationType.values()) {
                if (type.code != code) continue;
                return type;
            }
            throw new IllegalArgumentException("unknown ClientAuthenticationType: " + code);
        }
    }
}

