/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.pskstore;

import java.net.InetSocketAddress;
import javax.crypto.SecretKey;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;

public class StaticPskStore
implements PskStore {
    private final SecretKey key;
    private final PskPublicInformation fixedIdentity;

    public StaticPskStore(String identity, byte[] key) {
        this(new PskPublicInformation(identity), key);
    }

    public StaticPskStore(PskPublicInformation identity, byte[] key) {
        this.fixedIdentity = identity;
        this.key = SecretUtil.create(key, "PSK");
    }

    @Override
    public PskPublicInformation getIdentity(InetSocketAddress inetAddress) {
        return this.fixedIdentity;
    }

    @Override
    public PskPublicInformation getIdentity(InetSocketAddress peerAddress, ServerNames virtualHost) {
        return this.getIdentity(peerAddress);
    }

    @Override
    public SecretKey getKey(PskPublicInformation identity) {
        if (!this.fixedIdentity.equals((Object)identity)) {
            return null;
        }
        if (!this.fixedIdentity.isCompliantEncoding()) {
            identity.normalize(this.fixedIdentity.getPublicInfoAsString());
        }
        return SecretUtil.create(this.key);
    }

    @Override
    public SecretKey getKey(ServerNames serverNames, PskPublicInformation identity) {
        return this.getKey(identity);
    }
}

