/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.util.Collections;
import java.util.List;
import javax.crypto.SecretKey;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateRequest;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateVerify;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.ClientKeyExchange;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionIdExtension;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.ECDHClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ECDHServerKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskClientKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskServerKeyExchange;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeState;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.HelloVerifyRequest;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.PSKClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.PskUtil;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.ServerHelloDone;
import org.eclipse.californium.scandium.dtls.ServerNameExtension;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.ECDHECryptography;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;

public class ClientHandshaker
extends Handshaker {
    protected static HandshakeState[] SEVER_CERTIFICATE = new HandshakeState[]{new HandshakeState(HandshakeType.HELLO_VERIFY_REQUEST, true), new HandshakeState(HandshakeType.SERVER_HELLO), new HandshakeState(HandshakeType.CERTIFICATE), new HandshakeState(HandshakeType.SERVER_KEY_EXCHANGE), new HandshakeState(HandshakeType.CERTIFICATE_REQUEST, true), new HandshakeState(HandshakeType.SERVER_HELLO_DONE), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    private static HandshakeState[] NO_SEVER_CERTIFICATE = new HandshakeState[]{new HandshakeState(HandshakeType.HELLO_VERIFY_REQUEST, true), new HandshakeState(HandshakeType.SERVER_HELLO), new HandshakeState(HandshakeType.SERVER_KEY_EXCHANGE, true), new HandshakeState(HandshakeType.SERVER_HELLO_DONE), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    private ProtocolVersion maxProtocolVersion = new ProtocolVersion();
    private PublicKey serverPublicKey;
    private CertPath peerCertPath;
    protected ECPublicKey ephemeralServerPublicKey;
    protected ClientHello clientHello = null;
    private final List<CipherSuite> preferredCipherSuites;
    protected Integer maxFragmentLengthCode;
    protected final List<CertificateType> supportedClientCertificateTypes;
    protected final List<CertificateType> supportedServerCertificateTypes;
    protected CertificateRequest certificateRequest = null;
    protected byte[] handshakeHash = null;
    protected ServerNames indicatedServerNames;
    protected SignatureAndHashAlgorithm negotiatedSignatureAndHashAlgorithm;

    public ClientHandshaker(DTLSSession session, RecordLayer recordLayer, Connection connection, DtlsConnectorConfig config, int maxTransmissionUnit) {
        super(true, 0, session, recordLayer, connection, config, maxTransmissionUnit);
        this.preferredCipherSuites = config.getSupportedCipherSuites();
        this.maxFragmentLengthCode = config.getMaxFragmentLengthCode();
        this.supportedServerCertificateTypes = config.getTrustCertificateTypes();
        this.supportedClientCertificateTypes = config.getIdentityCertificateTypes();
    }

    final SignatureAndHashAlgorithm getNegotiatedSignatureAndHashAlgorithm() {
        return this.negotiatedSignatureAndHashAlgorithm;
    }

    @Override
    protected void doProcessMessage(HandshakeMessage message) throws HandshakeException, GeneralSecurityException {
        block0 : switch (message.getMessageType()) {
            case HELLO_VERIFY_REQUEST: {
                this.receivedHelloVerifyRequest((HelloVerifyRequest)message);
                break;
            }
            case SERVER_HELLO: {
                this.receivedServerHello((ServerHello)message);
                break;
            }
            case CERTIFICATE: {
                this.receivedServerCertificate((CertificateMessage)message);
                break;
            }
            case SERVER_KEY_EXCHANGE: {
                switch (this.getKeyExchangeAlgorithm()) {
                    case EC_DIFFIE_HELLMAN: {
                        this.receivedServerKeyExchange((ECDHServerKeyExchange)message);
                        break block0;
                    }
                    case PSK: {
                        break block0;
                    }
                    case ECDHE_PSK: {
                        this.receivedServerKeyExchange((EcdhPskServerKeyExchange)message);
                        break block0;
                    }
                    case NULL: {
                        this.LOGGER.info("Received unexpected ServerKeyExchange message in NULL key exchange mode.");
                        break block0;
                    }
                }
                throw new HandshakeException(String.format("Unsupported key exchange algorithm %s", this.getKeyExchangeAlgorithm().name()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, message.getPeer()));
            }
            case CERTIFICATE_REQUEST: {
                this.certificateRequest = (CertificateRequest)message;
                break;
            }
            case SERVER_HELLO_DONE: {
                this.receivedServerHelloDone((ServerHelloDone)message);
                this.expectChangeCipherSpecMessage();
                break;
            }
            case FINISHED: {
                this.receivedServerFinished((Finished)message);
                break;
            }
            default: {
                throw new HandshakeException(String.format("Received unexpected handshake message [%s] from peer %s", new Object[]{message.getMessageType(), message.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE, message.getPeer()));
            }
        }
    }

    private void receivedServerFinished(Finished message) throws HandshakeException, GeneralSecurityException {
        message.verifyData(this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), this.masterSecret, false, this.handshakeHash);
        this.sessionEstablished();
        this.handshakeCompleted();
    }

    protected void receivedHelloVerifyRequest(HelloVerifyRequest message) throws HandshakeException {
        this.handshakeMessages.clear();
        this.clientHello.setCookie(message.getCookie());
        this.flightNumber = 3;
        DTLSFlight flight = new DTLSFlight(this.getSession(), this.flightNumber);
        this.wrapMessage(flight, this.clientHello);
        this.sendFlight(flight);
        --this.statesIndex;
    }

    protected void receivedServerHello(ServerHello message) throws HandshakeException {
        ConnectionIdExtension extension;
        this.usedProtocol = message.getServerVersion();
        this.serverRandom = message.getRandom();
        this.session.setSessionIdentifier(message.getSessionId());
        CipherSuite cipherSuite = message.getCipherSuite();
        if (!this.preferredCipherSuites.contains((Object)cipherSuite)) {
            throw new HandshakeException("Server wants to use not supported cipher suite " + (Object)((Object)cipherSuite), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, message.getPeer()));
        }
        this.session.setCipherSuite(cipherSuite);
        CompressionMethod compressionMethod = message.getCompressionMethod();
        if (compressionMethod != CompressionMethod.NULL) {
            throw new HandshakeException("Server wants to use not supported compression method " + (Object)((Object)compressionMethod), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, message.getPeer()));
        }
        this.session.setCompressionMethod(message.getCompressionMethod());
        this.verifyServerHelloExtensions(message);
        if (this.connectionIdGenerator != null && (extension = message.getConnectionIdExtension()) != null) {
            ConnectionId connectionId = extension.getConnectionId();
            this.session.setWriteConnectionId(connectionId);
        }
        this.session.setSendCertificateType(message.getClientCertificateType());
        this.session.setSniSupported(message.hasServerNameExtension());
        this.session.setParameterAvailable();
        if (!cipherSuite.requiresServerCertificateMessage()) {
            this.states = NO_SEVER_CERTIFICATE;
        }
    }

    protected void verifyServerHelloExtensions(ServerHello message) throws HandshakeException {
        CertificateType serverCertificateType;
        SupportedPointFormatsExtension pointFormatsExtension;
        HelloExtensions serverExtensions = message.getExtensions();
        if (serverExtensions != null && !serverExtensions.isEmpty()) {
            HelloExtensions clientExtensions = this.clientHello.getExtensions();
            if (clientExtensions == null || clientExtensions.isEmpty()) {
                throw new HandshakeException("Server wants extensions, but client not!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNSUPPORTED_EXTENSION, message.getPeer()));
            }
            for (HelloExtension serverExtension : serverExtensions.getExtensions()) {
                if (clientExtensions.getExtension(serverExtension.getType()) != null) continue;
                throw new HandshakeException("Server wants " + (Object)((Object)serverExtension.getType()) + ", but client not!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNSUPPORTED_EXTENSION, message.getPeer()));
            }
        }
        if ((pointFormatsExtension = message.getSupportedPointFormatsExtension()) != null && !pointFormatsExtension.contains(SupportedPointFormatsExtension.ECPointFormat.UNCOMPRESSED)) {
            throw new HandshakeException("Server wants to use only not supported EC point formats!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, message.getPeer()));
        }
        MaxFragmentLengthExtension maxFragmentLengthExtension = message.getMaxFragmentLength();
        if (maxFragmentLengthExtension != null) {
            MaxFragmentLengthExtension.Length maxFragmentLength = maxFragmentLengthExtension.getFragmentLength();
            if (maxFragmentLength.code() == this.maxFragmentLengthCode.intValue()) {
                this.session.setMaxFragmentLength(maxFragmentLength.length());
            } else {
                throw new HandshakeException("Server wants to use other max. fragment size than proposed", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, message.getPeer()));
            }
        }
        if (!ClientHandshaker.isSupportedCertificateType(serverCertificateType = message.getServerCertificateType(), this.supportedServerCertificateTypes)) {
            throw new HandshakeException("Server wants to use not supported server certificate type " + (Object)((Object)serverCertificateType), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, message.getPeer()));
        }
        this.session.setReceiveCertificateType(serverCertificateType);
    }

    private void receivedServerCertificate(CertificateMessage message) throws HandshakeException {
        this.verifyCertificate(message);
        this.serverPublicKey = message.getPublicKey();
        this.peerCertPath = message.getCertificateChain();
    }

    private void receivedServerKeyExchange(ECDHServerKeyExchange message) throws HandshakeException {
        message.verifySignature(this.serverPublicKey, this.clientRandom, this.serverRandom);
        if (this.peerCertPath != null) {
            this.session.setPeerIdentity((Principal)new X509CertPath(this.peerCertPath));
        } else {
            this.session.setPeerIdentity((Principal)new RawPublicKeyIdentity(this.serverPublicKey));
        }
        this.ephemeralServerPublicKey = message.getPublicKey();
        try {
            this.ecdhe = new ECDHECryptography(this.ephemeralServerPublicKey.getParams());
        }
        catch (GeneralSecurityException e) {
            throw new HandshakeException(String.format("Cannot create ephemeral keys from domain params provided by server: %s", e.getMessage()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.getPeerAddress()));
        }
    }

    private void receivedServerKeyExchange(EcdhPskServerKeyExchange message) throws HandshakeException {
        this.ephemeralServerPublicKey = message.getPublicKey();
        try {
            this.ecdhe = new ECDHECryptography(this.ephemeralServerPublicKey.getParams());
        }
        catch (GeneralSecurityException e) {
            throw new HandshakeException(String.format("Cannot create ephemeral keys from domain params provided by server: %s", e.getMessage()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.getPeerAddress()));
        }
    }

    protected void receivedServerHelloDone(ServerHelloDone message) throws HandshakeException, GeneralSecurityException {
        MessageDigest mdWithClientFinished;
        SecretKey premasterSecret;
        ClientKeyExchange clientKeyExchange;
        this.flightNumber += 2;
        DTLSFlight flight = new DTLSFlight(this.getSession(), this.flightNumber);
        this.createCertificateMessage(flight);
        PskUtil pskUtil = null;
        switch (this.getKeyExchangeAlgorithm()) {
            case EC_DIFFIE_HELLMAN: {
                clientKeyExchange = new ECDHClientKeyExchange(this.ecdhe.getPublicKey(), this.session.getPeer());
                premasterSecret = this.ecdhe.generateSecret(this.ephemeralServerPublicKey);
                break;
            }
            case PSK: {
                pskUtil = new PskUtil(this.sniEnabled, this.session, this.pskStore);
                this.LOGGER.debug("Using PSK identity: {}", (Object)pskUtil.getPskPrincipal());
                clientKeyExchange = new PSKClientKeyExchange(pskUtil.getPskPublicIdentity(), this.session.getPeer());
                premasterSecret = pskUtil.generatePremasterSecretFromPSK(null);
                break;
            }
            case ECDHE_PSK: {
                pskUtil = new PskUtil(this.sniEnabled, this.session, this.pskStore);
                this.LOGGER.debug("Using PSK identity: {}", (Object)pskUtil.getPskPrincipal());
                clientKeyExchange = new EcdhPskClientKeyExchange(pskUtil.getPskPublicIdentity(), this.ecdhe.getPublicKey(), this.session.getPeer());
                SecretKey eck = this.ecdhe.generateSecret(this.ephemeralServerPublicKey);
                premasterSecret = pskUtil.generatePremasterSecretFromPSK(eck);
                SecretUtil.destroy(eck);
                break;
            }
            default: {
                throw new HandshakeException("Unknown key exchange algorithm: " + (Object)((Object)this.getKeyExchangeAlgorithm()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer()));
            }
        }
        SecretUtil.destroy(pskUtil);
        if (premasterSecret != null) {
            this.generateKeys(premasterSecret);
            SecretUtil.destroy(premasterSecret);
        }
        this.wrapMessage(flight, clientKeyExchange);
        if (this.certificateRequest != null && this.negotiatedSignatureAndHashAlgorithm != null) {
            CertificateType clientCertificateType = this.session.sendCertificateType();
            if (!ClientHandshaker.isSupportedCertificateType(clientCertificateType, this.supportedClientCertificateTypes)) {
                throw new HandshakeException("Server wants to use not supported client certificate type " + (Object)((Object)clientCertificateType), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, message.getPeer()));
            }
            CertificateVerify certificateVerify = new CertificateVerify(this.negotiatedSignatureAndHashAlgorithm, this.privateKey, this.handshakeMessages, this.session.getPeer());
            this.wrapMessage(flight, certificateVerify);
        }
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage(this.session.getPeer());
        this.wrapMessage(flight, changeCipherSpecMessage);
        this.setCurrentWriteState();
        MessageDigest md = this.getHandshakeMessageDigest();
        try {
            mdWithClientFinished = (MessageDigest)md.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HandshakeException("Cannot create FINISHED message", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, message.getPeer()));
        }
        Finished finished = new Finished(this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), this.masterSecret, this.isClient, md.digest(), this.session.getPeer());
        this.wrapMessage(flight, finished);
        mdWithClientFinished.update(finished.toByteArray());
        this.handshakeHash = mdWithClientFinished.digest();
        this.sendFlight(flight);
    }

    protected void createCertificateMessage(DTLSFlight flight) throws HandshakeException {
        if (this.certificateRequest != null) {
            CertificateMessage clientCertificate;
            if (CertificateType.RAW_PUBLIC_KEY == this.session.sendCertificateType()) {
                byte[] rawPublicKeyBytes = Bytes.EMPTY;
                PublicKey key = this.determineClientRawPublicKey(this.certificateRequest);
                if (key != null) {
                    rawPublicKeyBytes = key.getEncoded();
                }
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("sending CERTIFICATE message with client RawPublicKey [{}] to server", (Object)StringUtil.byteArray2HexString((byte[])rawPublicKeyBytes));
                }
                clientCertificate = new CertificateMessage(rawPublicKeyBytes, this.session.getPeer());
            } else if (CertificateType.X_509 == this.session.sendCertificateType()) {
                List<X509Certificate> clientChain = this.determineClientCertificateChain(this.certificateRequest);
                List<X509Certificate> truncatedChain = this.certificateRequest.removeTrustedCertificates(clientChain);
                this.LOGGER.debug("sending CERTIFICATE message with client certificate chain [length: {}] to server", (Object)truncatedChain.size());
                clientCertificate = new CertificateMessage(truncatedChain, this.session.getPeer());
            } else {
                throw new IllegalArgumentException("Certificate type " + (Object)((Object)this.session.sendCertificateType()) + " not supported!");
            }
            this.wrapMessage(flight, clientCertificate);
        }
    }

    PublicKey determineClientRawPublicKey(CertificateRequest certRequest) throws HandshakeException {
        if (this.publicKey == null) {
            return null;
        }
        this.negotiatedSignatureAndHashAlgorithm = certRequest.getSignatureAndHashAlgorithm(this.publicKey);
        if (this.negotiatedSignatureAndHashAlgorithm == null) {
            return null;
        }
        return this.publicKey;
    }

    List<X509Certificate> determineClientCertificateChain(CertificateRequest certRequest) throws HandshakeException {
        if (this.certificateChain == null) {
            return Collections.emptyList();
        }
        this.negotiatedSignatureAndHashAlgorithm = certRequest.getSignatureAndHashAlgorithm(this.certificateChain);
        if (this.negotiatedSignatureAndHashAlgorithm == null) {
            return Collections.emptyList();
        }
        return this.certificateChain;
    }

    private static boolean isSupportedCertificateType(CertificateType certType, List<CertificateType> supportedCertificateTypes) {
        if (supportedCertificateTypes != null) {
            return supportedCertificateTypes.contains((Object)certType);
        }
        return certType == CertificateType.X_509;
    }

    @Override
    public void startHandshake() throws HandshakeException {
        this.handshakeStarted();
        ClientHello startMessage = new ClientHello(this.maxProtocolVersion, this.preferredCipherSuites, this.supportedClientCertificateTypes, this.supportedServerCertificateTypes, this.session.getPeer());
        this.clientRandom = startMessage.getRandom();
        startMessage.addCompressionMethod(CompressionMethod.NULL);
        this.addConnectionId(startMessage);
        this.addMaxFragmentLength(startMessage);
        this.addServerNameIndication(startMessage);
        this.flightNumber = 1;
        this.clientHello = startMessage;
        DTLSFlight flight = new DTLSFlight(this.session, this.flightNumber);
        this.wrapMessage(flight, startMessage);
        this.sendFlight(flight);
        this.states = SEVER_CERTIFICATE;
        this.statesIndex = 0;
    }

    protected void addMaxFragmentLength(ClientHello helloMessage) {
        if (this.maxFragmentLengthCode != null) {
            MaxFragmentLengthExtension ext = new MaxFragmentLengthExtension(this.maxFragmentLengthCode);
            helloMessage.addExtension(ext);
            this.LOGGER.debug("Indicating max. fragment length [{}] to server [{}]", (Object)this.maxFragmentLengthCode, (Object)this.getPeerAddress());
        }
    }

    protected void addConnectionId(ClientHello helloMessage) {
        if (this.connectionIdGenerator != null) {
            ConnectionId connectionId = this.connectionIdGenerator.useConnectionId() ? this.getConnection().getConnectionId() : ConnectionId.EMPTY;
            ConnectionIdExtension extension = ConnectionIdExtension.fromConnectionId(connectionId);
            helloMessage.addExtension(extension);
        }
    }

    protected void addServerNameIndication(ClientHello helloMessage) {
        if (this.sniEnabled && this.session.getVirtualHost() != null) {
            this.LOGGER.debug("adding SNI extension to CLIENT_HELLO message [{}]", (Object)this.session.getVirtualHost());
            helloMessage.addExtension(ServerNameExtension.forHostName(this.session.getVirtualHost()));
        }
    }
}

