/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.util;

public class ByteArrayUtils {
    private static final char[] BIN_TO_HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static byte[] concatenate(byte[] a, byte[] b) {
        int lengthA = a.length;
        int lengthB = b.length;
        byte[] concat = new byte[lengthA + lengthB];
        System.arraycopy(a, 0, concat, 0, lengthA);
        System.arraycopy(b, 0, concat, lengthA, lengthB);
        return concat;
    }

    public static String toHexString(byte[] byteArray) {
        if (byteArray != null && byteArray.length != 0) {
            char[] bytesHexadecimal = new char[byteArray.length * 3];
            int dest = 0;
            for (int src = 0; src < byteArray.length; ++src) {
                int value = byteArray[src] & 0xFF;
                bytesHexadecimal[dest++] = BIN_TO_HEX_ARRAY[value >>> 4];
                bytesHexadecimal[dest++] = BIN_TO_HEX_ARRAY[value & 0xF];
                bytesHexadecimal[dest++] = 32;
            }
            return new String(bytesHexadecimal, 0, bytesHexadecimal.length - 1);
        }
        return "--";
    }

    public static String toHex(byte[] byteArray) {
        char[] bytesHexadecimal = new char[byteArray.length * 2];
        int dest = 0;
        for (int src = 0; src < byteArray.length; ++src) {
            int value = byteArray[src] & 0xFF;
            bytesHexadecimal[dest++] = BIN_TO_HEX_ARRAY[value >>> 4];
            bytesHexadecimal[dest++] = BIN_TO_HEX_ARRAY[value & 0xF];
        }
        return new String(bytesHexadecimal);
    }

    public static byte[] trimZeroes(byte[] byeArray) {
        int count;
        for (count = 0; count < byeArray.length - 1 && byeArray[count] == 0; ++count) {
        }
        if (count == 0) {
            return byeArray;
        }
        byte[] trimmedByteArray = new byte[byeArray.length - count];
        System.arraycopy(byeArray, count, trimmedByteArray, 0, trimmedByteArray.length);
        return trimmedByteArray;
    }
}

