/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.californium.elements.util.StandardCharsets;
import org.eclipse.californium.scandium.util.ByteArrayUtils;

public final class PseudoRandomFunction {
    public static final String ALGORITHM_HMAC_SHA256 = "HmacSHA256";

    private PseudoRandomFunction() {
    }

    static byte[] doPRF(byte[] secret, byte[] label, byte[] seed, int length) {
        try {
            Mac hmac = Mac.getInstance(ALGORITHM_HMAC_SHA256);
            hmac.init(new SecretKeySpec(secret, "MAC"));
            return PseudoRandomFunction.doExpansion(hmac, ByteArrayUtils.concatenate(label, seed), length);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(String.format("MAC algorithm %s is not available on JVM", ALGORITHM_HMAC_SHA256), e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Cannot run Pseudo Random Function with invalid key", e);
        }
    }

    public static final byte[] doPRF(byte[] secret, Label label, byte[] seed) {
        return PseudoRandomFunction.doPRF(secret, label.getBytes(), seed, label.length());
    }

    static final byte[] doExpansion(Mac hmac, byte[] data, int length) {
        int offset = 0;
        int macLength = hmac.getMacLength();
        byte[] aAndSeed = new byte[macLength + data.length];
        byte[] expansion = new byte[length];
        try {
            System.arraycopy(data, 0, aAndSeed, macLength, data.length);
            hmac.update(data);
            while (true) {
                hmac.doFinal(aAndSeed, 0);
                hmac.update(aAndSeed);
                int nextOffset = offset + macLength;
                if (nextOffset > length) {
                    hmac.doFinal(aAndSeed, 0);
                    System.arraycopy(aAndSeed, 0, expansion, offset, length - offset);
                } else {
                    hmac.doFinal(expansion, offset);
                    if (nextOffset != length) {
                        offset = nextOffset;
                        hmac.update(aAndSeed, 0, macLength);
                        continue;
                    }
                }
                break;
            }
        }
        catch (ShortBufferException e) {
            e.printStackTrace();
        }
        return expansion;
    }

    public static enum Label {
        MASTER_SECRET_LABEL("master secret", 48),
        KEY_EXPANSION_LABEL("key expansion", 128),
        CLIENT_FINISHED_LABEL("client finished", 12),
        SERVER_FINISHED_LABEL("server finished", 12);

        private String value;
        private int length;

        private Label(String value, int length) {
            this.value = value;
            this.length = length;
        }

        public String value() {
            return this.value;
        }

        public byte[] getBytes() {
            return this.value.getBytes(StandardCharsets.UTF_8);
        }

        public int length() {
            return this.length;
        }
    }
}

