/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.californium.elements.util.LeastRecentlyUsedCache;
import org.eclipse.californium.scandium.dtls.ClientSessionCache;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.ResumptionSupportingConnectionStore;
import org.eclipse.californium.scandium.dtls.SessionCache;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SessionTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InMemoryConnectionStore
implements ResumptionSupportingConnectionStore {
    private static final Logger LOG = LoggerFactory.getLogger((String)InMemoryConnectionStore.class.getName());
    private static final int DEFAULT_CACHE_SIZE = 150000;
    private static final long DEFAULT_EXPIRATION_THRESHOLD = 129600L;
    private final LeastRecentlyUsedCache<InetSocketAddress, Connection> connections;
    private final Map<SessionId, Connection> connectionsByEstablishedSession;
    private final SessionCache sessionCache;
    private String tag = "";

    public InMemoryConnectionStore() {
        this(150000, 129600L);
    }

    public InMemoryConnectionStore(SessionCache sessionCache) {
        this(150000, 129600L, sessionCache);
    }

    public InMemoryConnectionStore(int capacity, long threshold) {
        this(capacity, threshold, null);
    }

    public InMemoryConnectionStore(int capacity, long threshold, SessionCache sessionCache) {
        this.connections = new LeastRecentlyUsedCache(capacity, threshold);
        this.connections.setEvictingOnReadAccess(false);
        this.connections.setUpdatingOnReadAccess(false);
        this.connectionsByEstablishedSession = new HashMap<SessionId, Connection>();
        this.sessionCache = sessionCache;
        if (sessionCache != null) {
            this.connections.addEvictionListener((LeastRecentlyUsedCache.EvictionListener)new LeastRecentlyUsedCache.EvictionListener<Connection>(){

                public void onEviction(Connection staleConnection) {
                    InMemoryConnectionStore.this.removeFromEstablishedSessions(staleConnection);
                    InMemoryConnectionStore.this.removeSessionFromCache(staleConnection);
                }
            });
            if (sessionCache instanceof ClientSessionCache) {
                ClientSessionCache clientCache = (ClientSessionCache)sessionCache;
                LOG.debug("resume client sessions {}", (Object)clientCache);
                for (InetSocketAddress peer : clientCache) {
                    SessionTicket ticket = clientCache.getSessionTicket(peer);
                    SessionId id = clientCache.getSessionIdentity(peer);
                    if (ticket == null || id == null) continue;
                    Connection connection = new Connection(ticket, id);
                    connection.setResumptionRequired(true);
                    this.connections.put((Object)peer, (Object)connection);
                    LOG.debug("resume {} {}", (Object)peer, (Object)id);
                }
            }
        }
        LOG.info("Created new InMemoryConnectionStore [capacity: {}, connection expiration threshold: {}s]", (Object)capacity, (Object)threshold);
    }

    public synchronized void setTag(String tag) {
        this.tag = tag.endsWith(" ") ? tag : tag + " ";
    }

    @Override
    public synchronized boolean put(Connection connection) {
        if (connection != null) {
            if (this.connections.put((Object)connection.getPeerAddress(), (Object)connection)) {
                LOG.debug("{}connection: add {}", (Object)this.tag, (Object)connection.getPeerAddress());
                return true;
            }
            LOG.debug("{}connection store is full! {} max. entries.", (Object)this.tag, (Object)this.connections.getCapacity());
            this.dump();
            return false;
        }
        return false;
    }

    @Override
    public synchronized boolean update(Connection connection) {
        return connection != null && this.connections.update((Object)connection.getPeerAddress());
    }

    @Override
    public synchronized void putEstablishedSession(DTLSSession session, Connection connection) {
        SessionId sessionId = session.getSessionIdentifier();
        if (!sessionId.isEmpty()) {
            this.connectionsByEstablishedSession.put(session.getSessionIdentifier(), connection);
            if (this.sessionCache != null) {
                this.sessionCache.put(session);
            }
        }
    }

    @Override
    public synchronized Connection find(SessionId id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        Connection conFromLocalCache = this.findLocally(id);
        if (this.sessionCache == null) {
            return conFromLocalCache;
        }
        SessionTicket ticket = this.sessionCache.get(id);
        if (ticket == null) {
            if (conFromLocalCache != null) {
                this.remove(conFromLocalCache, false);
            }
            return null;
        }
        if (conFromLocalCache == null) {
            return new Connection(ticket, id);
        }
        return conFromLocalCache;
    }

    private synchronized Connection findLocally(SessionId id) {
        Connection connection = this.connectionsByEstablishedSession.get(id);
        if (connection != null) {
            this.connections.update((Object)connection.getPeerAddress());
        }
        return connection;
    }

    @Override
    public synchronized void markAllAsResumptionRequired() {
        for (Connection connection : this.connections.values()) {
            connection.setResumptionRequired(true);
            LOG.debug("{}connection: mark for resumption {}!", (Object)this.tag, (Object)connection.getPeerAddress());
        }
    }

    @Override
    public synchronized int remainingCapacity() {
        return this.connections.remainingCapacity();
    }

    @Override
    public synchronized Connection get(InetSocketAddress peerAddress) {
        return (Connection)this.connections.get((Object)peerAddress);
    }

    @Override
    public Connection remove(InetSocketAddress peerAddress) {
        return this.remove(peerAddress, true);
    }

    @Override
    public synchronized Connection remove(InetSocketAddress peerAddress, boolean removeFromSessionCache) {
        Connection connection = (Connection)this.connections.remove((Object)peerAddress);
        if (connection != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{}connection: remove {}:{}", new Object[]{this.tag, connection, peerAddress, new Throwable("connection removed!")});
            } else {
                LOG.debug("{}connection: remove {}", (Object)this.tag, (Object)peerAddress);
            }
            this.removeFromEstablishedSessions(connection);
            if (removeFromSessionCache) {
                this.removeSessionFromCache(connection);
            }
        }
        return connection;
    }

    @Override
    public boolean remove(Connection connection) {
        return this.remove(connection, true);
    }

    @Override
    public synchronized boolean remove(Connection connection, boolean removeFromSessionCache) {
        boolean removed;
        boolean bl = removed = this.connections.remove((Object)connection.getPeerAddress(), (Object)connection) == connection;
        if (removed) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{}connection: remove {}:{}", new Object[]{this.tag, connection, connection.getPeerAddress(), new Throwable("connection removed!")});
            } else {
                LOG.debug("{}connection: remove {}", (Object)this.tag, (Object)connection.getPeerAddress());
            }
            this.removeFromEstablishedSessions(connection);
            if (removeFromSessionCache) {
                this.removeSessionFromCache(connection);
            }
        }
        return removed;
    }

    private void removeFromEstablishedSessions(Connection connection) {
        SessionId sessionId;
        Connection removedConnection;
        DTLSSession establishedSession = connection.getEstablishedSession();
        if (establishedSession != null && (removedConnection = this.connectionsByEstablishedSession.remove(sessionId = establishedSession.getSessionIdentifier())) != connection) {
            this.connectionsByEstablishedSession.put(sessionId, removedConnection);
        }
    }

    private synchronized void removeSessionFromCache(Connection connection) {
        if (this.sessionCache != null && connection.hasEstablishedSession()) {
            this.sessionCache.remove(connection.getEstablishedSession().getSessionIdentifier());
        }
    }

    @Override
    public final synchronized void clear() {
        this.connections.clear();
        this.connectionsByEstablishedSession.clear();
    }

    public synchronized void dump() {
        if (this.connections.size() == 0) {
            LOG.debug("  {}connections empty!", (Object)this.tag);
        } else {
            for (Connection connection : this.connections.values()) {
                LOG.debug("  {}connection: {}", (Object)this.tag, (Object)connection.getPeerAddress());
            }
        }
    }
}

