/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.Record;

public class DTLSFlight {
    private final List<Record> messages;
    private final InetSocketAddress peerAddress;
    private final DTLSSession session;
    private final int flightNumber;
    private int tries;
    private int timeout = 0;
    private boolean retransmissionNeeded = false;
    private volatile boolean responseStarted;
    private volatile boolean responseCompleted;
    private ScheduledFuture<?> timeoutTask;

    public DTLSFlight(DTLSSession session, int flightNumber) {
        if (session == null) {
            throw new NullPointerException("Session must not be null");
        }
        if (session.getPeer() == null) {
            throw new NullPointerException("Peer address must not be null");
        }
        this.session = session;
        this.peerAddress = session.getPeer();
        this.messages = new ArrayList<Record>();
        this.retransmissionNeeded = true;
        this.flightNumber = flightNumber;
    }

    public void addMessage(List<Record> messagesToAdd) {
        this.messages.addAll(messagesToAdd);
    }

    public void addMessage(Record messageToAdd) {
        this.messages.add(messageToAdd);
    }

    public List<Record> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public InetSocketAddress getPeerAddress() {
        return this.peerAddress;
    }

    public DTLSSession getSession() {
        return this.session;
    }

    public int getFlightNumber() {
        return this.flightNumber;
    }

    public int getTries() {
        return this.tries;
    }

    public void incrementTries() {
        ++this.tries;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void incrementTimeout() {
        this.timeout *= 2;
    }

    public boolean isRetransmissionNeeded() {
        return this.retransmissionNeeded;
    }

    public void setRetransmissionNeeded(boolean needsRetransmission) {
        this.retransmissionNeeded = needsRetransmission;
    }

    public boolean isResponseStarted() {
        return this.responseStarted;
    }

    public void setResponseStarted() {
        this.responseStarted = true;
    }

    private final void cancelTimeout() {
        if (this.timeoutTask != null) {
            if (!this.timeoutTask.isDone()) {
                this.timeoutTask.cancel(true);
            }
            this.timeoutTask = null;
        }
    }

    public void setResponseCompleted() {
        this.responseCompleted = true;
        this.cancelTimeout();
    }

    public boolean isResponseCompleted() {
        return this.responseCompleted;
    }

    public void setTimeoutTask(ScheduledFuture<?> timeoutTask) {
        if (this.responseCompleted) {
            timeoutTask.cancel(true);
        } else {
            this.cancelTimeout();
            this.timeoutTask = timeoutTask;
        }
    }

    public void setNewSequenceNumbers() throws GeneralSecurityException {
        if (this.getTries() > 0 && this.session != null) {
            for (Record record : this.messages) {
                int epoch = record.getEpoch();
                record.setSequenceNumber(this.session.getSequenceNumber(epoch));
            }
        } else {
            throw new IllegalStateException("Can only set new sequence numbers for retransmitted flight with session");
        }
    }
}

