/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;

class DTLSConnectionState {
    private CipherSuite cipherSuite;
    private CompressionMethod compressionMethod;
    private SecretKey encryptionKey;
    private IvParameterSpec iv;
    private SecretKey macKey;

    DTLSConnectionState() {
        this(CipherSuite.TLS_NULL_WITH_NULL_NULL, CompressionMethod.NULL, null, null, null);
    }

    DTLSConnectionState(CipherSuite cipherSuite, CompressionMethod compressionMethod, SecretKey encryptionKey, IvParameterSpec iv, SecretKey macKey) {
        if (cipherSuite == null) {
            throw new NullPointerException("Cipher suite must not be null");
        }
        if (compressionMethod == null) {
            throw new NullPointerException("Compression method must not be null");
        }
        this.cipherSuite = cipherSuite;
        this.compressionMethod = compressionMethod;
        this.encryptionKey = encryptionKey;
        this.iv = iv;
        this.macKey = macKey;
    }

    CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public boolean hasValidCipherSuite() {
        return !CipherSuite.TLS_NULL_WITH_NULL_NULL.equals((Object)this.cipherSuite);
    }

    CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    SecretKey getEncryptionKey() {
        return this.encryptionKey;
    }

    IvParameterSpec getIv() {
        return this.iv;
    }

    SecretKey getMacKey() {
        return this.macKey;
    }

    int getMacLength() {
        return this.cipherSuite.getMacLength();
    }

    int getMacKeyLength() {
        return this.cipherSuite.getMacKeyLength();
    }

    int getRecordIvLength() {
        return this.cipherSuite.getRecordIvLength();
    }

    final int getMaxCiphertextExpansion() {
        return this.cipherSuite.getMaxCiphertextExpansion();
    }

    public final String toString() {
        StringBuilder b = new StringBuilder("DTLSConnectionState:");
        b.append(StringUtil.lineSeparator()).append("\tCipher suite: ").append((Object)this.cipherSuite);
        b.append(StringUtil.lineSeparator()).append("\tCompression method: ").append((Object)this.compressionMethod);
        b.append(StringUtil.lineSeparator()).append("\tIV: ").append(this.iv == null ? "null" : "not null");
        b.append(StringUtil.lineSeparator()).append("\tMAC key: ").append(this.macKey == null ? "null" : "not null");
        b.append(StringUtil.lineSeparator()).append("\tEncryption key: ").append(this.encryptionKey == null ? "null" : "not null");
        return b.toString();
    }
}

