/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SessionListener;
import org.eclipse.californium.scandium.dtls.SessionTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Connection {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Connection.class.getName());
    private final InetSocketAddress peerAddress;
    private final SessionTicket ticket;
    private final SessionId sessionId;
    private final SessionListener sessionListener;
    private final AtomicReference<Handshaker> ongoingHandshake = new AtomicReference();
    private final AtomicLong lastMessageNanos = new AtomicLong();
    private volatile DTLSSession establishedSession;
    private volatile boolean resumptionRequired = false;

    public Connection(InetSocketAddress peerAddress) {
        if (peerAddress == null) {
            throw new NullPointerException("Peer address must not be null");
        }
        this.sessionId = null;
        this.ticket = null;
        this.peerAddress = peerAddress;
        this.sessionListener = new ConnectionSessionListener();
    }

    public Connection(SessionTicket sessionTicket, SessionId sessionId) {
        if (sessionTicket == null) {
            throw new NullPointerException("session ticket must not be null");
        }
        if (sessionId == null) {
            throw new NullPointerException("session identity must not be null");
        }
        this.ticket = sessionTicket;
        this.sessionId = sessionId;
        this.peerAddress = null;
        this.sessionListener = null;
    }

    public final SessionListener getSessionListener() {
        return this.sessionListener;
    }

    public boolean isActive() {
        return this.establishedSession != null || this.ticket != null;
    }

    public SessionId getSessionIdentity() {
        return this.sessionId;
    }

    public SessionTicket getSessionTicket() {
        return this.ticket;
    }

    public boolean hasSessionTicket() {
        return this.ticket != null;
    }

    public InetSocketAddress getPeerAddress() {
        return this.peerAddress;
    }

    public DTLSSession getEstablishedSession() {
        return this.establishedSession;
    }

    public boolean hasEstablishedSession() {
        return this.establishedSession != null;
    }

    public Handshaker getOngoingHandshake() {
        return this.ongoingHandshake.get();
    }

    public boolean hasOngoingHandshake() {
        return this.ongoingHandshake.get() != null;
    }

    public boolean hasOngoingHandshakeStartedByMessage(HandshakeMessage handshakeMessage) {
        Handshaker handshaker = this.ongoingHandshake.get();
        return handshaker != null && handshaker.hasBeenStartedByMessage(handshakeMessage);
    }

    public void cancelPendingFlight() {
        Handshaker handshaker = this.ongoingHandshake.get();
        if (handshaker != null) {
            handshaker.cancelPendingFlight();
        }
    }

    public DTLSSession getSession(int readEpoch) {
        DTLSSession session = this.establishedSession;
        if (session != null && session.getReadEpoch() == readEpoch) {
            return session;
        }
        Handshaker handshaker = this.ongoingHandshake.get();
        if (handshaker != null && (session = handshaker.getSession()) != null && session.getReadEpoch() == readEpoch) {
            return session;
        }
        return null;
    }

    public boolean isResumptionRequired() {
        return this.resumptionRequired;
    }

    public boolean isAutoResumptionRequired(Long autoResumptionTimeoutMillis) {
        if (!this.resumptionRequired && autoResumptionTimeoutMillis != null && this.establishedSession != null) {
            if (autoResumptionTimeoutMillis == 0L) {
                this.setResumptionRequired(true);
            } else {
                long expires;
                long now = ClockUtil.nanoRealtime();
                if (now - (expires = this.lastMessageNanos.get() + TimeUnit.MILLISECONDS.toNanos(autoResumptionTimeoutMillis)) > 0L) {
                    this.setResumptionRequired(true);
                }
            }
        }
        return this.resumptionRequired;
    }

    public void refreshAutoResumptionTime() {
        long now = ClockUtil.nanoRealtime();
        this.lastMessageNanos.set(now);
    }

    public void setResumptionRequired(boolean resumptionRequired) {
        this.resumptionRequired = resumptionRequired;
    }

    private class ConnectionSessionListener
    implements SessionListener {
        private ConnectionSessionListener() {
        }

        @Override
        public void handshakeStarted(Handshaker handshaker) throws HandshakeException {
            Connection.this.ongoingHandshake.set(handshaker);
            LOGGER.debug("Handshake with [{}] has been started", (Object)handshaker.getPeerAddress());
        }

        @Override
        public void sessionEstablished(Handshaker handshaker, DTLSSession session) throws HandshakeException {
            Connection.this.establishedSession = session;
            LOGGER.debug("Session with [{}] has been established", (Object)session.getPeer());
        }

        @Override
        public void handshakeCompleted(Handshaker handshaker) {
            if (Connection.this.ongoingHandshake.compareAndSet(handshaker, null)) {
                LOGGER.debug("Handshake with [{}] has been completed", (Object)handshaker.getPeerAddress());
            }
        }

        @Override
        public void handshakeFailed(Handshaker handshaker, Throwable error) {
            if (Connection.this.ongoingHandshake.compareAndSet(handshaker, null)) {
                LOGGER.debug("Handshake with [{}] has failed", (Object)handshaker.getPeerAddress());
            }
        }

        @Override
        public void handshakeFlightRetransmitted(Handshaker handshaker, int flight) {
        }
    }
}

