/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.config;

import java.net.InetSocketAddress;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.dtls.rpkstore.TrustAllRpks;
import org.eclipse.californium.scandium.dtls.rpkstore.TrustedRpkStore;
import org.eclipse.californium.scandium.dtls.x509.CertificateVerifier;
import org.eclipse.californium.scandium.dtls.x509.StaticCertificateVerifier;
import org.eclipse.californium.scandium.util.ListUtils;

public final class DtlsConnectorConfig {
    public static final int DEFAULT_MAX_DEFERRED_PROCESSED_APPLICATION_DATA_MESSAGES = 10;
    public static final int DEFAULT_MAX_CONNECTIONS = 150000;
    public static final long DEFAULT_STALE_CONNECTION_TRESHOLD = 1800L;
    public static final int DEFAULT_RETRANSMISSION_TIMEOUT_MS = 1000;
    public static final int DEFAULT_MAX_RETRANSMISSIONS = 4;
    public static final int DEFAULT_VERIFY_PEERS_ON_RESUMPTION_THRESHOLD_IN_PERCENT = 30;
    private static final int DEFAULT_EXECUTOR_THREAD_POOL_SIZE = 6 * Runtime.getRuntime().availableProcessors();
    private static final int DEFAULT_RECEIVER_THREADS = (Runtime.getRuntime().availableProcessors() + 1) / 2;
    private static final String EC_ALGORITHM_NAME = "EC";
    private InetSocketAddress address;
    private X509Certificate[] trustStore;
    private CertificateVerifier certificateVerifier;
    private Boolean earlyStopRetransmission;
    private Boolean enableReuseAddress;
    private Integer maxFragmentLengthCode;
    private Integer retransmissionTimeout;
    private Integer maxRetransmissions;
    private Integer maxTransmissionUnit;
    private Boolean clientAuthenticationWanted;
    private Boolean clientAuthenticationRequired;
    private Boolean serverOnly;
    private List<CertificateType> identityCertificateTypes;
    private List<CertificateType> trustCertificateTypes;
    private PskStore pskStore;
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private List<X509Certificate> certChain;
    private List<CipherSuite> supportedCipherSuites;
    private TrustedRpkStore trustedRPKs;
    private Integer outboundMessageBufferSize;
    private Integer maxDeferredProcessedApplicationDataMessages;
    private Integer maxConnections;
    private Long staleConnectionThreshold;
    private Integer connectionThreadCount;
    private Integer receiverThreadCount;
    private Long autoResumptionTimeoutMillis;
    private Boolean sniEnabled;
    private Integer verifyPeersOnResumptionThreshold;
    private Boolean useNoServerSessionId;

    private DtlsConnectorConfig() {
    }

    public Integer getMaxFragmentLengthCode() {
        return this.maxFragmentLengthCode;
    }

    public Integer getRetransmissionTimeout() {
        return this.retransmissionTimeout;
    }

    public Integer getMaxDeferredProcessedApplicationDataMessages() {
        return this.maxDeferredProcessedApplicationDataMessages;
    }

    public Integer getMaxRetransmissions() {
        return this.maxRetransmissions;
    }

    public Integer getMaxTransmissionUnit() {
        return this.maxTransmissionUnit;
    }

    public Boolean isEarlyStopRetransmission() {
        return this.earlyStopRetransmission;
    }

    public Boolean isAddressReuseEnabled() {
        return this.enableReuseAddress;
    }

    public Boolean isSniEnabled() {
        return this.sniEnabled;
    }

    public Integer getVerifyPeersOnResumptionThreshold() {
        return this.verifyPeersOnResumptionThreshold;
    }

    public Integer getOutboundMessageBufferSize() {
        return this.outboundMessageBufferSize;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public List<X509Certificate> getCertificateChain() {
        return this.certChain;
    }

    public List<CipherSuite> getSupportedCipherSuites() {
        return this.supportedCipherSuites;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PskStore getPskStore() {
        return this.pskStore;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Deprecated
    public X509Certificate[] getTrustStore() {
        if (this.trustStore == null) {
            return null;
        }
        return Arrays.copyOf(this.trustStore, this.trustStore.length);
    }

    public CertificateVerifier getCertificateVerifier() {
        return this.certificateVerifier;
    }

    public Boolean isClientAuthenticationWanted() {
        return this.clientAuthenticationWanted;
    }

    public Boolean isClientAuthenticationRequired() {
        return this.clientAuthenticationRequired;
    }

    public Boolean isServerOnly() {
        return this.serverOnly;
    }

    public List<CertificateType> getIdentityCertificateTypes() {
        return this.identityCertificateTypes;
    }

    public List<CertificateType> getTrustCertificateTypes() {
        return this.trustCertificateTypes;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public Long getStaleConnectionThreshold() {
        return this.staleConnectionThreshold;
    }

    public Integer getConnectionThreadCount() {
        return this.connectionThreadCount;
    }

    public Integer getReceiverThreadCount() {
        return this.receiverThreadCount;
    }

    public Long getAutoResumptionTimeoutMillis() {
        return this.autoResumptionTimeoutMillis;
    }

    public Boolean useNoServerSessionId() {
        return this.useNoServerSessionId;
    }

    public TrustedRpkStore getRpkTrustStore() {
        return this.trustedRPKs;
    }

    protected Object clone() {
        DtlsConnectorConfig cloned = new DtlsConnectorConfig();
        cloned.address = this.address;
        cloned.trustStore = this.trustStore;
        cloned.certificateVerifier = this.certificateVerifier;
        cloned.earlyStopRetransmission = this.earlyStopRetransmission;
        cloned.enableReuseAddress = this.enableReuseAddress;
        cloned.maxFragmentLengthCode = this.maxFragmentLengthCode;
        cloned.retransmissionTimeout = this.retransmissionTimeout;
        cloned.maxRetransmissions = this.maxRetransmissions;
        cloned.maxTransmissionUnit = this.maxTransmissionUnit;
        cloned.clientAuthenticationRequired = this.clientAuthenticationRequired;
        cloned.clientAuthenticationWanted = this.clientAuthenticationWanted;
        cloned.serverOnly = this.serverOnly;
        cloned.identityCertificateTypes = this.identityCertificateTypes;
        cloned.trustCertificateTypes = this.trustCertificateTypes;
        cloned.pskStore = this.pskStore;
        cloned.privateKey = this.privateKey;
        cloned.publicKey = this.publicKey;
        cloned.certChain = this.certChain;
        cloned.supportedCipherSuites = this.supportedCipherSuites;
        cloned.trustedRPKs = this.trustedRPKs;
        cloned.outboundMessageBufferSize = this.outboundMessageBufferSize;
        cloned.maxDeferredProcessedApplicationDataMessages = this.maxDeferredProcessedApplicationDataMessages;
        cloned.maxConnections = this.maxConnections;
        cloned.staleConnectionThreshold = this.staleConnectionThreshold;
        cloned.connectionThreadCount = this.connectionThreadCount;
        cloned.receiverThreadCount = this.receiverThreadCount;
        cloned.autoResumptionTimeoutMillis = this.autoResumptionTimeoutMillis;
        cloned.sniEnabled = this.sniEnabled;
        cloned.verifyPeersOnResumptionThreshold = this.verifyPeersOnResumptionThreshold;
        cloned.useNoServerSessionId = this.useNoServerSessionId;
        return cloned;
    }

    static /* synthetic */ X509Certificate[] access$1902(DtlsConnectorConfig x0, X509Certificate[] x1) {
        x0.trustStore = x1;
        return x1;
    }

    public static final class Builder {
        private DtlsConnectorConfig config;
        private boolean clientOnly;

        public Builder() {
            this.config = new DtlsConnectorConfig();
        }

        public Builder(DtlsConnectorConfig initialConfiguration) {
            this.config = (DtlsConnectorConfig)initialConfiguration.clone();
        }

        public Builder setAddress(InetSocketAddress address) {
            if (address.isUnresolved()) {
                throw new IllegalArgumentException("Bind address must not be unresolved");
            }
            this.config.address = address;
            return this;
        }

        public Builder setEnableAddressReuse(boolean enable) {
            this.config.enableReuseAddress = enable;
            return this;
        }

        public Builder setClientOnly() {
            if (this.config.clientAuthenticationRequired != null || this.config.clientAuthenticationWanted != null) {
                throw new IllegalStateException("client only is not support with server side client authentication!");
            }
            if (this.config.serverOnly != null) {
                throw new IllegalStateException("client only is not support with server only!");
            }
            if (this.config.useNoServerSessionId != null && this.config.useNoServerSessionId.booleanValue()) {
                throw new IllegalStateException("client only is not support with no server session id!");
            }
            this.clientOnly = true;
            return this;
        }

        public Builder setServerOnly(boolean enable) {
            if (this.clientOnly) {
                throw new IllegalStateException("server only is not supported for client only!");
            }
            this.config.serverOnly = enable;
            return this;
        }

        public Builder setMaxFragmentLengthCode(Integer lengthCode) {
            if (lengthCode != null && (lengthCode < 1 || lengthCode > 4)) {
                throw new IllegalArgumentException("Maximum fragment length code must be one of {1, 2, 3, 4}");
            }
            this.config.maxFragmentLengthCode = lengthCode;
            return this;
        }

        public Builder setOutboundMessageBufferSize(int capacity) {
            if (capacity < 1) {
                throw new IllegalArgumentException("Outbound message buffer size must be at least 1");
            }
            this.config.outboundMessageBufferSize = capacity;
            return this;
        }

        public Builder setMaxRetransmissions(int count) {
            if (count < 1) {
                throw new IllegalArgumentException("Maximum number of retransmissions must be greater than zero");
            }
            this.config.maxRetransmissions = count;
            return this;
        }

        public Builder setMaxTransmissionUnit(int mtu) {
            this.config.maxTransmissionUnit = mtu;
            return this;
        }

        public Builder setClientAuthenticationWanted(boolean authWanted) {
            if (this.clientOnly) {
                throw new IllegalStateException("client authentication is not supported for client only!");
            }
            if (authWanted && Boolean.TRUE.equals(this.config.clientAuthenticationRequired)) {
                throw new IllegalStateException("client authentication is already required!");
            }
            this.config.clientAuthenticationWanted = authWanted;
            return this;
        }

        public Builder setClientAuthenticationRequired(boolean authRequired) {
            if (this.clientOnly) {
                throw new IllegalStateException("client authentication is not supported for client only!");
            }
            if (authRequired && Boolean.TRUE.equals(this.config.clientAuthenticationWanted)) {
                throw new IllegalStateException("client authentication is already wanted!");
            }
            this.config.clientAuthenticationRequired = authRequired;
            return this;
        }

        public Builder setSupportedCipherSuites(CipherSuite ... cipherSuites) {
            if (cipherSuites == null) {
                throw new NullPointerException("Connector must support at least one cipher suite");
            }
            return this.setSupportedCipherSuites(Arrays.asList(cipherSuites));
        }

        public Builder setSupportedCipherSuites(List<CipherSuite> cipherSuites) {
            if (cipherSuites == null) {
                throw new NullPointerException("Connector must support at least one cipher suite");
            }
            if (cipherSuites.isEmpty()) {
                throw new IllegalArgumentException("Connector must support at least one cipher suite");
            }
            if (cipherSuites.contains((Object)CipherSuite.TLS_NULL_WITH_NULL_NULL)) {
                throw new IllegalArgumentException("NULL Cipher Suite is not supported by connector");
            }
            this.config.supportedCipherSuites = cipherSuites;
            return this;
        }

        public Builder setSupportedCipherSuites(String ... cipherSuites) {
            if (cipherSuites == null) {
                throw new NullPointerException("Connector must support at least one cipher suite");
            }
            ArrayList<CipherSuite> suites = new ArrayList<CipherSuite>(cipherSuites.length);
            for (int i = 0; i < cipherSuites.length; ++i) {
                CipherSuite knownSuite = CipherSuite.getTypeByName(cipherSuites[i]);
                if (knownSuite == null) {
                    throw new IllegalArgumentException(String.format("Cipher suite [%s] is not (yet) supported", cipherSuites[i]));
                }
                suites.add(knownSuite);
            }
            return this.setSupportedCipherSuites(suites);
        }

        public Builder setEarlyStopRetransmission(boolean activate) {
            this.config.earlyStopRetransmission = activate;
            return this;
        }

        public Builder setRetransmissionTimeout(int timeout) {
            if (timeout < 0) {
                throw new IllegalArgumentException("Retransmission timeout must not be negative");
            }
            this.config.retransmissionTimeout = timeout;
            return this;
        }

        public Builder setPskStore(PskStore pskStore) {
            this.config.pskStore = pskStore;
            return this;
        }

        public Builder setIdentity(PrivateKey privateKey, PublicKey publicKey) {
            if (privateKey == null) {
                throw new NullPointerException("The private key must not be null");
            }
            if (publicKey == null) {
                throw new NullPointerException("The public key must not be null");
            }
            this.config.privateKey = privateKey;
            this.config.publicKey = publicKey;
            this.config.certChain = null;
            this.config.identityCertificateTypes = new ArrayList(1);
            this.config.identityCertificateTypes.add(CertificateType.RAW_PUBLIC_KEY);
            return this;
        }

        public Builder setIdentity(PrivateKey privateKey, Certificate[] certificateChain, CertificateType ... certificateTypes) {
            if (certificateTypes == null || certificateTypes.length == 0) {
                return this.setIdentity(privateKey, certificateChain, (List<CertificateType>)null);
            }
            return this.setIdentity(privateKey, certificateChain, Arrays.asList(certificateTypes));
        }

        public Builder setIdentity(PrivateKey privateKey, Certificate[] certificateChain, List<CertificateType> certificateTypes) {
            if (privateKey == null) {
                throw new NullPointerException("The private key must not be null!");
            }
            if (certificateChain == null) {
                throw new NullPointerException("The certificate chain must not be null!");
            }
            if (certificateChain.length < 1) {
                throw new IllegalArgumentException("The certificate chain must not be empty!");
            }
            if (certificateTypes != null && certificateTypes.isEmpty()) {
                throw new IllegalArgumentException("The certificate types must not be empty!");
            }
            if (certificateTypes != null) {
                for (CertificateType certificateType : certificateTypes) {
                    if (certificateType.isSupported()) continue;
                    throw new IllegalArgumentException("The certificate type " + (Object)((Object)certificateType) + " is not supported!");
                }
            }
            this.config.privateKey = privateKey;
            this.config.certChain = Arrays.asList(SslContextUtil.asX509Certificates((Certificate[])certificateChain));
            this.config.publicKey = ((X509Certificate)this.config.certChain.get(0)).getPublicKey();
            if (certificateTypes == null) {
                this.config.identityCertificateTypes = new ArrayList(1);
                this.config.identityCertificateTypes.add(CertificateType.X_509);
            } else {
                this.config.identityCertificateTypes = certificateTypes;
                if (!this.config.identityCertificateTypes.contains((Object)CertificateType.X_509)) {
                    this.config.certChain = null;
                }
            }
            return this;
        }

        public Builder setTrustStore(Certificate[] trustedCerts) {
            if (trustedCerts == null) {
                throw new NullPointerException("Trust store must not be null");
            }
            if (trustedCerts.length == 0) {
                DtlsConnectorConfig.access$1902(this.config, new X509Certificate[0]);
            } else {
                DtlsConnectorConfig.access$1902(this.config, SslContextUtil.asX509Certificates((Certificate[])trustedCerts));
            }
            return this;
        }

        public Builder setCertificateVerifier(CertificateVerifier verifier) {
            if (verifier == null) {
                throw new NullPointerException("CertificateVerifier must not be null");
            }
            this.config.certificateVerifier = verifier;
            return this;
        }

        public Builder setRpkTrustStore(TrustedRpkStore store) {
            if (store == null) {
                throw new IllegalStateException("Must provide a non-null rpk trust store");
            }
            this.config.trustedRPKs = store;
            return this;
        }

        public Builder setRpkTrustAll() {
            this.config.trustedRPKs = new TrustAllRpks();
            return this;
        }

        public Builder setTrustCertificateTypes(CertificateType ... certificateTypes) {
            if (certificateTypes == null) {
                throw new NullPointerException("CertificateTypes must not be null!");
            }
            if (certificateTypes.length == 0) {
                throw new IllegalArgumentException("CertificateTypes must not be empty!");
            }
            for (CertificateType certificateType : certificateTypes) {
                if (certificateType.isSupported()) continue;
                throw new IllegalArgumentException("The certificate type " + (Object)((Object)certificateType) + " is not supported!");
            }
            this.config.trustCertificateTypes = Arrays.asList(certificateTypes);
            return this;
        }

        public Builder setMaxDeferredProcessedApplicationDataMessages(int maxDeferredProcessedApplicationDataMessages) {
            if (maxDeferredProcessedApplicationDataMessages < 0) {
                throw new IllegalArgumentException("Max deferred processed application data messages must not be negative!");
            }
            this.config.maxDeferredProcessedApplicationDataMessages = maxDeferredProcessedApplicationDataMessages;
            return this;
        }

        public Builder setMaxConnections(int maxConnections) {
            if (maxConnections < 1) {
                throw new IllegalArgumentException("Max connections must be at least 1");
            }
            this.config.maxConnections = maxConnections;
            return this;
        }

        public Builder setStaleConnectionThreshold(long threshold) {
            if (threshold < 1L) {
                throw new IllegalArgumentException("Threshold must be at least 1 second");
            }
            this.config.staleConnectionThreshold = threshold;
            return this;
        }

        public Builder setConnectionThreadCount(int threadCount) {
            this.config.connectionThreadCount = threadCount;
            return this;
        }

        public Builder setReceiverThreadCount(int threadCount) {
            this.config.receiverThreadCount = threadCount;
            return this;
        }

        public Builder setAutoResumptionTimeoutMillis(long timeoutInMillis) {
            if (timeoutInMillis < 1L) {
                throw new IllegalArgumentException("auto resumption timeout must not below 1!");
            }
            this.config.autoResumptionTimeoutMillis = timeoutInMillis;
            return this;
        }

        public Builder setSniEnabled(boolean flag) {
            this.config.sniEnabled = flag;
            return this;
        }

        public Builder setVerifyPeersOnResumptionThreshold(int threshold) {
            if (threshold < 0 || threshold > 100) {
                throw new IllegalArgumentException("threshold must be between 0 and 100, but is " + threshold + "!");
            }
            this.config.verifyPeersOnResumptionThreshold = threshold;
            return this;
        }

        public Builder setNoServerSessionId(boolean flag) {
            if (this.clientOnly && flag) {
                throw new IllegalArgumentException("not applicable for client only!");
            }
            this.config.useNoServerSessionId = flag;
            return this;
        }

        private boolean isConfiguredWithKeyPair() {
            return this.config.privateKey != null && this.config.publicKey != null;
        }

        public DtlsConnectorConfig getIncompleteConfig() {
            return this.config;
        }

        public DtlsConnectorConfig build() {
            if (this.config.address == null) {
                this.config.address = new InetSocketAddress(0);
            }
            if (this.config.enableReuseAddress == null) {
                this.config.enableReuseAddress = false;
            }
            if (this.config.earlyStopRetransmission == null) {
                this.config.earlyStopRetransmission = true;
            }
            if (this.config.retransmissionTimeout == null) {
                this.config.retransmissionTimeout = 1000;
            }
            if (this.config.maxRetransmissions == null) {
                this.config.maxRetransmissions = 4;
            }
            if (this.config.clientAuthenticationRequired == null) {
                this.config.clientAuthenticationRequired = true;
            }
            if (this.config.clientAuthenticationWanted == null) {
                this.config.clientAuthenticationWanted = false;
            }
            if (this.config.serverOnly == null) {
                this.config.serverOnly = false;
            }
            if (this.config.useNoServerSessionId == null) {
                this.config.useNoServerSessionId = false;
            }
            if (this.config.outboundMessageBufferSize == null) {
                this.config.outboundMessageBufferSize = 100000;
            }
            if (this.config.maxDeferredProcessedApplicationDataMessages == null) {
                this.config.maxDeferredProcessedApplicationDataMessages = 10;
            }
            if (this.config.maxConnections == null) {
                this.config.maxConnections = 150000;
            }
            if (this.config.connectionThreadCount == null) {
                this.config.connectionThreadCount = DEFAULT_EXECUTOR_THREAD_POOL_SIZE;
            }
            if (this.config.receiverThreadCount == null) {
                this.config.receiverThreadCount = DEFAULT_RECEIVER_THREADS;
            }
            if (this.config.staleConnectionThreshold == null) {
                this.config.staleConnectionThreshold = 1800L;
            }
            if (this.config.sniEnabled == null) {
                this.config.sniEnabled = Boolean.TRUE;
            }
            if (this.config.verifyPeersOnResumptionThreshold == null) {
                this.config.verifyPeersOnResumptionThreshold = 30;
            }
            if (this.config.certificateVerifier == null && this.config.trustStore != null) {
                this.config.certificateVerifier = new StaticCertificateVerifier(this.config.trustStore);
            }
            if (this.config.trustCertificateTypes == null && (this.config.trustedRPKs != null || this.config.certificateVerifier != null)) {
                this.config.trustCertificateTypes = new ArrayList(2);
                if (this.config.trustedRPKs != null) {
                    this.config.trustCertificateTypes.add(CertificateType.RAW_PUBLIC_KEY);
                }
                if (this.config.certificateVerifier != null) {
                    this.config.trustCertificateTypes.add(CertificateType.X_509);
                }
            }
            if (!this.config.clientAuthenticationRequired.booleanValue() && !this.config.clientAuthenticationWanted.booleanValue() && this.config.trustCertificateTypes != null) {
                throw new IllegalStateException("configured trusted certificates or certificate verifier are not used for disabled client authentication!");
            }
            if (this.config.supportedCipherSuites == null || this.config.supportedCipherSuites.isEmpty()) {
                this.determineCipherSuitesFromConfig();
            }
            if (this.config.supportedCipherSuites == null || this.config.supportedCipherSuites.isEmpty()) {
                throw new IllegalStateException("Supported cipher suites must be set either explicitly or implicitly by means of setting the identity or PSK store");
            }
            if (this.config.trustCertificateTypes != null) {
                if (this.config.trustCertificateTypes.contains((Object)CertificateType.RAW_PUBLIC_KEY) && this.config.trustedRPKs == null) {
                    throw new IllegalStateException("rpk trust must be set for trust certificate type RAW_PUBLIC_KEY");
                }
                if (this.config.trustCertificateTypes.contains((Object)CertificateType.X_509) && this.config.certificateVerifier == null) {
                    throw new IllegalStateException("trusted certificates or certificate verifier must be set for trust certificate type X_509");
                }
            }
            boolean certifacte = false;
            boolean psk = false;
            for (CipherSuite suite : this.config.supportedCipherSuites) {
                switch (suite) {
                    case TLS_PSK_WITH_AES_128_CCM_8: 
                    case TLS_PSK_WITH_AES_128_CBC_SHA256: 
                    case TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256: {
                        this.verifyPskBasedCipherConfig(suite);
                        psk = true;
                        break;
                    }
                    case TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8: 
                    case TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256: {
                        this.verifyEcBasedCipherConfig(suite);
                        certifacte = true;
                        break;
                    }
                }
            }
            if (!psk && this.config.pskStore != null) {
                throw new IllegalStateException("PSK store set, but no PSK cipher suite!");
            }
            if (!certifacte) {
                if (this.config.privateKey != null || this.config.publicKey != null) {
                    throw new IllegalStateException("Identity set, but no certificate based cipher suite!");
                }
                if (this.config.trustedRPKs != null || this.config.certificateVerifier != null) {
                    throw new IllegalStateException("certificate trust set, but no certificate based cipher suite!");
                }
            }
            this.config.trustCertificateTypes = ListUtils.init(this.config.trustCertificateTypes);
            this.config.identityCertificateTypes = ListUtils.init(this.config.identityCertificateTypes);
            this.config.supportedCipherSuites = ListUtils.init(this.config.supportedCipherSuites);
            this.config.certChain = ListUtils.init(this.config.certChain);
            return this.config;
        }

        private void verifyPskBasedCipherConfig(CipherSuite suite) {
            if (this.config.pskStore == null) {
                throw new IllegalStateException("PSK store must be set for configured " + suite.name());
            }
        }

        private void verifyEcBasedCipherConfig(CipherSuite suite) {
            if (this.config.privateKey == null || this.config.publicKey == null) {
                if (!this.clientOnly) {
                    throw new IllegalStateException("Identity must be set for configured " + suite.name());
                }
            } else if (!(!suite.isEccBased() || DtlsConnectorConfig.EC_ALGORITHM_NAME.equals(this.config.privateKey.getAlgorithm()) && DtlsConnectorConfig.EC_ALGORITHM_NAME.equals(this.config.publicKey.getAlgorithm()))) {
                throw new IllegalStateException("Keys must be ECDSA capable for configured " + suite.name());
            }
            if (this.config.clientAuthenticationRequired.booleanValue() || this.config.clientAuthenticationWanted.booleanValue()) {
                if (this.config.trustCertificateTypes == null) {
                    throw new IllegalStateException("trust must be set for configured " + suite.name());
                }
                if (this.config.trustCertificateTypes.contains((Object)CertificateType.RAW_PUBLIC_KEY) && this.config.trustedRPKs == null) {
                    throw new IllegalStateException("Raw public key trust must be set for configured " + suite.name());
                }
                if (this.config.trustCertificateTypes.contains((Object)CertificateType.X_509) && this.config.certificateVerifier == null) {
                    throw new IllegalStateException("X509 certficate trust must be set for configured " + suite.name());
                }
            }
        }

        private void determineCipherSuitesFromConfig() {
            boolean certificates;
            ArrayList<CipherSuite> ciphers = new ArrayList<CipherSuite>();
            boolean bl = certificates = this.isConfiguredWithKeyPair() || this.config.trustCertificateTypes != null;
            if (certificates) {
                ciphers.add(CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8);
                ciphers.add(CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256);
            }
            if (this.config.pskStore != null) {
                ciphers.add(CipherSuite.TLS_PSK_WITH_AES_128_CCM_8);
                ciphers.add(CipherSuite.TLS_PSK_WITH_AES_128_CBC_SHA256);
                ciphers.add(CipherSuite.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256);
            }
            this.config.supportedCipherSuites = ciphers;
        }
    }
}

