/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.util;

import org.eclipse.californium.elements.auth.PreSharedKeyIdentity;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.util.ServerName;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PskUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PskUtil.class.getName());
    private byte[] psk;
    private PreSharedKeyIdentity pskIdentity;

    public PskUtil(boolean sniEnabled, DTLSSession session, PskStore pskStore) throws HandshakeException {
        if (session == null) {
            throw new NullPointerException("Dtls session cannot be null");
        }
        if (pskStore == null) {
            throw new NullPointerException("psk store cannot be null");
        }
        String virtualHostName = session.getVirtualHost();
        String identity = null;
        if (sniEnabled && virtualHostName != null) {
            ServerNames virtualHost = ServerNames.newInstance().add(ServerName.fromHostName(virtualHostName));
            if (!session.isSniSupported()) {
                LOGGER.warn("client is configured to use SNI but server does not support it, PSK authentication is likely to fail");
            }
            if ((identity = pskStore.getIdentity(session.getPeer(), virtualHost)) == null) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, session.getPeer());
                throw new HandshakeException(String.format("No Identity found for peer [address: %s, virtual host: %s]", session.getPeer(), virtualHostName), alert);
            }
            this.psk = pskStore.getKey(virtualHost, identity);
            if (this.psk == null) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, session.getPeer());
                throw new HandshakeException(String.format("No pre-shared key found for [virtual host: %s, identity: %s]", virtualHostName, identity), alert);
            }
            this.pskIdentity = new PreSharedKeyIdentity(virtualHostName, identity);
        } else {
            identity = pskStore.getIdentity(session.getPeer());
            if (identity == null) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, session.getPeer());
                throw new HandshakeException(String.format("No Identity found for peer [address: %s]", session.getPeer()), alert);
            }
            this.psk = pskStore.getKey(identity);
            if (this.psk == null) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, session.getPeer());
                throw new HandshakeException(String.format("No pre-shared key found for [identity: %s]", identity), alert);
            }
            this.pskIdentity = new PreSharedKeyIdentity(identity);
        }
    }

    public PreSharedKeyIdentity getPskIdentity() {
        return this.pskIdentity;
    }

    public byte[] getPreSharedKey() {
        return this.psk;
    }
}

