/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class CipherManager {
    private static final ThreadLocal<Map<String, Cipher>> threadLocalCipherMap = new ThreadLocal<Map<String, Cipher>>(){

        @Override
        protected Map<String, Cipher> initialValue() {
            return new HashMap<String, Cipher>(5);
        }
    };

    public static Cipher getInstance(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Map<String, Cipher> map = threadLocalCipherMap.get();
        Cipher cipher = map.get(transformation);
        if (cipher == null) {
            cipher = Cipher.getInstance(transformation);
            map.put(transformation, cipher);
        }
        return cipher;
    }
}

