/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.scandium.auth.PrincipalSerializer;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;

public final class SessionTicket {
    private final int hashCode;
    private final ProtocolVersion protocolVersion;
    private final byte[] masterSecret;
    private final CipherSuite cipherSuite;
    private final CompressionMethod compressionMethod;
    private final Principal clientIdentity;
    private final long timestampMillis;

    SessionTicket(ProtocolVersion protocolVersion, CipherSuite cipherSuite, CompressionMethod compressionMethod, byte[] masterSecret, Principal clientIdentity, long timestampMillis) {
        if (protocolVersion == null) {
            throw new NullPointerException("Protcol version must not be null");
        }
        if (cipherSuite == null) {
            throw new NullPointerException("Cipher suite must not be null");
        }
        if (compressionMethod == null) {
            throw new NullPointerException("Compression method must not be null");
        }
        if (masterSecret == null) {
            throw new NullPointerException("Master secret must not be null");
        }
        this.protocolVersion = protocolVersion;
        this.masterSecret = masterSecret;
        this.cipherSuite = cipherSuite;
        this.compressionMethod = compressionMethod;
        this.clientIdentity = clientIdentity;
        this.timestampMillis = timestampMillis;
        this.hashCode = Arrays.hashCode(masterSecret);
    }

    public void encode(DatagramWriter writer) {
        writer.write(this.protocolVersion.getMajor(), 8);
        writer.write(this.protocolVersion.getMinor(), 8);
        writer.write(this.cipherSuite.getCode(), 16);
        writer.write(this.compressionMethod.getCode(), 8);
        writer.writeBytes(this.masterSecret);
        PrincipalSerializer.serialize(this.clientIdentity, writer);
        writer.writeLong(TimeUnit.MILLISECONDS.toSeconds(this.timestampMillis), 32);
    }

    public static SessionTicket decode(DatagramReader source) {
        if (source == null) {
            throw new NullPointerException("reader must not be null");
        }
        int major = source.read(8);
        int minor = source.read(8);
        ProtocolVersion ver = new ProtocolVersion(major, minor);
        CipherSuite cipherSuite = CipherSuite.getTypeByCode(source.read(16));
        if (cipherSuite == null) {
            return null;
        }
        CompressionMethod compressionMethod = CompressionMethod.getMethodByCode(source.read(8));
        if (compressionMethod == null) {
            return null;
        }
        byte[] masterSecret = source.readBytes(48);
        Principal identity = null;
        try {
            identity = PrincipalSerializer.deserialize(source);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        long timestampMillis = TimeUnit.SECONDS.toMillis(source.readLong(32));
        return new SessionTicket(ver, cipherSuite, compressionMethod, masterSecret, identity, timestampMillis);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionTicket other = (SessionTicket)obj;
        if (!Arrays.equals(this.masterSecret, other.masterSecret)) {
            return false;
        }
        if (!this.protocolVersion.equals(other.protocolVersion)) {
            return false;
        }
        if (!this.cipherSuite.equals((Object)other.cipherSuite)) {
            return false;
        }
        if (!this.compressionMethod.equals((Object)other.compressionMethod)) {
            return false;
        }
        if (!this.clientIdentity.equals(other.clientIdentity)) {
            return false;
        }
        return this.timestampMillis == other.timestampMillis;
    }

    public final ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public final byte[] getMasterSecret() {
        return this.masterSecret;
    }

    public final CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public final CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    public final Principal getClientIdentity() {
        return this.clientIdentity;
    }

    public final long getTimestamp() {
        return this.timestampMillis;
    }
}

