/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientHandshaker;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.HelloVerifyRequest;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.SessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumingClientHandshaker
extends ClientHandshaker {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ResumingClientHandshaker.class.getName());
    private boolean fullHandshake = false;
    private DTLSFlight lastFlight;

    public ResumingClientHandshaker(DTLSSession session, RecordLayer recordLayer, SessionListener sessionListener, DtlsConnectorConfig config, int maxTransmissionUnit) {
        super(session, recordLayer, sessionListener, config, maxTransmissionUnit);
        if (session.getSessionIdentifier() == null) {
            throw new IllegalArgumentException("Session must contain the ID of the session to resume");
        }
    }

    @Override
    protected synchronized void doProcessMessage(DTLSMessage message) throws HandshakeException, GeneralSecurityException {
        if (this.fullHandshake) {
            super.doProcessMessage(message);
            return;
        }
        if (this.lastFlight != null) {
            LOGGER.debug("Received server's [{}] FINISHED message again, retransmitting last flight...", (Object)message.getPeer());
            this.lastFlight.incrementTries();
            this.lastFlight.setNewSequenceNumbers();
            this.recordLayer.sendFlight(this.lastFlight);
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Processing {} message from peer [{}]");
            if (LOGGER.isTraceEnabled()) {
                msg.append(":").append(StringUtil.lineSeparator()).append(message);
            }
            LOGGER.debug(msg.toString(), (Object)message.getContentType(), (Object)message.getPeer());
        }
        switch (message.getContentType()) {
            case CHANGE_CIPHER_SPEC: {
                this.calculateKeys(this.session.getMasterSecret());
                this.setCurrentReadState();
                LOGGER.debug("Processed {} message from peer [{}]", (Object)message.getContentType(), (Object)message.getPeer());
                break;
            }
            case HANDSHAKE: {
                this.recordLayer.cancelRetransmissions();
                HandshakeMessage handshakeMsg = (HandshakeMessage)message;
                switch (handshakeMsg.getMessageType()) {
                    case HELLO_VERIFY_REQUEST: {
                        this.receivedHelloVerifyRequest((HelloVerifyRequest)message);
                        break;
                    }
                    case SERVER_HELLO: {
                        ServerHello serverHello = (ServerHello)message;
                        if (!this.session.getSessionIdentifier().equals(serverHello.getSessionId())) {
                            LOGGER.debug("Server [{}] refuses to resume session [{}], performing full handshake instead...", new Object[]{serverHello.getPeer(), this.session.getSessionIdentifier()});
                            this.fullHandshake = true;
                            this.session.resetMasterSecret();
                            super.receivedServerHello(serverHello);
                            return;
                        }
                        if (!serverHello.getCompressionMethod().equals((Object)this.session.getCompressionMethod())) {
                            throw new HandshakeException("Server wants to change compression method in resumed session", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, serverHello.getPeer()));
                        }
                        if (!serverHello.getCipherSuite().equals((Object)this.session.getCipherSuite())) {
                            throw new HandshakeException("Server wants to change cipher suite in resumed session", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, serverHello.getPeer()));
                        }
                        this.serverHello = serverHello;
                        this.serverRandom = serverHello.getRandom();
                        this.expectChangeCipherSpecMessage();
                        break;
                    }
                    case FINISHED: {
                        this.receivedServerFinished((Finished)handshakeMsg);
                        break;
                    }
                    default: {
                        throw new HandshakeException(String.format("Received unexpected handshake message [%s] from peer %s", new Object[]{handshakeMsg.getMessageType(), handshakeMsg.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE, handshakeMsg.getPeer()));
                    }
                }
                if (this.lastFlight == null) {
                    this.incrementNextReceiveSeq();
                }
                LOGGER.debug("Processed {} message with sequence no [{}] from peer [{}]", new Object[]{handshakeMsg.getMessageType(), handshakeMsg.getMessageSeq(), handshakeMsg.getPeer()});
                break;
            }
            default: {
                throw new HandshakeException(String.format("Received unexpected message [%s] from peer %s", new Object[]{message.getContentType(), message.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, message.getPeer()));
            }
        }
    }

    private void receivedServerFinished(Finished message) throws HandshakeException {
        if (this.lastFlight != null) {
            return;
        }
        DTLSFlight flight = new DTLSFlight(this.getSession(), 5);
        this.md.update(this.clientHello.toByteArray());
        this.md.update(this.serverHello.getRawMessage());
        MessageDigest mdWithServerFinish = null;
        try {
            mdWithServerFinish = (MessageDigest)this.md.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HandshakeException("Cannot create FINISHED message hash", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, message.getPeer()));
        }
        mdWithServerFinish.update(message.getRawMessage());
        this.handshakeHash = this.md.digest();
        message.verifyData(this.session.getMasterSecret(), false, this.handshakeHash);
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage(message.getPeer());
        flight.addMessage(this.wrapMessage(changeCipherSpecMessage));
        this.setCurrentWriteState();
        this.handshakeHash = mdWithServerFinish.digest();
        Finished finished = new Finished(this.session.getMasterSecret(), this.isClient, this.handshakeHash, message.getPeer());
        flight.addMessage(this.wrapMessage(finished));
        this.state = HandshakeType.FINISHED.getCode();
        flight.setRetransmissionNeeded(false);
        this.lastFlight = flight;
        this.recordLayer.sendFlight(flight);
        this.sessionEstablished();
    }

    @Override
    public void startHandshake() throws HandshakeException {
        this.handshakeStarted();
        ClientHello message = new ClientHello(new ProtocolVersion(), new SecureRandom(), this.session, this.supportedClientCertificateTypes, this.supportedServerCertificateTypes);
        this.clientRandom = message.getRandom();
        message.addCompressionMethod(this.session.getCompressionMethod());
        if (this.maxFragmentLengthCode != null) {
            MaxFragmentLengthExtension ext = new MaxFragmentLengthExtension(this.maxFragmentLengthCode);
            message.addExtension(ext);
            LOGGER.debug("Indicating max. fragment length [{}] to server [{}]", new Object[]{this.maxFragmentLengthCode, this.getPeerAddress()});
        }
        this.state = message.getMessageType().getCode();
        this.clientHello = message;
        DTLSFlight flight = new DTLSFlight(this.getSession(), 1);
        flight.addMessage(this.wrapMessage(message));
        this.recordLayer.sendFlight(flight);
    }
}

