/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;

public class HandshakeParameter {
    private final CipherSuite.KeyExchangeAlgorithm keyExchange;
    private final boolean useRawPublicKey;

    public HandshakeParameter(CipherSuite.KeyExchangeAlgorithm keyExchange, boolean useRawPublicKey) {
        if (keyExchange == null) {
            throw new NullPointerException("key exchange must not be null!");
        }
        this.keyExchange = keyExchange;
        this.useRawPublicKey = useRawPublicKey;
    }

    public CipherSuite.KeyExchangeAlgorithm getKeyExchangeAlgorithm() {
        return this.keyExchange;
    }

    public boolean useRawPublicKey() {
        return this.useRawPublicKey;
    }

    public String toString() {
        return "KeyExgAl=" + (Object)((Object)this.keyExchange) + ", " + (this.useRawPublicKey ? "RPK" : "x.509");
    }
}

