/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.util.Arrays;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AbstractMessage;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateRequest;
import org.eclipse.californium.scandium.dtls.CertificateVerify;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.ECDHClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ECDHServerKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskClientKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskServerKeyExchange;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.FragmentedHandshakeMessage;
import org.eclipse.californium.scandium.dtls.GenericHandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeParameter;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.HelloRequest;
import org.eclipse.californium.scandium.dtls.HelloVerifyRequest;
import org.eclipse.californium.scandium.dtls.NULLClientKeyExchange;
import org.eclipse.californium.scandium.dtls.PSKClientKeyExchange;
import org.eclipse.californium.scandium.dtls.PSKServerKeyExchange;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.ServerHelloDone;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HandshakeMessage
extends AbstractMessage {
    public static final int MESSAGE_TYPE_BITS = 8;
    public static final int MESSAGE_LENGTH_BITS = 24;
    public static final int MESSAGE_SEQ_BITS = 16;
    public static final int FRAGMENT_OFFSET_BITS = 24;
    public static final int FRAGMENT_LENGTH_BITS = 24;
    public static final int MESSAGE_HEADER_LENGTH_BYTES = 12;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)HandshakeMessage.class.getCanonicalName());
    private int messageSeq = -1;
    private int fragmentOffset = -1;
    private int fragmentLength = -1;
    private byte[] rawMessage;

    protected HandshakeMessage(InetSocketAddress peerAddress) {
        super(peerAddress);
    }

    public abstract HandshakeType getMessageType();

    public abstract int getMessageLength();

    public abstract byte[] fragmentToByteArray();

    @Override
    public final ContentType getContentType() {
        return ContentType.HANDSHAKE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\tHandshake Protocol");
        sb.append(StringUtil.lineSeparator()).append("\tType: ").append((Object)this.getMessageType());
        sb.append(StringUtil.lineSeparator()).append("\tPeer: ").append(this.getPeer());
        sb.append(StringUtil.lineSeparator()).append("\tMessage Sequence No: ").append(this.messageSeq);
        sb.append(StringUtil.lineSeparator()).append("\tFragment Offset: ").append(this.fragmentOffset);
        sb.append(StringUtil.lineSeparator()).append("\tFragment Length: ").append(this.fragmentLength);
        sb.append(StringUtil.lineSeparator()).append("\tLength: ").append(this.getMessageLength()).append(StringUtil.lineSeparator());
        return sb.toString();
    }

    @Override
    public byte[] toByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.getMessageType().getCode(), 8);
        writer.write(this.getMessageLength(), 24);
        writer.write(this.messageSeq, 16);
        if (this.fragmentOffset < 0) {
            this.fragmentOffset = 0;
        }
        writer.write(this.fragmentOffset, 24);
        if (this.fragmentLength < 0) {
            this.fragmentLength = this.getMessageLength();
        }
        writer.write(this.fragmentLength, 24);
        writer.writeBytes(this.fragmentToByteArray());
        return writer.toByteArray();
    }

    public static HandshakeMessage fromByteArray(byte[] byteArray, HandshakeParameter parameter, InetSocketAddress peerAddress) throws HandshakeException {
        HandshakeMessage body;
        DatagramReader reader = new DatagramReader(byteArray);
        HandshakeType type = HandshakeType.getTypeByCode(reader.read(8));
        LOGGER.trace("Parsing HANDSHAKE message of type [{}]", (Object)type);
        int length = reader.read(24);
        int messageSeq = reader.read(16);
        int fragmentOffset = reader.read(24);
        int fragmentLength = reader.read(24);
        byte[] bytesLeft = reader.readBytes(fragmentLength);
        if (length != fragmentLength) {
            return new FragmentedHandshakeMessage(type, length, messageSeq, fragmentOffset, bytesLeft, peerAddress);
        }
        switch (type) {
            case HELLO_REQUEST: {
                body = new HelloRequest(peerAddress);
                break;
            }
            case CLIENT_HELLO: {
                body = ClientHello.fromByteArray(bytesLeft, peerAddress);
                break;
            }
            case SERVER_HELLO: {
                body = ServerHello.fromByteArray(bytesLeft, peerAddress);
                break;
            }
            case HELLO_VERIFY_REQUEST: {
                body = HelloVerifyRequest.fromByteArray(bytesLeft, peerAddress);
                break;
            }
            case CERTIFICATE: {
                if (parameter == null) {
                    body = GenericHandshakeMessage.fromByteArray(type, byteArray, peerAddress);
                    break;
                }
                body = CertificateMessage.fromByteArray(bytesLeft, parameter.useRawPublicKey(), peerAddress);
                break;
            }
            case SERVER_KEY_EXCHANGE: {
                if (parameter == null) {
                    body = GenericHandshakeMessage.fromByteArray(type, byteArray, peerAddress);
                    break;
                }
                body = HandshakeMessage.readServerKeyExchange(bytesLeft, parameter.getKeyExchangeAlgorithm(), peerAddress);
                break;
            }
            case CERTIFICATE_REQUEST: {
                body = CertificateRequest.fromByteArray(bytesLeft, peerAddress);
                break;
            }
            case SERVER_HELLO_DONE: {
                body = new ServerHelloDone(peerAddress);
                break;
            }
            case CERTIFICATE_VERIFY: {
                body = CertificateVerify.fromByteArray(bytesLeft, peerAddress);
                break;
            }
            case CLIENT_KEY_EXCHANGE: {
                if (parameter == null) {
                    throw new HandshakeException("Unexpected client key exchange message", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE, peerAddress));
                }
                body = HandshakeMessage.readClientKeyExchange(bytesLeft, parameter.getKeyExchangeAlgorithm(), peerAddress);
                break;
            }
            case FINISHED: {
                body = Finished.fromByteArray(bytesLeft, peerAddress);
                break;
            }
            default: {
                throw new HandshakeException(String.format("Cannot parse unsupported message type %s", new Object[]{type}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, peerAddress));
            }
        }
        body.rawMessage = Arrays.copyOf(byteArray, byteArray.length);
        body.setFragmentLength(fragmentLength);
        body.setFragmentOffset(fragmentOffset);
        body.setMessageSeq(messageSeq);
        return body;
    }

    private static HandshakeMessage readServerKeyExchange(byte[] bytesLeft, CipherSuite.KeyExchangeAlgorithm keyExchange, InetSocketAddress peerAddress) throws HandshakeException {
        switch (keyExchange) {
            case EC_DIFFIE_HELLMAN: {
                return ECDHServerKeyExchange.fromByteArray(bytesLeft, peerAddress);
            }
            case PSK: {
                return PSKServerKeyExchange.fromByteArray(bytesLeft, peerAddress);
            }
            case ECDHE_PSK: {
                return EcdhPskServerKeyExchange.fromByteArray(bytesLeft, peerAddress);
            }
        }
        throw new HandshakeException("Unsupported key exchange algorithm", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, peerAddress));
    }

    private static HandshakeMessage readClientKeyExchange(byte[] bytesLeft, CipherSuite.KeyExchangeAlgorithm keyExchange, InetSocketAddress peerAddress) throws HandshakeException {
        switch (keyExchange) {
            case EC_DIFFIE_HELLMAN: {
                return ECDHClientKeyExchange.fromByteArray(bytesLeft, peerAddress);
            }
            case PSK: {
                return PSKClientKeyExchange.fromByteArray(bytesLeft, peerAddress);
            }
            case ECDHE_PSK: {
                return EcdhPskClientKeyExchange.fromByteArray(bytesLeft, peerAddress);
            }
            case NULL: {
                return NULLClientKeyExchange.fromByteArray(bytesLeft, peerAddress);
            }
        }
        throw new HandshakeException("Unknown key exchange algorithm", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, peerAddress));
    }

    public int getMessageSeq() {
        return this.messageSeq;
    }

    public void incrementMessageSeq() {
        ++this.messageSeq;
    }

    public int getFragmentOffset() {
        return this.fragmentOffset;
    }

    public int getFragmentLength() {
        return this.fragmentLength;
    }

    public void setFragmentLength(int length) {
        this.fragmentLength = length;
    }

    public void setMessageSeq(int messageSeq) {
        this.messageSeq = messageSeq;
    }

    public void setFragmentOffset(int fragmentOffset) {
        this.fragmentOffset = fragmentOffset;
    }

    protected final byte[] getRawMessage() {
        return this.rawMessage;
    }
}

