/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.util.Arrays;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeParameter;
import org.eclipse.californium.scandium.dtls.HandshakeType;

public class GenericHandshakeMessage
extends HandshakeMessage {
    private final HandshakeType type;
    private final byte[] byteArray;

    private GenericHandshakeMessage(HandshakeType type, byte[] byteArray, InetSocketAddress peerAddress) {
        super(peerAddress);
        this.byteArray = Arrays.copyOf(byteArray, byteArray.length);
        this.type = type;
    }

    @Override
    public HandshakeType getMessageType() {
        return this.type;
    }

    @Override
    public int getMessageLength() {
        return this.byteArray.length;
    }

    @Override
    public byte[] fragmentToByteArray() {
        return this.byteArray;
    }

    public HandshakeMessage getSpecificHandshakeMessage(HandshakeParameter parameter) throws HandshakeException {
        if (parameter == null) {
            throw new NullPointerException("HandshakeParameter must not be null!");
        }
        return HandshakeMessage.fromByteArray(this.getRawMessage(), parameter, this.getPeer());
    }

    public static GenericHandshakeMessage fromByteArray(HandshakeType type, byte[] byteArray, InetSocketAddress peerAddress) {
        return new GenericHandshakeMessage(type, byteArray, peerAddress);
    }
}

