/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.util.Arrays;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StandardCharsets;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.ClientKeyExchange;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.cipher.ECDHECryptography;
import org.eclipse.californium.scandium.util.ByteArrayUtils;

public final class EcdhPskClientKeyExchange
extends ClientKeyExchange {
    protected static final int LENGTH_BITS = 8;
    private static final int IDENTITY_LENGTH_BITS = 16;
    private final byte[] identityEncoded;
    private final String identity;
    private final byte[] pointEncoded;

    public EcdhPskClientKeyExchange(String hint, PublicKey clientPublicKey, InetSocketAddress peerAddress) {
        super(peerAddress);
        if (hint == null) {
            throw new NullPointerException("identity cannot be null");
        }
        if (clientPublicKey == null) {
            throw new NullPointerException("ephemeral public key cannot be null");
        }
        this.identity = hint;
        this.identityEncoded = hint.getBytes(StandardCharsets.UTF_8);
        ECPublicKey publicKey = (ECPublicKey)clientPublicKey;
        ECPoint point = publicKey.getW();
        ECParameterSpec params = publicKey.getParams();
        this.pointEncoded = ECDHECryptography.encodePoint(point, params.getCurve());
    }

    public EcdhPskClientKeyExchange(byte[] hintEncoded, byte[] pointEncoded, InetSocketAddress peerAddress) {
        super(peerAddress);
        if (hintEncoded == null) {
            throw new NullPointerException("identity cannot be null");
        }
        if (pointEncoded == null) {
            throw new NullPointerException("epehemeral public key cannot be null");
        }
        this.identityEncoded = Arrays.copyOf(hintEncoded, hintEncoded.length);
        this.identity = new String(this.identityEncoded, StandardCharsets.UTF_8);
        this.pointEncoded = Arrays.copyOf(pointEncoded, pointEncoded.length);
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.identityEncoded.length, 16);
        writer.writeBytes(this.identityEncoded);
        writer.write(this.pointEncoded.length, 8);
        writer.writeBytes(this.pointEncoded);
        return writer.toByteArray();
    }

    public static HandshakeMessage fromByteArray(byte[] byteArray, InetSocketAddress peerAddress) {
        if (byteArray == null) {
            throw new NullPointerException("byte array cannot be null");
        }
        if (peerAddress == null) {
            throw new NullPointerException("peer address cannot be null");
        }
        DatagramReader reader = new DatagramReader(byteArray);
        int identityLength = reader.read(16);
        byte[] identityEncoded = reader.readBytes(identityLength);
        int length = reader.read(8);
        byte[] pointEncoded = reader.readBytes(length);
        return new EcdhPskClientKeyExchange(identityEncoded, pointEncoded, peerAddress);
    }

    @Override
    public int getMessageLength() {
        return 3 + this.identityEncoded.length + this.pointEncoded.length;
    }

    public byte[] getEncodedPoint() {
        return Arrays.copyOf(this.pointEncoded, this.pointEncoded.length);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\t\t Encoded identity value: ");
        sb.append(ByteArrayUtils.toHex(this.identityEncoded)).append(StringUtil.lineSeparator());
        sb.append("\t\tEC Diffie-Hellman public value: ");
        sb.append(ByteArrayUtils.toHexString(this.pointEncoded));
        sb.append(StringUtil.lineSeparator());
        return sb.toString();
    }

    public String getIdentity() {
        return this.identity;
    }
}

