/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.Record;

public class DTLSFlight {
    private final List<Record> messages;
    private final InetSocketAddress peerAddress;
    private final DTLSSession session;
    private final int flightNumber;
    private int tries;
    private int timeout = 0;
    private boolean retransmissionNeeded = false;
    private boolean cancelled;
    private ScheduledFuture<?> retransmitTask;

    public DTLSFlight(DTLSSession session, int flightNumber) {
        if (session == null) {
            throw new NullPointerException("Session must not be null");
        }
        if (session.getPeer() == null) {
            throw new NullPointerException("Peer address must not be null");
        }
        this.session = session;
        this.peerAddress = session.getPeer();
        this.messages = new ArrayList<Record>();
        this.retransmissionNeeded = true;
        this.flightNumber = flightNumber;
    }

    public void addMessage(List<Record> messagesToAdd) {
        this.messages.addAll(messagesToAdd);
    }

    public void addMessage(Record messageToAdd) {
        this.messages.add(messageToAdd);
    }

    public List<Record> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public InetSocketAddress getPeerAddress() {
        return this.peerAddress;
    }

    public DTLSSession getSession() {
        return this.session;
    }

    public int getFlightNumber() {
        return this.flightNumber;
    }

    public int getTries() {
        return this.tries;
    }

    public void incrementTries() {
        ++this.tries;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void incrementTimeout() {
        this.timeout *= 2;
    }

    public boolean isRetransmissionNeeded() {
        return this.retransmissionNeeded;
    }

    public void setRetransmissionNeeded(boolean needsRetransmission) {
        this.retransmissionNeeded = needsRetransmission;
    }

    private final void cancelCurrentRetransmission() {
        if (this.retransmitTask != null) {
            if (!this.retransmitTask.isDone()) {
                this.retransmitTask.cancel(true);
            }
            this.retransmitTask = null;
        }
    }

    public synchronized void cancelRetransmission() {
        this.cancelled = true;
        this.cancelCurrentRetransmission();
    }

    public synchronized void setRetransmitTask(ScheduledFuture<?> retransmitTask) {
        if (this.cancelled) {
            retransmitTask.cancel(true);
        } else {
            this.cancelCurrentRetransmission();
            this.retransmitTask = retransmitTask;
        }
    }

    public synchronized boolean isRetransmissionCancelled() {
        return this.cancelled;
    }

    public void setNewSequenceNumbers() throws GeneralSecurityException {
        if (this.getTries() > 0 && this.session != null) {
            for (Record record : this.messages) {
                int epoch = record.getEpoch();
                record.setSequenceNumber(this.session.getSequenceNumber(epoch));
            }
        } else {
            throw new IllegalStateException("Can only set new sequence numbers for retransmitted flight with session");
        }
    }
}

