/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.config;

import java.net.InetSocketAddress;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.dtls.rpkstore.TrustAllRpks;
import org.eclipse.californium.scandium.dtls.rpkstore.TrustedRpkStore;
import org.eclipse.californium.scandium.dtls.x509.CertificateVerifier;
import org.eclipse.californium.scandium.dtls.x509.StaticCertificateVerifier;

public final class DtlsConnectorConfig {
    public static final int DEFAULT_MAX_CONNECTIONS = 150000;
    public static final long DEFAULT_STALE_CONNECTION_TRESHOLD = 1800L;
    private static final String EC_ALGORITHM_NAME = "EC";
    private InetSocketAddress address;
    private X509Certificate[] trustStore;
    private CertificateVerifier certificateVerifier;
    private Boolean earlyStopRetransmission;
    private Boolean enableReuseAddress;
    private Integer maxFragmentLengthCode;
    private Integer retransmissionTimeout;
    private Integer maxRetransmissions;
    private Integer maxTransmissionUnit;
    private Boolean clientAuthenticationRequired;
    private Boolean sendRawKey;
    private PskStore pskStore;
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private X509Certificate[] certChain;
    private CipherSuite[] supportedCipherSuites;
    private TrustedRpkStore trustedRPKs;
    private Integer outboundMessageBufferSize;
    private Integer maxConnections;
    private Long staleConnectionThreshold;
    private Integer connectionThreadCount;
    private Long autoResumptionTimeoutMillis;
    private Boolean sniEnabled;

    private DtlsConnectorConfig() {
    }

    public Integer getMaxFragmentLengthCode() {
        return this.maxFragmentLengthCode;
    }

    public Integer getRetransmissionTimeout() {
        return this.retransmissionTimeout;
    }

    public Integer getMaxRetransmissions() {
        return this.maxRetransmissions;
    }

    public Integer getMaxTransmissionUnit() {
        return this.maxTransmissionUnit;
    }

    public Boolean isEarlyStopRetransmission() {
        return this.earlyStopRetransmission;
    }

    public Boolean isAddressReuseEnabled() {
        return this.enableReuseAddress;
    }

    public Boolean isSniEnabled() {
        return this.sniEnabled;
    }

    public Integer getOutboundMessageBufferSize() {
        return this.outboundMessageBufferSize;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public X509Certificate[] getCertificateChain() {
        if (this.certChain == null) {
            return null;
        }
        return Arrays.copyOf(this.certChain, this.certChain.length);
    }

    public CipherSuite[] getSupportedCipherSuites() {
        if (this.supportedCipherSuites == null) {
            return new CipherSuite[0];
        }
        return Arrays.copyOf(this.supportedCipherSuites, this.supportedCipherSuites.length);
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PskStore getPskStore() {
        return this.pskStore;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public X509Certificate[] getTrustStore() {
        return this.trustStore;
    }

    public CertificateVerifier getCertificateVerifier() {
        return this.certificateVerifier;
    }

    public Boolean isClientAuthenticationRequired() {
        return this.clientAuthenticationRequired;
    }

    public Boolean isSendRawKey() {
        return this.sendRawKey;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public Long getStaleConnectionThreshold() {
        return this.staleConnectionThreshold;
    }

    public Integer getConnectionThreadCount() {
        return this.connectionThreadCount;
    }

    public Long getAutoResumptionTimeoutMillis() {
        return this.autoResumptionTimeoutMillis;
    }

    public TrustedRpkStore getRpkTrustStore() {
        return this.trustedRPKs;
    }

    protected Object clone() {
        DtlsConnectorConfig cloned = new DtlsConnectorConfig();
        cloned.address = this.address;
        cloned.trustStore = this.trustStore;
        cloned.certificateVerifier = this.certificateVerifier;
        cloned.earlyStopRetransmission = this.earlyStopRetransmission;
        cloned.enableReuseAddress = this.enableReuseAddress;
        cloned.maxFragmentLengthCode = this.maxFragmentLengthCode;
        cloned.retransmissionTimeout = this.retransmissionTimeout;
        cloned.maxRetransmissions = this.maxRetransmissions;
        cloned.maxTransmissionUnit = this.maxTransmissionUnit;
        cloned.clientAuthenticationRequired = this.clientAuthenticationRequired;
        cloned.sendRawKey = this.sendRawKey;
        cloned.pskStore = this.pskStore;
        cloned.privateKey = this.privateKey;
        cloned.publicKey = this.publicKey;
        cloned.certChain = this.certChain;
        cloned.supportedCipherSuites = this.supportedCipherSuites;
        cloned.trustedRPKs = this.trustedRPKs;
        cloned.outboundMessageBufferSize = this.outboundMessageBufferSize;
        cloned.maxConnections = this.maxConnections;
        cloned.staleConnectionThreshold = this.staleConnectionThreshold;
        cloned.connectionThreadCount = this.connectionThreadCount;
        cloned.autoResumptionTimeoutMillis = this.autoResumptionTimeoutMillis;
        cloned.sniEnabled = this.sniEnabled;
        return cloned;
    }

    static /* synthetic */ CipherSuite[] access$802(DtlsConnectorConfig x0, CipherSuite[] x1) {
        x0.supportedCipherSuites = x1;
        return x1;
    }

    static /* synthetic */ X509Certificate[] access$1402(DtlsConnectorConfig x0, X509Certificate[] x1) {
        x0.certChain = x1;
        return x1;
    }

    static /* synthetic */ X509Certificate[] access$1602(DtlsConnectorConfig x0, X509Certificate[] x1) {
        x0.trustStore = x1;
        return x1;
    }

    public static final class Builder {
        private DtlsConnectorConfig config;
        private boolean clientOnly;

        public Builder() {
            this.config = new DtlsConnectorConfig();
        }

        public Builder(DtlsConnectorConfig initalValues) {
            this.config = (DtlsConnectorConfig)initalValues.clone();
        }

        public Builder setAddress(InetSocketAddress address) {
            if (address.isUnresolved()) {
                throw new IllegalArgumentException("Bind address must not be unresolved");
            }
            this.config.address = address;
            return this;
        }

        public Builder setEnableAddressReuse(boolean enable) {
            this.config.enableReuseAddress = enable;
            return this;
        }

        public Builder setClientOnly() {
            this.clientOnly = true;
            return this;
        }

        public Builder setMaxFragmentLengthCode(Integer lengthCode) {
            if (lengthCode != null && (lengthCode < 1 || lengthCode > 4)) {
                throw new IllegalArgumentException("Maximum fragment length code must be one of {1, 2, 3, 4}");
            }
            this.config.maxFragmentLengthCode = lengthCode;
            return this;
        }

        public Builder setOutboundMessageBufferSize(int capacity) {
            if (capacity < 1) {
                throw new IllegalArgumentException("Outbound message buffer size must be at least 1");
            }
            this.config.outboundMessageBufferSize = capacity;
            return this;
        }

        public Builder setMaxRetransmissions(int count) {
            if (count < 1) {
                throw new IllegalArgumentException("Maximum number of retransmissions must be greater than zero");
            }
            this.config.maxRetransmissions = count;
            return this;
        }

        public Builder setMaxTransmissionUnit(int mtu) {
            this.config.maxTransmissionUnit = mtu;
            return this;
        }

        public Builder setClientAuthenticationRequired(boolean authRequired) {
            this.config.clientAuthenticationRequired = authRequired;
            return this;
        }

        public Builder setSupportedCipherSuites(CipherSuite[] cipherSuites) {
            if (cipherSuites == null || cipherSuites.length == 0) {
                throw new IllegalArgumentException("Connector must support at least one cipher suite");
            }
            for (CipherSuite suite : cipherSuites) {
                if (!CipherSuite.TLS_NULL_WITH_NULL_NULL.equals((Object)suite)) continue;
                throw new IllegalArgumentException("NULL Cipher Suite is not supported by connector");
            }
            DtlsConnectorConfig.access$802(this.config, Arrays.copyOf(cipherSuites, cipherSuites.length));
            return this;
        }

        public Builder setSupportedCipherSuites(String[] cipherSuites) {
            CipherSuite[] suites = new CipherSuite[cipherSuites.length];
            for (int i = 0; i < cipherSuites.length; ++i) {
                if (CipherSuite.TLS_NULL_WITH_NULL_NULL.name().equals(cipherSuites[i])) {
                    throw new IllegalArgumentException("NULL Cipher Suite is not supported by connector");
                }
                CipherSuite knownSuite = CipherSuite.getTypeByName(cipherSuites[i]);
                if (knownSuite == null) {
                    throw new IllegalArgumentException(String.format("Cipher suite [%s] is not (yet) supported", cipherSuites[i]));
                }
                suites[i] = knownSuite;
            }
            DtlsConnectorConfig.access$802(this.config, suites);
            return this;
        }

        public Builder setEarlyStopRetransmission(boolean activate) {
            this.config.earlyStopRetransmission = activate;
            return this;
        }

        public Builder setRetransmissionTimeout(int timeout) {
            if (timeout < 0) {
                throw new IllegalArgumentException("Retransmission timeout must not be negative");
            }
            this.config.retransmissionTimeout = timeout;
            return this;
        }

        public Builder setPskStore(PskStore pskStore) {
            this.config.pskStore = pskStore;
            return this;
        }

        public Builder setIdentity(PrivateKey privateKey, PublicKey publicKey) {
            if (privateKey == null) {
                throw new NullPointerException("The private key must not be null");
            }
            if (publicKey == null) {
                throw new NullPointerException("The public key must not be null");
            }
            this.config.privateKey = privateKey;
            this.config.publicKey = publicKey;
            DtlsConnectorConfig.access$1402(this.config, null);
            this.config.sendRawKey = true;
            return this;
        }

        public Builder setIdentity(PrivateKey privateKey, Certificate[] certificateChain, boolean preferRawPublicKeys) {
            if (privateKey == null) {
                throw new NullPointerException("The private key must not be null");
            }
            if (certificateChain == null || certificateChain.length < 1) {
                throw new NullPointerException("The certificate chain must not be null or empty");
            }
            this.config.privateKey = privateKey;
            DtlsConnectorConfig.access$1402(this.config, Builder.toX509Certificates(certificateChain));
            this.config.publicKey = this.config.certChain[0].getPublicKey();
            this.config.sendRawKey = preferRawPublicKeys;
            return this;
        }

        public Builder setTrustStore(Certificate[] trustedCerts) {
            if (trustedCerts == null) {
                throw new NullPointerException("Trust store must not be null");
            }
            DtlsConnectorConfig.access$1602(this.config, Builder.toX509Certificates(trustedCerts));
            return this;
        }

        public Builder setCertificateVerifier(CertificateVerifier verifier) {
            if (verifier == null) {
                throw new NullPointerException("CertificateVerifier must not be null");
            }
            this.config.certificateVerifier = verifier;
            return this;
        }

        public void setRpkTrustStore(TrustedRpkStore store) {
            if (store == null) {
                throw new IllegalStateException("Must provide a non-null rpk trust store");
            }
            this.config.trustedRPKs = store;
        }

        private static X509Certificate[] toX509Certificates(Certificate[] certs) {
            ArrayList<X509Certificate> result = new ArrayList<X509Certificate>(certs.length);
            for (Certificate cert : certs) {
                if (!X509Certificate.class.isInstance(cert)) {
                    throw new IllegalArgumentException("can only process X.509 certificates");
                }
                result.add((X509Certificate)cert);
            }
            return result.toArray(new X509Certificate[certs.length]);
        }

        public Builder setMaxConnections(int maxConnections) {
            if (maxConnections < 1) {
                throw new IllegalArgumentException("Max connections must be at least 1");
            }
            this.config.maxConnections = maxConnections;
            return this;
        }

        public Builder setStaleConnectionThreshold(long threshold) {
            if (threshold < 1L) {
                throw new IllegalArgumentException("Threshold must be at least 1 second");
            }
            this.config.staleConnectionThreshold = threshold;
            return this;
        }

        public Builder setConnectionThreadCount(int threadCount) {
            this.config.connectionThreadCount = threadCount;
            return this;
        }

        public Builder setAutoResumptionTimeoutMillis(long timeoutInMillis) {
            this.config.autoResumptionTimeoutMillis = timeoutInMillis;
            return this;
        }

        public Builder setSniEnabled(boolean flag) {
            this.config.sniEnabled = flag;
            return this;
        }

        private boolean isConfiguredWithKeyPair() {
            return this.config.privateKey != null && this.config.publicKey != null;
        }

        public DtlsConnectorConfig getIncompleteConfig() {
            return this.config;
        }

        public DtlsConnectorConfig build() {
            if (this.config.address == null) {
                this.config.address = new InetSocketAddress(0);
            }
            if (this.config.enableReuseAddress == null) {
                this.config.enableReuseAddress = false;
            }
            if (this.config.earlyStopRetransmission == null) {
                this.config.earlyStopRetransmission = true;
            }
            if (this.config.retransmissionTimeout == null) {
                this.config.retransmissionTimeout = 1000;
            }
            if (this.config.maxRetransmissions == null) {
                this.config.maxRetransmissions = 4;
            }
            if (this.config.clientAuthenticationRequired == null) {
                this.config.clientAuthenticationRequired = true;
            }
            if (this.config.sendRawKey == null) {
                this.config.sendRawKey = true;
            }
            if (this.config.outboundMessageBufferSize == null) {
                this.config.outboundMessageBufferSize = 100000;
            }
            if (this.config.maxConnections == null) {
                this.config.maxConnections = 150000;
            }
            if (this.config.staleConnectionThreshold == null) {
                this.config.staleConnectionThreshold = 1800L;
            }
            if (this.config.certificateVerifier == null && this.config.trustStore != null) {
                this.config.certificateVerifier = new StaticCertificateVerifier(this.config.trustStore);
            }
            if (this.config.supportedCipherSuites == null || this.config.supportedCipherSuites.length == 0) {
                this.determineCipherSuitesFromConfig();
            }
            if (this.config.trustedRPKs == null) {
                this.config.trustedRPKs = new TrustAllRpks();
            }
            if (this.config.sniEnabled == null) {
                this.config.sniEnabled = Boolean.TRUE;
            }
            if (this.config.supportedCipherSuites == null || this.config.supportedCipherSuites.length == 0) {
                throw new IllegalStateException("Supported cipher suites must be set either explicitly or implicitly by means of setting the identity or PSK store");
            }
            block4: for (CipherSuite suite : this.config.supportedCipherSuites) {
                switch (suite) {
                    case TLS_PSK_WITH_AES_128_CCM_8: 
                    case TLS_PSK_WITH_AES_128_CBC_SHA256: 
                    case TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256: {
                        this.verifyPskBasedCipherConfig();
                        continue block4;
                    }
                    case TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8: 
                    case TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256: {
                        this.verifyEcBasedCipherConfig();
                        continue block4;
                    }
                }
            }
            return this.config;
        }

        private void verifyPskBasedCipherConfig() {
            if (this.config.pskStore == null) {
                throw new IllegalStateException("PSK store must be set when support for " + CipherSuite.TLS_PSK_WITH_AES_128_CCM_8.name() + " is configured");
            }
        }

        private void verifyEcBasedCipherConfig() {
            if (!this.clientOnly) {
                if (this.config.getPrivateKey() == null || this.config.getPublicKey() == null) {
                    throw new IllegalStateException("Identity must be set");
                }
                if (!DtlsConnectorConfig.EC_ALGORITHM_NAME.equals(this.config.privateKey.getAlgorithm()) || !DtlsConnectorConfig.EC_ALGORITHM_NAME.equals(this.config.getPublicKey().getAlgorithm())) {
                    throw new IllegalStateException("Keys must be ECDSA capable when support for an ECDHE_ECDSA based cipher suite is configured");
                }
            }
        }

        private void determineCipherSuitesFromConfig() {
            ArrayList<CipherSuite> ciphers = new ArrayList<CipherSuite>();
            boolean certificates = this.isConfiguredWithKeyPair();
            if (!certificates && this.clientOnly) {
                boolean bl = certificates = this.config.trustedRPKs != null || this.config.certificateVerifier != null;
            }
            if (certificates) {
                ciphers.add(CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8);
                ciphers.add(CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256);
            }
            if (this.config.pskStore != null) {
                ciphers.add(CipherSuite.TLS_PSK_WITH_AES_128_CCM_8);
                ciphers.add(CipherSuite.TLS_PSK_WITH_AES_128_CBC_SHA256);
                ciphers.add(CipherSuite.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256);
            }
            DtlsConnectorConfig.access$802(this.config, ciphers.toArray(new CipherSuite[0]));
        }
    }
}

