/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public enum CipherSuite {
    TLS_NULL_WITH_NULL_NULL(0, KeyExchangeAlgorithm.NULL, Cipher.NULL, MACAlgorithm.NULL),
    TLS_PSK_WITH_AES_128_CBC_SHA256(174, KeyExchangeAlgorithm.PSK, Cipher.AES_128_CBC, MACAlgorithm.HMAC_SHA256),
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256(49187, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, Cipher.AES_128_CBC, MACAlgorithm.HMAC_SHA256),
    TLS_PSK_WITH_AES_128_CCM_8(49320, KeyExchangeAlgorithm.PSK, Cipher.AES_128_CCM_8, MACAlgorithm.NULL),
    TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8(49326, KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN, Cipher.AES_128_CCM_8, MACAlgorithm.NULL);

    private static final Logger LOGGER;
    private static final int CIPHER_SUITE_BITS = 16;
    private int code;
    private KeyExchangeAlgorithm keyExchange;
    private Cipher cipher;
    private MACAlgorithm macAlgorithm;
    private PRFAlgorithm pseudoRandomFunction;
    private int maxCipherTextExpansion;

    private CipherSuite(int code, KeyExchangeAlgorithm keyExchange, Cipher cipher, MACAlgorithm macAlgorithm) {
        this(code, keyExchange, cipher, macAlgorithm, PRFAlgorithm.TLS_PRF_SHA256);
    }

    private CipherSuite(int code, KeyExchangeAlgorithm keyExchange, Cipher cipher, MACAlgorithm macAlgorithm, PRFAlgorithm prf) {
        this.code = code;
        this.keyExchange = keyExchange;
        this.cipher = cipher;
        this.macAlgorithm = macAlgorithm;
        this.pseudoRandomFunction = prf;
        switch (this.cipher.getType()) {
            case BLOCK: {
                this.maxCipherTextExpansion = cipher.getRecordIvLength() + macAlgorithm.getOutputLength() + cipher.getRecordIvLength() + 1;
                break;
            }
            case AEAD: {
                this.maxCipherTextExpansion = cipher.getRecordIvLength() + cipher.getCiphertextExpansion();
                break;
            }
            default: {
                this.maxCipherTextExpansion = 0;
            }
        }
    }

    public int getMaxCiphertextExpansion() {
        return this.maxCipherTextExpansion;
    }

    public String getTransformation() {
        return this.cipher.getTransformation();
    }

    public int getCode() {
        return this.code;
    }

    public KeyExchangeAlgorithm getKeyExchange() {
        return this.keyExchange;
    }

    public boolean requiresServerCertificateMessage() {
        return !KeyExchangeAlgorithm.DH_ANON.equals((Object)this.keyExchange) && !KeyExchangeAlgorithm.PSK.equals((Object)this.keyExchange) && !KeyExchangeAlgorithm.NULL.equals((Object)this.keyExchange);
    }

    public boolean isEccBased() {
        return KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN.equals((Object)this.keyExchange);
    }

    public int getMacLength() {
        return this.macAlgorithm.getOutputLength();
    }

    public int getMacKeyLength() {
        return this.macAlgorithm.getKeyLength();
    }

    public String getMacName() {
        return this.macAlgorithm.getName();
    }

    public int getRecordIvLength() {
        return this.cipher.getRecordIvLength();
    }

    public int getFixedIvLength() {
        return this.cipher.getFixedIvLength();
    }

    public PRFAlgorithm getPseudoRandomFunction() {
        return this.pseudoRandomFunction;
    }

    public CipherType getCipherType() {
        return this.cipher.getType();
    }

    public int getEncKeyLength() {
        return this.cipher.getKeyLength();
    }

    public static CipherSuite getTypeByCode(int code) {
        for (CipherSuite cipher : CipherSuite.values()) {
            if (cipher.code != code) continue;
            return cipher;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Cannot resolve cipher suite code [{0}]", Integer.toHexString(code));
        }
        return null;
    }

    public static CipherSuite getTypeByName(String name) {
        for (CipherSuite suite : CipherSuite.values()) {
            if (!suite.name().equals(name)) continue;
            return suite;
        }
        return null;
    }

    public static byte[] listToByteArray(List<CipherSuite> cipherSuites) {
        DatagramWriter writer = new DatagramWriter();
        for (CipherSuite cipherSuite : cipherSuites) {
            writer.write(cipherSuite.getCode(), 16);
        }
        return writer.toByteArray();
    }

    public static List<CipherSuite> listFromByteArray(byte[] byteArray, int numElements) {
        ArrayList<CipherSuite> cipherSuites = new ArrayList<CipherSuite>();
        DatagramReader reader = new DatagramReader(byteArray);
        for (int i = 0; i < numElements; ++i) {
            int code = reader.read(16);
            CipherSuite cipher = CipherSuite.getTypeByCode(code);
            if (cipher == null) continue;
            cipherSuites.add(cipher);
        }
        return cipherSuites;
    }

    static {
        LOGGER = Logger.getLogger(CipherSuite.class.getCanonicalName());
    }

    public static enum CipherType {
        NULL,
        STREAM,
        BLOCK,
        AEAD;

    }

    private static enum PRFAlgorithm {
        TLS_PRF_SHA256;

    }

    public static enum KeyExchangeAlgorithm {
        NULL,
        DHE_DSS,
        DHE_RSA,
        DH_ANON,
        RSA,
        DH_DSS,
        DH_RSA,
        PSK,
        EC_DIFFIE_HELLMAN;

    }

    private static enum Cipher {
        NULL("NULL", CipherType.NULL, 0, 0, 0),
        B_3DES_EDE_CBC("DESede/CBC/NoPadding", CipherType.BLOCK, 24, 4, 8),
        AES_128_CBC("AES/CBC/NoPadding", CipherType.BLOCK, 16, 4, 16),
        AES_256_CBC("AES/CBC/NoPadding", CipherType.BLOCK, 32, 4, 16),
        AES_128_CCM_8("CCM", CipherType.AEAD, 16, 4, 8, 8);

        private String transformation;
        private int keyLength;
        private int fixedIvLength;
        private int recordIvLength;
        private CipherType type;
        private int ciphertextExpansion;

        private Cipher(String transformation, CipherType type, int keyLength, int fixedIvLength, int recordIvLength) {
            this.transformation = transformation;
            this.type = type;
            this.keyLength = keyLength;
            this.fixedIvLength = fixedIvLength;
            this.recordIvLength = recordIvLength;
        }

        private Cipher(String transformation, CipherType type, int keyLength, int fixedIvLength, int recordIvLength, int ciphertextExpansion) {
            this(transformation, type, keyLength, fixedIvLength, recordIvLength);
            this.ciphertextExpansion = ciphertextExpansion;
        }

        private String getTransformation() {
            return this.transformation;
        }

        private CipherType getType() {
            return this.type;
        }

        private int getKeyLength() {
            return this.keyLength;
        }

        private int getFixedIvLength() {
            return this.fixedIvLength;
        }

        private int getRecordIvLength() {
            return this.recordIvLength;
        }

        private int getCiphertextExpansion() {
            return this.ciphertextExpansion;
        }
    }

    private static enum MACAlgorithm {
        NULL(null, 0),
        HMAC_MD5("HmacMD5", 16),
        HMAC_SHA1("HmacSHA1", 20),
        HMAC_SHA256("HmacSHA256", 32),
        HMAC_SHA384("HmacSHA384", 48),
        HMAC_SHA512("HmacSHA512", 64);

        private String name;
        private int outputLength;

        private MACAlgorithm(String name, int outputLength) {
            this.name = name;
            this.outputLength = outputLength;
        }

        public String getName() {
            return this.name;
        }

        public int getOutputLength() {
            return this.outputLength;
        }

        public int getKeyLength() {
            return this.outputLength;
        }
    }
}

