/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.SecureRandom;
import java.util.Arrays;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.util.ByteArrayUtils;

public final class SessionId {
    private static final SessionId EMPTY_SESSION_ID = new SessionId(new byte[0]);
    private final byte[] id;

    public SessionId() {
        this.id = new Random(new SecureRandom()).getRandomBytes();
    }

    public SessionId(byte[] sessionId) {
        if (sessionId == null) {
            throw new NullPointerException("Session ID must not be null");
        }
        this.id = Arrays.copyOf(sessionId, sessionId.length);
    }

    public int length() {
        return this.id.length;
    }

    public byte[] getId() {
        return this.id;
    }

    public static SessionId emptySessionId() {
        return EMPTY_SESSION_ID;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.id);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionId other = (SessionId)obj;
        return Arrays.equals(this.id, other.id);
    }

    public String toString() {
        return ByteArrayUtils.toHexString(this.id);
    }
}

