/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionStore;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.util.LeastRecentlyUsedCache;

public class InMemoryConnectionStore
extends LeastRecentlyUsedCache<InetSocketAddress, Connection>
implements ConnectionStore {
    private static final Logger LOG = Logger.getLogger(InMemoryConnectionStore.class.getName());

    public InMemoryConnectionStore() {
    }

    public InMemoryConnectionStore(int capacity, long threshold) {
        super(capacity, threshold);
        LOG.log(Level.CONFIG, "Created new InMemoryConnectionStore [capacity: {0}, connection expiration threshold: {1}s]", new Object[]{capacity, threshold});
    }

    @Override
    public final synchronized boolean put(Connection connection) {
        if (connection != null) {
            return this.put(connection.getPeerAddress(), connection);
        }
        return false;
    }

    @Override
    public final synchronized Connection find(final SessionId id) {
        if (id == null) {
            return null;
        }
        return this.find(new LeastRecentlyUsedCache.Predicate<Connection>(){

            @Override
            public boolean accept(Connection connection) {
                DTLSSession session = connection.getEstablishedSession();
                if (session != null) {
                    return id.equals(session.getSessionIdentifier());
                }
                return false;
            }
        });
    }
}

