/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;

@Deprecated
public class DTLSConnectorConfig {
    private int maxFragmentLength = 4096;
    private int maxPayloadSize = this.maxFragmentLength + 25;
    private int retransmissionTimeout = 1000;
    private int maxRetransmit = 4;
    public boolean requireClientAuth = true;
    public boolean sendRawKey = true;
    public PskStore pskStore = null;
    public PrivateKey privateKey = null;
    public PublicKey publicKey = null;
    public Certificate[] certChain = null;
    public CipherSuite preferredCipherSuite = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8;
    private DTLSConnector connector;

    public DTLSConnectorConfig(DTLSConnector connector) {
        this.connector = connector;
    }

    private void assertNotStarted() {
        if (this.connector.isRunning()) {
            throw new IllegalStateException("can't configure the DTLS connector, it's already started");
        }
    }

    public void setPskStore(PskStore pskStore) {
        this.assertNotStarted();
        this.pskStore = pskStore;
    }

    public void setPrivateKey(PrivateKey privateKey, PublicKey publicKey) {
        this.assertNotStarted();
        if (privateKey == null) {
            throw new IllegalArgumentException("the privateKey should not be null");
        }
        if (publicKey == null) {
            throw new IllegalArgumentException("the publicKey should not be null");
        }
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.sendRawKey = true;
    }

    public void setPrivateKey(PrivateKey key, Certificate[] certChain, boolean sendRawKey) {
        this.assertNotStarted();
        if (key == null) {
            throw new IllegalArgumentException("the key should not be null");
        }
        if (certChain == null || certChain.length < 1) {
            throw new IllegalArgumentException("the certChain should not be null or empty");
        }
        this.privateKey = key;
        this.certChain = certChain;
        this.publicKey = certChain[0].getPublicKey();
        this.sendRawKey = sendRawKey;
    }

    public void setRequireClientAuth(boolean requireClientAuth) {
        this.assertNotStarted();
        this.requireClientAuth = requireClientAuth;
    }

    public void setPreferredCipherSuite(CipherSuite suite) {
        this.assertNotStarted();
        this.preferredCipherSuite = suite;
    }

    public int getMaxFragmentLength() {
        return this.maxFragmentLength;
    }

    public void setMaxFragmentLength(int maxFragmentLength) {
        this.maxFragmentLength = maxFragmentLength;
    }

    public int getMaxPayloadSize() {
        return this.maxPayloadSize;
    }

    public void setMaxPayloadSize(int maxPayloadSize) {
        this.maxPayloadSize = maxPayloadSize;
    }

    public int getRetransmissionTimeout() {
        return this.retransmissionTimeout;
    }

    public void setRetransmissionTimeout(int retransmissionTimeout) {
        this.retransmissionTimeout = retransmissionTimeout;
    }

    public int getMaxRetransmit() {
        return this.maxRetransmit;
    }

    public void setMaxRetransmit(int maxRetransmit) {
        this.maxRetransmit = maxRetransmit;
    }
}

