/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.util;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LeastRecentlyUsedCache<K, V> {
    private static final long DEFAULT_THRESHOLD_SECS = 129600L;
    private static final int DEFAULT_CAPACITY = 500000;
    private Map<K, CacheEntry<K, V>> cache;
    private volatile int capacity;
    private CacheEntry<K, V> header;
    private volatile long expirationThreshold;
    private List<EvictionListener<V>> evictionListeners = new LinkedList<EvictionListener<V>>();

    public LeastRecentlyUsedCache() {
        this(500000, 129600L);
    }

    public LeastRecentlyUsedCache(int capacity, long threshold) {
        this.capacity = capacity;
        this.expirationThreshold = threshold;
        this.cache = new HashMap<K, CacheEntry<K, V>>(capacity + 1, 1.0f);
        this.initLinkedList();
    }

    private void initLinkedList() {
        this.header = new CacheEntry(null, null, -1L);
        ((CacheEntry)this.header).after = (((CacheEntry)this.header).before = (CacheEntry)this.header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEvictionListener(EvictionListener<V> listener) {
        List<EvictionListener<V>> list = this.evictionListeners;
        synchronized (list) {
            if (listener != null) {
                this.evictionListeners.add(listener);
            }
        }
    }

    public final long getExpirationThreshold() {
        return this.expirationThreshold;
    }

    public final void setExpirationThreshold(long newThreshold) {
        this.expirationThreshold = newThreshold;
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    final synchronized int size() {
        return this.cache.size();
    }

    public final synchronized int remainingCapacity() {
        return this.capacity - this.cache.size();
    }

    public final synchronized void clear() {
        this.cache.clear();
        this.initLinkedList();
    }

    public final synchronized boolean put(K key, V value) {
        if (value != null) {
            CacheEntry<K, V> entry = this.cache.get(key);
            if (entry != null) {
                ((CacheEntry)entry).remove();
                this.add(key, value);
                return true;
            }
            if (this.cache.size() < this.capacity) {
                this.add(key, value);
                return true;
            }
            long thresholdDate = System.currentTimeMillis() - this.expirationThreshold * 1000L;
            CacheEntry eldest = ((CacheEntry)this.header).after;
            if (eldest.isStale(thresholdDate)) {
                eldest.remove();
                this.cache.remove(eldest.getKey());
                this.add(key, value);
                this.notifyEvictionListeners(eldest.getValue());
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEvictionListeners(V session) {
        List<EvictionListener<V>> list = this.evictionListeners;
        synchronized (list) {
            for (EvictionListener<V> listener : this.evictionListeners) {
                listener.onEviction(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final V getEldest() {
        CacheEntry<K, V> cacheEntry = this.header;
        synchronized (cacheEntry) {
            CacheEntry eldest = ((CacheEntry)this.header).after;
            return (V)eldest.getValue();
        }
    }

    private synchronized void add(K key, V value) {
        CacheEntry entry = new CacheEntry(key, value, System.currentTimeMillis());
        this.cache.put(key, entry);
        entry.addBefore((CacheEntry)this.header);
    }

    public final synchronized V get(K key) {
        if (key == null) {
            return null;
        }
        CacheEntry<K, V> entry = this.cache.get(key);
        if (entry == null) {
            return null;
        }
        if (((CacheEntry)entry).isStale(this.expirationThreshold)) {
            this.cache.remove(((CacheEntry)entry).getKey());
            ((CacheEntry)entry).remove();
            return null;
        }
        ((CacheEntry)entry).recordAccess((CacheEntry)this.header);
        return (V)((CacheEntry)entry).getValue();
    }

    public final synchronized V remove(K key) {
        CacheEntry<K, V> entry;
        if (key != null && (entry = this.cache.remove(key)) != null) {
            ((CacheEntry)entry).remove();
            return (V)((CacheEntry)entry).getValue();
        }
        return null;
    }

    protected final V find(Predicate<V> predicate) {
        for (CacheEntry<K, V> entry : this.cache.values()) {
            if (!predicate.accept(((CacheEntry)entry).getValue())) continue;
            return (V)((CacheEntry)entry).getValue();
        }
        return null;
    }

    private static class CacheEntry<K, V> {
        private K key;
        private V value;
        private long lastUpdate;
        private CacheEntry<K, V> after;
        private CacheEntry<K, V> before;

        private CacheEntry(K key, V value, long lastUpdate) {
            this.value = value;
            this.key = key;
            this.lastUpdate = lastUpdate;
        }

        private K getKey() {
            return this.key;
        }

        private V getValue() {
            return this.value;
        }

        private boolean isStale(long threshold) {
            return this.lastUpdate <= threshold;
        }

        private void recordAccess(CacheEntry<K, V> header) {
            this.remove();
            this.lastUpdate = System.currentTimeMillis();
            this.addBefore(header);
        }

        private void addBefore(CacheEntry<K, V> existingEntry) {
            this.after = existingEntry;
            this.before = existingEntry.before;
            this.before.after = this;
            this.after.before = this;
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        public String toString() {
            return new StringBuffer("CacheEntry [key: ").append(this.key).append(", last access: ").append(this.lastUpdate).append("]").toString();
        }
    }

    static interface EvictionListener<V> {
        public void onEviction(V var1);
    }

    protected static interface Predicate<V> {
        public boolean accept(V var1);
    }
}

