/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.scandium.auth.PreSharedKeyIdentity;
import org.eclipse.californium.scandium.auth.RawPublicKeyIdentity;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateRequest;
import org.eclipse.californium.scandium.dtls.CertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.CertificateVerify;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.ClientKeyExchange;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.ECDHClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ECDHServerKeyExchange;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.HelloRequest;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.NULLClientKeyExchange;
import org.eclipse.californium.scandium.dtls.PSKClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.ServerCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.ServerHelloDone;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SessionListener;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.SupportedEllipticCurvesExtension;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.ECDHECryptography;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.util.ByteArrayUtils;

public class ServerHandshaker
extends Handshaker {
    private static final Logger LOGGER = Logger.getLogger(ServerHandshaker.class.getName());
    private DTLSFlight lastFlight;
    private boolean clientAuthenticationRequired = false;
    private PublicKey clientPublicKey;
    private X509Certificate peerCertificate;
    private List<CipherSuite> supportedCipherSuites;
    private List<CertificateTypeExtension.CertificateType> supportedClientCertificateTypes;
    private List<CertificateTypeExtension.CertificateType> supportedServerCertificateTypes;
    private CertificateTypeExtension.CertificateType negotiatedClientCertificateType;
    private CertificateTypeExtension.CertificateType negotiatedServerCertificateType;
    private ECDHECryptography.SupportedGroup negotiatedSupportedGroup;
    protected CertificateMessage clientCertificate = null;
    protected ClientKeyExchange clientKeyExchange;
    protected CertificateVerify certificateVerify = null;
    protected final PskStore pskStore;

    public ServerHandshaker(DTLSSession session, SessionListener sessionListener, DtlsConnectorConfig config, int maxTransmissionUnit) throws HandshakeException {
        this(0, session, sessionListener, config, maxTransmissionUnit);
    }

    public ServerHandshaker(int initialMessageSequenceNo, DTLSSession session, SessionListener sessionListener, DtlsConnectorConfig config, int maxTransmissionUnit) throws HandshakeException {
        super(false, initialMessageSequenceNo, session, sessionListener, config.getTrustStore(), maxTransmissionUnit);
        this.supportedCipherSuites = Arrays.asList(config.getSupportedCipherSuites());
        this.pskStore = config.getPskStore();
        this.privateKey = config.getPrivateKey();
        this.certificateChain = config.getCertificateChain();
        this.publicKey = config.getPublicKey();
        this.clientAuthenticationRequired = config.isClientAuthenticationRequired();
        this.supportedClientCertificateTypes = new ArrayList<CertificateTypeExtension.CertificateType>();
        this.supportedClientCertificateTypes.add(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY);
        if (this.rootCertificates != null && this.rootCertificates.length > 0) {
            this.supportedClientCertificateTypes.add(CertificateTypeExtension.CertificateType.X_509);
        }
        this.supportedServerCertificateTypes = new ArrayList<CertificateTypeExtension.CertificateType>();
        if (this.privateKey != null && this.publicKey != null) {
            if (this.certificateChain == null) {
                this.supportedServerCertificateTypes.add(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY);
            } else if (config.isSendRawKey()) {
                this.supportedServerCertificateTypes.add(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY);
                this.supportedServerCertificateTypes.add(CertificateTypeExtension.CertificateType.X_509);
            } else {
                this.supportedServerCertificateTypes.add(CertificateTypeExtension.CertificateType.X_509);
                this.supportedServerCertificateTypes.add(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY);
            }
        }
    }

    @Override
    protected synchronized DTLSFlight doProcessMessage(DTLSMessage message) throws HandshakeException, GeneralSecurityException {
        if (this.lastFlight != null) {
            LOGGER.log(Level.FINER, "Received client's ({0}) FINISHED message again, retransmitting last flight...", this.getPeerAddress());
            return this.lastFlight;
        }
        DTLSFlight flight = null;
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuffer msg = new StringBuffer();
            msg.append(String.format("Processing %s message from peer [%s]", new Object[]{message.getContentType(), message.getPeer()}));
            if (LOGGER.isLoggable(Level.FINEST)) {
                msg.append(":\n").append(message);
            }
            LOGGER.fine(msg.toString());
        }
        switch (message.getContentType()) {
            case CHANGE_CIPHER_SPEC: {
                this.setCurrentReadState();
                LOGGER.log(Level.FINE, "Processed {1} message from peer [{0}]", new Object[]{message.getPeer(), message.getContentType()});
                break;
            }
            case HANDSHAKE: {
                HandshakeMessage handshakeMsg = (HandshakeMessage)message;
                switch (handshakeMsg.getMessageType()) {
                    case CLIENT_HELLO: {
                        flight = this.receivedClientHello((ClientHello)handshakeMsg);
                        break;
                    }
                    case CERTIFICATE: {
                        this.receivedClientCertificate((CertificateMessage)handshakeMsg);
                        break;
                    }
                    case CLIENT_KEY_EXCHANGE: {
                        switch (this.getKeyExchangeAlgorithm()) {
                            case PSK: {
                                byte[] premasterSecret = this.receivedClientKeyExchange((PSKClientKeyExchange)handshakeMsg);
                                this.generateKeys(premasterSecret);
                                break;
                            }
                            case EC_DIFFIE_HELLMAN: {
                                byte[] premasterSecret = this.receivedClientKeyExchange((ECDHClientKeyExchange)handshakeMsg);
                                this.generateKeys(premasterSecret);
                                break;
                            }
                            case NULL: {
                                byte[] premasterSecret = this.receivedClientKeyExchange((NULLClientKeyExchange)handshakeMsg);
                                this.generateKeys(premasterSecret);
                                break;
                            }
                            default: {
                                throw new HandshakeException(String.format("Unsupported key exchange algorithm %s", this.getKeyExchangeAlgorithm().name()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, handshakeMsg.getPeer()));
                            }
                        }
                        this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, this.clientKeyExchange.getRawMessage());
                        break;
                    }
                    case CERTIFICATE_VERIFY: {
                        this.receivedCertificateVerify((CertificateVerify)handshakeMsg);
                        break;
                    }
                    case FINISHED: {
                        flight = this.receivedClientFinished((Finished)handshakeMsg);
                        break;
                    }
                    default: {
                        throw new HandshakeException(String.format("Received unexpected %s message from peer %s", new Object[]{handshakeMsg.getMessageType(), handshakeMsg.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE, handshakeMsg.getPeer()));
                    }
                }
                this.incrementNextReceiveSeq();
                LOGGER.log(Level.FINE, "Processed {1} message with message sequence no [{2}] from peer [{0}]", new Object[]{message.getPeer(), handshakeMsg.getMessageType(), handshakeMsg.getMessageSeq()});
                break;
            }
            default: {
                throw new HandshakeException(String.format("Received unexpected %s message from peer %s", new Object[]{message.getContentType(), message.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, message.getPeer()));
            }
        }
        return flight;
    }

    private void receivedClientCertificate(CertificateMessage message) throws HandshakeException {
        if (this.clientCertificate != null && this.clientCertificate.getMessageSeq() == message.getMessageSeq()) {
            return;
        }
        this.clientCertificate = message;
        this.clientCertificate.verifyCertificate(this.rootCertificates);
        this.clientPublicKey = this.clientCertificate.getPublicKey();
        if (message.getCertificateChain() != null && message.getCertificateChain().length > 0) {
            this.peerCertificate = message.getCertificateChain()[0];
        }
        this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, this.clientCertificate.getRawMessage());
    }

    private void receivedCertificateVerify(CertificateVerify message) throws HandshakeException {
        this.certificateVerify = message;
        message.verifySignature(this.clientPublicKey, this.handshakeMessages);
        if (this.peerCertificate != null) {
            this.session.setPeerIdentity(this.peerCertificate.getSubjectX500Principal());
        } else {
            this.session.setPeerIdentity(new RawPublicKeyIdentity(this.clientPublicKey));
        }
        this.session.setPeerRawPublicKey(this.clientPublicKey);
    }

    private DTLSFlight receivedClientFinished(Finished message) throws HandshakeException {
        if (this.lastFlight != null) {
            return null;
        }
        if (CipherSuite.KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN.equals((Object)this.getKeyExchangeAlgorithm()) && this.clientAuthenticationRequired && (this.clientCertificate == null || this.certificateVerify == null)) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer());
            throw new HandshakeException("Client did not send required authentication messages.", alert);
        }
        DTLSFlight flight = new DTLSFlight(this.getSession());
        if (this.clientCertificate != null) {
            this.md.update(this.clientCertificate.getRawMessage());
        }
        this.md.update(this.clientKeyExchange.getRawMessage());
        if (this.certificateVerify != null) {
            this.md.update(this.certificateVerify.getRawMessage());
        }
        MessageDigest mdWithClientFinished = null;
        try {
            mdWithClientFinished = (MessageDigest)this.md.clone();
            mdWithClientFinished.update(message.toByteArray());
        }
        catch (CloneNotSupportedException e) {
            LOGGER.log(Level.SEVERE, "Cannot compute digest for server's Finish handshake message", e);
        }
        byte[] handshakeHash = this.md.digest();
        message.verifyData(this.getMasterSecret(), true, handshakeHash);
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage(this.session.getPeer());
        flight.addMessage(this.wrapMessage(changeCipherSpecMessage));
        this.setCurrentWriteState();
        handshakeHash = mdWithClientFinished.digest();
        Finished finished = new Finished(this.getMasterSecret(), this.isClient, handshakeHash, this.session.getPeer());
        flight.addMessage(this.wrapMessage(finished));
        this.state = HandshakeType.FINISHED.getCode();
        flight.setRetransmissionNeeded(false);
        this.lastFlight = flight;
        this.sessionEstablished();
        return flight;
    }

    private DTLSFlight receivedClientHello(ClientHello message) throws HandshakeException {
        this.handshakeStarted();
        DTLSFlight flight = new DTLSFlight(this.getSession());
        this.md.update(message.getRawMessage());
        this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, message.getRawMessage());
        ProtocolVersion serverVersion = this.negotiateProtocolVersion(message.getClientVersion());
        this.clientRandom = message.getRandom();
        this.serverRandom = new Random();
        SessionId sessionId = new SessionId();
        this.session.setSessionIdentifier(sessionId);
        CipherSuite cipherSuite = this.negotiateCipherSuite(message);
        this.session.setCipherSuite(cipherSuite);
        if (!message.getCompressionMethods().contains((Object)CompressionMethod.NULL)) {
            throw new HandshakeException("Client does not support NULL compression method", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, message.getPeer()));
        }
        this.session.setCompressionMethod(CompressionMethod.NULL);
        HelloExtensions serverHelloExtensions = new HelloExtensions();
        MaxFragmentLengthExtension maxFragmentLengthExt = message.getMaxFragmentLengthExtension();
        if (maxFragmentLengthExt != null) {
            this.session.setMaxFragmentLength(maxFragmentLengthExt.getFragmentLength().length());
            serverHelloExtensions.addExtension(maxFragmentLengthExt);
            LOGGER.log(Level.FINE, "Negotiated max. fragment length [{0} bytes] with peer [{1}]", new Object[]{maxFragmentLengthExt.getFragmentLength().length(), message.getPeer()});
        }
        if (cipherSuite.requiresServerCertificateMessage()) {
            serverHelloExtensions.addExtension(this.negotiateServerCertificateType(message));
            if (this.clientAuthenticationRequired) {
                serverHelloExtensions.addExtension(this.negotiateClientCertificateType(message));
            }
        }
        if (cipherSuite.isEccBased()) {
            List<SupportedPointFormatsExtension.ECPointFormat> formats = Arrays.asList(SupportedPointFormatsExtension.ECPointFormat.UNCOMPRESSED);
            serverHelloExtensions.addExtension(new SupportedPointFormatsExtension(formats));
        }
        ServerHello serverHello = new ServerHello(serverVersion, this.serverRandom, sessionId, cipherSuite, this.session.getCompressionMethod(), serverHelloExtensions, this.session.getPeer());
        flight.addMessage(this.wrapMessage(serverHello));
        this.md.update(serverHello.toByteArray());
        this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, serverHello.toByteArray());
        CertificateMessage certificateMessage = null;
        if (cipherSuite.requiresServerCertificateMessage()) {
            certificateMessage = this.session.sendRawPublicKey() ? new CertificateMessage(this.publicKey.getEncoded(), this.session.getPeer()) : new CertificateMessage(this.certificateChain, this.session.getPeer());
            flight.addMessage(this.wrapMessage(certificateMessage));
            this.md.update(certificateMessage.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, certificateMessage.toByteArray());
        }
        HandshakeMessage serverKeyExchange = null;
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        switch (this.getKeyExchangeAlgorithm()) {
            case EC_DIFFIE_HELLMAN: {
                signatureAndHashAlgorithm = new SignatureAndHashAlgorithm(CertificateRequest.HashAlgorithm.SHA256, CertificateRequest.SignatureAlgorithm.ECDSA);
                try {
                    this.ecdhe = new ECDHECryptography(this.negotiatedSupportedGroup.getEcParams());
                    serverKeyExchange = new ECDHServerKeyExchange(signatureAndHashAlgorithm, this.ecdhe, this.privateKey, this.clientRandom, this.serverRandom, this.negotiatedSupportedGroup.getId(), this.session.getPeer());
                    break;
                }
                catch (GeneralSecurityException e) {
                    throw new HandshakeException(String.format("Error performing EC Diffie Hellman key exchange: %s", e.getMessage()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.getPeerAddress()));
                }
            }
            case PSK: {
                break;
            }
        }
        if (serverKeyExchange != null) {
            flight.addMessage(this.wrapMessage(serverKeyExchange));
            this.md.update(serverKeyExchange.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, serverKeyExchange.toByteArray());
        }
        if (this.clientAuthenticationRequired && signatureAndHashAlgorithm != null) {
            CertificateRequest certificateRequest = new CertificateRequest(this.session.getPeer());
            certificateRequest.addCertificateType(CertificateRequest.ClientCertificateType.ECDSA_SIGN);
            certificateRequest.addSignatureAlgorithm(new SignatureAndHashAlgorithm(signatureAndHashAlgorithm.getHash(), signatureAndHashAlgorithm.getSignature()));
            certificateRequest.addCertificateAuthorities(this.rootCertificates);
            flight.addMessage(this.wrapMessage(certificateRequest));
            this.md.update(certificateRequest.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, certificateRequest.toByteArray());
        }
        ServerHelloDone serverHelloDone = new ServerHelloDone(this.session.getPeer());
        flight.addMessage(this.wrapMessage(serverHelloDone));
        this.md.update(serverHelloDone.toByteArray());
        this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, serverHelloDone.toByteArray());
        return flight;
    }

    private byte[] receivedClientKeyExchange(ECDHClientKeyExchange message) {
        this.clientKeyExchange = message;
        byte[] premasterSecret = this.ecdhe.getSecret(message.getEncodedPoint()).getEncoded();
        return premasterSecret;
    }

    private byte[] receivedClientKeyExchange(PSKClientKeyExchange message) throws HandshakeException {
        this.clientKeyExchange = message;
        String identity = message.getIdentity();
        byte[] psk = this.pskStore.getKey(identity);
        LOGGER.log(Level.FINER, "Client [{0}] uses PSK identity [{1}]", new Object[]{this.getPeerAddress(), identity});
        if (psk == null) {
            throw new HandshakeException(String.format("Cannot authenticate client, identity [%s] is unknown", identity), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer()));
        }
        this.session.setPeerIdentity(new PreSharedKeyIdentity(identity));
        this.session.setPskIdentity(identity);
        return this.generatePremasterSecretFromPSK(psk);
    }

    private byte[] receivedClientKeyExchange(NULLClientKeyExchange message) {
        this.clientKeyExchange = message;
        return new byte[0];
    }

    @Override
    public DTLSFlight getStartHandshakeMessage() throws HandshakeException {
        HelloRequest helloRequest = new HelloRequest(this.session.getPeer());
        DTLSFlight flight = new DTLSFlight(this.getSession());
        flight.addMessage(this.wrapMessage(helloRequest));
        return flight;
    }

    private ProtocolVersion negotiateProtocolVersion(ProtocolVersion clientVersion) throws HandshakeException {
        ProtocolVersion version = new ProtocolVersion();
        if (clientVersion.compareTo(version) >= 0) {
            return new ProtocolVersion();
        }
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.PROTOCOL_VERSION, this.session.getPeer());
        throw new HandshakeException("The server only supports DTLS v1.2", alert);
    }

    private CipherSuite negotiateCipherSuite(ClientHello clientHello) throws HandshakeException {
        for (CipherSuite cipherSuite : clientHello.getCipherSuites()) {
            if (cipherSuite == CipherSuite.TLS_NULL_WITH_NULL_NULL || !this.supportedCipherSuites.contains((Object)cipherSuite)) continue;
            if (cipherSuite.isEccBased()) {
                ECDHECryptography.SupportedGroup group = this.negotiateNamedCurve(clientHello);
                if (group == null) continue;
                this.negotiatedSupportedGroup = group;
            }
            LOGGER.log(Level.FINER, "Negotiated cipher suite [{0}] with peer [{1}]", new Object[]{cipherSuite.name(), this.getPeerAddress()});
            return cipherSuite;
        }
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, this.session.getPeer());
        throw new HandshakeException("Client proposed unsupported cipher suites only", alert);
    }

    private ECDHECryptography.SupportedGroup negotiateNamedCurve(ClientHello clientHello) {
        ECDHECryptography.SupportedGroup result;
        block2: {
            SupportedEllipticCurvesExtension extension;
            List<ECDHECryptography.SupportedGroup> preferredGroups;
            block1: {
                result = null;
                preferredGroups = ECDHECryptography.SupportedGroup.getPreferredGroups();
                extension = clientHello.getSupportedEllipticCurvesExtension();
                if (extension != null) break block1;
                if (preferredGroups.isEmpty()) break block2;
                result = preferredGroups.get(0);
                break block2;
            }
            for (Integer preferredGroupId : extension.getSupportedGroupIds()) {
                ECDHECryptography.SupportedGroup group = ECDHECryptography.SupportedGroup.fromId(preferredGroupId);
                if (group == null || !group.isUsable() || !preferredGroups.contains((Object)group)) continue;
                result = group;
                break;
            }
        }
        return result;
    }

    private ClientCertificateTypeExtension negotiateClientCertificateType(ClientHello clientHello) throws HandshakeException {
        ClientCertificateTypeExtension certTypeExt = clientHello.getClientCertificateTypeExtension();
        if (certTypeExt != null) {
            for (CertificateTypeExtension.CertificateType certType : certTypeExt.getCertificateTypes()) {
                if (!this.supportedClientCertificateTypes.contains((Object)certType)) continue;
                this.negotiatedClientCertificateType = certType;
                break;
            }
        } else if (this.supportedClientCertificateTypes.contains((Object)CertificateTypeExtension.CertificateType.X_509)) {
            this.negotiatedClientCertificateType = CertificateTypeExtension.CertificateType.X_509;
        }
        if (this.negotiatedClientCertificateType == null) {
            throw new HandshakeException("Server does not support any of the client's preferred client certificate types", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNSUPPORTED_CERTIFICATE, this.session.getPeer()));
        }
        this.session.setReceiveRawPublicKey(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY.equals((Object)this.negotiatedClientCertificateType));
        ClientCertificateTypeExtension result = new ClientCertificateTypeExtension(false);
        result.addCertificateType(this.negotiatedClientCertificateType);
        return result;
    }

    private ServerCertificateTypeExtension negotiateServerCertificateType(ClientHello clientHello) throws HandshakeException {
        ServerCertificateTypeExtension certTypeExt = clientHello.getServerCertificateTypeExtension();
        if (certTypeExt != null) {
            for (CertificateTypeExtension.CertificateType certType : certTypeExt.getCertificateTypes()) {
                if (!this.supportedServerCertificateTypes.contains((Object)certType)) continue;
                this.negotiatedServerCertificateType = certType;
                break;
            }
        } else if (this.supportedServerCertificateTypes.contains((Object)CertificateTypeExtension.CertificateType.X_509)) {
            this.negotiatedServerCertificateType = CertificateTypeExtension.CertificateType.X_509;
        }
        if (this.negotiatedServerCertificateType == null) {
            throw new HandshakeException("Server does not support any of the client's preferred server certificate types", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNSUPPORTED_CERTIFICATE, this.session.getPeer()));
        }
        this.session.setSendRawPublicKey(CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY.equals((Object)this.negotiatedServerCertificateType));
        ServerCertificateTypeExtension result = new ServerCertificateTypeExtension(false);
        result.addCertificateType(this.negotiatedServerCertificateType);
        return result;
    }

    final CertificateTypeExtension.CertificateType getNegotiatedClientCertificateType() {
        return this.negotiatedClientCertificateType;
    }

    final CertificateTypeExtension.CertificateType getNegotiatedServerCertificateType() {
        return this.negotiatedServerCertificateType;
    }

    final ECDHECryptography.SupportedGroup getNegotiatedSupportedGroup() {
        return this.negotiatedSupportedGroup;
    }
}

