/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.ServerHandshaker;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.SessionListener;

public class ResumingServerHandshaker
extends ServerHandshaker {
    private static final Logger LOGGER = Logger.getLogger(ResumingServerHandshaker.class.getName());
    private byte[] handshakeHash;

    public ResumingServerHandshaker(int sequenceNumber, DTLSSession session, SessionListener sessionListener, DtlsConnectorConfig config, int maxTransmissionUnit) throws HandshakeException {
        super(sequenceNumber, session, sessionListener, config, maxTransmissionUnit);
    }

    @Override
    protected synchronized DTLSFlight doProcessMessage(DTLSMessage message) throws HandshakeException, GeneralSecurityException {
        DTLSFlight flight = null;
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuffer msg = new StringBuffer();
            msg.append(String.format("Processing %s message from peer [%s]", new Object[]{message.getContentType(), message.getPeer()}));
            if (LOGGER.isLoggable(Level.FINEST)) {
                msg.append(":\n").append(message);
            }
            LOGGER.fine(msg.toString());
        }
        switch (message.getContentType()) {
            case ALERT: {
                break;
            }
            case CHANGE_CIPHER_SPEC: {
                this.setCurrentReadState();
                LOGGER.log(Level.FINE, "Processed {1} message from peer [{0}]", new Object[]{message.getPeer(), message.getContentType()});
                break;
            }
            case HANDSHAKE: {
                HandshakeMessage handshakeMsg = (HandshakeMessage)message;
                switch (handshakeMsg.getMessageType()) {
                    case CLIENT_HELLO: {
                        flight = this.receivedClientHello((ClientHello)handshakeMsg);
                        break;
                    }
                    case FINISHED: {
                        this.receivedClientFinished((Finished)handshakeMsg);
                        break;
                    }
                    default: {
                        throw new HandshakeException(String.format("Received unexpected handshake message [%s] from peer %s", new Object[]{handshakeMsg.getMessageType(), handshakeMsg.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE, handshakeMsg.getPeer()));
                    }
                }
                this.incrementNextReceiveSeq();
                LOGGER.log(Level.FINE, "Processed {1} message with sequence no [{2}] from peer [{0}]", new Object[]{handshakeMsg.getPeer(), handshakeMsg.getMessageType(), handshakeMsg.getMessageSeq()});
                break;
            }
            default: {
                throw new HandshakeException(String.format("Received unexpected message [%s] from peer %s", new Object[]{message.getContentType(), message.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, message.getPeer()));
            }
        }
        return flight;
    }

    private DTLSFlight receivedClientHello(ClientHello clientHello) throws HandshakeException {
        this.handshakeStarted();
        if (!clientHello.getCipherSuites().contains((Object)this.session.getCipherSuite())) {
            throw new HandshakeException("Client wants to change cipher suite in resumed session", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, clientHello.getPeer()));
        }
        if (!clientHello.getCompressionMethods().contains((Object)this.session.getCompressionMethod())) {
            throw new HandshakeException("Client wants to change compression method in resumed session", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, clientHello.getPeer()));
        }
        DTLSFlight flight = new DTLSFlight(this.getSession());
        this.md.update(clientHello.getRawMessage());
        this.clientRandom = clientHello.getRandom();
        this.serverRandom = new Random(new SecureRandom());
        ServerHello serverHello = new ServerHello(clientHello.getClientVersion(), this.serverRandom, this.session.getSessionIdentifier(), this.session.getCipherSuite(), this.session.getCompressionMethod(), null, clientHello.getPeer());
        flight.addMessage(this.wrapMessage(serverHello));
        this.md.update(serverHello.toByteArray());
        this.calculateKeys(this.session.getMasterSecret());
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage(clientHello.getPeer());
        flight.addMessage(this.wrapMessage(changeCipherSpecMessage));
        this.setCurrentWriteState();
        MessageDigest mdWithServerFinished = null;
        try {
            mdWithServerFinished = (MessageDigest)this.md.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HandshakeException("Cannot create FINISHED message hash", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, clientHello.getPeer()));
        }
        this.handshakeHash = this.md.digest();
        Finished finished = new Finished(this.session.getMasterSecret(), false, this.handshakeHash, clientHello.getPeer());
        flight.addMessage(this.wrapMessage(finished));
        mdWithServerFinished.update(finished.toByteArray());
        this.handshakeHash = mdWithServerFinished.digest();
        return flight;
    }

    private void receivedClientFinished(Finished message) throws HandshakeException {
        message.verifyData(this.session.getMasterSecret(), true, this.handshakeHash);
        this.sessionEstablished();
        this.handshakeCompleted();
    }
}

